# Bigcommerce\CustomersV3\CustomersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customersDelete()**](CustomersApi.md#customersDelete) | **DELETE** /customers | Delete Customers |
| [**customersGet()**](CustomersApi.md#customersGet) | **GET** /customers | Get All Customers |
| [**customersPost()**](CustomersApi.md#customersPost) | **POST** /customers | Create Customers |
| [**customersPut()**](CustomersApi.md#customersPut) | **PUT** /customers | Update Customers |


## `customersDelete()`

```php
customersDelete($id_in)
```

Delete Customers

Deletes Customers.  **Required Query** * id:in -- ID of the customer  **Notes**  A query is required to delete customers. If not provided, a 204 is returned, with no changes to the data.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id_in = array(56); // int[] | Filter items by ID. `id:in=4,5,6`

try {
    $apiInstance->customersDelete($id_in);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->customersDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id_in** | [**int[]**](../Model/int.md)| Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersGet()`

```php
customersGet($page, $limit, $id_in, $company_in, $customer_group_id_in, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_min, $date_modified_max, $email_in, $name_in, $name_like, $registration_ip_address_in, $include, $sort): \Bigcommerce\CustomersV3\Model\CustomersGet200Response
```

Get All Customers

Returns a list of Customers. Optional filter parameters can be passed in.  **Notes**  Attribute names are not available on the customer object.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number. `page=1`
$limit = 3.4; // float | Items count per page. `limit=50`
$id_in = array(56); // int[] | Filter items by ID. `id:in=4,5,6`
$company_in = array('company_in_example'); // string[] | Filter items by company. `company:in=bigcommerce,commongood`
$customer_group_id_in = array('customer_group_id_in_example'); // string[] | Filter items by customer_group_id. `customer_group_id:in=5,6`
$date_created = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by date_created. `date_created=2018-09-05T13:43:54`
$date_created_max = 'date_created_max_example'; // string | Filter items by maximum date_created. `date_created:max=2018-09-10`
$date_created_min = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by date_created. `date_created:min=2018-09-05`
$date_modified = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by date_modified. `date_modified=2018-09-05T13:45:03`
$date_modified_min = 'date_modified_min_example'; // string | Filter items by mininum date_modified. `date_modified:min=2019-09-04T:00:00:00` or `date_modified:min=2019-09-04`
$date_modified_max = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by maximum date_modified `date_modified:max=2018-09-05T13:45:03` or `date_modified:max=2019-09-04`
$email_in = 'email_in_example'; // string | Filter items by email. `email:in=janedoe@example.com`
$name_in = array('name_in_example'); // string[] | Filter items by first_name and last_name. `name=james moriarty`
$name_like = array('name_like_example'); // string[] | Filter items by substring in first_name and last_name. `name:like=moriarty, sherlock` Concatenates the first_name and last_name fields.
$registration_ip_address_in = array(56); // int[] | Filter items by registration_ip_address. If the customer was created using the API, then registration address is blank. `registration_ip_address:in=12.345.6.789`
$include = 'include_example'; // string | Indicates whether to include customer sub-resources:  * `addresses` - customer addresses  * `storecredit` - store credit  * `attributes` - customer attributes and address attributes  * `formfields` - customer and address form fields   `include=addresses,storecredit,attributes,formfields`
$sort = 'sort_example'; // string | Sort items by date_created or last_name: * `date_created:asc` - date created, ascending * `date_created:desc` - date created, descending * `last_name:asc` - last name, ascending * `last_name:desc` - last name, descending  Example: `sort=last_name:asc`

try {
    $result = $apiInstance->customersGet($page, $limit, $id_in, $company_in, $customer_group_id_in, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_min, $date_modified_max, $email_in, $name_in, $name_like, $registration_ip_address_in, $include, $sort);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->customersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number. &#x60;page&#x3D;1&#x60; | [optional] |
| **limit** | **float**| Items count per page. &#x60;limit&#x3D;50&#x60; | [optional] |
| **id_in** | [**int[]**](../Model/int.md)| Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; | [optional] |
| **company_in** | [**string[]**](../Model/string.md)| Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; | [optional] |
| **customer_group_id_in** | [**string[]**](../Model/string.md)| Filter items by customer_group_id. &#x60;customer_group_id:in&#x3D;5,6&#x60; | [optional] |
| **date_created** | **\DateTime**| Filter items by date_created. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; | [optional] |
| **date_created_max** | **string**| Filter items by maximum date_created. &#x60;date_created:max&#x3D;2018-09-10&#x60; | [optional] |
| **date_created_min** | **\DateTime**| Filter items by date_created. &#x60;date_created:min&#x3D;2018-09-05&#x60; | [optional] |
| **date_modified** | **\DateTime**| Filter items by date_modified. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; | [optional] |
| **date_modified_min** | **string**| Filter items by mininum date_modified. &#x60;date_modified:min&#x3D;2019-09-04T:00:00:00&#x60; or &#x60;date_modified:min&#x3D;2019-09-04&#x60; | [optional] |
| **date_modified_max** | **\DateTime**| Filter items by maximum date_modified &#x60;date_modified:max&#x3D;2018-09-05T13:45:03&#x60; or &#x60;date_modified:max&#x3D;2019-09-04&#x60; | [optional] |
| **email_in** | **string**| Filter items by email. &#x60;email:in&#x3D;janedoe@example.com&#x60; | [optional] |
| **name_in** | [**string[]**](../Model/string.md)| Filter items by first_name and last_name. &#x60;name&#x3D;james moriarty&#x60; | [optional] |
| **name_like** | [**string[]**](../Model/string.md)| Filter items by substring in first_name and last_name. &#x60;name:like&#x3D;moriarty, sherlock&#x60; Concatenates the first_name and last_name fields. | [optional] |
| **registration_ip_address_in** | [**int[]**](../Model/int.md)| Filter items by registration_ip_address. If the customer was created using the API, then registration address is blank. &#x60;registration_ip_address:in&#x3D;12.345.6.789&#x60; | [optional] |
| **include** | **string**| Indicates whether to include customer sub-resources:  * &#x60;addresses&#x60; - customer addresses  * &#x60;storecredit&#x60; - store credit  * &#x60;attributes&#x60; - customer attributes and address attributes  * &#x60;formfields&#x60; - customer and address form fields   &#x60;include&#x3D;addresses,storecredit,attributes,formfields&#x60; | [optional] |
| **sort** | **string**| Sort items by date_created or last_name: * &#x60;date_created:asc&#x60; - date created, ascending * &#x60;date_created:desc&#x60; - date created, descending * &#x60;last_name:asc&#x60; - last name, ascending * &#x60;last_name:desc&#x60; - last name, descending  Example: &#x60;sort&#x3D;last_name:asc&#x60; | [optional] |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomersGet200Response**](../Model/CustomersGet200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersPost()`

```php
customersPost($customer_post): \Bigcommerce\CustomersV3\Model\CustomersGet200Response
```

Create Customers

Creates Customers. Multiple customers can be created in one call.  **Required Fields** * last_name * first_name * email  **Required Fields Customer Address** * first_name * city * country_code * state_or_province * last_name * address1 * postal_code  **Required Fields Attributes** * Attributes must be [created](https://developer.bigcommerce.com/api-reference/customer-subscribers/v3-customers-api/customer-attributes/customersattributespost) **BEFORE** creating a customer. * attribute_id * attribute_value -- This is input as a string, regardless of the [Type](/api-reference/customer-subscribers/v3-customers-api/models/type).  **Notes** For multi-storefront merchants who wants to give: * Global access:   * The channel listed in `origin_channel_id` needs `allow_global_logins=true` in their channel settings   * Leave `channel_ids` empty * Channel restricted access:   * The channel listed in `origin_channel_id` needs to have `allow_global_logins=false` in their channel settings   *  Either leave `channel_ids` empty to use the current channel or give the list of channels we grant access

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_post = [{"email":"string","first_name":"string","last_name":"string","company":"string","phone":"string","notes":"string","tax_exempt_category":"string","customer_group_id":0,"addresses":[{"address1":"Addr 1","address2":"","address_type":"residential","city":"San Francisco","company":"History","country_code":"US","first_name":"Ronald","last_name":"Swimmer","phone":"707070707","postal_code":"33333","state_or_province":"California"}],"attributes":[[{"attribute_id":0,"value":"string"}]],"authentication":{"force_password_reset":true,"new_password":"string"},"accepts_product_review_abandoned_cart_emails":true,"store_credit_amounts":[{"amount":43.15}],"origin_channel_id":1}]; // \Bigcommerce\CustomersV3\Model\CustomerPost[] | 

try {
    $result = $apiInstance->customersPost($customer_post);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->customersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_post** | [**\Bigcommerce\CustomersV3\Model\CustomerPost[]**](../Model/CustomerPost.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomersGet200Response**](../Model/CustomersGet200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersPut()`

```php
customersPut($customer_put): \Bigcommerce\CustomersV3\Model\CustomersGet200Response
```

Update Customers

Updates Customers. Subresource updates are not supported. Multiple customers can be updated in one call.  **Required Fields** * id -- ID of the *Customer* This must be included in the request body  **Read Only Fields** * id * registration_ip_address * date_created * date_modified   **Notes**  * Attributes Values can not be updated using Update a Customer. Use the Update a [Customer Attribute Values](https://developer.bigcommerce.com/api-reference/customer-subscribers/v3-customers-api/customer-attribute-values/customersattributevaluesput) endpoint. * channel_ids -- Updating the list of channels a customer can access may create some side effects in a multi-storefront situation. This list determines which customer account we will use to authenticate a shopper given a channel.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_put = [{"email":"string","first_name":"string","last_name":"string","company":"string","phone":"string","registration_ip_address":"string","notes":"string","tax_exempt_category":"string","customer_group_id":0,"id":0,"authentication":{"force_password_reset":true,"new_password":"string"},"accepts_product_review_abandoned_cart_emails":true,"store_credit_amounts":[{"amount":43.15}],"channel_ids":[-1,-2]}]; // \Bigcommerce\CustomersV3\Model\CustomerPut[]

try {
    $result = $apiInstance->customersPut($customer_put);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->customersPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_put** | [**\Bigcommerce\CustomersV3\Model\CustomerPut[]**](../Model/CustomerPut.md)|  | [optional] |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomersGet200Response**](../Model/CustomersGet200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
