# Bigcommerce\CustomersV3\CustomerSettingsChannelApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customerSettingsChannelGet()**](CustomerSettingsChannelApi.md#customerSettingsChannelGet) | **GET** /customers/settings/channels/{channel_id} | Gets the customer settings per channel |
| [**customerSettingsChannelPut()**](CustomerSettingsChannelApi.md#customerSettingsChannelPut) | **PUT** /customers/settings/channels/{channel_id} | Update the customer settings per channel |


## `customerSettingsChannelGet()`

```php
customerSettingsChannelGet($channel_id): \Bigcommerce\CustomersV3\Model\CustomerChannelSettingsObject
```

Gets the customer settings per channel

Gets the customer settings per channel

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerSettingsChannelApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$channel_id = array('key' => new \stdClass); // object

try {
    $result = $apiInstance->customerSettingsChannelGet($channel_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerSettingsChannelApi->customerSettingsChannelGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **channel_id** | [**object**](../Model/.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerChannelSettingsObject**](../Model/CustomerChannelSettingsObject.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerSettingsChannelPut()`

```php
customerSettingsChannelPut($channel_id, $customer_channel_settings_object): \Bigcommerce\CustomersV3\Model\CustomerSettingsObject
```

Update the customer settings per channel

Update the customer settings per channel

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerSettingsChannelApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$channel_id = 56; // int
$customer_channel_settings_object = new \Bigcommerce\CustomersV3\Model\CustomerChannelSettingsObject(); // \Bigcommerce\CustomersV3\Model\CustomerChannelSettingsObject

try {
    $result = $apiInstance->customerSettingsChannelPut($channel_id, $customer_channel_settings_object);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerSettingsChannelApi->customerSettingsChannelPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **channel_id** | **int**|  | |
| **customer_channel_settings_object** | [**\Bigcommerce\CustomersV3\Model\CustomerChannelSettingsObject**](../Model/CustomerChannelSettingsObject.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerSettingsObject**](../Model/CustomerSettingsObject.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
