# Bigcommerce\CustomersV3\CustomerSettingsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customerSettingsGet()**](CustomerSettingsApi.md#customerSettingsGet) | **GET** /customers/settings | Gets the customer settings |
| [**customerSettingsPut()**](CustomerSettingsApi.md#customerSettingsPut) | **PUT** /customers/settings | Update the customer settings |


## `customerSettingsGet()`

```php
customerSettingsGet(): \Bigcommerce\CustomersV3\Model\CustomerSettingsObject
```

Gets the customer settings

Gets the customer settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->customerSettingsGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerSettingsApi->customerSettingsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerSettingsObject**](../Model/CustomerSettingsObject.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerSettingsPut()`

```php
customerSettingsPut($customer_settings_object): \Bigcommerce\CustomersV3\Model\CustomerSettingsObject
```

Update the customer settings

Update the customer settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_settings_object = new \Bigcommerce\CustomersV3\Model\CustomerSettingsObject(); // \Bigcommerce\CustomersV3\Model\CustomerSettingsObject

try {
    $result = $apiInstance->customerSettingsPut($customer_settings_object);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerSettingsApi->customerSettingsPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_settings_object** | [**\Bigcommerce\CustomersV3\Model\CustomerSettingsObject**](../Model/CustomerSettingsObject.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerSettingsObject**](../Model/CustomerSettingsObject.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
