# Bigcommerce\CustomersV3\CustomerFormFieldValuesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customerFormFieldValuePUT()**](CustomerFormFieldValuesApi.md#customerFormFieldValuePUT) | **PUT** /customers/form-field-values | Upsert Customer Form Field Values |
| [**customerFormFieldsGet()**](CustomerFormFieldValuesApi.md#customerFormFieldsGet) | **GET** /customers/form-field-values | Get Customer Form Field Values |


## `customerFormFieldValuePUT()`

```php
customerFormFieldValuePUT($form_field_value_full): \Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response
```

Upsert Customer Form Field Values

Upserts Customer Form Field Values. Updates the form field values on the Customer or Customer Address. Multiple form field values can be updated in one call.  Upsert checks for an existing record, if there is none it creates the record, if there is a matching record it updates that record.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerFormFieldValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$form_field_value_full = [{"name":"color","value":"blue","customer_id":0}]; // \Bigcommerce\CustomersV3\Model\FormFieldValueFull[]

try {
    $result = $apiInstance->customerFormFieldValuePUT($form_field_value_full);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerFormFieldValuesApi->customerFormFieldValuePUT: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **form_field_value_full** | [**\Bigcommerce\CustomersV3\Model\FormFieldValueFull[]**](../Model/FormFieldValueFull.md)|  | [optional] |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response**](../Model/CustomerFormFieldsGet200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerFormFieldsGet()`

```php
customerFormFieldsGet($page, $limit, $customer_id, $address_id, $field_name, $field_type): \Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response
```

Get Customer Form Field Values

Returns a list of Form Field Values for the Customer or Customer Address object.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerFormFieldValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number. `page=1`
$limit = 3.4; // float | Items count per page. `limit=50`
$customer_id = 56; // int | Filter by the customer ID.
$address_id = 56; // int | Filter by the ID of the customer address.
$field_name = 'field_name_example'; // string | Filter by the field name.
$field_type = 'field_type_example'; // string | Filter by the field type.  * `checkboxes` - checkboxes field  * `date` - date field  * `multiline` - multiline text field  * `numbers` - numbers only field  * `password` - password field  * `radiobuttons` - radio buttons field  * `text` - text field  * `picklist` - pick list field

try {
    $result = $apiInstance->customerFormFieldsGet($page, $limit, $customer_id, $address_id, $field_name, $field_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerFormFieldValuesApi->customerFormFieldsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number. &#x60;page&#x3D;1&#x60; | [optional] |
| **limit** | **float**| Items count per page. &#x60;limit&#x3D;50&#x60; | [optional] |
| **customer_id** | **int**| Filter by the customer ID. | [optional] |
| **address_id** | **int**| Filter by the ID of the customer address. | [optional] |
| **field_name** | **string**| Filter by the field name. | [optional] |
| **field_type** | **string**| Filter by the field type.  * &#x60;checkboxes&#x60; - checkboxes field  * &#x60;date&#x60; - date field  * &#x60;multiline&#x60; - multiline text field  * &#x60;numbers&#x60; - numbers only field  * &#x60;password&#x60; - password field  * &#x60;radiobuttons&#x60; - radio buttons field  * &#x60;text&#x60; - text field  * &#x60;picklist&#x60; - pick list field | [optional] |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response**](../Model/CustomerFormFieldsGet200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
