# Bigcommerce\CustomersV3\CustomerConsentApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customersConsentByCustomerIdGET()**](CustomerConsentApi.md#customersConsentByCustomerIdGET) | **GET** /customers/{customerId}/consent | Get Customer Consent |
| [**customersConsentByCustomerIdPUT()**](CustomerConsentApi.md#customersConsentByCustomerIdPUT) | **PUT** /customers/{customerId}/consent | Update Customer Consent |


## `customersConsentByCustomerIdGET()`

```php
customersConsentByCustomerIdGET($customer_id): \Bigcommerce\CustomersV3\Model\ConsentFull
```

Get Customer Consent

Gets the status of a customer's consent to allow data collection by cookies and scripts while shopping on a storefront.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerConsentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 'customer_id_example'; // string | 

try {
    $result = $apiInstance->customersConsentByCustomerIdGET($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerConsentApi->customersConsentByCustomerIdGET: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **string**|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\ConsentFull**](../Model/ConsentFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersConsentByCustomerIdPUT()`

```php
customersConsentByCustomerIdPUT($customer_id, $declare_customer_consent_request): \Bigcommerce\CustomersV3\Model\ConsentFull
```

Update Customer Consent

Updates the status of a customer's consent to allow data collection by cookies and scripts while shopping on a storefront.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerConsentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 'customer_id_example'; // string | 
$declare_customer_consent_request = new \Bigcommerce\CustomersV3\Model\DeclareCustomerConsentRequest(); // \Bigcommerce\CustomersV3\Model\DeclareCustomerConsentRequest

try {
    $result = $apiInstance->customersConsentByCustomerIdPUT($customer_id, $declare_customer_consent_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerConsentApi->customersConsentByCustomerIdPUT: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **string**|  | |
| **declare_customer_consent_request** | [**\Bigcommerce\CustomersV3\Model\DeclareCustomerConsentRequest**](../Model/DeclareCustomerConsentRequest.md)|  | [optional] |

### Return type

[**\Bigcommerce\CustomersV3\Model\ConsentFull**](../Model/ConsentFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
