# Bigcommerce\CustomersV3\CustomerAttributesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customersAttributesDelete()**](CustomerAttributesApi.md#customersAttributesDelete) | **DELETE** /customers/attributes | Delete Customer Attributes |
| [**customersAttributesGet()**](CustomerAttributesApi.md#customersAttributesGet) | **GET** /customers/attributes | Get All Customer Attributes |
| [**customersAttributesPost()**](CustomerAttributesApi.md#customersAttributesPost) | **POST** /customers/attributes | Create a Customer Attribute |
| [**customersAttributesPut()**](CustomerAttributesApi.md#customersAttributesPut) | **PUT** /customers/attributes | Update a Customer Attribute |


## `customersAttributesDelete()`

```php
customersAttributesDelete($id_in)
```

Delete Customer Attributes

Deletes Customer Attributes from the store.  **Required Query** * id:in -- ID of the *Customer Attribute*

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id_in = array(56); // int[] | Filter items by ID.

try {
    $apiInstance->customersAttributesDelete($id_in);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAttributesApi->customersAttributesDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id_in** | [**int[]**](../Model/int.md)| Filter items by ID. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersAttributesGet()`

```php
customersAttributesGet($page, $limit, $name, $name_like, $type, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min): \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse
```

Get All Customer Attributes

Returns a list of Customer Attributes. You can pass in optional filter parameters.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number. `page=1`
$limit = 3.4; // float | Items count per page. `limit=50`
$name = 'name_example'; // string | Filter items by customer attribute name `name=Date+Joined`
$name_like = 'name_like_example'; // string | Filter items by substring in customer attribute name. `name:like=join`
$type = 'type_example'; // string | The type of the customer attribute.
$date_created = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by `date_created`. `date_created=2021-01-07T20:28:16Z`
$date_created_max = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by maximum `date_created`. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. `date_created=2021-01-07` or `date_created=1610051296000`
$date_created_min = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by minimum `date_created`. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. `date_created=2021-01-07` or `date_created=1610051296000`
$date_modified = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by `date_modified`.
$date_modified_max = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by maximum `date_modified`. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. `date_created=2021-01-07` or `date_created=1610051296000`
$date_modified_min = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by minimum `date_modified`. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. `date_created=2021-01-07` or `date_created=1610051296000`

try {
    $result = $apiInstance->customersAttributesGet($page, $limit, $name, $name_like, $type, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAttributesApi->customersAttributesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number. &#x60;page&#x3D;1&#x60; | [optional] |
| **limit** | **float**| Items count per page. &#x60;limit&#x3D;50&#x60; | [optional] |
| **name** | **string**| Filter items by customer attribute name &#x60;name&#x3D;Date+Joined&#x60; | [optional] |
| **name_like** | **string**| Filter items by substring in customer attribute name. &#x60;name:like&#x3D;join&#x60; | [optional] |
| **type** | **string**| The type of the customer attribute. | [optional] |
| **date_created** | **\DateTime**| Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2021-01-07T20:28:16Z&#x60; | [optional] |
| **date_created_max** | **\DateTime**| Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; | [optional] |
| **date_created_min** | **\DateTime**| Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; | [optional] |
| **date_modified** | **\DateTime**| Filter items by &#x60;date_modified&#x60;. | [optional] |
| **date_modified_max** | **\DateTime**| Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; | [optional] |
| **date_modified_min** | **\DateTime**| Filter items by minimum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; | [optional] |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse**](../Model/CustomerAttributesResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersAttributesPost()`

```php
customersAttributesPost($attribute_post): \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse
```

Create a Customer Attribute

Creates a Customer Attribute. Multiple customer attributes can be created in one call.  **Required Fields** * name * type  **Notes**  Once the data type is set, it can not be changed. The attribute will need to be deleted then created again with the new data type. This will also delete it from the customer.  Customer attributes are created separately from the customer. After the name and type are created, then the attributes can be added to the customer.  A store cannot have more than 50 customer attributes.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attribute_post = array(new \Bigcommerce\CustomersV3\Model\AttributePost()); // \Bigcommerce\CustomersV3\Model\AttributePost[]

try {
    $result = $apiInstance->customersAttributesPost($attribute_post);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAttributesApi->customersAttributesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **attribute_post** | [**\Bigcommerce\CustomersV3\Model\AttributePost[]**](../Model/AttributePost.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse**](../Model/CustomerAttributesResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersAttributesPut()`

```php
customersAttributesPut($attribute_put): \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse
```

Update a Customer Attribute

Updates a Customer Attribute. Multiple customer attributes can be updated in one call.  **Required Fields** * id -- ID of the *Customer Attribute*  Once the data type is set, it can not be changed. The attribute will need to be deleted then created again with the new data type. This will also delete it from the customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attribute_put = array(new \Bigcommerce\CustomersV3\Model\AttributePut()); // \Bigcommerce\CustomersV3\Model\AttributePut[]

try {
    $result = $apiInstance->customersAttributesPut($attribute_put);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAttributesApi->customersAttributesPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **attribute_put** | [**\Bigcommerce\CustomersV3\Model\AttributePut[]**](../Model/AttributePut.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse**](../Model/CustomerAttributesResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
