# Bigcommerce\CustomersV3\CustomerAttributeValuesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customersAttributeValuesDelete()**](CustomerAttributeValuesApi.md#customersAttributeValuesDelete) | **DELETE** /customers/attribute-values | Delete Customer Attribute Values |
| [**customersAttributeValuesGet()**](CustomerAttributeValuesApi.md#customersAttributeValuesGet) | **GET** /customers/attribute-values | Get All Customer Attribute Values |
| [**customersAttributeValuesPut()**](CustomerAttributeValuesApi.md#customersAttributeValuesPut) | **PUT** /customers/attribute-values | Upsert Customer Attribute Values |


## `customersAttributeValuesDelete()`

```php
customersAttributeValuesDelete($id_in)
```

Delete Customer Attribute Values

Deletes Customer Attribute Values. Deletes the attribute value from the customer.  **Required Query** * id:in - ID of the *Customer Attribute Value*

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAttributeValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id_in = array(56); // int[] | Filter items by ID. `id:in=4,5,6`

try {
    $apiInstance->customersAttributeValuesDelete($id_in);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAttributeValuesApi->customersAttributeValuesDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id_in** | [**int[]**](../Model/int.md)| Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersAttributeValuesGet()`

```php
customersAttributeValuesGet($page, $limit, $customer_id_in, $attribute_id_in, $name, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min): \Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse
```

Get All Customer Attribute Values

Returns a list of Customer Attribute Values. Optional filter parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAttributeValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number. `page=1`
$limit = 3.4; // float | Items count per page. `limit=50`
$customer_id_in = array(56); // int[] | Filter items by the customer ID. `customer_id:in=23,24,55`
$attribute_id_in = array(56); // int[] | Filter items by the attribute ID. `attribute_id:in=1,2`
$name = 'name_example'; // string | Filter items by the attribute name. `name=age`
$date_created = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by `date_created`. `date_created=2018-09-05T13:43:54`
$date_created_max = 'date_created_max_example'; // string | Filter items by maximum `date_created`. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. `date_created=2021-01-07` or `date_created=1610051296000`
$date_created_min = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by minimum `date_created`. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. `date_created=2021-01-07` or `date_created=1610051296000`
$date_modified = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by `date_modified`. `date_modified=2018-09-05T13:45:03`
$date_modified_max = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by maximum `date_modified`. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. `date_created=2021-01-07` or `date_created=1610051296000`
$date_modified_min = 'date_modified_min_example'; // string | Filter items by mininum `date_modified`. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. `date_created=2021-01-07` or `date_created=1610051296000`

try {
    $result = $apiInstance->customersAttributeValuesGet($page, $limit, $customer_id_in, $attribute_id_in, $name, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAttributeValuesApi->customersAttributeValuesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number. &#x60;page&#x3D;1&#x60; | [optional] |
| **limit** | **float**| Items count per page. &#x60;limit&#x3D;50&#x60; | [optional] |
| **customer_id_in** | [**int[]**](../Model/int.md)| Filter items by the customer ID. &#x60;customer_id:in&#x3D;23,24,55&#x60; | [optional] |
| **attribute_id_in** | [**int[]**](../Model/int.md)| Filter items by the attribute ID. &#x60;attribute_id:in&#x3D;1,2&#x60; | [optional] |
| **name** | **string**| Filter items by the attribute name. &#x60;name&#x3D;age&#x60; | [optional] |
| **date_created** | **\DateTime**| Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; | [optional] |
| **date_created_max** | **string**| Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; | [optional] |
| **date_created_min** | **\DateTime**| Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; | [optional] |
| **date_modified** | **\DateTime**| Filter items by &#x60;date_modified&#x60;. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; | [optional] |
| **date_modified_max** | **\DateTime**| Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; | [optional] |
| **date_modified_min** | **string**| Filter items by mininum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; | [optional] |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse**](../Model/CustomerAttributeValueCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersAttributeValuesPut()`

```php
customersAttributeValuesPut($attribue_value_base): \Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse
```

Upsert Customer Attribute Values

Upserts Customer Attribute Values. Updates the attribute values on the Customer. Multiple customer attribute values can be updated in one call.  Upsert checks for an existing record. If there is none, it creates the record, if there is a matching record, it updates that record.  Up to 10 per call are allowed.  **Required Fields** * customer_id -- ID of the *Customer* * id -- ID of the *Customer Attribute* * value -- Value of the *Customer Attribute*

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAttributeValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attribue_value_base = array(new \Bigcommerce\CustomersV3\Model\AttribueValueBase()); // \Bigcommerce\CustomersV3\Model\AttribueValueBase[]

try {
    $result = $apiInstance->customersAttributeValuesPut($attribue_value_base);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAttributeValuesApi->customersAttributeValuesPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **attribue_value_base** | [**\Bigcommerce\CustomersV3\Model\AttribueValueBase[]**](../Model/AttribueValueBase.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse**](../Model/CustomerAttributeValueCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
