# Bigcommerce\CustomersV3\CustomerAddressesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**customersAddressesDelete()**](CustomerAddressesApi.md#customersAddressesDelete) | **DELETE** /customers/addresses | Delete a Customer Address |
| [**customersAddressesGet()**](CustomerAddressesApi.md#customersAddressesGet) | **GET** /customers/addresses | Get All Customer Addresses |
| [**customersAddressesPost()**](CustomerAddressesApi.md#customersAddressesPost) | **POST** /customers/addresses | Create a Customer Address |
| [**customersAddressesPut()**](CustomerAddressesApi.md#customersAddressesPut) | **PUT** /customers/addresses | Update a Customer Address |


## `customersAddressesDelete()`

```php
customersAddressesDelete($id_in)
```

Delete a Customer Address

Deletes a Customer Address.  **Required Query** * id:in -- ID of the *Customer Address*

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id_in = array(56); // int[] | Filter items by ID. `id:in=4,5,6`

try {
    $apiInstance->customersAddressesDelete($id_in);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->customersAddressesDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id_in** | [**int[]**](../Model/int.md)| Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersAddressesGet()`

```php
customersAddressesGet($page, $limit, $company_in, $name_in, $customer_id_in, $include, $id_in): \Bigcommerce\CustomersV3\Model\AddressCollectionResponse
```

Get All Customer Addresses

Returns a list of Customer Addresses. Optional filter parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number. `page=1`
$limit = 3.4; // float | Items count per page. `limit=50`
$company_in = array('company_in_example'); // string[] | Filter items by company. `company:in=bigcommerce,commongood`
$name_in = array('name_in_example'); // string[] | Filter items by first_name and last_name. `name:in=James+Moriarty`
$customer_id_in = array(56); // int[] | Filter by the ID of the customer. Also accepts comma-separated IDs to filter for multiple customers. `customer_id:in=23,24,55`
$include = 'include_example'; // string | Indicates whether to include customer address sub-resources: * `formfields` - address form fields `include=formfields`
$id_in = array(56); // int[] | Filter items by ID. `id:in=4,5,6`

try {
    $result = $apiInstance->customersAddressesGet($page, $limit, $company_in, $name_in, $customer_id_in, $include, $id_in);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->customersAddressesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number. &#x60;page&#x3D;1&#x60; | [optional] |
| **limit** | **float**| Items count per page. &#x60;limit&#x3D;50&#x60; | [optional] |
| **company_in** | [**string[]**](../Model/string.md)| Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; | [optional] |
| **name_in** | [**string[]**](../Model/string.md)| Filter items by first_name and last_name. &#x60;name:in&#x3D;James+Moriarty&#x60; | [optional] |
| **customer_id_in** | [**int[]**](../Model/int.md)| Filter by the ID of the customer. Also accepts comma-separated IDs to filter for multiple customers. &#x60;customer_id:in&#x3D;23,24,55&#x60; | [optional] |
| **include** | **string**| Indicates whether to include customer address sub-resources: * &#x60;formfields&#x60; - address form fields &#x60;include&#x3D;formfields&#x60; | [optional] |
| **id_in** | [**int[]**](../Model/int.md)| Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; | [optional] |

### Return type

[**\Bigcommerce\CustomersV3\Model\AddressCollectionResponse**](../Model/AddressCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersAddressesPost()`

```php
customersAddressesPost($address_post): \Bigcommerce\CustomersV3\Model\AddressCollectionResponse
```

Create a Customer Address

Creates a Customer Address. Multiple customer addresses can be created in one call.  **Required Fields** * first_name * city * customer_id * country_code * state_or_province * last_name * address1 * postal_code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$address_post = array(new \Bigcommerce\CustomersV3\Model\AddressPost()); // \Bigcommerce\CustomersV3\Model\AddressPost[]

try {
    $result = $apiInstance->customersAddressesPost($address_post);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->customersAddressesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **address_post** | [**\Bigcommerce\CustomersV3\Model\AddressPost[]**](../Model/AddressPost.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\AddressCollectionResponse**](../Model/AddressCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customersAddressesPut()`

```php
customersAddressesPut($address_put): \Bigcommerce\CustomersV3\Model\AddressCollectionResponse
```

Update a Customer Address

Updates a Customer Address. Multiple customer addresses can be updated in one call.  **Required Fields** * id -- ID of the *Customer Address* * customer_id -- ID of the *Customer*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$address_put = array(new \Bigcommerce\CustomersV3\Model\AddressPut()); // \Bigcommerce\CustomersV3\Model\AddressPut[]

try {
    $result = $apiInstance->customersAddressesPut($address_put);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->customersAddressesPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **address_put** | [**\Bigcommerce\CustomersV3\Model\AddressPut[]**](../Model/AddressPut.md)|  | |

### Return type

[**\Bigcommerce\CustomersV3\Model\AddressCollectionResponse**](../Model/AddressCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
