# OpenAPIClient-php

Create and manage customers.

- [Authentication](#authentication)
- [Resources](#resources)

## Authentication

Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:

```http
GET /stores/store_hash/v3/catalog/summary
host: api.bigcommerce.com
Accept: application/json
X-Auth-Token: {access_token}
```

|Header|Parameter|Description|
|-|-|-|
|`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|

### OAuth Scopes

| UI Name                                      | Permission | Parameter                                     |
|----------------------------------------------|------------|-----------------------------------------------|
| Customers                                    | modify     | `store_v2_customers`                          |
| Customers                                    | read-only  | `store_v2_customers_read_only`                |

For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).

## Resources
* [Customer and Subscribers Overview](/api-docs/customers/customers-subscribers-overview).


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/bigcommerce.git"
    }
  ],
  "require": {
    "talisman/bigcommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV3\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id_in = array(56); // int[] | Filter items by ID. `id:in=4,5,6`

try {
    $apiInstance->customersAddressesDelete($id_in);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->customersAddressesDelete: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CustomerAddressesApi* | [**customersAddressesDelete**](docs/Api/CustomerAddressesApi.md#customersaddressesdelete) | **DELETE** /customers/addresses | Delete a Customer Address
*CustomerAddressesApi* | [**customersAddressesGet**](docs/Api/CustomerAddressesApi.md#customersaddressesget) | **GET** /customers/addresses | Get All Customer Addresses
*CustomerAddressesApi* | [**customersAddressesPost**](docs/Api/CustomerAddressesApi.md#customersaddressespost) | **POST** /customers/addresses | Create a Customer Address
*CustomerAddressesApi* | [**customersAddressesPut**](docs/Api/CustomerAddressesApi.md#customersaddressesput) | **PUT** /customers/addresses | Update a Customer Address
*CustomerAttributeValuesApi* | [**customersAttributeValuesDelete**](docs/Api/CustomerAttributeValuesApi.md#customersattributevaluesdelete) | **DELETE** /customers/attribute-values | Delete Customer Attribute Values
*CustomerAttributeValuesApi* | [**customersAttributeValuesGet**](docs/Api/CustomerAttributeValuesApi.md#customersattributevaluesget) | **GET** /customers/attribute-values | Get All Customer Attribute Values
*CustomerAttributeValuesApi* | [**customersAttributeValuesPut**](docs/Api/CustomerAttributeValuesApi.md#customersattributevaluesput) | **PUT** /customers/attribute-values | Upsert Customer Attribute Values
*CustomerAttributesApi* | [**customersAttributesDelete**](docs/Api/CustomerAttributesApi.md#customersattributesdelete) | **DELETE** /customers/attributes | Delete Customer Attributes
*CustomerAttributesApi* | [**customersAttributesGet**](docs/Api/CustomerAttributesApi.md#customersattributesget) | **GET** /customers/attributes | Get All Customer Attributes
*CustomerAttributesApi* | [**customersAttributesPost**](docs/Api/CustomerAttributesApi.md#customersattributespost) | **POST** /customers/attributes | Create a Customer Attribute
*CustomerAttributesApi* | [**customersAttributesPut**](docs/Api/CustomerAttributesApi.md#customersattributesput) | **PUT** /customers/attributes | Update a Customer Attribute
*CustomerConsentApi* | [**customersConsentByCustomerIdGET**](docs/Api/CustomerConsentApi.md#customersconsentbycustomeridget) | **GET** /customers/{customerId}/consent | Get Customer Consent
*CustomerConsentApi* | [**customersConsentByCustomerIdPUT**](docs/Api/CustomerConsentApi.md#customersconsentbycustomeridput) | **PUT** /customers/{customerId}/consent | Update Customer Consent
*CustomerFormFieldValuesApi* | [**customerFormFieldValuePUT**](docs/Api/CustomerFormFieldValuesApi.md#customerformfieldvalueput) | **PUT** /customers/form-field-values | Upsert Customer Form Field Values
*CustomerFormFieldValuesApi* | [**customerFormFieldsGet**](docs/Api/CustomerFormFieldValuesApi.md#customerformfieldsget) | **GET** /customers/form-field-values | Get Customer Form Field Values
*CustomerSettingsApi* | [**customerSettingsGet**](docs/Api/CustomerSettingsApi.md#customersettingsget) | **GET** /customers/settings | Gets the customer settings
*CustomerSettingsApi* | [**customerSettingsPut**](docs/Api/CustomerSettingsApi.md#customersettingsput) | **PUT** /customers/settings | Update the customer settings
*CustomerSettingsChannelApi* | [**customerSettingsChannelGet**](docs/Api/CustomerSettingsChannelApi.md#customersettingschannelget) | **GET** /customers/settings/channels/{channel_id} | Gets the customer settings per channel
*CustomerSettingsChannelApi* | [**customerSettingsChannelPut**](docs/Api/CustomerSettingsChannelApi.md#customersettingschannelput) | **PUT** /customers/settings/channels/{channel_id} | Update the customer settings per channel
*CustomersApi* | [**customersDelete**](docs/Api/CustomersApi.md#customersdelete) | **DELETE** /customers | Delete Customers
*CustomersApi* | [**customersGet**](docs/Api/CustomersApi.md#customersget) | **GET** /customers | Get All Customers
*CustomersApi* | [**customersPost**](docs/Api/CustomersApi.md#customerspost) | **POST** /customers | Create Customers
*CustomersApi* | [**customersPut**](docs/Api/CustomersApi.md#customersput) | **PUT** /customers | Update Customers

## Models

- [AddressCollectionResponse](docs/Model/AddressCollectionResponse.md)
- [AddressFormFieldValue](docs/Model/AddressFormFieldValue.md)
- [AddressFull](docs/Model/AddressFull.md)
- [AddressPost](docs/Model/AddressPost.md)
- [AddressPut](docs/Model/AddressPut.md)
- [AddressType](docs/Model/AddressType.md)
- [AttribueValueBase](docs/Model/AttribueValueBase.md)
- [AttributeBase](docs/Model/AttributeBase.md)
- [AttributeFull](docs/Model/AttributeFull.md)
- [AttributePost](docs/Model/AttributePost.md)
- [AttributePut](docs/Model/AttributePut.md)
- [AttributeValueFull](docs/Model/AttributeValueFull.md)
- [BankAccountInstrument](docs/Model/BankAccountInstrument.md)
- [BillingAddress](docs/Model/BillingAddress.md)
- [CardInstrument](docs/Model/CardInstrument.md)
- [ConsentFull](docs/Model/ConsentFull.md)
- [CustomerAddressesBase](docs/Model/CustomerAddressesBase.md)
- [CustomerAttributeValue](docs/Model/CustomerAttributeValue.md)
- [CustomerAttributeValue1](docs/Model/CustomerAttributeValue1.md)
- [CustomerAttributeValueCollectionResponse](docs/Model/CustomerAttributeValueCollectionResponse.md)
- [CustomerAttributeValueFull](docs/Model/CustomerAttributeValueFull.md)
- [CustomerAttributesResponse](docs/Model/CustomerAttributesResponse.md)
- [CustomerAuthenticationBase](docs/Model/CustomerAuthenticationBase.md)
- [CustomerAuthenticationPostPut](docs/Model/CustomerAuthenticationPostPut.md)
- [CustomerBase](docs/Model/CustomerBase.md)
- [CustomerChannelSettingsObject](docs/Model/CustomerChannelSettingsObject.md)
- [CustomerFormFieldValue](docs/Model/CustomerFormFieldValue.md)
- [CustomerFormFieldsGet200Response](docs/Model/CustomerFormFieldsGet200Response.md)
- [CustomerFull](docs/Model/CustomerFull.md)
- [CustomerPost](docs/Model/CustomerPost.md)
- [CustomerPut](docs/Model/CustomerPut.md)
- [CustomerSettingsObject](docs/Model/CustomerSettingsObject.md)
- [CustomerSettingsObjectCustomerGroupSettings](docs/Model/CustomerSettingsObjectCustomerGroupSettings.md)
- [CustomerSettingsObjectPrivacySettings](docs/Model/CustomerSettingsObjectPrivacySettings.md)
- [CustomerStoredCreditAmountsInner](docs/Model/CustomerStoredCreditAmountsInner.md)
- [CustomersGet200Response](docs/Model/CustomersGet200Response.md)
- [DeclareCustomerConsentRequest](docs/Model/DeclareCustomerConsentRequest.md)
- [DeclareCustomerConsentResponse](docs/Model/DeclareCustomerConsentResponse.md)
- [ErrorResponse](docs/Model/ErrorResponse.md)
- [FormFieldValueFull](docs/Model/FormFieldValueFull.md)
- [Links](docs/Model/Links.md)
- [MetaCollection](docs/Model/MetaCollection.md)
- [Pagination](docs/Model/Pagination.md)
- [PayPalAccountInstrument](docs/Model/PayPalAccountInstrument.md)
- [Type](docs/Model/Type.md)

## Authorization

Authentication schemes defined for the API:
### X-Auth-Token

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: ``
    - Package version: `3`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
