<?php
/**
 * CustomersApiTest
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V2
 *
 * Create and Manage Customers, Customer Addresses, and Customer Groups. Additionally, validate customer passwords. To learn more about Customers see [here](/api-docs/customers/customers-subscribers-overview).   ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/{store_hash}/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](/api-docs/getting-started/authentication).  ## Available Endpoints | Resource / Endpoint                     | Description                                                                   | |-----------------------------------------|-------------------------------------------------------------------------------| | Customers                               | Identity and account details for customers shopping on BigCommerce stores     | | Customers Addresses                     | Postal address belonging to a customer.                                       | | Customers Groups                        | Groupings of customers who share the same level of access and discounts       | | Customers Validate Password             | Validate customer passwords                                                   |  ## Usage Notes  **Customer Groups** * Customer Groups are only available on specific plans.  **Customers vs. Subscribers** * A subscriber is not always a customer. Someone can sign up for the newsletter only and not create an account. * A customer is not always a subscriber. Signing up for the newsletter is a separate action from creating an account and purchasing an item. * A customer and a subscriber can be the same. If a shopper checks out on the storefront, creates an account and opts into the newsletter, they are a customer and a subscriber.  ## Resources  ### Related APIs / Endpoints   [Customer Login API](/api-docs/customers/customer-login-api) - [Current Customer API](/api-docs/customers/current-customer-api) - [Customers API (v3)](/api-reference/customer-subscribers/v3-customers-api) - [Subscribers API](/api-reference/customer-subscribers/subscribers-api)  ### Webhooks - [Customers](/api-docs/store-management/webhooks/webhook-events#customer)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace Bigcommerce\CustomersV2\Test\Api;

use \Bigcommerce\CustomersV2\Configuration;
use \Bigcommerce\CustomersV2\ApiException;
use \Bigcommerce\CustomersV2\ObjectSerializer;
use PHPUnit\Framework\TestCase;

/**
 * CustomersApiTest Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomersApiTest extends TestCase
{

    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for createANewCustomer
     *
     * Create a New Customer.
     *
     */
    public function testCreateANewCustomer()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for deleteACustomer
     *
     * Delete a Customer.
     *
     */
    public function testDeleteACustomer()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for deleteAllCustomers
     *
     * Delete Customers.
     *
     */
    public function testDeleteAllCustomers()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for getACountOfCustomers
     *
     * Get a Count of Customers.
     *
     */
    public function testGetACountOfCustomers()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for getACustomer
     *
     * Get a Customer.
     *
     */
    public function testGetACustomer()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for getAllCustomers
     *
     * Get All Customers.
     *
     */
    public function testGetAllCustomers()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for updateACustomer
     *
     * Update a Customer.
     *
     */
    public function testUpdateACustomer()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }
}
