<?php
/**
 * Customers
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V2
 *
 * Create and Manage Customers, Customer Addresses, and Customer Groups. Additionally, validate customer passwords. To learn more about Customers see [here](/api-docs/customers/customers-subscribers-overview).   ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/{store_hash}/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](/api-docs/getting-started/authentication).  ## Available Endpoints | Resource / Endpoint                     | Description                                                                   | |-----------------------------------------|-------------------------------------------------------------------------------| | Customers                               | Identity and account details for customers shopping on BigCommerce stores     | | Customers Addresses                     | Postal address belonging to a customer.                                       | | Customers Groups                        | Groupings of customers who share the same level of access and discounts       | | Customers Validate Password             | Validate customer passwords                                                   |  ## Usage Notes  **Customer Groups** * Customer Groups are only available on specific plans.  **Customers vs. Subscribers** * A subscriber is not always a customer. Someone can sign up for the newsletter only and not create an account. * A customer is not always a subscriber. Signing up for the newsletter is a separate action from creating an account and purchasing an item. * A customer and a subscriber can be the same. If a shopper checks out on the storefront, creates an account and opts into the newsletter, they are a customer and a subscriber.  ## Resources  ### Related APIs / Endpoints   [Customer Login API](/api-docs/customers/customer-login-api) - [Current Customer API](/api-docs/customers/current-customer-api) - [Customers API (v3)](/api-reference/customer-subscribers/v3-customers-api) - [Subscribers API](/api-reference/customer-subscribers/subscribers-api)  ### Webhooks - [Customers](/api-docs/store-management/webhooks/webhook-events#customer)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV2\Model;

use \ArrayAccess;
use \Bigcommerce\CustomersV2\ObjectSerializer;

/**
 * Customers Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Customers implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Customers';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        '_authentication' => '\Bigcommerce\CustomersV2\Model\CustomersAuthentication',
        'company' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'email' => 'string',
        'phone' => 'string',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'store_credit' => 'string',
        'registration_ip_address' => 'string',
        'customer_group_id' => 'int',
        'notes' => 'string',
        'tax_exempt_category' => 'string',
        'accepts_marketing' => 'bool',
        'addresses' => '\Bigcommerce\CustomersV2\Model\AddressFieldResource',
        'form_fields' => '\Bigcommerce\CustomersV2\Model\FormFields[]',
        'reset_pass_on_login' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        '_authentication' => null,
        'company' => null,
        'first_name' => null,
        'last_name' => null,
        'email' => null,
        'phone' => null,
        'date_created' => 'date-time',
        'date_modified' => 'date-time',
        'store_credit' => null,
        'registration_ip_address' => null,
        'customer_group_id' => null,
        'notes' => null,
        'tax_exempt_category' => null,
        'accepts_marketing' => null,
        'addresses' => null,
        'form_fields' => null,
        'reset_pass_on_login' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        '_authentication' => false,
        'company' => false,
        'first_name' => false,
        'last_name' => false,
        'email' => false,
        'phone' => false,
        'date_created' => false,
        'date_modified' => false,
        'store_credit' => false,
        'registration_ip_address' => false,
        'customer_group_id' => false,
        'notes' => false,
        'tax_exempt_category' => false,
        'accepts_marketing' => false,
        'addresses' => false,
        'form_fields' => false,
        'reset_pass_on_login' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        '_authentication' => '_authentication',
        'company' => 'company',
        'first_name' => 'first_name',
        'last_name' => 'last_name',
        'email' => 'email',
        'phone' => 'phone',
        'date_created' => 'date_created',
        'date_modified' => 'date_modified',
        'store_credit' => 'store_credit',
        'registration_ip_address' => 'registration_ip_address',
        'customer_group_id' => 'customer_group_id',
        'notes' => 'notes',
        'tax_exempt_category' => 'tax_exempt_category',
        'accepts_marketing' => 'accepts_marketing',
        'addresses' => 'addresses',
        'form_fields' => 'form_fields',
        'reset_pass_on_login' => 'reset_pass_on_login'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        '_authentication' => 'setAuthentication',
        'company' => 'setCompany',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'email' => 'setEmail',
        'phone' => 'setPhone',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'store_credit' => 'setStoreCredit',
        'registration_ip_address' => 'setRegistrationIpAddress',
        'customer_group_id' => 'setCustomerGroupId',
        'notes' => 'setNotes',
        'tax_exempt_category' => 'setTaxExemptCategory',
        'accepts_marketing' => 'setAcceptsMarketing',
        'addresses' => 'setAddresses',
        'form_fields' => 'setFormFields',
        'reset_pass_on_login' => 'setResetPassOnLogin'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        '_authentication' => 'getAuthentication',
        'company' => 'getCompany',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'email' => 'getEmail',
        'phone' => 'getPhone',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'store_credit' => 'getStoreCredit',
        'registration_ip_address' => 'getRegistrationIpAddress',
        'customer_group_id' => 'getCustomerGroupId',
        'notes' => 'getNotes',
        'tax_exempt_category' => 'getTaxExemptCategory',
        'accepts_marketing' => 'getAcceptsMarketing',
        'addresses' => 'getAddresses',
        'form_fields' => 'getFormFields',
        'reset_pass_on_login' => 'getResetPassOnLogin'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('_authentication', $data ?? [], null);
        $this->setIfExists('company', $data ?? [], null);
        $this->setIfExists('first_name', $data ?? [], null);
        $this->setIfExists('last_name', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('date_modified', $data ?? [], null);
        $this->setIfExists('store_credit', $data ?? [], null);
        $this->setIfExists('registration_ip_address', $data ?? [], null);
        $this->setIfExists('customer_group_id', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('tax_exempt_category', $data ?? [], null);
        $this->setIfExists('accepts_marketing', $data ?? [], null);
        $this->setIfExists('addresses', $data ?? [], null);
        $this->setIfExists('form_fields', $data ?? [], null);
        $this->setIfExists('reset_pass_on_login', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['first_name'] === null) {
            $invalidProperties[] = "'first_name' can't be null";
        }
        if ($this->container['last_name'] === null) {
            $invalidProperties[] = "'last_name' can't be null";
        }
        if ($this->container['email'] === null) {
            $invalidProperties[] = "'email' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Unique numeric ID of this customer. This is a READ-ONLY field; do not set or modify its value in a POST or PUT request.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets _authentication
     *
     * @return \Bigcommerce\CustomersV2\Model\CustomersAuthentication|null
     */
    public function getAuthentication()
    {
        return $this->container['_authentication'];
    }

    /**
     * Sets _authentication
     *
     * @param \Bigcommerce\CustomersV2\Model\CustomersAuthentication|null $_authentication _authentication
     *
     * @return self
     */
    public function setAuthentication($_authentication)
    {
        if (is_null($_authentication)) {
            throw new \InvalidArgumentException('non-nullable _authentication cannot be null');
        }
        $this->container['_authentication'] = $_authentication;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string|null
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string|null $company The name of the company for which the customer works.
     *
     * @return self
     */
    public function setCompany($company)
    {
        if (is_null($company)) {
            throw new \InvalidArgumentException('non-nullable company cannot be null');
        }
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string $first_name First name of the customer.
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        if (is_null($first_name)) {
            throw new \InvalidArgumentException('non-nullable first_name cannot be null');
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string $last_name Last name of the customer.
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        if (is_null($last_name)) {
            throw new \InvalidArgumentException('non-nullable last_name cannot be null');
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string $email Email address of the customer.
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone Phone number of the customer.
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created Date on which the customer registered from the storefront or was created in the control panel. This is a READ-ONLY field; do not set or modify its value in a POST or PUT request.
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     *
     * @return \DateTime|null
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     *
     * @param \DateTime|null $date_modified Date on which the customer updated their details in the storefront or was updated in the control panel. This is a READ-ONLY field; do not set or modify its value in a POST or PUT request.
     *
     * @return self
     */
    public function setDateModified($date_modified)
    {
        if (is_null($date_modified)) {
            throw new \InvalidArgumentException('non-nullable date_modified cannot be null');
        }
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets store_credit
     *
     * @return string|null
     */
    public function getStoreCredit()
    {
        return $this->container['store_credit'];
    }

    /**
     * Sets store_credit
     *
     * @param string|null $store_credit The amount of credit the customer has. (Float, Float as String, Integer)
     *
     * @return self
     */
    public function setStoreCredit($store_credit)
    {
        if (is_null($store_credit)) {
            throw new \InvalidArgumentException('non-nullable store_credit cannot be null');
        }
        $this->container['store_credit'] = $store_credit;

        return $this;
    }

    /**
     * Gets registration_ip_address
     *
     * @return string|null
     */
    public function getRegistrationIpAddress()
    {
        return $this->container['registration_ip_address'];
    }

    /**
     * Sets registration_ip_address
     *
     * @param string|null $registration_ip_address The customer’s IP address when they signed up.
     *
     * @return self
     */
    public function setRegistrationIpAddress($registration_ip_address)
    {
        if (is_null($registration_ip_address)) {
            throw new \InvalidArgumentException('non-nullable registration_ip_address cannot be null');
        }
        $this->container['registration_ip_address'] = $registration_ip_address;

        return $this;
    }

    /**
     * Gets customer_group_id
     *
     * @return int|null
     */
    public function getCustomerGroupId()
    {
        return $this->container['customer_group_id'];
    }

    /**
     * Sets customer_group_id
     *
     * @param int|null $customer_group_id The group to which the customer belongs.
     *
     * @return self
     */
    public function setCustomerGroupId($customer_group_id)
    {
        if (is_null($customer_group_id)) {
            throw new \InvalidArgumentException('non-nullable customer_group_id cannot be null');
        }
        $this->container['customer_group_id'] = $customer_group_id;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Store-owner notes on the customer.
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets tax_exempt_category
     *
     * @return string|null
     */
    public function getTaxExemptCategory()
    {
        return $this->container['tax_exempt_category'];
    }

    /**
     * Sets tax_exempt_category
     *
     * @param string|null $tax_exempt_category If applicable, the tax-exempt category of the shopper’s customer account. You can apply a tax-exempt category to multiple customers. This code should match the exemption codes provided by the third-party integration.
     *
     * @return self
     */
    public function setTaxExemptCategory($tax_exempt_category)
    {
        if (is_null($tax_exempt_category)) {
            throw new \InvalidArgumentException('non-nullable tax_exempt_category cannot be null');
        }
        $this->container['tax_exempt_category'] = $tax_exempt_category;

        return $this;
    }

    /**
     * Gets accepts_marketing
     *
     * @return bool|null
     */
    public function getAcceptsMarketing()
    {
        return $this->container['accepts_marketing'];
    }

    /**
     * Sets accepts_marketing
     *
     * @param bool|null $accepts_marketing If the customer accepts product review emails or abandon cart emails. Read-Only.
     *
     * @return self
     */
    public function setAcceptsMarketing($accepts_marketing)
    {
        if (is_null($accepts_marketing)) {
            throw new \InvalidArgumentException('non-nullable accepts_marketing cannot be null');
        }
        $this->container['accepts_marketing'] = $accepts_marketing;

        return $this;
    }

    /**
     * Gets addresses
     *
     * @return \Bigcommerce\CustomersV2\Model\AddressFieldResource|null
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     *
     * @param \Bigcommerce\CustomersV2\Model\AddressFieldResource|null $addresses addresses
     *
     * @return self
     */
    public function setAddresses($addresses)
    {
        if (is_null($addresses)) {
            throw new \InvalidArgumentException('non-nullable addresses cannot be null');
        }
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets form_fields
     *
     * @return \Bigcommerce\CustomersV2\Model\FormFields[]|null
     */
    public function getFormFields()
    {
        return $this->container['form_fields'];
    }

    /**
     * Sets form_fields
     *
     * @param \Bigcommerce\CustomersV2\Model\FormFields[]|null $form_fields Array of custom fields. This is a READ-ONLY field; do not set or modify its value in a POST or PUT request.
     *
     * @return self
     */
    public function setFormFields($form_fields)
    {
        if (is_null($form_fields)) {
            throw new \InvalidArgumentException('non-nullable form_fields cannot be null');
        }
        $this->container['form_fields'] = $form_fields;

        return $this;
    }

    /**
     * Gets reset_pass_on_login
     *
     * @return bool|null
     */
    public function getResetPassOnLogin()
    {
        return $this->container['reset_pass_on_login'];
    }

    /**
     * Sets reset_pass_on_login
     *
     * @param bool|null $reset_pass_on_login Force a password change on next login.
     *
     * @return self
     */
    public function setResetPassOnLogin($reset_pass_on_login)
    {
        if (is_null($reset_pass_on_login)) {
            throw new \InvalidArgumentException('non-nullable reset_pass_on_login cannot be null');
        }
        $this->container['reset_pass_on_login'] = $reset_pass_on_login;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


