<?php
/**
 * CustomersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V2
 *
 * Create and Manage Customers, Customer Addresses, and Customer Groups. Additionally, validate customer passwords. To learn more about Customers see [here](/api-docs/customers/customers-subscribers-overview).   ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/{store_hash}/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](/api-docs/getting-started/authentication).  ## Available Endpoints | Resource / Endpoint                     | Description                                                                   | |-----------------------------------------|-------------------------------------------------------------------------------| | Customers                               | Identity and account details for customers shopping on BigCommerce stores     | | Customers Addresses                     | Postal address belonging to a customer.                                       | | Customers Groups                        | Groupings of customers who share the same level of access and discounts       | | Customers Validate Password             | Validate customer passwords                                                   |  ## Usage Notes  **Customer Groups** * Customer Groups are only available on specific plans.  **Customers vs. Subscribers** * A subscriber is not always a customer. Someone can sign up for the newsletter only and not create an account. * A customer is not always a subscriber. Signing up for the newsletter is a separate action from creating an account and purchasing an item. * A customer and a subscriber can be the same. If a shopper checks out on the storefront, creates an account and opts into the newsletter, they are a customer and a subscriber.  ## Resources  ### Related APIs / Endpoints   [Customer Login API](/api-docs/customers/customer-login-api) - [Current Customer API](/api-docs/customers/current-customer-api) - [Customers API (v3)](/api-reference/customer-subscribers/v3-customers-api) - [Subscribers API](/api-reference/customer-subscribers/subscribers-api)  ### Webhooks - [Customers](/api-docs/store-management/webhooks/webhook-events#customer)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV2\ApiException;
use Bigcommerce\CustomersV2\Configuration;
use Bigcommerce\CustomersV2\FormDataProcessor;
use Bigcommerce\CustomersV2\HeaderSelector;
use Bigcommerce\CustomersV2\ObjectSerializer;

/**
 * CustomersApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createANewCustomer' => [
            'application/json',
        ],
        'deleteACustomer' => [
            'application/json',
        ],
        'deleteAllCustomers' => [
            'application/json',
        ],
        'getACountOfCustomers' => [
            'application/json',
        ],
        'getACustomer' => [
            'application/json',
        ],
        'getAllCustomers' => [
            'application/json',
        ],
        'updateACustomer' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createANewCustomer
     *
     * Create a New Customer
     *
     * @param  \Bigcommerce\CustomersV2\Model\CreateANewCustomerRequest $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createANewCustomer'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerFull
     * @deprecated
     */
    public function createANewCustomer($body, string $contentType = self::contentTypes['createANewCustomer'][0])
    {
        list($response) = $this->createANewCustomerWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation createANewCustomerWithHttpInfo
     *
     * Create a New Customer
     *
     * @param  \Bigcommerce\CustomersV2\Model\CreateANewCustomerRequest $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createANewCustomer'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerFull, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function createANewCustomerWithHttpInfo($body, string $contentType = self::contentTypes['createANewCustomer'][0])
    {
        $request = $this->createANewCustomerRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createANewCustomerAsync
     *
     * Create a New Customer
     *
     * @param  \Bigcommerce\CustomersV2\Model\CreateANewCustomerRequest $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createANewCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function createANewCustomerAsync($body, string $contentType = self::contentTypes['createANewCustomer'][0])
    {
        return $this->createANewCustomerAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createANewCustomerAsyncWithHttpInfo
     *
     * Create a New Customer
     *
     * @param  \Bigcommerce\CustomersV2\Model\CreateANewCustomerRequest $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createANewCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function createANewCustomerAsyncWithHttpInfo($body, string $contentType = self::contentTypes['createANewCustomer'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerFull';
        $request = $this->createANewCustomerRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createANewCustomer'
     *
     * @param  \Bigcommerce\CustomersV2\Model\CreateANewCustomerRequest $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createANewCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function createANewCustomerRequest($body, string $contentType = self::contentTypes['createANewCustomer'][0])
    {

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createANewCustomer'
            );
        }


        $resourcePath = '/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteACustomer
     *
     * Delete a Customer
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomer'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     * @deprecated
     */
    public function deleteACustomer($customer_id, string $contentType = self::contentTypes['deleteACustomer'][0])
    {
        $this->deleteACustomerWithHttpInfo($customer_id, $contentType);
    }

    /**
     * Operation deleteACustomerWithHttpInfo
     *
     * Delete a Customer
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomer'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function deleteACustomerWithHttpInfo($customer_id, string $contentType = self::contentTypes['deleteACustomer'][0])
    {
        $request = $this->deleteACustomerRequest($customer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteACustomerAsync
     *
     * Delete a Customer
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deleteACustomerAsync($customer_id, string $contentType = self::contentTypes['deleteACustomer'][0])
    {
        return $this->deleteACustomerAsyncWithHttpInfo($customer_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteACustomerAsyncWithHttpInfo
     *
     * Delete a Customer
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deleteACustomerAsyncWithHttpInfo($customer_id, string $contentType = self::contentTypes['deleteACustomer'][0])
    {
        $returnType = '';
        $request = $this->deleteACustomerRequest($customer_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteACustomer'
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function deleteACustomerRequest($customer_id, string $contentType = self::contentTypes['deleteACustomer'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling deleteACustomer'
            );
        }


        $resourcePath = '/customers/{customer_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAllCustomers
     *
     * Delete Customers
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomers'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     * @deprecated
     */
    public function deleteAllCustomers(string $contentType = self::contentTypes['deleteAllCustomers'][0])
    {
        $this->deleteAllCustomersWithHttpInfo($contentType);
    }

    /**
     * Operation deleteAllCustomersWithHttpInfo
     *
     * Delete Customers
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomers'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function deleteAllCustomersWithHttpInfo(string $contentType = self::contentTypes['deleteAllCustomers'][0])
    {
        $request = $this->deleteAllCustomersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteAllCustomersAsync
     *
     * Delete Customers
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deleteAllCustomersAsync(string $contentType = self::contentTypes['deleteAllCustomers'][0])
    {
        return $this->deleteAllCustomersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAllCustomersAsyncWithHttpInfo
     *
     * Delete Customers
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deleteAllCustomersAsyncWithHttpInfo(string $contentType = self::contentTypes['deleteAllCustomers'][0])
    {
        $returnType = '';
        $request = $this->deleteAllCustomersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAllCustomers'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function deleteAllCustomersRequest(string $contentType = self::contentTypes['deleteAllCustomers'][0])
    {


        $resourcePath = '/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getACountOfCustomers
     *
     * Get a Count of Customers
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomers'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CountFull
     * @deprecated
     */
    public function getACountOfCustomers(string $contentType = self::contentTypes['getACountOfCustomers'][0])
    {
        list($response) = $this->getACountOfCustomersWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getACountOfCustomersWithHttpInfo
     *
     * Get a Count of Customers
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomers'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CountFull, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getACountOfCustomersWithHttpInfo(string $contentType = self::contentTypes['getACountOfCustomers'][0])
    {
        $request = $this->getACountOfCustomersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CountFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CountFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CountFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getACountOfCustomersAsync
     *
     * Get a Count of Customers
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getACountOfCustomersAsync(string $contentType = self::contentTypes['getACountOfCustomers'][0])
    {
        return $this->getACountOfCustomersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getACountOfCustomersAsyncWithHttpInfo
     *
     * Get a Count of Customers
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getACountOfCustomersAsyncWithHttpInfo(string $contentType = self::contentTypes['getACountOfCustomers'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CountFull';
        $request = $this->getACountOfCustomersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getACountOfCustomers'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getACountOfCustomersRequest(string $contentType = self::contentTypes['getACountOfCustomers'][0])
    {


        $resourcePath = '/customers/count';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getACustomer
     *
     * Get a Customer
     *
     * @param  int $customer_id Unique numeric ID of this customer. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomer'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerFull
     * @deprecated
     */
    public function getACustomer($customer_id, string $contentType = self::contentTypes['getACustomer'][0])
    {
        list($response) = $this->getACustomerWithHttpInfo($customer_id, $contentType);
        return $response;
    }

    /**
     * Operation getACustomerWithHttpInfo
     *
     * Get a Customer
     *
     * @param  int $customer_id Unique numeric ID of this customer. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomer'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerFull, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getACustomerWithHttpInfo($customer_id, string $contentType = self::contentTypes['getACustomer'][0])
    {
        $request = $this->getACustomerRequest($customer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getACustomerAsync
     *
     * Get a Customer
     *
     * @param  int $customer_id Unique numeric ID of this customer. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getACustomerAsync($customer_id, string $contentType = self::contentTypes['getACustomer'][0])
    {
        return $this->getACustomerAsyncWithHttpInfo($customer_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getACustomerAsyncWithHttpInfo
     *
     * Get a Customer
     *
     * @param  int $customer_id Unique numeric ID of this customer. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getACustomerAsyncWithHttpInfo($customer_id, string $contentType = self::contentTypes['getACustomer'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerFull';
        $request = $this->getACustomerRequest($customer_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getACustomer'
     *
     * @param  int $customer_id Unique numeric ID of this customer. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getACustomerRequest($customer_id, string $contentType = self::contentTypes['getACustomer'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling getACustomer'
            );
        }
        

        $resourcePath = '/customers/{customer_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllCustomers
     *
     * Get All Customers
     *
     * @param  string|null $first_name first_name (optional)
     * @param  string|null $last_name last_name (optional)
     * @param  string|null $company company (optional)
     * @param  string|null $email email (optional)
     * @param  string|null $phone phone (optional)
     * @param  string|null $store_credit store_credit (optional)
     * @param  int|null $customer_group_id customer_group_id (optional)
     * @param  int|null $min_id min_id (optional)
     * @param  int|null $max_id max_id (optional)
     * @param  \DateTime|null $min_date_created min_date_created (optional)
     * @param  \DateTime|null $max_date_created max_date_created (optional)
     * @param  \DateTime|null $min_date_modified min_date_modified (optional)
     * @param  \DateTime|null $max_date_modified max_date_modified (optional)
     * @param  string|null $tax_exempt_category tax_exempt_category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomers'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerFull[]
     * @deprecated
     */
    public function getAllCustomers($first_name = null, $last_name = null, $company = null, $email = null, $phone = null, $store_credit = null, $customer_group_id = null, $min_id = null, $max_id = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $tax_exempt_category = null, string $contentType = self::contentTypes['getAllCustomers'][0])
    {
        list($response) = $this->getAllCustomersWithHttpInfo($first_name, $last_name, $company, $email, $phone, $store_credit, $customer_group_id, $min_id, $max_id, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $tax_exempt_category, $contentType);
        return $response;
    }

    /**
     * Operation getAllCustomersWithHttpInfo
     *
     * Get All Customers
     *
     * @param  string|null $first_name (optional)
     * @param  string|null $last_name (optional)
     * @param  string|null $company (optional)
     * @param  string|null $email (optional)
     * @param  string|null $phone (optional)
     * @param  string|null $store_credit (optional)
     * @param  int|null $customer_group_id (optional)
     * @param  int|null $min_id (optional)
     * @param  int|null $max_id (optional)
     * @param  \DateTime|null $min_date_created (optional)
     * @param  \DateTime|null $max_date_created (optional)
     * @param  \DateTime|null $min_date_modified (optional)
     * @param  \DateTime|null $max_date_modified (optional)
     * @param  string|null $tax_exempt_category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomers'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerFull[], HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getAllCustomersWithHttpInfo($first_name = null, $last_name = null, $company = null, $email = null, $phone = null, $store_credit = null, $customer_group_id = null, $min_id = null, $max_id = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $tax_exempt_category = null, string $contentType = self::contentTypes['getAllCustomers'][0])
    {
        $request = $this->getAllCustomersRequest($first_name, $last_name, $company, $email, $phone, $store_credit, $customer_group_id, $min_id, $max_id, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $tax_exempt_category, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerFull[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerFull[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerFull[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAllCustomersAsync
     *
     * Get All Customers
     *
     * @param  string|null $first_name (optional)
     * @param  string|null $last_name (optional)
     * @param  string|null $company (optional)
     * @param  string|null $email (optional)
     * @param  string|null $phone (optional)
     * @param  string|null $store_credit (optional)
     * @param  int|null $customer_group_id (optional)
     * @param  int|null $min_id (optional)
     * @param  int|null $max_id (optional)
     * @param  \DateTime|null $min_date_created (optional)
     * @param  \DateTime|null $max_date_created (optional)
     * @param  \DateTime|null $min_date_modified (optional)
     * @param  \DateTime|null $max_date_modified (optional)
     * @param  string|null $tax_exempt_category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getAllCustomersAsync($first_name = null, $last_name = null, $company = null, $email = null, $phone = null, $store_credit = null, $customer_group_id = null, $min_id = null, $max_id = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $tax_exempt_category = null, string $contentType = self::contentTypes['getAllCustomers'][0])
    {
        return $this->getAllCustomersAsyncWithHttpInfo($first_name, $last_name, $company, $email, $phone, $store_credit, $customer_group_id, $min_id, $max_id, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $tax_exempt_category, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllCustomersAsyncWithHttpInfo
     *
     * Get All Customers
     *
     * @param  string|null $first_name (optional)
     * @param  string|null $last_name (optional)
     * @param  string|null $company (optional)
     * @param  string|null $email (optional)
     * @param  string|null $phone (optional)
     * @param  string|null $store_credit (optional)
     * @param  int|null $customer_group_id (optional)
     * @param  int|null $min_id (optional)
     * @param  int|null $max_id (optional)
     * @param  \DateTime|null $min_date_created (optional)
     * @param  \DateTime|null $max_date_created (optional)
     * @param  \DateTime|null $min_date_modified (optional)
     * @param  \DateTime|null $max_date_modified (optional)
     * @param  string|null $tax_exempt_category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getAllCustomersAsyncWithHttpInfo($first_name = null, $last_name = null, $company = null, $email = null, $phone = null, $store_credit = null, $customer_group_id = null, $min_id = null, $max_id = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $tax_exempt_category = null, string $contentType = self::contentTypes['getAllCustomers'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerFull[]';
        $request = $this->getAllCustomersRequest($first_name, $last_name, $company, $email, $phone, $store_credit, $customer_group_id, $min_id, $max_id, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $tax_exempt_category, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllCustomers'
     *
     * @param  string|null $first_name (optional)
     * @param  string|null $last_name (optional)
     * @param  string|null $company (optional)
     * @param  string|null $email (optional)
     * @param  string|null $phone (optional)
     * @param  string|null $store_credit (optional)
     * @param  int|null $customer_group_id (optional)
     * @param  int|null $min_id (optional)
     * @param  int|null $max_id (optional)
     * @param  \DateTime|null $min_date_created (optional)
     * @param  \DateTime|null $max_date_created (optional)
     * @param  \DateTime|null $min_date_modified (optional)
     * @param  \DateTime|null $max_date_modified (optional)
     * @param  string|null $tax_exempt_category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getAllCustomersRequest($first_name = null, $last_name = null, $company = null, $email = null, $phone = null, $store_credit = null, $customer_group_id = null, $min_id = null, $max_id = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $tax_exempt_category = null, string $contentType = self::contentTypes['getAllCustomers'][0])
    {
















        $resourcePath = '/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $first_name,
            'first_name', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_name,
            'last_name', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $company,
            'company', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $email,
            'email', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $phone,
            'phone', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $store_credit,
            'store_credit', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_group_id,
            'customer_group_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_id,
            'min_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_id,
            'max_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_date_created,
            'min_date_created', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_date_created,
            'max_date_created	', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_date_modified,
            'min_date_modified', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_date_modified,
            'max_date_modified', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $tax_exempt_category,
            'tax_exempt_category', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateACustomer
     *
     * Update a Customer
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\Customers|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomer'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerBase
     * @deprecated
     */
    public function updateACustomer($customer_id, $body = null, string $contentType = self::contentTypes['updateACustomer'][0])
    {
        list($response) = $this->updateACustomerWithHttpInfo($customer_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation updateACustomerWithHttpInfo
     *
     * Update a Customer
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\Customers|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomer'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerBase, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function updateACustomerWithHttpInfo($customer_id, $body = null, string $contentType = self::contentTypes['updateACustomer'][0])
    {
        $request = $this->updateACustomerRequest($customer_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerBase',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerBase',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerBase',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateACustomerAsync
     *
     * Update a Customer
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\Customers|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function updateACustomerAsync($customer_id, $body = null, string $contentType = self::contentTypes['updateACustomer'][0])
    {
        return $this->updateACustomerAsyncWithHttpInfo($customer_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateACustomerAsyncWithHttpInfo
     *
     * Update a Customer
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\Customers|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function updateACustomerAsyncWithHttpInfo($customer_id, $body = null, string $contentType = self::contentTypes['updateACustomer'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerBase';
        $request = $this->updateACustomerRequest($customer_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateACustomer'
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\Customers|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function updateACustomerRequest($customer_id, $body = null, string $contentType = self::contentTypes['updateACustomer'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling updateACustomer'
            );
        }



        $resourcePath = '/customers/{customer_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
