<?php
/**
 * CustomerGroupsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V2
 *
 * Create and Manage Customers, Customer Addresses, and Customer Groups. Additionally, validate customer passwords. To learn more about Customers see [here](/api-docs/customers/customers-subscribers-overview).   ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/{store_hash}/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](/api-docs/getting-started/authentication).  ## Available Endpoints | Resource / Endpoint                     | Description                                                                   | |-----------------------------------------|-------------------------------------------------------------------------------| | Customers                               | Identity and account details for customers shopping on BigCommerce stores     | | Customers Addresses                     | Postal address belonging to a customer.                                       | | Customers Groups                        | Groupings of customers who share the same level of access and discounts       | | Customers Validate Password             | Validate customer passwords                                                   |  ## Usage Notes  **Customer Groups** * Customer Groups are only available on specific plans.  **Customers vs. Subscribers** * A subscriber is not always a customer. Someone can sign up for the newsletter only and not create an account. * A customer is not always a subscriber. Signing up for the newsletter is a separate action from creating an account and purchasing an item. * A customer and a subscriber can be the same. If a shopper checks out on the storefront, creates an account and opts into the newsletter, they are a customer and a subscriber.  ## Resources  ### Related APIs / Endpoints   [Customer Login API](/api-docs/customers/customer-login-api) - [Current Customer API](/api-docs/customers/current-customer-api) - [Customers API (v3)](/api-reference/customer-subscribers/v3-customers-api) - [Subscribers API](/api-reference/customer-subscribers/subscribers-api)  ### Webhooks - [Customers](/api-docs/store-management/webhooks/webhook-events#customer)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV2\ApiException;
use Bigcommerce\CustomersV2\Configuration;
use Bigcommerce\CustomersV2\FormDataProcessor;
use Bigcommerce\CustomersV2\HeaderSelector;
use Bigcommerce\CustomersV2\ObjectSerializer;

/**
 * CustomerGroupsApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerGroupsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createACustomerGroup' => [
            'application/json',
        ],
        'deleteACustomerGroup' => [
            'application/json',
        ],
        'deleteAllCustomerGroups' => [
            'application/json',
        ],
        'getACountOfCustomerGroups' => [
            'application/json',
        ],
        'getACustomerGroup' => [
            'application/json',
        ],
        'getAllCustomerGroups' => [
            'application/json',
        ],
        'updateACustomerGroup' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createACustomerGroup
     *
     * Create a Customer Group
     *
     * @param  string $x_auth_token x_auth_token (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupPost $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerGroup'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerGroupFull|\Bigcommerce\CustomersV2\Model\CreateACustomerGroup207Response
     */
    public function createACustomerGroup($x_auth_token, $body, string $contentType = self::contentTypes['createACustomerGroup'][0])
    {
        list($response) = $this->createACustomerGroupWithHttpInfo($x_auth_token, $body, $contentType);
        return $response;
    }

    /**
     * Operation createACustomerGroupWithHttpInfo
     *
     * Create a Customer Group
     *
     * @param  string $x_auth_token (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupPost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerGroup'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerGroupFull|\Bigcommerce\CustomersV2\Model\CreateACustomerGroup207Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function createACustomerGroupWithHttpInfo($x_auth_token, $body, string $contentType = self::contentTypes['createACustomerGroup'][0])
    {
        $request = $this->createACustomerGroupRequest($x_auth_token, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                        $request,
                        $response,
                    );
                case 207:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CreateACustomerGroup207Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CreateACustomerGroup207Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createACustomerGroupAsync
     *
     * Create a Customer Group
     *
     * @param  string $x_auth_token (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupPost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createACustomerGroupAsync($x_auth_token, $body, string $contentType = self::contentTypes['createACustomerGroup'][0])
    {
        return $this->createACustomerGroupAsyncWithHttpInfo($x_auth_token, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createACustomerGroupAsyncWithHttpInfo
     *
     * Create a Customer Group
     *
     * @param  string $x_auth_token (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupPost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createACustomerGroupAsyncWithHttpInfo($x_auth_token, $body, string $contentType = self::contentTypes['createACustomerGroup'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerGroupFull';
        $request = $this->createACustomerGroupRequest($x_auth_token, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createACustomerGroup'
     *
     * @param  string $x_auth_token (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupPost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createACustomerGroupRequest($x_auth_token, $body, string $contentType = self::contentTypes['createACustomerGroup'][0])
    {

        // verify the required parameter 'x_auth_token' is set
        if ($x_auth_token === null || (is_array($x_auth_token) && count($x_auth_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_auth_token when calling createACustomerGroup'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createACustomerGroup'
            );
        }


        $resourcePath = '/customer_groups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_auth_token !== null) {
            $headerParams['X-Auth-Token'] = ObjectSerializer::toHeaderValue($x_auth_token);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteACustomerGroup
     *
     * Delete a Customer Group
     *
     * @param  int $customer_group_id The id of the customer group. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomerGroup'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteACustomerGroup($customer_group_id, string $contentType = self::contentTypes['deleteACustomerGroup'][0])
    {
        $this->deleteACustomerGroupWithHttpInfo($customer_group_id, $contentType);
    }

    /**
     * Operation deleteACustomerGroupWithHttpInfo
     *
     * Delete a Customer Group
     *
     * @param  int $customer_group_id The id of the customer group. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomerGroup'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteACustomerGroupWithHttpInfo($customer_group_id, string $contentType = self::contentTypes['deleteACustomerGroup'][0])
    {
        $request = $this->deleteACustomerGroupRequest($customer_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteACustomerGroupAsync
     *
     * Delete a Customer Group
     *
     * @param  int $customer_group_id The id of the customer group. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteACustomerGroupAsync($customer_group_id, string $contentType = self::contentTypes['deleteACustomerGroup'][0])
    {
        return $this->deleteACustomerGroupAsyncWithHttpInfo($customer_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteACustomerGroupAsyncWithHttpInfo
     *
     * Delete a Customer Group
     *
     * @param  int $customer_group_id The id of the customer group. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteACustomerGroupAsyncWithHttpInfo($customer_group_id, string $contentType = self::contentTypes['deleteACustomerGroup'][0])
    {
        $returnType = '';
        $request = $this->deleteACustomerGroupRequest($customer_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteACustomerGroup'
     *
     * @param  int $customer_group_id The id of the customer group. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteACustomerGroupRequest($customer_group_id, string $contentType = self::contentTypes['deleteACustomerGroup'][0])
    {

        // verify the required parameter 'customer_group_id' is set
        if ($customer_group_id === null || (is_array($customer_group_id) && count($customer_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_group_id when calling deleteACustomerGroup'
            );
        }
        

        $resourcePath = '/customer_groups/{customer_group_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_group_id' . '}',
                ObjectSerializer::toPathValue($customer_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAllCustomerGroups
     *
     * Delete Customer Groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteAllCustomerGroups(string $contentType = self::contentTypes['deleteAllCustomerGroups'][0])
    {
        $this->deleteAllCustomerGroupsWithHttpInfo($contentType);
    }

    /**
     * Operation deleteAllCustomerGroupsWithHttpInfo
     *
     * Delete Customer Groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAllCustomerGroupsWithHttpInfo(string $contentType = self::contentTypes['deleteAllCustomerGroups'][0])
    {
        $request = $this->deleteAllCustomerGroupsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteAllCustomerGroupsAsync
     *
     * Delete Customer Groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAllCustomerGroupsAsync(string $contentType = self::contentTypes['deleteAllCustomerGroups'][0])
    {
        return $this->deleteAllCustomerGroupsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAllCustomerGroupsAsyncWithHttpInfo
     *
     * Delete Customer Groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAllCustomerGroupsAsyncWithHttpInfo(string $contentType = self::contentTypes['deleteAllCustomerGroups'][0])
    {
        $returnType = '';
        $request = $this->deleteAllCustomerGroupsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAllCustomerGroups'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteAllCustomerGroupsRequest(string $contentType = self::contentTypes['deleteAllCustomerGroups'][0])
    {


        $resourcePath = '/customer_groups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getACountOfCustomerGroups
     *
     * Get a Count of Customer Groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomerGroups'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CountFull
     */
    public function getACountOfCustomerGroups(string $contentType = self::contentTypes['getACountOfCustomerGroups'][0])
    {
        list($response) = $this->getACountOfCustomerGroupsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getACountOfCustomerGroupsWithHttpInfo
     *
     * Get a Count of Customer Groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomerGroups'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CountFull, HTTP status code, HTTP response headers (array of strings)
     */
    public function getACountOfCustomerGroupsWithHttpInfo(string $contentType = self::contentTypes['getACountOfCustomerGroups'][0])
    {
        $request = $this->getACountOfCustomerGroupsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CountFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CountFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CountFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getACountOfCustomerGroupsAsync
     *
     * Get a Count of Customer Groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getACountOfCustomerGroupsAsync(string $contentType = self::contentTypes['getACountOfCustomerGroups'][0])
    {
        return $this->getACountOfCustomerGroupsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getACountOfCustomerGroupsAsyncWithHttpInfo
     *
     * Get a Count of Customer Groups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getACountOfCustomerGroupsAsyncWithHttpInfo(string $contentType = self::contentTypes['getACountOfCustomerGroups'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CountFull';
        $request = $this->getACountOfCustomerGroupsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getACountOfCustomerGroups'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountOfCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getACountOfCustomerGroupsRequest(string $contentType = self::contentTypes['getACountOfCustomerGroups'][0])
    {


        $resourcePath = '/customer_groups/count';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getACustomerGroup
     *
     * Get a Customer Group
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Name of the customer groups (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerGroup'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerGroupFull
     */
    public function getACustomerGroup($customer_group_id, $page = null, $limit = null, $name = null, $is_default = null, string $contentType = self::contentTypes['getACustomerGroup'][0])
    {
        list($response) = $this->getACustomerGroupWithHttpInfo($customer_group_id, $page, $limit, $name, $is_default, $contentType);
        return $response;
    }

    /**
     * Operation getACustomerGroupWithHttpInfo
     *
     * Get a Customer Group
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Name of the customer groups (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerGroup'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerGroupFull, HTTP status code, HTTP response headers (array of strings)
     */
    public function getACustomerGroupWithHttpInfo($customer_group_id, $page = null, $limit = null, $name = null, $is_default = null, string $contentType = self::contentTypes['getACustomerGroup'][0])
    {
        $request = $this->getACustomerGroupRequest($customer_group_id, $page, $limit, $name, $is_default, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getACustomerGroupAsync
     *
     * Get a Customer Group
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Name of the customer groups (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getACustomerGroupAsync($customer_group_id, $page = null, $limit = null, $name = null, $is_default = null, string $contentType = self::contentTypes['getACustomerGroup'][0])
    {
        return $this->getACustomerGroupAsyncWithHttpInfo($customer_group_id, $page, $limit, $name, $is_default, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getACustomerGroupAsyncWithHttpInfo
     *
     * Get a Customer Group
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Name of the customer groups (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getACustomerGroupAsyncWithHttpInfo($customer_group_id, $page = null, $limit = null, $name = null, $is_default = null, string $contentType = self::contentTypes['getACustomerGroup'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerGroupFull';
        $request = $this->getACustomerGroupRequest($customer_group_id, $page, $limit, $name, $is_default, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getACustomerGroup'
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Name of the customer groups (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getACustomerGroupRequest($customer_group_id, $page = null, $limit = null, $name = null, $is_default = null, string $contentType = self::contentTypes['getACustomerGroup'][0])
    {

        // verify the required parameter 'customer_group_id' is set
        if ($customer_group_id === null || (is_array($customer_group_id) && count($customer_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_group_id when calling getACustomerGroup'
            );
        }

        
        



        $resourcePath = '/customer_groups/{customer_group_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_default,
            'is_default', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_group_id' . '}',
                ObjectSerializer::toPathValue($customer_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllCustomerGroups
     *
     * Get All Customer Groups
     *
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Filter customer groups by exact name match. Can use &#x60;name:like&#x60; to filter using a fuzzy matching method. This is good for implementing search. (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  bool|null $is_group_for_guests If the groups is for guests. There can only be one customer group for guests at a time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerGroupFull[]|string
     */
    public function getAllCustomerGroups($page = null, $limit = null, $name = null, $is_default = null, $is_group_for_guests = null, string $contentType = self::contentTypes['getAllCustomerGroups'][0])
    {
        list($response) = $this->getAllCustomerGroupsWithHttpInfo($page, $limit, $name, $is_default, $is_group_for_guests, $contentType);
        return $response;
    }

    /**
     * Operation getAllCustomerGroupsWithHttpInfo
     *
     * Get All Customer Groups
     *
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Filter customer groups by exact name match. Can use &#x60;name:like&#x60; to filter using a fuzzy matching method. This is good for implementing search. (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  bool|null $is_group_for_guests If the groups is for guests. There can only be one customer group for guests at a time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerGroupFull[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllCustomerGroupsWithHttpInfo($page = null, $limit = null, $name = null, $is_default = null, $is_group_for_guests = null, string $contentType = self::contentTypes['getAllCustomerGroups'][0])
    {
        $request = $this->getAllCustomerGroupsRequest($page, $limit, $name, $is_default, $is_group_for_guests, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerGroupFull[]',
                        $request,
                        $response,
                    );
                case 204:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerGroupFull[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerGroupFull[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 204:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAllCustomerGroupsAsync
     *
     * Get All Customer Groups
     *
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Filter customer groups by exact name match. Can use &#x60;name:like&#x60; to filter using a fuzzy matching method. This is good for implementing search. (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  bool|null $is_group_for_guests If the groups is for guests. There can only be one customer group for guests at a time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllCustomerGroupsAsync($page = null, $limit = null, $name = null, $is_default = null, $is_group_for_guests = null, string $contentType = self::contentTypes['getAllCustomerGroups'][0])
    {
        return $this->getAllCustomerGroupsAsyncWithHttpInfo($page, $limit, $name, $is_default, $is_group_for_guests, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllCustomerGroupsAsyncWithHttpInfo
     *
     * Get All Customer Groups
     *
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Filter customer groups by exact name match. Can use &#x60;name:like&#x60; to filter using a fuzzy matching method. This is good for implementing search. (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  bool|null $is_group_for_guests If the groups is for guests. There can only be one customer group for guests at a time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllCustomerGroupsAsyncWithHttpInfo($page = null, $limit = null, $name = null, $is_default = null, $is_group_for_guests = null, string $contentType = self::contentTypes['getAllCustomerGroups'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerGroupFull[]';
        $request = $this->getAllCustomerGroupsRequest($page, $limit, $name, $is_default, $is_group_for_guests, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllCustomerGroups'
     *
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string|null $name Filter customer groups by exact name match. Can use &#x60;name:like&#x60; to filter using a fuzzy matching method. This is good for implementing search. (optional)
     * @param  bool|null $is_default If customers who signup are added to this group by default (optional)
     * @param  bool|null $is_group_for_guests If the groups is for guests. There can only be one customer group for guests at a time. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllCustomerGroupsRequest($page = null, $limit = null, $name = null, $is_default = null, $is_group_for_guests = null, string $contentType = self::contentTypes['getAllCustomerGroups'][0])
    {

        
        




        $resourcePath = '/customer_groups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_default,
            'is_default', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_group_for_guests,
            'is_group_for_guests', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateACustomerGroup
     *
     * Update a Customer Group
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupFull|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerGroup'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerGroupFull|\Bigcommerce\CustomersV2\Model\UpdateACustomerGroup207Response
     */
    public function updateACustomerGroup($customer_group_id, $body = null, string $contentType = self::contentTypes['updateACustomerGroup'][0])
    {
        list($response) = $this->updateACustomerGroupWithHttpInfo($customer_group_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation updateACustomerGroupWithHttpInfo
     *
     * Update a Customer Group
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupFull|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerGroup'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerGroupFull|\Bigcommerce\CustomersV2\Model\UpdateACustomerGroup207Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateACustomerGroupWithHttpInfo($customer_group_id, $body = null, string $contentType = self::contentTypes['updateACustomerGroup'][0])
    {
        $request = $this->updateACustomerGroupRequest($customer_group_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                        $request,
                        $response,
                    );
                case 207:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\UpdateACustomerGroup207Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerGroupFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\UpdateACustomerGroup207Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateACustomerGroupAsync
     *
     * Update a Customer Group
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupFull|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateACustomerGroupAsync($customer_group_id, $body = null, string $contentType = self::contentTypes['updateACustomerGroup'][0])
    {
        return $this->updateACustomerGroupAsyncWithHttpInfo($customer_group_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateACustomerGroupAsyncWithHttpInfo
     *
     * Update a Customer Group
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupFull|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateACustomerGroupAsyncWithHttpInfo($customer_group_id, $body = null, string $contentType = self::contentTypes['updateACustomerGroup'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerGroupFull';
        $request = $this->updateACustomerGroupRequest($customer_group_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateACustomerGroup'
     *
     * @param  int $customer_group_id Id of the customer group (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerGroupFull|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateACustomerGroupRequest($customer_group_id, $body = null, string $contentType = self::contentTypes['updateACustomerGroup'][0])
    {

        // verify the required parameter 'customer_group_id' is set
        if ($customer_group_id === null || (is_array($customer_group_id) && count($customer_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_group_id when calling updateACustomerGroup'
            );
        }



        $resourcePath = '/customer_groups/{customer_group_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_group_id' . '}',
                ObjectSerializer::toPathValue($customer_group_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
