<?php
/**
 * CustomerAddressesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V2
 *
 * Create and Manage Customers, Customer Addresses, and Customer Groups. Additionally, validate customer passwords. To learn more about Customers see [here](/api-docs/customers/customers-subscribers-overview).   ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/{store_hash}/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](/api-docs/getting-started/authentication).  ## Available Endpoints | Resource / Endpoint                     | Description                                                                   | |-----------------------------------------|-------------------------------------------------------------------------------| | Customers                               | Identity and account details for customers shopping on BigCommerce stores     | | Customers Addresses                     | Postal address belonging to a customer.                                       | | Customers Groups                        | Groupings of customers who share the same level of access and discounts       | | Customers Validate Password             | Validate customer passwords                                                   |  ## Usage Notes  **Customer Groups** * Customer Groups are only available on specific plans.  **Customers vs. Subscribers** * A subscriber is not always a customer. Someone can sign up for the newsletter only and not create an account. * A customer is not always a subscriber. Signing up for the newsletter is a separate action from creating an account and purchasing an item. * A customer and a subscriber can be the same. If a shopper checks out on the storefront, creates an account and opts into the newsletter, they are a customer and a subscriber.  ## Resources  ### Related APIs / Endpoints   [Customer Login API](/api-docs/customers/customer-login-api) - [Current Customer API](/api-docs/customers/current-customer-api) - [Customers API (v3)](/api-reference/customer-subscribers/v3-customers-api) - [Subscribers API](/api-reference/customer-subscribers/subscribers-api)  ### Webhooks - [Customers](/api-docs/store-management/webhooks/webhook-events#customer)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV2\ApiException;
use Bigcommerce\CustomersV2\Configuration;
use Bigcommerce\CustomersV2\FormDataProcessor;
use Bigcommerce\CustomersV2\HeaderSelector;
use Bigcommerce\CustomersV2\ObjectSerializer;

/**
 * CustomerAddressesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerAddressesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createACustomerAddress' => [
            'application/json',
        ],
        'deleteAllCustomerAddresses' => [
            'application/json',
        ],
        'deletesACustomerAddress' => [
            'application/json',
        ],
        'getACountofCustomerAddresses' => [
            'application/json',
        ],
        'getACustomerAddress' => [
            'application/json',
        ],
        'getAllCustomerAddresses' => [
            'application/json',
        ],
        'updateACustomerAddress' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createACustomerAddress
     *
     * Create a Customer Address
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddressBase $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerAddressFull
     * @deprecated
     */
    public function createACustomerAddress($customer_id, $body, string $contentType = self::contentTypes['createACustomerAddress'][0])
    {
        list($response) = $this->createACustomerAddressWithHttpInfo($customer_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation createACustomerAddressWithHttpInfo
     *
     * Create a Customer Address
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddressBase $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerAddressFull, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function createACustomerAddressWithHttpInfo($customer_id, $body, string $contentType = self::contentTypes['createACustomerAddress'][0])
    {
        $request = $this->createACustomerAddressRequest($customer_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createACustomerAddressAsync
     *
     * Create a Customer Address
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddressBase $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function createACustomerAddressAsync($customer_id, $body, string $contentType = self::contentTypes['createACustomerAddress'][0])
    {
        return $this->createACustomerAddressAsyncWithHttpInfo($customer_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createACustomerAddressAsyncWithHttpInfo
     *
     * Create a Customer Address
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddressBase $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function createACustomerAddressAsyncWithHttpInfo($customer_id, $body, string $contentType = self::contentTypes['createACustomerAddress'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerAddressFull';
        $request = $this->createACustomerAddressRequest($customer_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createACustomerAddress'
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddressBase $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function createACustomerAddressRequest($customer_id, $body, string $contentType = self::contentTypes['createACustomerAddress'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling createACustomerAddress'
            );
        }
        
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createACustomerAddress'
            );
        }


        $resourcePath = '/customers/{customer_id}/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAllCustomerAddresses
     *
     * Delete Customer Address
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     * @deprecated
     */
    public function deleteAllCustomerAddresses($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['deleteAllCustomerAddresses'][0])
    {
        $this->deleteAllCustomerAddressesWithHttpInfo($customer_id, $page, $limit, $contentType);
    }

    /**
     * Operation deleteAllCustomerAddressesWithHttpInfo
     *
     * Delete Customer Address
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function deleteAllCustomerAddressesWithHttpInfo($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['deleteAllCustomerAddresses'][0])
    {
        $request = $this->deleteAllCustomerAddressesRequest($customer_id, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteAllCustomerAddressesAsync
     *
     * Delete Customer Address
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deleteAllCustomerAddressesAsync($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['deleteAllCustomerAddresses'][0])
    {
        return $this->deleteAllCustomerAddressesAsyncWithHttpInfo($customer_id, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAllCustomerAddressesAsyncWithHttpInfo
     *
     * Delete Customer Address
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deleteAllCustomerAddressesAsyncWithHttpInfo($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['deleteAllCustomerAddresses'][0])
    {
        $returnType = '';
        $request = $this->deleteAllCustomerAddressesRequest($customer_id, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAllCustomerAddresses'
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function deleteAllCustomerAddressesRequest($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['deleteAllCustomerAddresses'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling deleteAllCustomerAddresses'
            );
        }

        
        

        $resourcePath = '/customers/{customer_id}/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletesACustomerAddress
     *
     * Delete a Customer Address
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  int $customer_address_id Id of the customer address. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletesACustomerAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     * @deprecated
     */
    public function deletesACustomerAddress($customer_id, $customer_address_id, string $contentType = self::contentTypes['deletesACustomerAddress'][0])
    {
        $this->deletesACustomerAddressWithHttpInfo($customer_id, $customer_address_id, $contentType);
    }

    /**
     * Operation deletesACustomerAddressWithHttpInfo
     *
     * Delete a Customer Address
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  int $customer_address_id Id of the customer address. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletesACustomerAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function deletesACustomerAddressWithHttpInfo($customer_id, $customer_address_id, string $contentType = self::contentTypes['deletesACustomerAddress'][0])
    {
        $request = $this->deletesACustomerAddressRequest($customer_id, $customer_address_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deletesACustomerAddressAsync
     *
     * Delete a Customer Address
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  int $customer_address_id Id of the customer address. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletesACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deletesACustomerAddressAsync($customer_id, $customer_address_id, string $contentType = self::contentTypes['deletesACustomerAddress'][0])
    {
        return $this->deletesACustomerAddressAsyncWithHttpInfo($customer_id, $customer_address_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletesACustomerAddressAsyncWithHttpInfo
     *
     * Delete a Customer Address
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  int $customer_address_id Id of the customer address. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletesACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deletesACustomerAddressAsyncWithHttpInfo($customer_id, $customer_address_id, string $contentType = self::contentTypes['deletesACustomerAddress'][0])
    {
        $returnType = '';
        $request = $this->deletesACustomerAddressRequest($customer_id, $customer_address_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletesACustomerAddress'
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  int $customer_address_id Id of the customer address. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletesACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function deletesACustomerAddressRequest($customer_id, $customer_address_id, string $contentType = self::contentTypes['deletesACustomerAddress'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling deletesACustomerAddress'
            );
        }

        // verify the required parameter 'customer_address_id' is set
        if ($customer_address_id === null || (is_array($customer_address_id) && count($customer_address_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_address_id when calling deletesACustomerAddress'
            );
        }


        $resourcePath = '/customers/{customer_id}/addresses/{customer_address_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }
        // path params
        if ($customer_address_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_address_id' . '}',
                ObjectSerializer::toPathValue($customer_address_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getACountofCustomerAddresses
     *
     * Get a Count of Customer Addresses
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountofCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CountFull
     * @deprecated
     */
    public function getACountofCustomerAddresses($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACountofCustomerAddresses'][0])
    {
        list($response) = $this->getACountofCustomerAddressesWithHttpInfo($customer_id, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation getACountofCustomerAddressesWithHttpInfo
     *
     * Get a Count of Customer Addresses
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountofCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CountFull, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getACountofCustomerAddressesWithHttpInfo($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACountofCustomerAddresses'][0])
    {
        $request = $this->getACountofCustomerAddressesRequest($customer_id, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CountFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CountFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CountFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getACountofCustomerAddressesAsync
     *
     * Get a Count of Customer Addresses
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountofCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getACountofCustomerAddressesAsync($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACountofCustomerAddresses'][0])
    {
        return $this->getACountofCustomerAddressesAsyncWithHttpInfo($customer_id, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getACountofCustomerAddressesAsyncWithHttpInfo
     *
     * Get a Count of Customer Addresses
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountofCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getACountofCustomerAddressesAsyncWithHttpInfo($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACountofCustomerAddresses'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CountFull';
        $request = $this->getACountofCustomerAddressesRequest($customer_id, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getACountofCustomerAddresses'
     *
     * @param  int $customer_id Id of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACountofCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getACountofCustomerAddressesRequest($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACountofCustomerAddresses'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling getACountofCustomerAddresses'
            );
        }

        
        

        $resourcePath = '/customers/{customer_id}/addresses/count';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getACustomerAddress
     *
     * Get a Customer Address
     *
     * @param  int $customer_address_id ID of the customer address (required)
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerAddressFull
     * @deprecated
     */
    public function getACustomerAddress($customer_address_id, $customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACustomerAddress'][0])
    {
        list($response) = $this->getACustomerAddressWithHttpInfo($customer_address_id, $customer_id, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation getACustomerAddressWithHttpInfo
     *
     * Get a Customer Address
     *
     * @param  int $customer_address_id ID of the customer address (required)
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerAddressFull, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getACustomerAddressWithHttpInfo($customer_address_id, $customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACustomerAddress'][0])
    {
        $request = $this->getACustomerAddressRequest($customer_address_id, $customer_id, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getACustomerAddressAsync
     *
     * Get a Customer Address
     *
     * @param  int $customer_address_id ID of the customer address (required)
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getACustomerAddressAsync($customer_address_id, $customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACustomerAddress'][0])
    {
        return $this->getACustomerAddressAsyncWithHttpInfo($customer_address_id, $customer_id, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getACustomerAddressAsyncWithHttpInfo
     *
     * Get a Customer Address
     *
     * @param  int $customer_address_id ID of the customer address (required)
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getACustomerAddressAsyncWithHttpInfo($customer_address_id, $customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACustomerAddress'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerAddressFull';
        $request = $this->getACustomerAddressRequest($customer_address_id, $customer_id, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getACustomerAddress'
     *
     * @param  int $customer_address_id ID of the customer address (required)
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getACustomerAddressRequest($customer_address_id, $customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getACustomerAddress'][0])
    {

        // verify the required parameter 'customer_address_id' is set
        if ($customer_address_id === null || (is_array($customer_address_id) && count($customer_address_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_address_id when calling getACustomerAddress'
            );
        }
        
        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling getACustomerAddress'
            );
        }
        
        
        

        $resourcePath = '/customers/{customer_id}/addresses/{customer_address_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_address_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_address_id' . '}',
                ObjectSerializer::toPathValue($customer_address_id),
                $resourcePath
            );
        }
        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllCustomerAddresses
     *
     * Get All Customer Addresses
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerAddressFull[]
     * @deprecated
     */
    public function getAllCustomerAddresses($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllCustomerAddresses'][0])
    {
        list($response) = $this->getAllCustomerAddressesWithHttpInfo($customer_id, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation getAllCustomerAddressesWithHttpInfo
     *
     * Get All Customer Addresses
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerAddressFull[], HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getAllCustomerAddressesWithHttpInfo($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllCustomerAddresses'][0])
    {
        $request = $this->getAllCustomerAddressesRequest($customer_id, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerAddressFull[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerAddressFull[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerAddressFull[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAllCustomerAddressesAsync
     *
     * Get All Customer Addresses
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getAllCustomerAddressesAsync($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllCustomerAddresses'][0])
    {
        return $this->getAllCustomerAddressesAsyncWithHttpInfo($customer_id, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllCustomerAddressesAsyncWithHttpInfo
     *
     * Get All Customer Addresses
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getAllCustomerAddressesAsyncWithHttpInfo($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllCustomerAddresses'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerAddressFull[]';
        $request = $this->getAllCustomerAddressesRequest($customer_id, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllCustomerAddresses'
     *
     * @param  int $customer_id ID of the customer (required)
     * @param  float|null $page Number of pages (optional)
     * @param  float|null $limit Count per page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getAllCustomerAddressesRequest($customer_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllCustomerAddresses'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling getAllCustomerAddresses'
            );
        }
        
        
        

        $resourcePath = '/customers/{customer_id}/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateACustomerAddress
     *
     * Update a Customer Address
     *
     * @param  int $customer_id ID of this customer (required)
     * @param  int $customer_address_id ID of the customer address. (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddress $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV2\Model\CustomerAddressFull
     * @deprecated
     */
    public function updateACustomerAddress($customer_id, $customer_address_id, $body, string $contentType = self::contentTypes['updateACustomerAddress'][0])
    {
        list($response) = $this->updateACustomerAddressWithHttpInfo($customer_id, $customer_address_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation updateACustomerAddressWithHttpInfo
     *
     * Update a Customer Address
     *
     * @param  int $customer_id ID of this customer (required)
     * @param  int $customer_address_id ID of the customer address. (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddress $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV2\Model\CustomerAddressFull, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function updateACustomerAddressWithHttpInfo($customer_id, $customer_address_id, $body, string $contentType = self::contentTypes['updateACustomerAddress'][0])
    {
        $request = $this->updateACustomerAddressRequest($customer_id, $customer_address_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV2\Model\CustomerAddressFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateACustomerAddressAsync
     *
     * Update a Customer Address
     *
     * @param  int $customer_id ID of this customer (required)
     * @param  int $customer_address_id ID of the customer address. (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddress $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function updateACustomerAddressAsync($customer_id, $customer_address_id, $body, string $contentType = self::contentTypes['updateACustomerAddress'][0])
    {
        return $this->updateACustomerAddressAsyncWithHttpInfo($customer_id, $customer_address_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateACustomerAddressAsyncWithHttpInfo
     *
     * Update a Customer Address
     *
     * @param  int $customer_id ID of this customer (required)
     * @param  int $customer_address_id ID of the customer address. (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddress $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function updateACustomerAddressAsyncWithHttpInfo($customer_id, $customer_address_id, $body, string $contentType = self::contentTypes['updateACustomerAddress'][0])
    {
        $returnType = '\Bigcommerce\CustomersV2\Model\CustomerAddressFull';
        $request = $this->updateACustomerAddressRequest($customer_id, $customer_address_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateACustomerAddress'
     *
     * @param  int $customer_id ID of this customer (required)
     * @param  int $customer_address_id ID of the customer address. (required)
     * @param  \Bigcommerce\CustomersV2\Model\CustomerAddress $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateACustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function updateACustomerAddressRequest($customer_id, $customer_address_id, $body, string $contentType = self::contentTypes['updateACustomerAddress'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling updateACustomerAddress'
            );
        }
        
        // verify the required parameter 'customer_address_id' is set
        if ($customer_address_id === null || (is_array($customer_address_id) && count($customer_address_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_address_id when calling updateACustomerAddress'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling updateACustomerAddress'
            );
        }


        $resourcePath = '/customers/{customer_id}/addresses/{customer_address_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_id' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }
        // path params
        if ($customer_address_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_address_id' . '}',
                ObjectSerializer::toPathValue($customer_address_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Response Schema', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
