# Bigcommerce\CustomersV2\CustomersApi

All URIs are relative to https://api.bigcommerce.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createANewCustomer()**](CustomersApi.md#createANewCustomer) | **POST** /customers | Create a New Customer |
| [**deleteACustomer()**](CustomersApi.md#deleteACustomer) | **DELETE** /customers/{customer_id} | Delete a Customer |
| [**deleteAllCustomers()**](CustomersApi.md#deleteAllCustomers) | **DELETE** /customers | Delete Customers |
| [**getACountOfCustomers()**](CustomersApi.md#getACountOfCustomers) | **GET** /customers/count | Get a Count of Customers |
| [**getACustomer()**](CustomersApi.md#getACustomer) | **GET** /customers/{customer_id} | Get a Customer |
| [**getAllCustomers()**](CustomersApi.md#getAllCustomers) | **GET** /customers | Get All Customers |
| [**updateACustomer()**](CustomersApi.md#updateACustomer) | **PUT** /customers/{customer_id} | Update a Customer |


## `createANewCustomer()`

```php
createANewCustomer($body): \Bigcommerce\CustomersV2\Model\CustomerFull
```

Create a New Customer

Creates a *Customer*.  **Required Fields** *   `first_name` *   `last_name` *   `email`  **Read Only Fields** *   `id` *   `date_created` *   `date_modified` *   `accepts_marketing` *   `addresses` *   `form_fields`  ## Notes   The `_authentication` object exposes functionality associated with the customer’s ability to log in to the store. All properties of the `_authentication` object are optional.  When the `_authentication` object is not supplied with an update request, then the existing customer password remains the same.  ## Updating Passwords   To manually update a customer password in the same way as the control panel, supply a value for the password field:  ```json {     \"_authentication\": {         \"password\": \"12w69Y217PYR96J\"     } } ```  ## Confirming Passwords   An additional optional `password_confirmation` field can also be sent, providing password confirmation as a service:  ```json {     \"_authentication\": {        \"password\": \"12w69Y217PYR96J\",        \"password_confirmation\": \"12w69Y217PYR96J\"     } } ```  ## Forcing Password Resets   To force a customer to reset their password upon their next login attempt, give the `force_reset` field a value of true, as shown here:  ```json {     \"_authentication\": {         \"force_reset\": true     } }

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \Bigcommerce\CustomersV2\Model\CreateANewCustomerRequest(); // \Bigcommerce\CustomersV2\Model\CreateANewCustomerRequest

try {
    $result = $apiInstance->createANewCustomer($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->createANewCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Bigcommerce\CustomersV2\Model\CreateANewCustomerRequest**](../Model/CreateANewCustomerRequest.md)|  | |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerFull**](../Model/CustomerFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteACustomer()`

```php
deleteACustomer($customer_id)
```

Delete a Customer

Deletes a *Customer*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | Id of the customer

try {
    $apiInstance->deleteACustomer($customer_id);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->deleteACustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| Id of the customer | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAllCustomers()`

```php
deleteAllCustomers()
```

Delete Customers

By default, it deletes all *Customers*. Up to 100 customers per batch can be deleted.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $apiInstance->deleteAllCustomers();
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->deleteAllCustomers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getACountOfCustomers()`

```php
getACountOfCustomers(): \Bigcommerce\CustomersV2\Model\CountFull
```

Get a Count of Customers

Returns a count of all *Customers*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getACountOfCustomers();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getACountOfCustomers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\CustomersV2\Model\CountFull**](../Model/CountFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getACustomer()`

```php
getACustomer($customer_id): \Bigcommerce\CustomersV2\Model\CustomerFull
```

Get a Customer

Returns a single *Customer*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | Unique numeric ID of this customer.

try {
    $result = $apiInstance->getACustomer($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getACustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| Unique numeric ID of this customer. | |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerFull**](../Model/CustomerFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllCustomers()`

```php
getAllCustomers($first_name, $last_name, $company, $email, $phone, $store_credit, $customer_group_id, $min_id, $max_id, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $tax_exempt_category): \Bigcommerce\CustomersV2\Model\CustomerFull[]
```

Get All Customers

Returns a list of all *Customers*. Default sorting is by customer id, from lowest to highest. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$first_name = 'first_name_example'; // string
$last_name = 'last_name_example'; // string
$company = 'company_example'; // string
$email = 'email_example'; // string
$phone = 'phone_example'; // string
$store_credit = 'store_credit_example'; // string
$customer_group_id = 56; // int
$min_id = 56; // int
$max_id = 56; // int
$min_date_created = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$max_date_created = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$min_date_modified = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$max_date_modified = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$tax_exempt_category = 'tax_exempt_category_example'; // string

try {
    $result = $apiInstance->getAllCustomers($first_name, $last_name, $company, $email, $phone, $store_credit, $customer_group_id, $min_id, $max_id, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $tax_exempt_category);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getAllCustomers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **first_name** | **string**|  | [optional] |
| **last_name** | **string**|  | [optional] |
| **company** | **string**|  | [optional] |
| **email** | **string**|  | [optional] |
| **phone** | **string**|  | [optional] |
| **store_credit** | **string**|  | [optional] |
| **customer_group_id** | **int**|  | [optional] |
| **min_id** | **int**|  | [optional] |
| **max_id** | **int**|  | [optional] |
| **min_date_created** | **\DateTime**|  | [optional] |
| **max_date_created** | **\DateTime**|  | [optional] |
| **min_date_modified** | **\DateTime**|  | [optional] |
| **max_date_modified** | **\DateTime**|  | [optional] |
| **tax_exempt_category** | **string**|  | [optional] |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerFull[]**](../Model/CustomerFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateACustomer()`

```php
updateACustomer($customer_id, $body): \Bigcommerce\CustomersV2\Model\CustomerBase
```

Update a Customer

Updates a *Customer*.  **Read Only Fields** *   id *   date_created *   date_modified *   accepts_marketing *   addresses *   form_fields  ## Notes   The `_authentication` object exposes functionality associated with the customer’s ability to log in to the store. All properties of the `_authentication` object are optional.  When the `_authentication` object is not supplied with an update request, then the existing customer password remains the same.  ## Updating Passwords   To manually update a customer password in the same way as the control panel, supply a value for the `password` field:  ``` {     \"_authentication\": {         \"password\": \"12w69Y217PYR96J\"     } } ```  #### Confirming Passwords   An additional optional `password_confirmation` field can also be sent, providing password confirmation as a service:  ``` {     \"_authentication\": {        \"password\": \"12w69Y217PYR96J\"        \"password_confirmation\": \"12w69Y217PYR96J\"     } } ```  #### Forcing Password Resets   To force a customer to reset their password upon their next login attempt, give the `force_reset` field a value of true, as shown here:  ``` {     \"_authentication\": {         \"force_reset\": true     } } ```

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | Id of the customer
$body = new \Bigcommerce\CustomersV2\Model\Customers(); // \Bigcommerce\CustomersV2\Model\Customers

try {
    $result = $apiInstance->updateACustomer($customer_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->updateACustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| Id of the customer | |
| **body** | [**\Bigcommerce\CustomersV2\Model\Customers**](../Model/Customers.md)|  | [optional] |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerBase**](../Model/CustomerBase.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
