# Bigcommerce\CustomersV2\CustomerPasswordsApi

All URIs are relative to https://api.bigcommerce.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**validateCustomerPassword()**](CustomerPasswordsApi.md#validateCustomerPassword) | **POST** /customers/{customer_id}/validate | Validate a Password |


## `validateCustomerPassword()`

```php
validateCustomerPassword($customer_id, $body): \Bigcommerce\CustomersV2\Model\ValidatePassword
```

Validate a Password

**This endpoint has special rate limiting protections to protect against abuse.**  Provided a password, will return a true/false response indicating if the provided password matches the customer’s current password. This endpoint is useful if you want to power the login of another system using BigCommerce’s stored customer accounts, or as a safe way to migrate passwords to another system (by checking them against BigCommerce’s password, and if correct, storing it in another system securely.)If the password matches what’s stored against the customer account, the response will be:  ```json {     \"success\": \"true\" } ``` If the password does NOT match, the response will instead be:  ```json {     \"success\": \"false\" } ```

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerPasswordsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | Id of the customer
$body = new \Bigcommerce\CustomersV2\Model\ValidateCustomerPasswordRequest(); // \Bigcommerce\CustomersV2\Model\ValidateCustomerPasswordRequest

try {
    $result = $apiInstance->validateCustomerPassword($customer_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerPasswordsApi->validateCustomerPassword: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| Id of the customer | |
| **body** | [**\Bigcommerce\CustomersV2\Model\ValidateCustomerPasswordRequest**](../Model/ValidateCustomerPasswordRequest.md)|  | |

### Return type

[**\Bigcommerce\CustomersV2\Model\ValidatePassword**](../Model/ValidatePassword.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
