# Bigcommerce\CustomersV2\CustomerGroupsApi

All URIs are relative to https://api.bigcommerce.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createACustomerGroup()**](CustomerGroupsApi.md#createACustomerGroup) | **POST** /customer_groups | Create a Customer Group |
| [**deleteACustomerGroup()**](CustomerGroupsApi.md#deleteACustomerGroup) | **DELETE** /customer_groups/{customer_group_id} | Delete a Customer Group |
| [**deleteAllCustomerGroups()**](CustomerGroupsApi.md#deleteAllCustomerGroups) | **DELETE** /customer_groups | Delete Customer Groups |
| [**getACountOfCustomerGroups()**](CustomerGroupsApi.md#getACountOfCustomerGroups) | **GET** /customer_groups/count | Get a Count of Customer Groups |
| [**getACustomerGroup()**](CustomerGroupsApi.md#getACustomerGroup) | **GET** /customer_groups/{customer_group_id} | Get a Customer Group |
| [**getAllCustomerGroups()**](CustomerGroupsApi.md#getAllCustomerGroups) | **GET** /customer_groups | Get All Customer Groups |
| [**updateACustomerGroup()**](CustomerGroupsApi.md#updateACustomerGroup) | **PUT** /customer_groups/{customer_group_id} | Update a Customer Group |


## `createACustomerGroup()`

```php
createACustomerGroup($x_auth_token, $body): \Bigcommerce\CustomersV2\Model\CustomerGroupFull
```

Create a Customer Group

Creates a *Customer Group*.   **Required Fields** * name

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$x_auth_token = 'x_auth_token_example'; // string
$body = new \Bigcommerce\CustomersV2\Model\CustomerGroupPost(); // \Bigcommerce\CustomersV2\Model\CustomerGroupPost

try {
    $result = $apiInstance->createACustomerGroup($x_auth_token, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->createACustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_auth_token** | **string**|  | |
| **body** | [**\Bigcommerce\CustomersV2\Model\CustomerGroupPost**](../Model/CustomerGroupPost.md)|  | |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerGroupFull**](../Model/CustomerGroupFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteACustomerGroup()`

```php
deleteACustomerGroup($customer_group_id)
```

Delete a Customer Group

Deletes a *Customer Group*.   **Notes**  All existing customers are unassigned from the group when it is deleted.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 56; // int | The id of the customer group.

try {
    $apiInstance->deleteACustomerGroup($customer_group_id);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->deleteACustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_group_id** | **int**| The id of the customer group. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAllCustomerGroups()`

```php
deleteAllCustomerGroups()
```

Delete Customer Groups

By default, it deletes all *Customer Groups*.   All existing customers are unassigned from the group when it is deleted.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $apiInstance->deleteAllCustomerGroups();
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->deleteAllCustomerGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getACountOfCustomerGroups()`

```php
getACountOfCustomerGroups(): \Bigcommerce\CustomersV2\Model\CountFull
```

Get a Count of Customer Groups

Returns a count of all *Customer Groups*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getACountOfCustomerGroups();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->getACountOfCustomerGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\CustomersV2\Model\CountFull**](../Model/CountFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getACustomerGroup()`

```php
getACustomerGroup($customer_group_id, $page, $limit, $name, $is_default): \Bigcommerce\CustomersV2\Model\CustomerGroupFull
```

Get a Customer Group

Returns a *Customer Group*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 56; // int | Id of the customer group
$page = 3.4; // float | Number of pages
$limit = 3.4; // float | Count per page
$name = 'name_example'; // string | Name of the customer groups
$is_default = True; // bool | If customers who signup are added to this group by default

try {
    $result = $apiInstance->getACustomerGroup($customer_group_id, $page, $limit, $name, $is_default);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->getACustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_group_id** | **int**| Id of the customer group | |
| **page** | **float**| Number of pages | [optional] |
| **limit** | **float**| Count per page | [optional] |
| **name** | **string**| Name of the customer groups | [optional] |
| **is_default** | **bool**| If customers who signup are added to this group by default | [optional] |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerGroupFull**](../Model/CustomerGroupFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllCustomerGroups()`

```php
getAllCustomerGroups($page, $limit, $name, $is_default, $is_group_for_guests): \Bigcommerce\CustomersV2\Model\CustomerGroupFull[]
```

Get All Customer Groups

Returns a list of *Customer Groups*. Default sorting is by customer-group id, from lowest to highest.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 3.4; // float | Number of pages
$limit = 3.4; // float | Count per page
$name = 'name_example'; // string | Filter customer groups by exact name match. Can use `name:like` to filter using a fuzzy matching method. This is good for implementing search.
$is_default = True; // bool | If customers who signup are added to this group by default
$is_group_for_guests = True; // bool | If the groups is for guests. There can only be one customer group for guests at a time.

try {
    $result = $apiInstance->getAllCustomerGroups($page, $limit, $name, $is_default, $is_group_for_guests);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->getAllCustomerGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **float**| Number of pages | [optional] |
| **limit** | **float**| Count per page | [optional] |
| **name** | **string**| Filter customer groups by exact name match. Can use &#x60;name:like&#x60; to filter using a fuzzy matching method. This is good for implementing search. | [optional] |
| **is_default** | **bool**| If customers who signup are added to this group by default | [optional] |
| **is_group_for_guests** | **bool**| If the groups is for guests. There can only be one customer group for guests at a time. | [optional] |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerGroupFull[]**](../Model/CustomerGroupFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateACustomerGroup()`

```php
updateACustomerGroup($customer_group_id, $body): \Bigcommerce\CustomersV2\Model\CustomerGroupFull
```

Update a Customer Group

Updates a *Customer Group*.  **Notes**  Any combination of fields can be updated at once. Discount rules are treated in bulk. The entire set of rules is overwritten when a request is sent.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 56; // int | Id of the customer group
$body = new \Bigcommerce\CustomersV2\Model\CustomerGroupFull(); // \Bigcommerce\CustomersV2\Model\CustomerGroupFull

try {
    $result = $apiInstance->updateACustomerGroup($customer_group_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->updateACustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_group_id** | **int**| Id of the customer group | |
| **body** | [**\Bigcommerce\CustomersV2\Model\CustomerGroupFull**](../Model/CustomerGroupFull.md)|  | [optional] |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerGroupFull**](../Model/CustomerGroupFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
