# Bigcommerce\CustomersV2\CustomerAddressesApi

All URIs are relative to https://api.bigcommerce.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createACustomerAddress()**](CustomerAddressesApi.md#createACustomerAddress) | **POST** /customers/{customer_id}/addresses | Create a Customer Address |
| [**deleteAllCustomerAddresses()**](CustomerAddressesApi.md#deleteAllCustomerAddresses) | **DELETE** /customers/{customer_id}/addresses | Delete Customer Address |
| [**deletesACustomerAddress()**](CustomerAddressesApi.md#deletesACustomerAddress) | **DELETE** /customers/{customer_id}/addresses/{customer_address_id} | Delete a Customer Address |
| [**getACountofCustomerAddresses()**](CustomerAddressesApi.md#getACountofCustomerAddresses) | **GET** /customers/{customer_id}/addresses/count | Get a Count of Customer Addresses |
| [**getACustomerAddress()**](CustomerAddressesApi.md#getACustomerAddress) | **GET** /customers/{customer_id}/addresses/{customer_address_id} | Get a Customer Address |
| [**getAllCustomerAddresses()**](CustomerAddressesApi.md#getAllCustomerAddresses) | **GET** /customers/{customer_id}/addresses | Get All Customer Addresses |
| [**updateACustomerAddress()**](CustomerAddressesApi.md#updateACustomerAddress) | **PUT** /customers/{customer_id}/addresses/{customer_address_id} | Update a Customer Address |


## `createACustomerAddress()`

```php
createACustomerAddress($customer_id, $body): \Bigcommerce\CustomersV2\Model\CustomerAddressFull
```

Create a Customer Address

Creates a new *Customer Address*. (Note: The “state” property cannot be null. As a workaround for addresses that include no state/province string, pass a space as the “state” value.)  **Required Fields** *   first_name *   last_name *   phone *   street_1 *   city *   state *   zip *   country  **Read Only Fields** *   id *   country_iso2

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | ID of the customer
$body = new \Bigcommerce\CustomersV2\Model\CustomerAddressBase(); // \Bigcommerce\CustomersV2\Model\CustomerAddressBase

try {
    $result = $apiInstance->createACustomerAddress($customer_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->createACustomerAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| ID of the customer | |
| **body** | [**\Bigcommerce\CustomersV2\Model\CustomerAddressBase**](../Model/CustomerAddressBase.md)|  | |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerAddressFull**](../Model/CustomerAddressFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAllCustomerAddresses()`

```php
deleteAllCustomerAddresses($customer_id, $page, $limit)
```

Delete Customer Address

By default, it deletes all *Customer Addresses*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | Id of the customer
$page = 3.4; // float | Number of pages
$limit = 3.4; // float | Count per page

try {
    $apiInstance->deleteAllCustomerAddresses($customer_id, $page, $limit);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->deleteAllCustomerAddresses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| Id of the customer | |
| **page** | **float**| Number of pages | [optional] |
| **limit** | **float**| Count per page | [optional] |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deletesACustomerAddress()`

```php
deletesACustomerAddress($customer_id, $customer_address_id)
```

Delete a Customer Address

Deletes a *Customer Address*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | Id of the customer
$customer_address_id = 56; // int | Id of the customer address.

try {
    $apiInstance->deletesACustomerAddress($customer_id, $customer_address_id);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->deletesACustomerAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| Id of the customer | |
| **customer_address_id** | **int**| Id of the customer address. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getACountofCustomerAddresses()`

```php
getACountofCustomerAddresses($customer_id, $page, $limit): \Bigcommerce\CustomersV2\Model\CountFull
```

Get a Count of Customer Addresses

Returns a count of addresses for a customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | Id of the customer
$page = 3.4; // float | Number of pages
$limit = 3.4; // float | Count per page

try {
    $result = $apiInstance->getACountofCustomerAddresses($customer_id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->getACountofCustomerAddresses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| Id of the customer | |
| **page** | **float**| Number of pages | [optional] |
| **limit** | **float**| Count per page | [optional] |

### Return type

[**\Bigcommerce\CustomersV2\Model\CountFull**](../Model/CountFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getACustomerAddress()`

```php
getACustomerAddress($customer_address_id, $customer_id, $page, $limit): \Bigcommerce\CustomersV2\Model\CustomerAddressFull
```

Get a Customer Address

Returns a *Customer Address*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_address_id = 56; // int | ID of the customer address
$customer_id = 56; // int | ID of the customer
$page = 3.4; // float | Number of pages
$limit = 3.4; // float | Count per page

try {
    $result = $apiInstance->getACustomerAddress($customer_address_id, $customer_id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->getACustomerAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_address_id** | **int**| ID of the customer address | |
| **customer_id** | **int**| ID of the customer | |
| **page** | **float**| Number of pages | [optional] |
| **limit** | **float**| Count per page | [optional] |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerAddressFull**](../Model/CustomerAddressFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllCustomerAddresses()`

```php
getAllCustomerAddresses($customer_id, $page, $limit): \Bigcommerce\CustomersV2\Model\CustomerAddressFull[]
```

Get All Customer Addresses

Returns a list of *Customer Addresses*. Returns the addresses belonging to a customer. Default sorting is by address id, from lowest to highest.   The maximum limit is 250. If a limit isn’t provided, up to 50 `customer_addresses` are returned by default.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | ID of the customer
$page = 3.4; // float | Number of pages
$limit = 3.4; // float | Count per page

try {
    $result = $apiInstance->getAllCustomerAddresses($customer_id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->getAllCustomerAddresses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| ID of the customer | |
| **page** | **float**| Number of pages | [optional] |
| **limit** | **float**| Count per page | [optional] |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerAddressFull[]**](../Model/CustomerAddressFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateACustomerAddress()`

```php
updateACustomerAddress($customer_id, $customer_address_id, $body): \Bigcommerce\CustomersV2\Model\CustomerAddressFull
```

Update a Customer Address

Updates a *Customer Address*.   **Read Only Fields** *   id *   country_iso2

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | ID of this customer
$customer_address_id = 56; // int | ID of the customer address.
$body = new \Bigcommerce\CustomersV2\Model\CustomerAddress(); // \Bigcommerce\CustomersV2\Model\CustomerAddress

try {
    $result = $apiInstance->updateACustomerAddress($customer_id, $customer_address_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->updateACustomerAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**| ID of this customer | |
| **customer_address_id** | **int**| ID of the customer address. | |
| **body** | [**\Bigcommerce\CustomersV2\Model\CustomerAddress**](../Model/CustomerAddress.md)|  | |

### Return type

[**\Bigcommerce\CustomersV2\Model\CustomerAddressFull**](../Model/CustomerAddressFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
