# OpenAPIClient-php

Create and Manage Customers, Customer Addresses, and Customer Groups. Additionally, validate customer passwords. To learn more about Customers see [here](/api-docs/customers/customers-subscribers-overview). 

## Authentication

Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:

```http
GET /stores/{store_hash}/v3/catalog/summary
host: api.bigcommerce.com
Accept: application/json
X-Auth-Token: {access_token}
```

|Header|Parameter|Description|
|-|-|-|
|`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|

### OAuth Scopes
| UI Name                                      | Permission | Parameter                                     |
|----------------------------------------------|------------|-----------------------------------------------|
| Customers                                    | modify     | `store_v2_customers`                          |
| Customers                                    | read-only  | `store_v2_customers_read_only`                |

For more information on Authenticating BigCommerce APIs, see: [Authentication](/api-docs/getting-started/authentication).

## Available Endpoints
| Resource / Endpoint                     | Description                                                                   |
|-----------------------------------------|-------------------------------------------------------------------------------|
| Customers                               | Identity and account details for customers shopping on BigCommerce stores     |
| Customers Addresses                     | Postal address belonging to a customer.                                       |
| Customers Groups                        | Groupings of customers who share the same level of access and discounts       |
| Customers Validate Password             | Validate customer passwords                                                   |

## Usage Notes

**Customer Groups**
* Customer Groups are only available on specific plans.

**Customers vs. Subscribers**
* A subscriber is not always a customer. Someone can sign up for the newsletter only and not create an account.
* A customer is not always a subscriber. Signing up for the newsletter is a separate action from creating an account and purchasing an item.
* A customer and a subscriber can be the same. If a shopper checks out on the storefront, creates an account and opts into the newsletter, they are a customer and a subscriber.

## Resources

### Related APIs / Endpoints
  [Customer Login API](/api-docs/customers/customer-login-api)
- [Current Customer API](/api-docs/customers/current-customer-api)
- [Customers API (v3)](/api-reference/customer-subscribers/v3-customers-api)
- [Subscribers API](/api-reference/customer-subscribers/subscribers-api)

### Webhooks
- [Customers](/api-docs/store-management/webhooks/webhook-events#customer)


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/bigcommerce.git"
    }
  ],
  "require": {
    "talisman/bigcommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CustomersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CustomersV2\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int | ID of the customer
$body = new \Bigcommerce\CustomersV2\Model\CustomerAddressBase(); // \Bigcommerce\CustomersV2\Model\CustomerAddressBase

try {
    $result = $apiInstance->createACustomerAddress($customer_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->createACustomerAddress: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.bigcommerce.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CustomerAddressesApi* | [**createACustomerAddress**](docs/Api/CustomerAddressesApi.md#createacustomeraddress) | **POST** /customers/{customer_id}/addresses | Create a Customer Address
*CustomerAddressesApi* | [**deleteAllCustomerAddresses**](docs/Api/CustomerAddressesApi.md#deleteallcustomeraddresses) | **DELETE** /customers/{customer_id}/addresses | Delete Customer Address
*CustomerAddressesApi* | [**deletesACustomerAddress**](docs/Api/CustomerAddressesApi.md#deletesacustomeraddress) | **DELETE** /customers/{customer_id}/addresses/{customer_address_id} | Delete a Customer Address
*CustomerAddressesApi* | [**getACountofCustomerAddresses**](docs/Api/CustomerAddressesApi.md#getacountofcustomeraddresses) | **GET** /customers/{customer_id}/addresses/count | Get a Count of Customer Addresses
*CustomerAddressesApi* | [**getACustomerAddress**](docs/Api/CustomerAddressesApi.md#getacustomeraddress) | **GET** /customers/{customer_id}/addresses/{customer_address_id} | Get a Customer Address
*CustomerAddressesApi* | [**getAllCustomerAddresses**](docs/Api/CustomerAddressesApi.md#getallcustomeraddresses) | **GET** /customers/{customer_id}/addresses | Get All Customer Addresses
*CustomerAddressesApi* | [**updateACustomerAddress**](docs/Api/CustomerAddressesApi.md#updateacustomeraddress) | **PUT** /customers/{customer_id}/addresses/{customer_address_id} | Update a Customer Address
*CustomerGroupsApi* | [**createACustomerGroup**](docs/Api/CustomerGroupsApi.md#createacustomergroup) | **POST** /customer_groups | Create a Customer Group
*CustomerGroupsApi* | [**deleteACustomerGroup**](docs/Api/CustomerGroupsApi.md#deleteacustomergroup) | **DELETE** /customer_groups/{customer_group_id} | Delete a Customer Group
*CustomerGroupsApi* | [**deleteAllCustomerGroups**](docs/Api/CustomerGroupsApi.md#deleteallcustomergroups) | **DELETE** /customer_groups | Delete Customer Groups
*CustomerGroupsApi* | [**getACountOfCustomerGroups**](docs/Api/CustomerGroupsApi.md#getacountofcustomergroups) | **GET** /customer_groups/count | Get a Count of Customer Groups
*CustomerGroupsApi* | [**getACustomerGroup**](docs/Api/CustomerGroupsApi.md#getacustomergroup) | **GET** /customer_groups/{customer_group_id} | Get a Customer Group
*CustomerGroupsApi* | [**getAllCustomerGroups**](docs/Api/CustomerGroupsApi.md#getallcustomergroups) | **GET** /customer_groups | Get All Customer Groups
*CustomerGroupsApi* | [**updateACustomerGroup**](docs/Api/CustomerGroupsApi.md#updateacustomergroup) | **PUT** /customer_groups/{customer_group_id} | Update a Customer Group
*CustomerPasswordsApi* | [**validateCustomerPassword**](docs/Api/CustomerPasswordsApi.md#validatecustomerpassword) | **POST** /customers/{customer_id}/validate | Validate a Password
*CustomersApi* | [**createANewCustomer**](docs/Api/CustomersApi.md#createanewcustomer) | **POST** /customers | Create a New Customer
*CustomersApi* | [**deleteACustomer**](docs/Api/CustomersApi.md#deleteacustomer) | **DELETE** /customers/{customer_id} | Delete a Customer
*CustomersApi* | [**deleteAllCustomers**](docs/Api/CustomersApi.md#deleteallcustomers) | **DELETE** /customers | Delete Customers
*CustomersApi* | [**getACountOfCustomers**](docs/Api/CustomersApi.md#getacountofcustomers) | **GET** /customers/count | Get a Count of Customers
*CustomersApi* | [**getACustomer**](docs/Api/CustomersApi.md#getacustomer) | **GET** /customers/{customer_id} | Get a Customer
*CustomersApi* | [**getAllCustomers**](docs/Api/CustomersApi.md#getallcustomers) | **GET** /customers | Get All Customers
*CustomersApi* | [**updateACustomer**](docs/Api/CustomersApi.md#updateacustomer) | **PUT** /customers/{customer_id} | Update a Customer

## Models

- [AddressFieldResource](docs/Model/AddressFieldResource.md)
- [BillingAddressFull](docs/Model/BillingAddressFull.md)
- [CategoryAccessLevelFull](docs/Model/CategoryAccessLevelFull.md)
- [CountFull](docs/Model/CountFull.md)
- [CountryFull](docs/Model/CountryFull.md)
- [CreateACustomerGroup207Response](docs/Model/CreateACustomerGroup207Response.md)
- [CreateANewCustomerRequest](docs/Model/CreateANewCustomerRequest.md)
- [CustomerAddress](docs/Model/CustomerAddress.md)
- [CustomerAddressBase](docs/Model/CustomerAddressBase.md)
- [CustomerAddressFull](docs/Model/CustomerAddressFull.md)
- [CustomerBase](docs/Model/CustomerBase.md)
- [CustomerFormFields](docs/Model/CustomerFormFields.md)
- [CustomerFull](docs/Model/CustomerFull.md)
- [CustomerGroupFull](docs/Model/CustomerGroupFull.md)
- [CustomerGroupFullDiscountRulesInner](docs/Model/CustomerGroupFullDiscountRulesInner.md)
- [CustomerGroupPost](docs/Model/CustomerGroupPost.md)
- [Customers](docs/Model/Customers.md)
- [CustomersAuthentication](docs/Model/CustomersAuthentication.md)
- [FormFields](docs/Model/FormFields.md)
- [ShippingAddressFull](docs/Model/ShippingAddressFull.md)
- [StateFull](docs/Model/StateFull.md)
- [StatesResource](docs/Model/StatesResource.md)
- [StatesResourceFull](docs/Model/StatesResourceFull.md)
- [UpdateACustomerGroup207Response](docs/Model/UpdateACustomerGroup207Response.md)
- [ValidateCustomerPasswordRequest](docs/Model/ValidateCustomerPasswordRequest.md)
- [ValidatePassword](docs/Model/ValidatePassword.md)

## Authorization

Authentication schemes defined for the API:
### X-Auth-Token

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: ``
    - Package version: `2`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
