<?php
/**
 * ProductPost
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Model;

use \ArrayAccess;
use \Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * ProductPost Class Doc Comment
 *
 * @category Class
 * @description The model for a POST to create a product.
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProductPost implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'product_Post';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'type' => 'string',
        'sku' => 'string',
        'description' => 'string',
        'weight' => 'float',
        'width' => 'float',
        'depth' => 'float',
        'height' => 'float',
        'price' => 'float',
        'cost_price' => 'float',
        'retail_price' => 'float',
        'sale_price' => 'float',
        'tax_class_id' => 'int',
        'product_tax_code' => 'string',
        'categories' => 'int[]',
        'brand_id' => 'int',
        'inventory_level' => 'int',
        'inventory_warning_level' => 'int',
        'inventory_tracking' => 'string',
        'fixed_cost_shipping_price' => 'float',
        'is_free_shipping' => 'bool',
        'is_visible' => 'bool',
        'is_featured' => 'bool',
        'related_products' => 'int[]',
        'warranty' => 'string',
        'bin_picking_number' => 'string',
        'layout_file' => 'string',
        'upc' => 'string',
        'search_keywords' => 'string',
        'availability' => 'string',
        'availability_description' => 'string',
        'gift_wrapping_options_type' => 'string',
        'gift_wrapping_options_list' => 'int[]',
        'sort_order' => 'int',
        'condition' => 'string',
        'is_condition_shown' => 'bool',
        'order_quantity_minimum' => 'int',
        'order_quantity_maximum' => 'int',
        'page_title' => 'string',
        'meta_keywords' => 'string[]',
        'meta_description' => 'string',
        'view_count' => 'int',
        'preorder_release_date' => '\DateTime',
        'preorder_message' => 'string',
        'is_preorder_only' => 'bool',
        'is_price_hidden' => 'bool',
        'price_hidden_label' => 'string',
        'custom_url' => '\Bigcommerce\CatalogV3\Model\CustomUrlFull',
        'open_graph_type' => 'string',
        'open_graph_title' => 'string',
        'open_graph_description' => 'string',
        'open_graph_use_meta_description' => 'bool',
        'open_graph_use_product_name' => 'bool',
        'open_graph_use_image' => 'bool',
        'brand_name' => 'string',
        'gtin' => 'string',
        'mpn' => 'string',
        'reviews_rating_sum' => 'int',
        'reviews_count' => 'int',
        'total_sold' => 'int',
        'custom_fields' => '\Bigcommerce\CatalogV3\Model\ProductCustomFieldPut[]',
        'bulk_pricing_rules' => '\Bigcommerce\CatalogV3\Model\BulkPricingRuleFull[]',
        'images' => '\Bigcommerce\CatalogV3\Model\ProductImageFull[]',
        'videos' => '\Bigcommerce\CatalogV3\Model\ProductVideoFull[]',
        'variants' => '\Bigcommerce\CatalogV3\Model\ProductVariantPostProduct[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'type' => null,
        'sku' => null,
        'description' => null,
        'weight' => 'float',
        'width' => 'float',
        'depth' => 'float',
        'height' => 'float',
        'price' => 'float',
        'cost_price' => 'float',
        'retail_price' => 'float',
        'sale_price' => 'float',
        'tax_class_id' => null,
        'product_tax_code' => null,
        'categories' => null,
        'brand_id' => null,
        'inventory_level' => null,
        'inventory_warning_level' => null,
        'inventory_tracking' => null,
        'fixed_cost_shipping_price' => 'float',
        'is_free_shipping' => null,
        'is_visible' => null,
        'is_featured' => null,
        'related_products' => null,
        'warranty' => null,
        'bin_picking_number' => null,
        'layout_file' => null,
        'upc' => null,
        'search_keywords' => null,
        'availability' => null,
        'availability_description' => null,
        'gift_wrapping_options_type' => null,
        'gift_wrapping_options_list' => null,
        'sort_order' => null,
        'condition' => null,
        'is_condition_shown' => null,
        'order_quantity_minimum' => null,
        'order_quantity_maximum' => null,
        'page_title' => null,
        'meta_keywords' => null,
        'meta_description' => null,
        'view_count' => null,
        'preorder_release_date' => 'date-time',
        'preorder_message' => null,
        'is_preorder_only' => null,
        'is_price_hidden' => null,
        'price_hidden_label' => null,
        'custom_url' => null,
        'open_graph_type' => null,
        'open_graph_title' => null,
        'open_graph_description' => null,
        'open_graph_use_meta_description' => null,
        'open_graph_use_product_name' => null,
        'open_graph_use_image' => null,
        'brand_name' => null,
        'gtin' => null,
        'mpn' => null,
        'reviews_rating_sum' => null,
        'reviews_count' => null,
        'total_sold' => null,
        'custom_fields' => null,
        'bulk_pricing_rules' => null,
        'images' => null,
        'videos' => null,
        'variants' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'name' => false,
        'type' => false,
        'sku' => false,
        'description' => false,
        'weight' => false,
        'width' => false,
        'depth' => false,
        'height' => false,
        'price' => false,
        'cost_price' => false,
        'retail_price' => false,
        'sale_price' => false,
        'tax_class_id' => false,
        'product_tax_code' => false,
        'categories' => false,
        'brand_id' => false,
        'inventory_level' => false,
        'inventory_warning_level' => false,
        'inventory_tracking' => false,
        'fixed_cost_shipping_price' => false,
        'is_free_shipping' => false,
        'is_visible' => false,
        'is_featured' => false,
        'related_products' => false,
        'warranty' => false,
        'bin_picking_number' => false,
        'layout_file' => false,
        'upc' => false,
        'search_keywords' => false,
        'availability' => false,
        'availability_description' => false,
        'gift_wrapping_options_type' => false,
        'gift_wrapping_options_list' => false,
        'sort_order' => false,
        'condition' => false,
        'is_condition_shown' => false,
        'order_quantity_minimum' => false,
        'order_quantity_maximum' => false,
        'page_title' => false,
        'meta_keywords' => false,
        'meta_description' => false,
        'view_count' => false,
        'preorder_release_date' => true,
        'preorder_message' => false,
        'is_preorder_only' => false,
        'is_price_hidden' => false,
        'price_hidden_label' => false,
        'custom_url' => false,
        'open_graph_type' => false,
        'open_graph_title' => false,
        'open_graph_description' => false,
        'open_graph_use_meta_description' => false,
        'open_graph_use_product_name' => false,
        'open_graph_use_image' => false,
        'brand_name' => false,
        'gtin' => false,
        'mpn' => false,
        'reviews_rating_sum' => false,
        'reviews_count' => false,
        'total_sold' => false,
        'custom_fields' => false,
        'bulk_pricing_rules' => false,
        'images' => false,
        'videos' => false,
        'variants' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'type' => 'type',
        'sku' => 'sku',
        'description' => 'description',
        'weight' => 'weight',
        'width' => 'width',
        'depth' => 'depth',
        'height' => 'height',
        'price' => 'price',
        'cost_price' => 'cost_price',
        'retail_price' => 'retail_price',
        'sale_price' => 'sale_price',
        'tax_class_id' => 'tax_class_id',
        'product_tax_code' => 'product_tax_code',
        'categories' => 'categories',
        'brand_id' => 'brand_id',
        'inventory_level' => 'inventory_level',
        'inventory_warning_level' => 'inventory_warning_level',
        'inventory_tracking' => 'inventory_tracking',
        'fixed_cost_shipping_price' => 'fixed_cost_shipping_price',
        'is_free_shipping' => 'is_free_shipping',
        'is_visible' => 'is_visible',
        'is_featured' => 'is_featured',
        'related_products' => 'related_products',
        'warranty' => 'warranty',
        'bin_picking_number' => 'bin_picking_number',
        'layout_file' => 'layout_file',
        'upc' => 'upc',
        'search_keywords' => 'search_keywords',
        'availability' => 'availability',
        'availability_description' => 'availability_description',
        'gift_wrapping_options_type' => 'gift_wrapping_options_type',
        'gift_wrapping_options_list' => 'gift_wrapping_options_list',
        'sort_order' => 'sort_order',
        'condition' => 'condition',
        'is_condition_shown' => 'is_condition_shown',
        'order_quantity_minimum' => 'order_quantity_minimum',
        'order_quantity_maximum' => 'order_quantity_maximum',
        'page_title' => 'page_title',
        'meta_keywords' => 'meta_keywords',
        'meta_description' => 'meta_description',
        'view_count' => 'view_count',
        'preorder_release_date' => 'preorder_release_date',
        'preorder_message' => 'preorder_message',
        'is_preorder_only' => 'is_preorder_only',
        'is_price_hidden' => 'is_price_hidden',
        'price_hidden_label' => 'price_hidden_label',
        'custom_url' => 'custom_url',
        'open_graph_type' => 'open_graph_type',
        'open_graph_title' => 'open_graph_title',
        'open_graph_description' => 'open_graph_description',
        'open_graph_use_meta_description' => 'open_graph_use_meta_description',
        'open_graph_use_product_name' => 'open_graph_use_product_name',
        'open_graph_use_image' => 'open_graph_use_image',
        'brand_name' => 'brand_name',
        'gtin' => 'gtin',
        'mpn' => 'mpn',
        'reviews_rating_sum' => 'reviews_rating_sum',
        'reviews_count' => 'reviews_count',
        'total_sold' => 'total_sold',
        'custom_fields' => 'custom_fields',
        'bulk_pricing_rules' => 'bulk_pricing_rules',
        'images' => 'images',
        'videos' => 'videos',
        'variants' => 'variants'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'type' => 'setType',
        'sku' => 'setSku',
        'description' => 'setDescription',
        'weight' => 'setWeight',
        'width' => 'setWidth',
        'depth' => 'setDepth',
        'height' => 'setHeight',
        'price' => 'setPrice',
        'cost_price' => 'setCostPrice',
        'retail_price' => 'setRetailPrice',
        'sale_price' => 'setSalePrice',
        'tax_class_id' => 'setTaxClassId',
        'product_tax_code' => 'setProductTaxCode',
        'categories' => 'setCategories',
        'brand_id' => 'setBrandId',
        'inventory_level' => 'setInventoryLevel',
        'inventory_warning_level' => 'setInventoryWarningLevel',
        'inventory_tracking' => 'setInventoryTracking',
        'fixed_cost_shipping_price' => 'setFixedCostShippingPrice',
        'is_free_shipping' => 'setIsFreeShipping',
        'is_visible' => 'setIsVisible',
        'is_featured' => 'setIsFeatured',
        'related_products' => 'setRelatedProducts',
        'warranty' => 'setWarranty',
        'bin_picking_number' => 'setBinPickingNumber',
        'layout_file' => 'setLayoutFile',
        'upc' => 'setUpc',
        'search_keywords' => 'setSearchKeywords',
        'availability' => 'setAvailability',
        'availability_description' => 'setAvailabilityDescription',
        'gift_wrapping_options_type' => 'setGiftWrappingOptionsType',
        'gift_wrapping_options_list' => 'setGiftWrappingOptionsList',
        'sort_order' => 'setSortOrder',
        'condition' => 'setCondition',
        'is_condition_shown' => 'setIsConditionShown',
        'order_quantity_minimum' => 'setOrderQuantityMinimum',
        'order_quantity_maximum' => 'setOrderQuantityMaximum',
        'page_title' => 'setPageTitle',
        'meta_keywords' => 'setMetaKeywords',
        'meta_description' => 'setMetaDescription',
        'view_count' => 'setViewCount',
        'preorder_release_date' => 'setPreorderReleaseDate',
        'preorder_message' => 'setPreorderMessage',
        'is_preorder_only' => 'setIsPreorderOnly',
        'is_price_hidden' => 'setIsPriceHidden',
        'price_hidden_label' => 'setPriceHiddenLabel',
        'custom_url' => 'setCustomUrl',
        'open_graph_type' => 'setOpenGraphType',
        'open_graph_title' => 'setOpenGraphTitle',
        'open_graph_description' => 'setOpenGraphDescription',
        'open_graph_use_meta_description' => 'setOpenGraphUseMetaDescription',
        'open_graph_use_product_name' => 'setOpenGraphUseProductName',
        'open_graph_use_image' => 'setOpenGraphUseImage',
        'brand_name' => 'setBrandName',
        'gtin' => 'setGtin',
        'mpn' => 'setMpn',
        'reviews_rating_sum' => 'setReviewsRatingSum',
        'reviews_count' => 'setReviewsCount',
        'total_sold' => 'setTotalSold',
        'custom_fields' => 'setCustomFields',
        'bulk_pricing_rules' => 'setBulkPricingRules',
        'images' => 'setImages',
        'videos' => 'setVideos',
        'variants' => 'setVariants'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'type' => 'getType',
        'sku' => 'getSku',
        'description' => 'getDescription',
        'weight' => 'getWeight',
        'width' => 'getWidth',
        'depth' => 'getDepth',
        'height' => 'getHeight',
        'price' => 'getPrice',
        'cost_price' => 'getCostPrice',
        'retail_price' => 'getRetailPrice',
        'sale_price' => 'getSalePrice',
        'tax_class_id' => 'getTaxClassId',
        'product_tax_code' => 'getProductTaxCode',
        'categories' => 'getCategories',
        'brand_id' => 'getBrandId',
        'inventory_level' => 'getInventoryLevel',
        'inventory_warning_level' => 'getInventoryWarningLevel',
        'inventory_tracking' => 'getInventoryTracking',
        'fixed_cost_shipping_price' => 'getFixedCostShippingPrice',
        'is_free_shipping' => 'getIsFreeShipping',
        'is_visible' => 'getIsVisible',
        'is_featured' => 'getIsFeatured',
        'related_products' => 'getRelatedProducts',
        'warranty' => 'getWarranty',
        'bin_picking_number' => 'getBinPickingNumber',
        'layout_file' => 'getLayoutFile',
        'upc' => 'getUpc',
        'search_keywords' => 'getSearchKeywords',
        'availability' => 'getAvailability',
        'availability_description' => 'getAvailabilityDescription',
        'gift_wrapping_options_type' => 'getGiftWrappingOptionsType',
        'gift_wrapping_options_list' => 'getGiftWrappingOptionsList',
        'sort_order' => 'getSortOrder',
        'condition' => 'getCondition',
        'is_condition_shown' => 'getIsConditionShown',
        'order_quantity_minimum' => 'getOrderQuantityMinimum',
        'order_quantity_maximum' => 'getOrderQuantityMaximum',
        'page_title' => 'getPageTitle',
        'meta_keywords' => 'getMetaKeywords',
        'meta_description' => 'getMetaDescription',
        'view_count' => 'getViewCount',
        'preorder_release_date' => 'getPreorderReleaseDate',
        'preorder_message' => 'getPreorderMessage',
        'is_preorder_only' => 'getIsPreorderOnly',
        'is_price_hidden' => 'getIsPriceHidden',
        'price_hidden_label' => 'getPriceHiddenLabel',
        'custom_url' => 'getCustomUrl',
        'open_graph_type' => 'getOpenGraphType',
        'open_graph_title' => 'getOpenGraphTitle',
        'open_graph_description' => 'getOpenGraphDescription',
        'open_graph_use_meta_description' => 'getOpenGraphUseMetaDescription',
        'open_graph_use_product_name' => 'getOpenGraphUseProductName',
        'open_graph_use_image' => 'getOpenGraphUseImage',
        'brand_name' => 'getBrandName',
        'gtin' => 'getGtin',
        'mpn' => 'getMpn',
        'reviews_rating_sum' => 'getReviewsRatingSum',
        'reviews_count' => 'getReviewsCount',
        'total_sold' => 'getTotalSold',
        'custom_fields' => 'getCustomFields',
        'bulk_pricing_rules' => 'getBulkPricingRules',
        'images' => 'getImages',
        'videos' => 'getVideos',
        'variants' => 'getVariants'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_PHYSICAL = 'physical';
    public const TYPE_DIGITAL = 'digital';
    public const INVENTORY_TRACKING_NONE = 'none';
    public const INVENTORY_TRACKING_PRODUCT = 'product';
    public const INVENTORY_TRACKING_VARIANT = 'variant';
    public const AVAILABILITY_AVAILABLE = 'available';
    public const AVAILABILITY_DISABLED = 'disabled';
    public const AVAILABILITY_PREORDER = 'preorder';
    public const GIFT_WRAPPING_OPTIONS_TYPE_ANY = 'any';
    public const GIFT_WRAPPING_OPTIONS_TYPE_NONE = 'none';
    public const GIFT_WRAPPING_OPTIONS_TYPE__LIST = 'list';
    public const CONDITION__NEW = 'New';
    public const CONDITION_USED = 'Used';
    public const CONDITION_REFURBISHED = 'Refurbished';
    public const OPEN_GRAPH_TYPE_PRODUCT = 'product';
    public const OPEN_GRAPH_TYPE_ALBUM = 'album';
    public const OPEN_GRAPH_TYPE_BOOK = 'book';
    public const OPEN_GRAPH_TYPE_DRINK = 'drink';
    public const OPEN_GRAPH_TYPE_FOOD = 'food';
    public const OPEN_GRAPH_TYPE_GAME = 'game';
    public const OPEN_GRAPH_TYPE_MOVIE = 'movie';
    public const OPEN_GRAPH_TYPE_SONG = 'song';
    public const OPEN_GRAPH_TYPE_TV_SHOW = 'tv_show';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_PHYSICAL,
            self::TYPE_DIGITAL,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getInventoryTrackingAllowableValues()
    {
        return [
            self::INVENTORY_TRACKING_NONE,
            self::INVENTORY_TRACKING_PRODUCT,
            self::INVENTORY_TRACKING_VARIANT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAvailabilityAllowableValues()
    {
        return [
            self::AVAILABILITY_AVAILABLE,
            self::AVAILABILITY_DISABLED,
            self::AVAILABILITY_PREORDER,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getGiftWrappingOptionsTypeAllowableValues()
    {
        return [
            self::GIFT_WRAPPING_OPTIONS_TYPE_ANY,
            self::GIFT_WRAPPING_OPTIONS_TYPE_NONE,
            self::GIFT_WRAPPING_OPTIONS_TYPE__LIST,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getConditionAllowableValues()
    {
        return [
            self::CONDITION__NEW,
            self::CONDITION_USED,
            self::CONDITION_REFURBISHED,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getOpenGraphTypeAllowableValues()
    {
        return [
            self::OPEN_GRAPH_TYPE_PRODUCT,
            self::OPEN_GRAPH_TYPE_ALBUM,
            self::OPEN_GRAPH_TYPE_BOOK,
            self::OPEN_GRAPH_TYPE_DRINK,
            self::OPEN_GRAPH_TYPE_FOOD,
            self::OPEN_GRAPH_TYPE_GAME,
            self::OPEN_GRAPH_TYPE_MOVIE,
            self::OPEN_GRAPH_TYPE_SONG,
            self::OPEN_GRAPH_TYPE_TV_SHOW,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('cost_price', $data ?? [], null);
        $this->setIfExists('retail_price', $data ?? [], null);
        $this->setIfExists('sale_price', $data ?? [], null);
        $this->setIfExists('tax_class_id', $data ?? [], null);
        $this->setIfExists('product_tax_code', $data ?? [], null);
        $this->setIfExists('categories', $data ?? [], null);
        $this->setIfExists('brand_id', $data ?? [], null);
        $this->setIfExists('inventory_level', $data ?? [], null);
        $this->setIfExists('inventory_warning_level', $data ?? [], null);
        $this->setIfExists('inventory_tracking', $data ?? [], null);
        $this->setIfExists('fixed_cost_shipping_price', $data ?? [], null);
        $this->setIfExists('is_free_shipping', $data ?? [], null);
        $this->setIfExists('is_visible', $data ?? [], null);
        $this->setIfExists('is_featured', $data ?? [], null);
        $this->setIfExists('related_products', $data ?? [], null);
        $this->setIfExists('warranty', $data ?? [], null);
        $this->setIfExists('bin_picking_number', $data ?? [], null);
        $this->setIfExists('layout_file', $data ?? [], null);
        $this->setIfExists('upc', $data ?? [], null);
        $this->setIfExists('search_keywords', $data ?? [], null);
        $this->setIfExists('availability', $data ?? [], null);
        $this->setIfExists('availability_description', $data ?? [], null);
        $this->setIfExists('gift_wrapping_options_type', $data ?? [], null);
        $this->setIfExists('gift_wrapping_options_list', $data ?? [], null);
        $this->setIfExists('sort_order', $data ?? [], null);
        $this->setIfExists('condition', $data ?? [], null);
        $this->setIfExists('is_condition_shown', $data ?? [], null);
        $this->setIfExists('order_quantity_minimum', $data ?? [], null);
        $this->setIfExists('order_quantity_maximum', $data ?? [], null);
        $this->setIfExists('page_title', $data ?? [], null);
        $this->setIfExists('meta_keywords', $data ?? [], null);
        $this->setIfExists('meta_description', $data ?? [], null);
        $this->setIfExists('view_count', $data ?? [], null);
        $this->setIfExists('preorder_release_date', $data ?? [], null);
        $this->setIfExists('preorder_message', $data ?? [], null);
        $this->setIfExists('is_preorder_only', $data ?? [], null);
        $this->setIfExists('is_price_hidden', $data ?? [], null);
        $this->setIfExists('price_hidden_label', $data ?? [], null);
        $this->setIfExists('custom_url', $data ?? [], null);
        $this->setIfExists('open_graph_type', $data ?? [], null);
        $this->setIfExists('open_graph_title', $data ?? [], null);
        $this->setIfExists('open_graph_description', $data ?? [], null);
        $this->setIfExists('open_graph_use_meta_description', $data ?? [], null);
        $this->setIfExists('open_graph_use_product_name', $data ?? [], null);
        $this->setIfExists('open_graph_use_image', $data ?? [], null);
        $this->setIfExists('brand_name', $data ?? [], null);
        $this->setIfExists('gtin', $data ?? [], null);
        $this->setIfExists('mpn', $data ?? [], null);
        $this->setIfExists('reviews_rating_sum', $data ?? [], null);
        $this->setIfExists('reviews_count', $data ?? [], null);
        $this->setIfExists('total_sold', $data ?? [], null);
        $this->setIfExists('custom_fields', $data ?? [], null);
        $this->setIfExists('bulk_pricing_rules', $data ?? [], null);
        $this->setIfExists('images', $data ?? [], null);
        $this->setIfExists('videos', $data ?? [], null);
        $this->setIfExists('variants', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ((mb_strlen($this->container['name']) > 255)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be smaller than or equal to 255.";
        }

        if ((mb_strlen($this->container['name']) < 1)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['sku']) && (mb_strlen($this->container['sku']) > 255)) {
            $invalidProperties[] = "invalid value for 'sku', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['sku']) && (mb_strlen($this->container['sku']) < 0)) {
            $invalidProperties[] = "invalid value for 'sku', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['weight'] === null) {
            $invalidProperties[] = "'weight' can't be null";
        }
        if (($this->container['weight'] > 9999999999)) {
            $invalidProperties[] = "invalid value for 'weight', must be smaller than or equal to 9999999999.";
        }

        if (($this->container['weight'] < 0)) {
            $invalidProperties[] = "invalid value for 'weight', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['width']) && ($this->container['width'] > 9999999999)) {
            $invalidProperties[] = "invalid value for 'width', must be smaller than or equal to 9999999999.";
        }

        if (!is_null($this->container['width']) && ($this->container['width'] < 0)) {
            $invalidProperties[] = "invalid value for 'width', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['depth']) && ($this->container['depth'] > 9999999999)) {
            $invalidProperties[] = "invalid value for 'depth', must be smaller than or equal to 9999999999.";
        }

        if (!is_null($this->container['depth']) && ($this->container['depth'] < 0)) {
            $invalidProperties[] = "invalid value for 'depth', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['height']) && ($this->container['height'] > 9999999999)) {
            $invalidProperties[] = "invalid value for 'height', must be smaller than or equal to 9999999999.";
        }

        if (!is_null($this->container['height']) && ($this->container['height'] < 0)) {
            $invalidProperties[] = "invalid value for 'height', must be bigger than or equal to 0.";
        }

        if ($this->container['price'] === null) {
            $invalidProperties[] = "'price' can't be null";
        }
        if (($this->container['price'] < 0)) {
            $invalidProperties[] = "invalid value for 'price', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['cost_price']) && ($this->container['cost_price'] < 0)) {
            $invalidProperties[] = "invalid value for 'cost_price', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['retail_price']) && ($this->container['retail_price'] < 0)) {
            $invalidProperties[] = "invalid value for 'retail_price', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['sale_price']) && ($this->container['sale_price'] < 0)) {
            $invalidProperties[] = "invalid value for 'sale_price', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['tax_class_id']) && ($this->container['tax_class_id'] > 1000000000)) {
            $invalidProperties[] = "invalid value for 'tax_class_id', must be smaller than or equal to 1000000000.";
        }

        if (!is_null($this->container['tax_class_id']) && ($this->container['tax_class_id'] < 0)) {
            $invalidProperties[] = "invalid value for 'tax_class_id', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['product_tax_code']) && (mb_strlen($this->container['product_tax_code']) > 255)) {
            $invalidProperties[] = "invalid value for 'product_tax_code', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['product_tax_code']) && (mb_strlen($this->container['product_tax_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'product_tax_code', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['brand_id']) && ($this->container['brand_id'] > 1000000000)) {
            $invalidProperties[] = "invalid value for 'brand_id', must be smaller than or equal to 1000000000.";
        }

        if (!is_null($this->container['brand_id']) && ($this->container['brand_id'] < 0)) {
            $invalidProperties[] = "invalid value for 'brand_id', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['inventory_level']) && ($this->container['inventory_level'] > 1000000000)) {
            $invalidProperties[] = "invalid value for 'inventory_level', must be smaller than or equal to 1000000000.";
        }

        if (!is_null($this->container['inventory_level']) && ($this->container['inventory_level'] < 0)) {
            $invalidProperties[] = "invalid value for 'inventory_level', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['inventory_warning_level']) && ($this->container['inventory_warning_level'] > 1000000000)) {
            $invalidProperties[] = "invalid value for 'inventory_warning_level', must be smaller than or equal to 1000000000.";
        }

        if (!is_null($this->container['inventory_warning_level']) && ($this->container['inventory_warning_level'] < 0)) {
            $invalidProperties[] = "invalid value for 'inventory_warning_level', must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getInventoryTrackingAllowableValues();
        if (!is_null($this->container['inventory_tracking']) && !in_array($this->container['inventory_tracking'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'inventory_tracking', must be one of '%s'",
                $this->container['inventory_tracking'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['fixed_cost_shipping_price']) && ($this->container['fixed_cost_shipping_price'] < 0)) {
            $invalidProperties[] = "invalid value for 'fixed_cost_shipping_price', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['warranty']) && (mb_strlen($this->container['warranty']) > 65535)) {
            $invalidProperties[] = "invalid value for 'warranty', the character length must be smaller than or equal to 65535.";
        }

        if (!is_null($this->container['warranty']) && (mb_strlen($this->container['warranty']) < 0)) {
            $invalidProperties[] = "invalid value for 'warranty', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['bin_picking_number']) && (mb_strlen($this->container['bin_picking_number']) > 255)) {
            $invalidProperties[] = "invalid value for 'bin_picking_number', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['bin_picking_number']) && (mb_strlen($this->container['bin_picking_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'bin_picking_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['layout_file']) && (mb_strlen($this->container['layout_file']) > 500)) {
            $invalidProperties[] = "invalid value for 'layout_file', the character length must be smaller than or equal to 500.";
        }

        if (!is_null($this->container['layout_file']) && (mb_strlen($this->container['layout_file']) < 0)) {
            $invalidProperties[] = "invalid value for 'layout_file', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['upc']) && (mb_strlen($this->container['upc']) > 255)) {
            $invalidProperties[] = "invalid value for 'upc', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['upc']) && (mb_strlen($this->container['upc']) < 0)) {
            $invalidProperties[] = "invalid value for 'upc', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['search_keywords']) && (mb_strlen($this->container['search_keywords']) > 65535)) {
            $invalidProperties[] = "invalid value for 'search_keywords', the character length must be smaller than or equal to 65535.";
        }

        if (!is_null($this->container['search_keywords']) && (mb_strlen($this->container['search_keywords']) < 0)) {
            $invalidProperties[] = "invalid value for 'search_keywords', the character length must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getAvailabilityAllowableValues();
        if (!is_null($this->container['availability']) && !in_array($this->container['availability'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'availability', must be one of '%s'",
                $this->container['availability'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['availability_description']) && (mb_strlen($this->container['availability_description']) > 255)) {
            $invalidProperties[] = "invalid value for 'availability_description', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['availability_description']) && (mb_strlen($this->container['availability_description']) < 0)) {
            $invalidProperties[] = "invalid value for 'availability_description', the character length must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getGiftWrappingOptionsTypeAllowableValues();
        if (!is_null($this->container['gift_wrapping_options_type']) && !in_array($this->container['gift_wrapping_options_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'gift_wrapping_options_type', must be one of '%s'",
                $this->container['gift_wrapping_options_type'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['sort_order']) && ($this->container['sort_order'] > 2147483647)) {
            $invalidProperties[] = "invalid value for 'sort_order', must be smaller than or equal to 2147483647.";
        }

        if (!is_null($this->container['sort_order']) && ($this->container['sort_order'] < -2147483648)) {
            $invalidProperties[] = "invalid value for 'sort_order', must be bigger than or equal to -2147483648.";
        }

        $allowedValues = $this->getConditionAllowableValues();
        if (!is_null($this->container['condition']) && !in_array($this->container['condition'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'condition', must be one of '%s'",
                $this->container['condition'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['order_quantity_minimum']) && ($this->container['order_quantity_minimum'] > 1000000000)) {
            $invalidProperties[] = "invalid value for 'order_quantity_minimum', must be smaller than or equal to 1000000000.";
        }

        if (!is_null($this->container['order_quantity_minimum']) && ($this->container['order_quantity_minimum'] < 0)) {
            $invalidProperties[] = "invalid value for 'order_quantity_minimum', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['order_quantity_maximum']) && ($this->container['order_quantity_maximum'] > 1000000000)) {
            $invalidProperties[] = "invalid value for 'order_quantity_maximum', must be smaller than or equal to 1000000000.";
        }

        if (!is_null($this->container['order_quantity_maximum']) && ($this->container['order_quantity_maximum'] < 0)) {
            $invalidProperties[] = "invalid value for 'order_quantity_maximum', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['page_title']) && (mb_strlen($this->container['page_title']) > 255)) {
            $invalidProperties[] = "invalid value for 'page_title', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['page_title']) && (mb_strlen($this->container['page_title']) < 0)) {
            $invalidProperties[] = "invalid value for 'page_title', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['meta_description']) && (mb_strlen($this->container['meta_description']) > 65535)) {
            $invalidProperties[] = "invalid value for 'meta_description', the character length must be smaller than or equal to 65535.";
        }

        if (!is_null($this->container['meta_description']) && (mb_strlen($this->container['meta_description']) < 0)) {
            $invalidProperties[] = "invalid value for 'meta_description', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['view_count']) && ($this->container['view_count'] > 1000000000)) {
            $invalidProperties[] = "invalid value for 'view_count', must be smaller than or equal to 1000000000.";
        }

        if (!is_null($this->container['view_count']) && ($this->container['view_count'] < 0)) {
            $invalidProperties[] = "invalid value for 'view_count', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['preorder_message']) && (mb_strlen($this->container['preorder_message']) > 255)) {
            $invalidProperties[] = "invalid value for 'preorder_message', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['preorder_message']) && (mb_strlen($this->container['preorder_message']) < 0)) {
            $invalidProperties[] = "invalid value for 'preorder_message', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['price_hidden_label']) && (mb_strlen($this->container['price_hidden_label']) > 200)) {
            $invalidProperties[] = "invalid value for 'price_hidden_label', the character length must be smaller than or equal to 200.";
        }

        if (!is_null($this->container['price_hidden_label']) && (mb_strlen($this->container['price_hidden_label']) < 0)) {
            $invalidProperties[] = "invalid value for 'price_hidden_label', the character length must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getOpenGraphTypeAllowableValues();
        if (!is_null($this->container['open_graph_type']) && !in_array($this->container['open_graph_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'open_graph_type', must be one of '%s'",
                $this->container['open_graph_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The product name.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        if ((mb_strlen($name) > 255)) {
            throw new \InvalidArgumentException('invalid length for $name when calling ProductPost., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($name) < 1)) {
            throw new \InvalidArgumentException('invalid length for $name when calling ProductPost., must be bigger than or equal to 1.');
        }

        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type The product type. One of: `physical` - a physical stock unit, `digital` - a digital download.
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku User defined product code/stock keeping unit (SKU).
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        if ((mb_strlen($sku) > 255)) {
            throw new \InvalidArgumentException('invalid length for $sku when calling ProductPost., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($sku) < 0)) {
            throw new \InvalidArgumentException('invalid length for $sku when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The product description, which can include HTML formatting.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float $weight Weight of the product, which can be used when calculating shipping costs. This is based on the unit set on the store
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }

        if (($weight > 9999999999)) {
            throw new \InvalidArgumentException('invalid value for $weight when calling ProductPost., must be smaller than or equal to 9999999999.');
        }
        if (($weight < 0)) {
            throw new \InvalidArgumentException('invalid value for $weight when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width Width of the product, which can be used when calculating shipping costs.
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }

        if (($width > 9999999999)) {
            throw new \InvalidArgumentException('invalid value for $width when calling ProductPost., must be smaller than or equal to 9999999999.');
        }
        if (($width < 0)) {
            throw new \InvalidArgumentException('invalid value for $width when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth Depth of the product, which can be used when calculating shipping costs.
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            throw new \InvalidArgumentException('non-nullable depth cannot be null');
        }

        if (($depth > 9999999999)) {
            throw new \InvalidArgumentException('invalid value for $depth when calling ProductPost., must be smaller than or equal to 9999999999.');
        }
        if (($depth < 0)) {
            throw new \InvalidArgumentException('invalid value for $depth when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height Height of the product, which can be used when calculating shipping costs.
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }

        if (($height > 9999999999)) {
            throw new \InvalidArgumentException('invalid value for $height when calling ProductPost., must be smaller than or equal to 9999999999.');
        }
        if (($height < 0)) {
            throw new \InvalidArgumentException('invalid value for $height when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float $price The price of the product. The price should include or exclude tax, based on the store settings.
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }

        if (($price < 0)) {
            throw new \InvalidArgumentException('invalid value for $price when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets cost_price
     *
     * @return float|null
     */
    public function getCostPrice()
    {
        return $this->container['cost_price'];
    }

    /**
     * Sets cost_price
     *
     * @param float|null $cost_price The cost price of the product. Stored for reference only; it is not used or displayed anywhere on the store.
     *
     * @return self
     */
    public function setCostPrice($cost_price)
    {
        if (is_null($cost_price)) {
            throw new \InvalidArgumentException('non-nullable cost_price cannot be null');
        }

        if (($cost_price < 0)) {
            throw new \InvalidArgumentException('invalid value for $cost_price when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['cost_price'] = $cost_price;

        return $this;
    }

    /**
     * Gets retail_price
     *
     * @return float|null
     */
    public function getRetailPrice()
    {
        return $this->container['retail_price'];
    }

    /**
     * Sets retail_price
     *
     * @param float|null $retail_price The retail cost of the product. If entered, the retail cost price will be shown on the product page.
     *
     * @return self
     */
    public function setRetailPrice($retail_price)
    {
        if (is_null($retail_price)) {
            throw new \InvalidArgumentException('non-nullable retail_price cannot be null');
        }

        if (($retail_price < 0)) {
            throw new \InvalidArgumentException('invalid value for $retail_price when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['retail_price'] = $retail_price;

        return $this;
    }

    /**
     * Gets sale_price
     *
     * @return float|null
     */
    public function getSalePrice()
    {
        return $this->container['sale_price'];
    }

    /**
     * Sets sale_price
     *
     * @param float|null $sale_price If entered, the sale price will be used instead of value in the price field when calculating the product's cost.
     *
     * @return self
     */
    public function setSalePrice($sale_price)
    {
        if (is_null($sale_price)) {
            throw new \InvalidArgumentException('non-nullable sale_price cannot be null');
        }

        if (($sale_price < 0)) {
            throw new \InvalidArgumentException('invalid value for $sale_price when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['sale_price'] = $sale_price;

        return $this;
    }

    /**
     * Gets tax_class_id
     *
     * @return int|null
     */
    public function getTaxClassId()
    {
        return $this->container['tax_class_id'];
    }

    /**
     * Sets tax_class_id
     *
     * @param int|null $tax_class_id The ID of the tax class applied to the product. (NOTE: Value ignored if automatic tax is enabled.)
     *
     * @return self
     */
    public function setTaxClassId($tax_class_id)
    {
        if (is_null($tax_class_id)) {
            throw new \InvalidArgumentException('non-nullable tax_class_id cannot be null');
        }

        if (($tax_class_id > 1000000000)) {
            throw new \InvalidArgumentException('invalid value for $tax_class_id when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if (($tax_class_id < 0)) {
            throw new \InvalidArgumentException('invalid value for $tax_class_id when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['tax_class_id'] = $tax_class_id;

        return $this;
    }

    /**
     * Gets product_tax_code
     *
     * @return string|null
     */
    public function getProductTaxCode()
    {
        return $this->container['product_tax_code'];
    }

    /**
     * Sets product_tax_code
     *
     * @param string|null $product_tax_code Accepts AvaTax System Tax Codes, which identify products and services that fall into special sales-tax categories. By using these codes, merchants who subscribe to BigCommerce's Avalara Premium integration can calculate sales taxes more accurately. Stores without Avalara Premium will ignore the code when calculating sales tax. Do not pass more than one code. The codes are case-sensitive. For details, please see Avalara's documentation.
     *
     * @return self
     */
    public function setProductTaxCode($product_tax_code)
    {
        if (is_null($product_tax_code)) {
            throw new \InvalidArgumentException('non-nullable product_tax_code cannot be null');
        }
        if ((mb_strlen($product_tax_code) > 255)) {
            throw new \InvalidArgumentException('invalid length for $product_tax_code when calling ProductPost., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($product_tax_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $product_tax_code when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['product_tax_code'] = $product_tax_code;

        return $this;
    }

    /**
     * Gets categories
     *
     * @return int[]|null
     */
    public function getCategories()
    {
        return $this->container['categories'];
    }

    /**
     * Sets categories
     *
     * @param int[]|null $categories An array of IDs for the categories to which this product belongs. When updating a product, if an array of categories is supplied, all product categories will be overwritten. Does not accept more than 1,000 ID values.
     *
     * @return self
     */
    public function setCategories($categories)
    {
        if (is_null($categories)) {
            throw new \InvalidArgumentException('non-nullable categories cannot be null');
        }
        $this->container['categories'] = $categories;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return int|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param int|null $brand_id A product can be added to an existing brand during a product /PUT or /POST.
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        if (is_null($brand_id)) {
            throw new \InvalidArgumentException('non-nullable brand_id cannot be null');
        }

        if (($brand_id > 1000000000)) {
            throw new \InvalidArgumentException('invalid value for $brand_id when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if (($brand_id < 0)) {
            throw new \InvalidArgumentException('invalid value for $brand_id when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets inventory_level
     *
     * @return int|null
     */
    public function getInventoryLevel()
    {
        return $this->container['inventory_level'];
    }

    /**
     * Sets inventory_level
     *
     * @param int|null $inventory_level Current inventory level of the product. Simple inventory tracking must be enabled (See the `inventory_tracking` field) for this to take any effect.
     *
     * @return self
     */
    public function setInventoryLevel($inventory_level)
    {
        if (is_null($inventory_level)) {
            throw new \InvalidArgumentException('non-nullable inventory_level cannot be null');
        }

        if (($inventory_level > 1000000000)) {
            throw new \InvalidArgumentException('invalid value for $inventory_level when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if (($inventory_level < 0)) {
            throw new \InvalidArgumentException('invalid value for $inventory_level when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['inventory_level'] = $inventory_level;

        return $this;
    }

    /**
     * Gets inventory_warning_level
     *
     * @return int|null
     */
    public function getInventoryWarningLevel()
    {
        return $this->container['inventory_warning_level'];
    }

    /**
     * Sets inventory_warning_level
     *
     * @param int|null $inventory_warning_level Inventory warning level for the product. When the product's inventory level drops below the warning level, the store owner will be informed. Simple inventory tracking must be enabled (see the `inventory_tracking` field) for this to take any effect.
     *
     * @return self
     */
    public function setInventoryWarningLevel($inventory_warning_level)
    {
        if (is_null($inventory_warning_level)) {
            throw new \InvalidArgumentException('non-nullable inventory_warning_level cannot be null');
        }

        if (($inventory_warning_level > 1000000000)) {
            throw new \InvalidArgumentException('invalid value for $inventory_warning_level when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if (($inventory_warning_level < 0)) {
            throw new \InvalidArgumentException('invalid value for $inventory_warning_level when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['inventory_warning_level'] = $inventory_warning_level;

        return $this;
    }

    /**
     * Gets inventory_tracking
     *
     * @return string|null
     */
    public function getInventoryTracking()
    {
        return $this->container['inventory_tracking'];
    }

    /**
     * Sets inventory_tracking
     *
     * @param string|null $inventory_tracking The type of inventory tracking for the product. Values are: `none` - inventory levels will not be tracked; `product` - inventory levels will be tracked using the `inventory_level` and `inventory_warning_level` fields; `variant` - inventory levels will be tracked based on variants, which maintain their own warning levels and inventory levels.
     *
     * @return self
     */
    public function setInventoryTracking($inventory_tracking)
    {
        if (is_null($inventory_tracking)) {
            throw new \InvalidArgumentException('non-nullable inventory_tracking cannot be null');
        }
        $allowedValues = $this->getInventoryTrackingAllowableValues();
        if (!in_array($inventory_tracking, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'inventory_tracking', must be one of '%s'",
                    $inventory_tracking,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['inventory_tracking'] = $inventory_tracking;

        return $this;
    }

    /**
     * Gets fixed_cost_shipping_price
     *
     * @return float|null
     */
    public function getFixedCostShippingPrice()
    {
        return $this->container['fixed_cost_shipping_price'];
    }

    /**
     * Sets fixed_cost_shipping_price
     *
     * @param float|null $fixed_cost_shipping_price A fixed shipping cost for the product. If defined, this value will be used during checkout instead of normal shipping-cost calculation.
     *
     * @return self
     */
    public function setFixedCostShippingPrice($fixed_cost_shipping_price)
    {
        if (is_null($fixed_cost_shipping_price)) {
            throw new \InvalidArgumentException('non-nullable fixed_cost_shipping_price cannot be null');
        }

        if (($fixed_cost_shipping_price < 0)) {
            throw new \InvalidArgumentException('invalid value for $fixed_cost_shipping_price when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['fixed_cost_shipping_price'] = $fixed_cost_shipping_price;

        return $this;
    }

    /**
     * Gets is_free_shipping
     *
     * @return bool|null
     */
    public function getIsFreeShipping()
    {
        return $this->container['is_free_shipping'];
    }

    /**
     * Sets is_free_shipping
     *
     * @param bool|null $is_free_shipping Flag used to indicate whether the product has free shipping. If `true`, the shipping cost for the product will be zero.
     *
     * @return self
     */
    public function setIsFreeShipping($is_free_shipping)
    {
        if (is_null($is_free_shipping)) {
            throw new \InvalidArgumentException('non-nullable is_free_shipping cannot be null');
        }
        $this->container['is_free_shipping'] = $is_free_shipping;

        return $this;
    }

    /**
     * Gets is_visible
     *
     * @return bool|null
     */
    public function getIsVisible()
    {
        return $this->container['is_visible'];
    }

    /**
     * Sets is_visible
     *
     * @param bool|null $is_visible Flag to determine whether the product should be displayed to customers browsing the store. If `true`, the product will be displayed. If `false`, the product will be hidden from view.
     *
     * @return self
     */
    public function setIsVisible($is_visible)
    {
        if (is_null($is_visible)) {
            throw new \InvalidArgumentException('non-nullable is_visible cannot be null');
        }
        $this->container['is_visible'] = $is_visible;

        return $this;
    }

    /**
     * Gets is_featured
     *
     * @return bool|null
     */
    public function getIsFeatured()
    {
        return $this->container['is_featured'];
    }

    /**
     * Sets is_featured
     *
     * @param bool|null $is_featured Flag to determine whether the product should be included in the `featured products` panel when viewing the store.
     *
     * @return self
     */
    public function setIsFeatured($is_featured)
    {
        if (is_null($is_featured)) {
            throw new \InvalidArgumentException('non-nullable is_featured cannot be null');
        }
        $this->container['is_featured'] = $is_featured;

        return $this;
    }

    /**
     * Gets related_products
     *
     * @return int[]|null
     */
    public function getRelatedProducts()
    {
        return $this->container['related_products'];
    }

    /**
     * Sets related_products
     *
     * @param int[]|null $related_products An array of IDs for the related products.
     *
     * @return self
     */
    public function setRelatedProducts($related_products)
    {
        if (is_null($related_products)) {
            throw new \InvalidArgumentException('non-nullable related_products cannot be null');
        }
        $this->container['related_products'] = $related_products;

        return $this;
    }

    /**
     * Gets warranty
     *
     * @return string|null
     */
    public function getWarranty()
    {
        return $this->container['warranty'];
    }

    /**
     * Sets warranty
     *
     * @param string|null $warranty Warranty information displayed on the product page. Can include HTML formatting.
     *
     * @return self
     */
    public function setWarranty($warranty)
    {
        if (is_null($warranty)) {
            throw new \InvalidArgumentException('non-nullable warranty cannot be null');
        }
        if ((mb_strlen($warranty) > 65535)) {
            throw new \InvalidArgumentException('invalid length for $warranty when calling ProductPost., must be smaller than or equal to 65535.');
        }
        if ((mb_strlen($warranty) < 0)) {
            throw new \InvalidArgumentException('invalid length for $warranty when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['warranty'] = $warranty;

        return $this;
    }

    /**
     * Gets bin_picking_number
     *
     * @return string|null
     */
    public function getBinPickingNumber()
    {
        return $this->container['bin_picking_number'];
    }

    /**
     * Sets bin_picking_number
     *
     * @param string|null $bin_picking_number The BIN picking number for the product.
     *
     * @return self
     */
    public function setBinPickingNumber($bin_picking_number)
    {
        if (is_null($bin_picking_number)) {
            throw new \InvalidArgumentException('non-nullable bin_picking_number cannot be null');
        }
        if ((mb_strlen($bin_picking_number) > 255)) {
            throw new \InvalidArgumentException('invalid length for $bin_picking_number when calling ProductPost., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($bin_picking_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $bin_picking_number when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['bin_picking_number'] = $bin_picking_number;

        return $this;
    }

    /**
     * Gets layout_file
     *
     * @return string|null
     */
    public function getLayoutFile()
    {
        return $this->container['layout_file'];
    }

    /**
     * Sets layout_file
     *
     * @param string|null $layout_file The layout template file used to render this product category. This field is writable only for stores with a Blueprint theme applied.
     *
     * @return self
     */
    public function setLayoutFile($layout_file)
    {
        if (is_null($layout_file)) {
            throw new \InvalidArgumentException('non-nullable layout_file cannot be null');
        }
        if ((mb_strlen($layout_file) > 500)) {
            throw new \InvalidArgumentException('invalid length for $layout_file when calling ProductPost., must be smaller than or equal to 500.');
        }
        if ((mb_strlen($layout_file) < 0)) {
            throw new \InvalidArgumentException('invalid length for $layout_file when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['layout_file'] = $layout_file;

        return $this;
    }

    /**
     * Gets upc
     *
     * @return string|null
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     *
     * @param string|null $upc The product UPC code, which is used in feeds for shopping comparison sites and external channel integrations.
     *
     * @return self
     */
    public function setUpc($upc)
    {
        if (is_null($upc)) {
            throw new \InvalidArgumentException('non-nullable upc cannot be null');
        }
        if ((mb_strlen($upc) > 255)) {
            throw new \InvalidArgumentException('invalid length for $upc when calling ProductPost., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($upc) < 0)) {
            throw new \InvalidArgumentException('invalid length for $upc when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['upc'] = $upc;

        return $this;
    }

    /**
     * Gets search_keywords
     *
     * @return string|null
     */
    public function getSearchKeywords()
    {
        return $this->container['search_keywords'];
    }

    /**
     * Sets search_keywords
     *
     * @param string|null $search_keywords A comma-separated list of keywords that can be used to locate the product when searching the store.
     *
     * @return self
     */
    public function setSearchKeywords($search_keywords)
    {
        if (is_null($search_keywords)) {
            throw new \InvalidArgumentException('non-nullable search_keywords cannot be null');
        }
        if ((mb_strlen($search_keywords) > 65535)) {
            throw new \InvalidArgumentException('invalid length for $search_keywords when calling ProductPost., must be smaller than or equal to 65535.');
        }
        if ((mb_strlen($search_keywords) < 0)) {
            throw new \InvalidArgumentException('invalid length for $search_keywords when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['search_keywords'] = $search_keywords;

        return $this;
    }

    /**
     * Gets availability
     *
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->container['availability'];
    }

    /**
     * Sets availability
     *
     * @param string|null $availability Availability of the product. Availability options are: `available` - the product can be purchased on the storefront; `disabled` - the product is listed in the storefront, but cannot be purchased; `preorder` - the product is listed for pre-orders.
     *
     * @return self
     */
    public function setAvailability($availability)
    {
        if (is_null($availability)) {
            throw new \InvalidArgumentException('non-nullable availability cannot be null');
        }
        $allowedValues = $this->getAvailabilityAllowableValues();
        if (!in_array($availability, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'availability', must be one of '%s'",
                    $availability,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['availability'] = $availability;

        return $this;
    }

    /**
     * Gets availability_description
     *
     * @return string|null
     */
    public function getAvailabilityDescription()
    {
        return $this->container['availability_description'];
    }

    /**
     * Sets availability_description
     *
     * @param string|null $availability_description Availability text displayed on the checkout page, under the product title. Tells the customer how long it will normally take to ship this product, such as: 'Usually ships in 24 hours.'
     *
     * @return self
     */
    public function setAvailabilityDescription($availability_description)
    {
        if (is_null($availability_description)) {
            throw new \InvalidArgumentException('non-nullable availability_description cannot be null');
        }
        if ((mb_strlen($availability_description) > 255)) {
            throw new \InvalidArgumentException('invalid length for $availability_description when calling ProductPost., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($availability_description) < 0)) {
            throw new \InvalidArgumentException('invalid length for $availability_description when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['availability_description'] = $availability_description;

        return $this;
    }

    /**
     * Gets gift_wrapping_options_type
     *
     * @return string|null
     */
    public function getGiftWrappingOptionsType()
    {
        return $this->container['gift_wrapping_options_type'];
    }

    /**
     * Sets gift_wrapping_options_type
     *
     * @param string|null $gift_wrapping_options_type Type of gift-wrapping options. Values: `any` - allow any gift-wrapping options in the store; `none` - disallow gift-wrapping on the product; `list` – provide a list of IDs in the `gift_wrapping_options_list` field.
     *
     * @return self
     */
    public function setGiftWrappingOptionsType($gift_wrapping_options_type)
    {
        if (is_null($gift_wrapping_options_type)) {
            throw new \InvalidArgumentException('non-nullable gift_wrapping_options_type cannot be null');
        }
        $allowedValues = $this->getGiftWrappingOptionsTypeAllowableValues();
        if (!in_array($gift_wrapping_options_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'gift_wrapping_options_type', must be one of '%s'",
                    $gift_wrapping_options_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['gift_wrapping_options_type'] = $gift_wrapping_options_type;

        return $this;
    }

    /**
     * Gets gift_wrapping_options_list
     *
     * @return int[]|null
     */
    public function getGiftWrappingOptionsList()
    {
        return $this->container['gift_wrapping_options_list'];
    }

    /**
     * Sets gift_wrapping_options_list
     *
     * @param int[]|null $gift_wrapping_options_list A list of gift-wrapping option IDs.
     *
     * @return self
     */
    public function setGiftWrappingOptionsList($gift_wrapping_options_list)
    {
        if (is_null($gift_wrapping_options_list)) {
            throw new \InvalidArgumentException('non-nullable gift_wrapping_options_list cannot be null');
        }
        $this->container['gift_wrapping_options_list'] = $gift_wrapping_options_list;

        return $this;
    }

    /**
     * Gets sort_order
     *
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     *
     * @param int|null $sort_order Priority to give this product when included in product lists on category pages and in search results. Lower integers will place the product closer to the top of the results.
     *
     * @return self
     */
    public function setSortOrder($sort_order)
    {
        if (is_null($sort_order)) {
            throw new \InvalidArgumentException('non-nullable sort_order cannot be null');
        }

        if (($sort_order > 2147483647)) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling ProductPost., must be smaller than or equal to 2147483647.');
        }
        if (($sort_order < -2147483648)) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling ProductPost., must be bigger than or equal to -2147483648.');
        }

        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return string|null
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param string|null $condition The product condition. Will be shown on the product page if the `is_condition_shown` field's value is `true`. Possible values: `New`, `Used`, `Refurbished`.
     *
     * @return self
     */
    public function setCondition($condition)
    {
        if (is_null($condition)) {
            throw new \InvalidArgumentException('non-nullable condition cannot be null');
        }
        $allowedValues = $this->getConditionAllowableValues();
        if (!in_array($condition, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'condition', must be one of '%s'",
                    $condition,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets is_condition_shown
     *
     * @return bool|null
     */
    public function getIsConditionShown()
    {
        return $this->container['is_condition_shown'];
    }

    /**
     * Sets is_condition_shown
     *
     * @param bool|null $is_condition_shown Flag used to determine whether the product condition is shown to the customer on the product page.
     *
     * @return self
     */
    public function setIsConditionShown($is_condition_shown)
    {
        if (is_null($is_condition_shown)) {
            throw new \InvalidArgumentException('non-nullable is_condition_shown cannot be null');
        }
        $this->container['is_condition_shown'] = $is_condition_shown;

        return $this;
    }

    /**
     * Gets order_quantity_minimum
     *
     * @return int|null
     */
    public function getOrderQuantityMinimum()
    {
        return $this->container['order_quantity_minimum'];
    }

    /**
     * Sets order_quantity_minimum
     *
     * @param int|null $order_quantity_minimum The minimum quantity an order must contain, to be eligible to purchase this product.
     *
     * @return self
     */
    public function setOrderQuantityMinimum($order_quantity_minimum)
    {
        if (is_null($order_quantity_minimum)) {
            throw new \InvalidArgumentException('non-nullable order_quantity_minimum cannot be null');
        }

        if (($order_quantity_minimum > 1000000000)) {
            throw new \InvalidArgumentException('invalid value for $order_quantity_minimum when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if (($order_quantity_minimum < 0)) {
            throw new \InvalidArgumentException('invalid value for $order_quantity_minimum when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['order_quantity_minimum'] = $order_quantity_minimum;

        return $this;
    }

    /**
     * Gets order_quantity_maximum
     *
     * @return int|null
     */
    public function getOrderQuantityMaximum()
    {
        return $this->container['order_quantity_maximum'];
    }

    /**
     * Sets order_quantity_maximum
     *
     * @param int|null $order_quantity_maximum The maximum quantity an order can contain when purchasing the product.
     *
     * @return self
     */
    public function setOrderQuantityMaximum($order_quantity_maximum)
    {
        if (is_null($order_quantity_maximum)) {
            throw new \InvalidArgumentException('non-nullable order_quantity_maximum cannot be null');
        }

        if (($order_quantity_maximum > 1000000000)) {
            throw new \InvalidArgumentException('invalid value for $order_quantity_maximum when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if (($order_quantity_maximum < 0)) {
            throw new \InvalidArgumentException('invalid value for $order_quantity_maximum when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['order_quantity_maximum'] = $order_quantity_maximum;

        return $this;
    }

    /**
     * Gets page_title
     *
     * @return string|null
     */
    public function getPageTitle()
    {
        return $this->container['page_title'];
    }

    /**
     * Sets page_title
     *
     * @param string|null $page_title Custom title for the product page. If not defined, the product name will be used as the meta title.
     *
     * @return self
     */
    public function setPageTitle($page_title)
    {
        if (is_null($page_title)) {
            throw new \InvalidArgumentException('non-nullable page_title cannot be null');
        }
        if ((mb_strlen($page_title) > 255)) {
            throw new \InvalidArgumentException('invalid length for $page_title when calling ProductPost., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($page_title) < 0)) {
            throw new \InvalidArgumentException('invalid length for $page_title when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['page_title'] = $page_title;

        return $this;
    }

    /**
     * Gets meta_keywords
     *
     * @return string[]|null
     */
    public function getMetaKeywords()
    {
        return $this->container['meta_keywords'];
    }

    /**
     * Sets meta_keywords
     *
     * @param string[]|null $meta_keywords Custom meta keywords for the product page. If not defined, the store's default keywords will be used.
     *
     * @return self
     */
    public function setMetaKeywords($meta_keywords)
    {
        if (is_null($meta_keywords)) {
            throw new \InvalidArgumentException('non-nullable meta_keywords cannot be null');
        }
        $this->container['meta_keywords'] = $meta_keywords;

        return $this;
    }

    /**
     * Gets meta_description
     *
     * @return string|null
     */
    public function getMetaDescription()
    {
        return $this->container['meta_description'];
    }

    /**
     * Sets meta_description
     *
     * @param string|null $meta_description Custom meta description for the product page. If not defined, the store's default meta description will be used.
     *
     * @return self
     */
    public function setMetaDescription($meta_description)
    {
        if (is_null($meta_description)) {
            throw new \InvalidArgumentException('non-nullable meta_description cannot be null');
        }
        if ((mb_strlen($meta_description) > 65535)) {
            throw new \InvalidArgumentException('invalid length for $meta_description when calling ProductPost., must be smaller than or equal to 65535.');
        }
        if ((mb_strlen($meta_description) < 0)) {
            throw new \InvalidArgumentException('invalid length for $meta_description when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['meta_description'] = $meta_description;

        return $this;
    }

    /**
     * Gets view_count
     *
     * @return int|null
     */
    public function getViewCount()
    {
        return $this->container['view_count'];
    }

    /**
     * Sets view_count
     *
     * @param int|null $view_count The number of times the product has been viewed.
     *
     * @return self
     */
    public function setViewCount($view_count)
    {
        if (is_null($view_count)) {
            throw new \InvalidArgumentException('non-nullable view_count cannot be null');
        }

        if (($view_count > 1000000000)) {
            throw new \InvalidArgumentException('invalid value for $view_count when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if (($view_count < 0)) {
            throw new \InvalidArgumentException('invalid value for $view_count when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['view_count'] = $view_count;

        return $this;
    }

    /**
     * Gets preorder_release_date
     *
     * @return \DateTime|null
     */
    public function getPreorderReleaseDate()
    {
        return $this->container['preorder_release_date'];
    }

    /**
     * Sets preorder_release_date
     *
     * @param \DateTime|null $preorder_release_date Pre-order release date. See the `availability` field for details on setting a product's availability to accept pre-orders.
     *
     * @return self
     */
    public function setPreorderReleaseDate($preorder_release_date)
    {
        if (is_null($preorder_release_date)) {
            array_push($this->openAPINullablesSetToNull, 'preorder_release_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('preorder_release_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['preorder_release_date'] = $preorder_release_date;

        return $this;
    }

    /**
     * Gets preorder_message
     *
     * @return string|null
     */
    public function getPreorderMessage()
    {
        return $this->container['preorder_message'];
    }

    /**
     * Sets preorder_message
     *
     * @param string|null $preorder_message Custom expected-date message to display on the product page. If undefined, the message defaults to the storewide setting. Can contain the `%%DATE%%` placeholder, which will be substituted for the release date.
     *
     * @return self
     */
    public function setPreorderMessage($preorder_message)
    {
        if (is_null($preorder_message)) {
            throw new \InvalidArgumentException('non-nullable preorder_message cannot be null');
        }
        if ((mb_strlen($preorder_message) > 255)) {
            throw new \InvalidArgumentException('invalid length for $preorder_message when calling ProductPost., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($preorder_message) < 0)) {
            throw new \InvalidArgumentException('invalid length for $preorder_message when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['preorder_message'] = $preorder_message;

        return $this;
    }

    /**
     * Gets is_preorder_only
     *
     * @return bool|null
     */
    public function getIsPreorderOnly()
    {
        return $this->container['is_preorder_only'];
    }

    /**
     * Sets is_preorder_only
     *
     * @param bool|null $is_preorder_only If set to true then on the preorder release date the preorder status will automatically be removed. If set to false, then on the release date the preorder status **will not** be removed. It will need to be changed manually either in the control panel or using the API. Using the API set `availability` to `available`.
     *
     * @return self
     */
    public function setIsPreorderOnly($is_preorder_only)
    {
        if (is_null($is_preorder_only)) {
            throw new \InvalidArgumentException('non-nullable is_preorder_only cannot be null');
        }
        $this->container['is_preorder_only'] = $is_preorder_only;

        return $this;
    }

    /**
     * Gets is_price_hidden
     *
     * @return bool|null
     */
    public function getIsPriceHidden()
    {
        return $this->container['is_price_hidden'];
    }

    /**
     * Sets is_price_hidden
     *
     * @param bool|null $is_price_hidden False by default, indicating that this product's price should be shown on the product page. If set to `true`, the price is hidden. (NOTE: To successfully set `is_price_hidden` to `true`, the `availability` value must be `disabled`.)
     *
     * @return self
     */
    public function setIsPriceHidden($is_price_hidden)
    {
        if (is_null($is_price_hidden)) {
            throw new \InvalidArgumentException('non-nullable is_price_hidden cannot be null');
        }
        $this->container['is_price_hidden'] = $is_price_hidden;

        return $this;
    }

    /**
     * Gets price_hidden_label
     *
     * @return string|null
     */
    public function getPriceHiddenLabel()
    {
        return $this->container['price_hidden_label'];
    }

    /**
     * Sets price_hidden_label
     *
     * @param string|null $price_hidden_label By default, an empty string. If `is_price_hidden` is `true`, the value of `price_hidden_label` is displayed instead of the price. (NOTE: To successfully set a non-empty string value with `is_price_hidden` set to `true`, the `availability` value must be `disabled`.)
     *
     * @return self
     */
    public function setPriceHiddenLabel($price_hidden_label)
    {
        if (is_null($price_hidden_label)) {
            throw new \InvalidArgumentException('non-nullable price_hidden_label cannot be null');
        }
        if ((mb_strlen($price_hidden_label) > 200)) {
            throw new \InvalidArgumentException('invalid length for $price_hidden_label when calling ProductPost., must be smaller than or equal to 200.');
        }
        if ((mb_strlen($price_hidden_label) < 0)) {
            throw new \InvalidArgumentException('invalid length for $price_hidden_label when calling ProductPost., must be bigger than or equal to 0.');
        }

        $this->container['price_hidden_label'] = $price_hidden_label;

        return $this;
    }

    /**
     * Gets custom_url
     *
     * @return \Bigcommerce\CatalogV3\Model\CustomUrlFull|null
     */
    public function getCustomUrl()
    {
        return $this->container['custom_url'];
    }

    /**
     * Sets custom_url
     *
     * @param \Bigcommerce\CatalogV3\Model\CustomUrlFull|null $custom_url custom_url
     *
     * @return self
     */
    public function setCustomUrl($custom_url)
    {
        if (is_null($custom_url)) {
            throw new \InvalidArgumentException('non-nullable custom_url cannot be null');
        }
        $this->container['custom_url'] = $custom_url;

        return $this;
    }

    /**
     * Gets open_graph_type
     *
     * @return string|null
     */
    public function getOpenGraphType()
    {
        return $this->container['open_graph_type'];
    }

    /**
     * Sets open_graph_type
     *
     * @param string|null $open_graph_type Type of product, defaults to `product`.
     *
     * @return self
     */
    public function setOpenGraphType($open_graph_type)
    {
        if (is_null($open_graph_type)) {
            throw new \InvalidArgumentException('non-nullable open_graph_type cannot be null');
        }
        $allowedValues = $this->getOpenGraphTypeAllowableValues();
        if (!in_array($open_graph_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'open_graph_type', must be one of '%s'",
                    $open_graph_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['open_graph_type'] = $open_graph_type;

        return $this;
    }

    /**
     * Gets open_graph_title
     *
     * @return string|null
     */
    public function getOpenGraphTitle()
    {
        return $this->container['open_graph_title'];
    }

    /**
     * Sets open_graph_title
     *
     * @param string|null $open_graph_title Title of the product, if not specified the product name will be used instead.
     *
     * @return self
     */
    public function setOpenGraphTitle($open_graph_title)
    {
        if (is_null($open_graph_title)) {
            throw new \InvalidArgumentException('non-nullable open_graph_title cannot be null');
        }
        $this->container['open_graph_title'] = $open_graph_title;

        return $this;
    }

    /**
     * Gets open_graph_description
     *
     * @return string|null
     */
    public function getOpenGraphDescription()
    {
        return $this->container['open_graph_description'];
    }

    /**
     * Sets open_graph_description
     *
     * @param string|null $open_graph_description Description to use for the product, if not specified then the meta_description will be used instead.
     *
     * @return self
     */
    public function setOpenGraphDescription($open_graph_description)
    {
        if (is_null($open_graph_description)) {
            throw new \InvalidArgumentException('non-nullable open_graph_description cannot be null');
        }
        $this->container['open_graph_description'] = $open_graph_description;

        return $this;
    }

    /**
     * Gets open_graph_use_meta_description
     *
     * @return bool|null
     */
    public function getOpenGraphUseMetaDescription()
    {
        return $this->container['open_graph_use_meta_description'];
    }

    /**
     * Sets open_graph_use_meta_description
     *
     * @param bool|null $open_graph_use_meta_description Flag to determine if product description or open graph description is used.
     *
     * @return self
     */
    public function setOpenGraphUseMetaDescription($open_graph_use_meta_description)
    {
        if (is_null($open_graph_use_meta_description)) {
            throw new \InvalidArgumentException('non-nullable open_graph_use_meta_description cannot be null');
        }
        $this->container['open_graph_use_meta_description'] = $open_graph_use_meta_description;

        return $this;
    }

    /**
     * Gets open_graph_use_product_name
     *
     * @return bool|null
     */
    public function getOpenGraphUseProductName()
    {
        return $this->container['open_graph_use_product_name'];
    }

    /**
     * Sets open_graph_use_product_name
     *
     * @param bool|null $open_graph_use_product_name Flag to determine if product name or open graph name is used.
     *
     * @return self
     */
    public function setOpenGraphUseProductName($open_graph_use_product_name)
    {
        if (is_null($open_graph_use_product_name)) {
            throw new \InvalidArgumentException('non-nullable open_graph_use_product_name cannot be null');
        }
        $this->container['open_graph_use_product_name'] = $open_graph_use_product_name;

        return $this;
    }

    /**
     * Gets open_graph_use_image
     *
     * @return bool|null
     */
    public function getOpenGraphUseImage()
    {
        return $this->container['open_graph_use_image'];
    }

    /**
     * Sets open_graph_use_image
     *
     * @param bool|null $open_graph_use_image Flag to determine if product image or open graph image is used.
     *
     * @return self
     */
    public function setOpenGraphUseImage($open_graph_use_image)
    {
        if (is_null($open_graph_use_image)) {
            throw new \InvalidArgumentException('non-nullable open_graph_use_image cannot be null');
        }
        $this->container['open_graph_use_image'] = $open_graph_use_image;

        return $this;
    }

    /**
     * Gets brand_name
     *
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->container['brand_name'];
    }

    /**
     * Sets brand_name
     *
     * @param string|null $brand_name The brand can be created during a product PUT or POST request. If the brand already exists then the product will be added. If not the brand will be created and the product added. If using `brand_name` it performs a fuzzy match and adds the brand. eg. \"Common Good\" and \"Common good\" are the same. Brand name does not return as part of a product response. Only the `brand_id`.
     *
     * @return self
     */
    public function setBrandName($brand_name)
    {
        if (is_null($brand_name)) {
            throw new \InvalidArgumentException('non-nullable brand_name cannot be null');
        }
        $this->container['brand_name'] = $brand_name;

        return $this;
    }

    /**
     * Gets gtin
     *
     * @return string|null
     */
    public function getGtin()
    {
        return $this->container['gtin'];
    }

    /**
     * Sets gtin
     *
     * @param string|null $gtin Global Trade Item Number
     *
     * @return self
     */
    public function setGtin($gtin)
    {
        if (is_null($gtin)) {
            throw new \InvalidArgumentException('non-nullable gtin cannot be null');
        }
        $this->container['gtin'] = $gtin;

        return $this;
    }

    /**
     * Gets mpn
     *
     * @return string|null
     */
    public function getMpn()
    {
        return $this->container['mpn'];
    }

    /**
     * Sets mpn
     *
     * @param string|null $mpn Manufacturer Part Number
     *
     * @return self
     */
    public function setMpn($mpn)
    {
        if (is_null($mpn)) {
            throw new \InvalidArgumentException('non-nullable mpn cannot be null');
        }
        $this->container['mpn'] = $mpn;

        return $this;
    }

    /**
     * Gets reviews_rating_sum
     *
     * @return int|null
     */
    public function getReviewsRatingSum()
    {
        return $this->container['reviews_rating_sum'];
    }

    /**
     * Sets reviews_rating_sum
     *
     * @param int|null $reviews_rating_sum The total rating for the product.
     *
     * @return self
     */
    public function setReviewsRatingSum($reviews_rating_sum)
    {
        if (is_null($reviews_rating_sum)) {
            throw new \InvalidArgumentException('non-nullable reviews_rating_sum cannot be null');
        }
        $this->container['reviews_rating_sum'] = $reviews_rating_sum;

        return $this;
    }

    /**
     * Gets reviews_count
     *
     * @return int|null
     */
    public function getReviewsCount()
    {
        return $this->container['reviews_count'];
    }

    /**
     * Sets reviews_count
     *
     * @param int|null $reviews_count The number of times the product has been rated.
     *
     * @return self
     */
    public function setReviewsCount($reviews_count)
    {
        if (is_null($reviews_count)) {
            throw new \InvalidArgumentException('non-nullable reviews_count cannot be null');
        }
        $this->container['reviews_count'] = $reviews_count;

        return $this;
    }

    /**
     * Gets total_sold
     *
     * @return int|null
     */
    public function getTotalSold()
    {
        return $this->container['total_sold'];
    }

    /**
     * Sets total_sold
     *
     * @param int|null $total_sold The total quantity of this product sold.
     *
     * @return self
     */
    public function setTotalSold($total_sold)
    {
        if (is_null($total_sold)) {
            throw new \InvalidArgumentException('non-nullable total_sold cannot be null');
        }
        $this->container['total_sold'] = $total_sold;

        return $this;
    }

    /**
     * Gets custom_fields
     *
     * @return \Bigcommerce\CatalogV3\Model\ProductCustomFieldPut[]|null
     */
    public function getCustomFields()
    {
        return $this->container['custom_fields'];
    }

    /**
     * Sets custom_fields
     *
     * @param \Bigcommerce\CatalogV3\Model\ProductCustomFieldPut[]|null $custom_fields custom_fields
     *
     * @return self
     */
    public function setCustomFields($custom_fields)
    {
        if (is_null($custom_fields)) {
            throw new \InvalidArgumentException('non-nullable custom_fields cannot be null');
        }
        $this->container['custom_fields'] = $custom_fields;

        return $this;
    }

    /**
     * Gets bulk_pricing_rules
     *
     * @return \Bigcommerce\CatalogV3\Model\BulkPricingRuleFull[]|null
     */
    public function getBulkPricingRules()
    {
        return $this->container['bulk_pricing_rules'];
    }

    /**
     * Sets bulk_pricing_rules
     *
     * @param \Bigcommerce\CatalogV3\Model\BulkPricingRuleFull[]|null $bulk_pricing_rules bulk_pricing_rules
     *
     * @return self
     */
    public function setBulkPricingRules($bulk_pricing_rules)
    {
        if (is_null($bulk_pricing_rules)) {
            throw new \InvalidArgumentException('non-nullable bulk_pricing_rules cannot be null');
        }
        $this->container['bulk_pricing_rules'] = $bulk_pricing_rules;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Bigcommerce\CatalogV3\Model\ProductImageFull[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Bigcommerce\CatalogV3\Model\ProductImageFull[]|null $images images
     *
     * @return self
     */
    public function setImages($images)
    {
        if (is_null($images)) {
            throw new \InvalidArgumentException('non-nullable images cannot be null');
        }
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets videos
     *
     * @return \Bigcommerce\CatalogV3\Model\ProductVideoFull[]|null
     */
    public function getVideos()
    {
        return $this->container['videos'];
    }

    /**
     * Sets videos
     *
     * @param \Bigcommerce\CatalogV3\Model\ProductVideoFull[]|null $videos videos
     *
     * @return self
     */
    public function setVideos($videos)
    {
        if (is_null($videos)) {
            throw new \InvalidArgumentException('non-nullable videos cannot be null');
        }
        $this->container['videos'] = $videos;

        return $this;
    }

    /**
     * Gets variants
     *
     * @return \Bigcommerce\CatalogV3\Model\ProductVariantPostProduct[]|null
     */
    public function getVariants()
    {
        return $this->container['variants'];
    }

    /**
     * Sets variants
     *
     * @param \Bigcommerce\CatalogV3\Model\ProductVariantPostProduct[]|null $variants variants
     *
     * @return self
     */
    public function setVariants($variants)
    {
        if (is_null($variants)) {
            throw new \InvalidArgumentException('non-nullable variants cannot be null');
        }
        $this->container['variants'] = $variants;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


