<?php
/**
 * ProductOptionConfigFull
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Model;

use \ArrayAccess;
use \Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * ProductOptionConfigFull Class Doc Comment
 *
 * @category Class
 * @description The values for option config can vary based on the Modifier created.
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProductOptionConfigFull implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'productOptionConfig_Full';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'default_value' => 'string',
        'checked_by_default' => 'bool',
        'checkbox_label' => 'string',
        'date_limited' => 'bool',
        'date_limit_mode' => 'string',
        'date_earliest_value' => '\DateTime',
        'date_latest_value' => '\DateTime',
        'file_types_mode' => 'string',
        'file_types_supported' => 'string[]',
        'file_types_other' => 'string[]',
        'file_max_size' => 'int',
        'text_characters_limited' => 'bool',
        'text_min_length' => 'int',
        'text_max_length' => 'int',
        'text_lines_limited' => 'bool',
        'text_max_lines' => 'int',
        'number_limited' => 'bool',
        'number_limit_mode' => 'string',
        'number_lowest_value' => 'float',
        'number_highest_value' => 'float',
        'number_integers_only' => 'bool',
        'product_list_adjusts_inventory' => 'bool',
        'product_list_adjusts_pricing' => 'bool',
        'product_list_shipping_calc' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'default_value' => null,
        'checked_by_default' => null,
        'checkbox_label' => null,
        'date_limited' => null,
        'date_limit_mode' => null,
        'date_earliest_value' => 'date',
        'date_latest_value' => 'date',
        'file_types_mode' => null,
        'file_types_supported' => null,
        'file_types_other' => null,
        'file_max_size' => null,
        'text_characters_limited' => null,
        'text_min_length' => null,
        'text_max_length' => null,
        'text_lines_limited' => null,
        'text_max_lines' => null,
        'number_limited' => null,
        'number_limit_mode' => null,
        'number_lowest_value' => null,
        'number_highest_value' => null,
        'number_integers_only' => null,
        'product_list_adjusts_inventory' => null,
        'product_list_adjusts_pricing' => null,
        'product_list_shipping_calc' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'default_value' => false,
        'checked_by_default' => false,
        'checkbox_label' => false,
        'date_limited' => false,
        'date_limit_mode' => false,
        'date_earliest_value' => false,
        'date_latest_value' => false,
        'file_types_mode' => false,
        'file_types_supported' => false,
        'file_types_other' => false,
        'file_max_size' => false,
        'text_characters_limited' => false,
        'text_min_length' => false,
        'text_max_length' => false,
        'text_lines_limited' => false,
        'text_max_lines' => false,
        'number_limited' => false,
        'number_limit_mode' => false,
        'number_lowest_value' => false,
        'number_highest_value' => false,
        'number_integers_only' => false,
        'product_list_adjusts_inventory' => false,
        'product_list_adjusts_pricing' => false,
        'product_list_shipping_calc' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'default_value' => 'default_value',
        'checked_by_default' => 'checked_by_default',
        'checkbox_label' => 'checkbox_label',
        'date_limited' => 'date_limited',
        'date_limit_mode' => 'date_limit_mode',
        'date_earliest_value' => 'date_earliest_value',
        'date_latest_value' => 'date_latest_value',
        'file_types_mode' => 'file_types_mode',
        'file_types_supported' => 'file_types_supported',
        'file_types_other' => 'file_types_other',
        'file_max_size' => 'file_max_size',
        'text_characters_limited' => 'text_characters_limited',
        'text_min_length' => 'text_min_length',
        'text_max_length' => 'text_max_length',
        'text_lines_limited' => 'text_lines_limited',
        'text_max_lines' => 'text_max_lines',
        'number_limited' => 'number_limited',
        'number_limit_mode' => 'number_limit_mode',
        'number_lowest_value' => 'number_lowest_value',
        'number_highest_value' => 'number_highest_value',
        'number_integers_only' => 'number_integers_only',
        'product_list_adjusts_inventory' => 'product_list_adjusts_inventory',
        'product_list_adjusts_pricing' => 'product_list_adjusts_pricing',
        'product_list_shipping_calc' => 'product_list_shipping_calc'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'default_value' => 'setDefaultValue',
        'checked_by_default' => 'setCheckedByDefault',
        'checkbox_label' => 'setCheckboxLabel',
        'date_limited' => 'setDateLimited',
        'date_limit_mode' => 'setDateLimitMode',
        'date_earliest_value' => 'setDateEarliestValue',
        'date_latest_value' => 'setDateLatestValue',
        'file_types_mode' => 'setFileTypesMode',
        'file_types_supported' => 'setFileTypesSupported',
        'file_types_other' => 'setFileTypesOther',
        'file_max_size' => 'setFileMaxSize',
        'text_characters_limited' => 'setTextCharactersLimited',
        'text_min_length' => 'setTextMinLength',
        'text_max_length' => 'setTextMaxLength',
        'text_lines_limited' => 'setTextLinesLimited',
        'text_max_lines' => 'setTextMaxLines',
        'number_limited' => 'setNumberLimited',
        'number_limit_mode' => 'setNumberLimitMode',
        'number_lowest_value' => 'setNumberLowestValue',
        'number_highest_value' => 'setNumberHighestValue',
        'number_integers_only' => 'setNumberIntegersOnly',
        'product_list_adjusts_inventory' => 'setProductListAdjustsInventory',
        'product_list_adjusts_pricing' => 'setProductListAdjustsPricing',
        'product_list_shipping_calc' => 'setProductListShippingCalc'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'default_value' => 'getDefaultValue',
        'checked_by_default' => 'getCheckedByDefault',
        'checkbox_label' => 'getCheckboxLabel',
        'date_limited' => 'getDateLimited',
        'date_limit_mode' => 'getDateLimitMode',
        'date_earliest_value' => 'getDateEarliestValue',
        'date_latest_value' => 'getDateLatestValue',
        'file_types_mode' => 'getFileTypesMode',
        'file_types_supported' => 'getFileTypesSupported',
        'file_types_other' => 'getFileTypesOther',
        'file_max_size' => 'getFileMaxSize',
        'text_characters_limited' => 'getTextCharactersLimited',
        'text_min_length' => 'getTextMinLength',
        'text_max_length' => 'getTextMaxLength',
        'text_lines_limited' => 'getTextLinesLimited',
        'text_max_lines' => 'getTextMaxLines',
        'number_limited' => 'getNumberLimited',
        'number_limit_mode' => 'getNumberLimitMode',
        'number_lowest_value' => 'getNumberLowestValue',
        'number_highest_value' => 'getNumberHighestValue',
        'number_integers_only' => 'getNumberIntegersOnly',
        'product_list_adjusts_inventory' => 'getProductListAdjustsInventory',
        'product_list_adjusts_pricing' => 'getProductListAdjustsPricing',
        'product_list_shipping_calc' => 'getProductListShippingCalc'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DATE_LIMIT_MODE_EARLIEST = 'earliest';
    public const DATE_LIMIT_MODE_RANGE = 'range';
    public const DATE_LIMIT_MODE_LATEST = 'latest';
    public const FILE_TYPES_MODE_SPECIFIC = 'specific';
    public const FILE_TYPES_MODE_ALL = 'all';
    public const NUMBER_LIMIT_MODE_LOWEST = 'lowest';
    public const NUMBER_LIMIT_MODE_HIGHEST = 'highest';
    public const NUMBER_LIMIT_MODE_RANGE = 'range';
    public const PRODUCT_LIST_SHIPPING_CALC_NONE = 'none';
    public const PRODUCT_LIST_SHIPPING_CALC_WEIGHT = 'weight';
    public const PRODUCT_LIST_SHIPPING_CALC_PACKAGE = 'package';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDateLimitModeAllowableValues()
    {
        return [
            self::DATE_LIMIT_MODE_EARLIEST,
            self::DATE_LIMIT_MODE_RANGE,
            self::DATE_LIMIT_MODE_LATEST,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFileTypesModeAllowableValues()
    {
        return [
            self::FILE_TYPES_MODE_SPECIFIC,
            self::FILE_TYPES_MODE_ALL,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getNumberLimitModeAllowableValues()
    {
        return [
            self::NUMBER_LIMIT_MODE_LOWEST,
            self::NUMBER_LIMIT_MODE_HIGHEST,
            self::NUMBER_LIMIT_MODE_RANGE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getProductListShippingCalcAllowableValues()
    {
        return [
            self::PRODUCT_LIST_SHIPPING_CALC_NONE,
            self::PRODUCT_LIST_SHIPPING_CALC_WEIGHT,
            self::PRODUCT_LIST_SHIPPING_CALC_PACKAGE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('default_value', $data ?? [], null);
        $this->setIfExists('checked_by_default', $data ?? [], null);
        $this->setIfExists('checkbox_label', $data ?? [], null);
        $this->setIfExists('date_limited', $data ?? [], null);
        $this->setIfExists('date_limit_mode', $data ?? [], null);
        $this->setIfExists('date_earliest_value', $data ?? [], null);
        $this->setIfExists('date_latest_value', $data ?? [], null);
        $this->setIfExists('file_types_mode', $data ?? [], null);
        $this->setIfExists('file_types_supported', $data ?? [], null);
        $this->setIfExists('file_types_other', $data ?? [], null);
        $this->setIfExists('file_max_size', $data ?? [], null);
        $this->setIfExists('text_characters_limited', $data ?? [], null);
        $this->setIfExists('text_min_length', $data ?? [], null);
        $this->setIfExists('text_max_length', $data ?? [], null);
        $this->setIfExists('text_lines_limited', $data ?? [], null);
        $this->setIfExists('text_max_lines', $data ?? [], null);
        $this->setIfExists('number_limited', $data ?? [], null);
        $this->setIfExists('number_limit_mode', $data ?? [], null);
        $this->setIfExists('number_lowest_value', $data ?? [], null);
        $this->setIfExists('number_highest_value', $data ?? [], null);
        $this->setIfExists('number_integers_only', $data ?? [], null);
        $this->setIfExists('product_list_adjusts_inventory', $data ?? [], null);
        $this->setIfExists('product_list_adjusts_pricing', $data ?? [], null);
        $this->setIfExists('product_list_shipping_calc', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getDateLimitModeAllowableValues();
        if (!is_null($this->container['date_limit_mode']) && !in_array($this->container['date_limit_mode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'date_limit_mode', must be one of '%s'",
                $this->container['date_limit_mode'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getFileTypesModeAllowableValues();
        if (!is_null($this->container['file_types_mode']) && !in_array($this->container['file_types_mode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'file_types_mode', must be one of '%s'",
                $this->container['file_types_mode'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getNumberLimitModeAllowableValues();
        if (!is_null($this->container['number_limit_mode']) && !in_array($this->container['number_limit_mode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'number_limit_mode', must be one of '%s'",
                $this->container['number_limit_mode'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getProductListShippingCalcAllowableValues();
        if (!is_null($this->container['product_list_shipping_calc']) && !in_array($this->container['product_list_shipping_calc'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'product_list_shipping_calc', must be one of '%s'",
                $this->container['product_list_shipping_calc'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets default_value
     *
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->container['default_value'];
    }

    /**
     * Sets default_value
     *
     * @param string|null $default_value (date, text, multi_line_text, numbers_only_text) The default value. Shown on a date option as an ISO-8601–formatted string, or on a text option as a string.
     *
     * @return self
     */
    public function setDefaultValue($default_value)
    {
        if (is_null($default_value)) {
            throw new \InvalidArgumentException('non-nullable default_value cannot be null');
        }
        $this->container['default_value'] = $default_value;

        return $this;
    }

    /**
     * Gets checked_by_default
     *
     * @return bool|null
     */
    public function getCheckedByDefault()
    {
        return $this->container['checked_by_default'];
    }

    /**
     * Sets checked_by_default
     *
     * @param bool|null $checked_by_default (checkbox) Flag for setting the checkbox to be checked by default.
     *
     * @return self
     */
    public function setCheckedByDefault($checked_by_default)
    {
        if (is_null($checked_by_default)) {
            throw new \InvalidArgumentException('non-nullable checked_by_default cannot be null');
        }
        $this->container['checked_by_default'] = $checked_by_default;

        return $this;
    }

    /**
     * Gets checkbox_label
     *
     * @return string|null
     */
    public function getCheckboxLabel()
    {
        return $this->container['checkbox_label'];
    }

    /**
     * Sets checkbox_label
     *
     * @param string|null $checkbox_label (checkbox) Label displayed for the checkbox option.
     *
     * @return self
     */
    public function setCheckboxLabel($checkbox_label)
    {
        if (is_null($checkbox_label)) {
            throw new \InvalidArgumentException('non-nullable checkbox_label cannot be null');
        }
        $this->container['checkbox_label'] = $checkbox_label;

        return $this;
    }

    /**
     * Gets date_limited
     *
     * @return bool|null
     */
    public function getDateLimited()
    {
        return $this->container['date_limited'];
    }

    /**
     * Sets date_limited
     *
     * @param bool|null $date_limited (date) Flag to limit the dates allowed to be entered on a date option.
     *
     * @return self
     */
    public function setDateLimited($date_limited)
    {
        if (is_null($date_limited)) {
            throw new \InvalidArgumentException('non-nullable date_limited cannot be null');
        }
        $this->container['date_limited'] = $date_limited;

        return $this;
    }

    /**
     * Gets date_limit_mode
     *
     * @return string|null
     */
    public function getDateLimitMode()
    {
        return $this->container['date_limit_mode'];
    }

    /**
     * Sets date_limit_mode
     *
     * @param string|null $date_limit_mode (date) The type of limit that is allowed to be entered on a date option.
     *
     * @return self
     */
    public function setDateLimitMode($date_limit_mode)
    {
        if (is_null($date_limit_mode)) {
            throw new \InvalidArgumentException('non-nullable date_limit_mode cannot be null');
        }
        $allowedValues = $this->getDateLimitModeAllowableValues();
        if (!in_array($date_limit_mode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'date_limit_mode', must be one of '%s'",
                    $date_limit_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['date_limit_mode'] = $date_limit_mode;

        return $this;
    }

    /**
     * Gets date_earliest_value
     *
     * @return \DateTime|null
     */
    public function getDateEarliestValue()
    {
        return $this->container['date_earliest_value'];
    }

    /**
     * Sets date_earliest_value
     *
     * @param \DateTime|null $date_earliest_value (date) The earliest date allowed to be entered on the date option, as an ISO-8601 formatted string.
     *
     * @return self
     */
    public function setDateEarliestValue($date_earliest_value)
    {
        if (is_null($date_earliest_value)) {
            throw new \InvalidArgumentException('non-nullable date_earliest_value cannot be null');
        }
        $this->container['date_earliest_value'] = $date_earliest_value;

        return $this;
    }

    /**
     * Gets date_latest_value
     *
     * @return \DateTime|null
     */
    public function getDateLatestValue()
    {
        return $this->container['date_latest_value'];
    }

    /**
     * Sets date_latest_value
     *
     * @param \DateTime|null $date_latest_value (date) The latest date allowed to be entered on the date option, as an ISO-8601 formatted string.
     *
     * @return self
     */
    public function setDateLatestValue($date_latest_value)
    {
        if (is_null($date_latest_value)) {
            throw new \InvalidArgumentException('non-nullable date_latest_value cannot be null');
        }
        $this->container['date_latest_value'] = $date_latest_value;

        return $this;
    }

    /**
     * Gets file_types_mode
     *
     * @return string|null
     */
    public function getFileTypesMode()
    {
        return $this->container['file_types_mode'];
    }

    /**
     * Sets file_types_mode
     *
     * @param string|null $file_types_mode (file) The kind of restriction on the file types that can be uploaded with a file upload option. Values: `specific` - restricts uploads to particular file types; `all` - allows all file types.
     *
     * @return self
     */
    public function setFileTypesMode($file_types_mode)
    {
        if (is_null($file_types_mode)) {
            throw new \InvalidArgumentException('non-nullable file_types_mode cannot be null');
        }
        $allowedValues = $this->getFileTypesModeAllowableValues();
        if (!in_array($file_types_mode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'file_types_mode', must be one of '%s'",
                    $file_types_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['file_types_mode'] = $file_types_mode;

        return $this;
    }

    /**
     * Gets file_types_supported
     *
     * @return string[]|null
     */
    public function getFileTypesSupported()
    {
        return $this->container['file_types_supported'];
    }

    /**
     * Sets file_types_supported
     *
     * @param string[]|null $file_types_supported (file) The type of files allowed to be uploaded if the `file_type_option` is set to `specific`. Values:   `images` - Allows upload of image MIME types (`bmp`, `gif`, `jpg`, `jpeg`, `jpe`, `jif`, `jfif`, `jfi`, `png`, `wbmp`, `xbm`, `tiff`). `documents` - Allows upload of document MIME types (`txt`, `pdf`, `rtf`, `doc`, `docx`, `xls`, `xlsx`, `accdb`, `mdb`, `one`, `pps`, `ppsx`, `ppt`, `pptx`, `pub`, `odt`, `ods`, `odp`, `odg`, `odf`).   `other` - Allows file types defined in the `file_types_other` array.
     *
     * @return self
     */
    public function setFileTypesSupported($file_types_supported)
    {
        if (is_null($file_types_supported)) {
            throw new \InvalidArgumentException('non-nullable file_types_supported cannot be null');
        }
        $this->container['file_types_supported'] = $file_types_supported;

        return $this;
    }

    /**
     * Gets file_types_other
     *
     * @return string[]|null
     */
    public function getFileTypesOther()
    {
        return $this->container['file_types_other'];
    }

    /**
     * Sets file_types_other
     *
     * @param string[]|null $file_types_other (file) A list of other file types allowed with the file upload option.
     *
     * @return self
     */
    public function setFileTypesOther($file_types_other)
    {
        if (is_null($file_types_other)) {
            throw new \InvalidArgumentException('non-nullable file_types_other cannot be null');
        }
        $this->container['file_types_other'] = $file_types_other;

        return $this;
    }

    /**
     * Gets file_max_size
     *
     * @return int|null
     */
    public function getFileMaxSize()
    {
        return $this->container['file_max_size'];
    }

    /**
     * Sets file_max_size
     *
     * @param int|null $file_max_size (file) The maximum size for a file that can be used with the file upload option. This will still be limited by the server.
     *
     * @return self
     */
    public function setFileMaxSize($file_max_size)
    {
        if (is_null($file_max_size)) {
            throw new \InvalidArgumentException('non-nullable file_max_size cannot be null');
        }
        $this->container['file_max_size'] = $file_max_size;

        return $this;
    }

    /**
     * Gets text_characters_limited
     *
     * @return bool|null
     */
    public function getTextCharactersLimited()
    {
        return $this->container['text_characters_limited'];
    }

    /**
     * Sets text_characters_limited
     *
     * @param bool|null $text_characters_limited (text, multi_line_text) Flag to validate the length of a text or multi-line text input.
     *
     * @return self
     */
    public function setTextCharactersLimited($text_characters_limited)
    {
        if (is_null($text_characters_limited)) {
            throw new \InvalidArgumentException('non-nullable text_characters_limited cannot be null');
        }
        $this->container['text_characters_limited'] = $text_characters_limited;

        return $this;
    }

    /**
     * Gets text_min_length
     *
     * @return int|null
     */
    public function getTextMinLength()
    {
        return $this->container['text_min_length'];
    }

    /**
     * Sets text_min_length
     *
     * @param int|null $text_min_length (text, multi_line_text) The minimum length allowed for a text or multi-line text option.
     *
     * @return self
     */
    public function setTextMinLength($text_min_length)
    {
        if (is_null($text_min_length)) {
            throw new \InvalidArgumentException('non-nullable text_min_length cannot be null');
        }
        $this->container['text_min_length'] = $text_min_length;

        return $this;
    }

    /**
     * Gets text_max_length
     *
     * @return int|null
     */
    public function getTextMaxLength()
    {
        return $this->container['text_max_length'];
    }

    /**
     * Sets text_max_length
     *
     * @param int|null $text_max_length (text, multi_line_text) The maximum length allowed for a text or multi line text option.
     *
     * @return self
     */
    public function setTextMaxLength($text_max_length)
    {
        if (is_null($text_max_length)) {
            throw new \InvalidArgumentException('non-nullable text_max_length cannot be null');
        }
        $this->container['text_max_length'] = $text_max_length;

        return $this;
    }

    /**
     * Gets text_lines_limited
     *
     * @return bool|null
     */
    public function getTextLinesLimited()
    {
        return $this->container['text_lines_limited'];
    }

    /**
     * Sets text_lines_limited
     *
     * @param bool|null $text_lines_limited (multi_line_text) Flag to validate the maximum number of lines allowed on a multi-line text input.
     *
     * @return self
     */
    public function setTextLinesLimited($text_lines_limited)
    {
        if (is_null($text_lines_limited)) {
            throw new \InvalidArgumentException('non-nullable text_lines_limited cannot be null');
        }
        $this->container['text_lines_limited'] = $text_lines_limited;

        return $this;
    }

    /**
     * Gets text_max_lines
     *
     * @return int|null
     */
    public function getTextMaxLines()
    {
        return $this->container['text_max_lines'];
    }

    /**
     * Sets text_max_lines
     *
     * @param int|null $text_max_lines (multi_line_text) The maximum number of lines allowed on a multi-line text input.
     *
     * @return self
     */
    public function setTextMaxLines($text_max_lines)
    {
        if (is_null($text_max_lines)) {
            throw new \InvalidArgumentException('non-nullable text_max_lines cannot be null');
        }
        $this->container['text_max_lines'] = $text_max_lines;

        return $this;
    }

    /**
     * Gets number_limited
     *
     * @return bool|null
     */
    public function getNumberLimited()
    {
        return $this->container['number_limited'];
    }

    /**
     * Sets number_limited
     *
     * @param bool|null $number_limited (numbers_only_text) Flag to limit the value of a number option.
     *
     * @return self
     */
    public function setNumberLimited($number_limited)
    {
        if (is_null($number_limited)) {
            throw new \InvalidArgumentException('non-nullable number_limited cannot be null');
        }
        $this->container['number_limited'] = $number_limited;

        return $this;
    }

    /**
     * Gets number_limit_mode
     *
     * @return string|null
     */
    public function getNumberLimitMode()
    {
        return $this->container['number_limit_mode'];
    }

    /**
     * Sets number_limit_mode
     *
     * @param string|null $number_limit_mode (numbers_only_text) The type of limit on values entered for a number option.
     *
     * @return self
     */
    public function setNumberLimitMode($number_limit_mode)
    {
        if (is_null($number_limit_mode)) {
            throw new \InvalidArgumentException('non-nullable number_limit_mode cannot be null');
        }
        $allowedValues = $this->getNumberLimitModeAllowableValues();
        if (!in_array($number_limit_mode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'number_limit_mode', must be one of '%s'",
                    $number_limit_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['number_limit_mode'] = $number_limit_mode;

        return $this;
    }

    /**
     * Gets number_lowest_value
     *
     * @return float|null
     */
    public function getNumberLowestValue()
    {
        return $this->container['number_lowest_value'];
    }

    /**
     * Sets number_lowest_value
     *
     * @param float|null $number_lowest_value (numbers_only_text) The lowest allowed value for a number option if `number_limited` is true.
     *
     * @return self
     */
    public function setNumberLowestValue($number_lowest_value)
    {
        if (is_null($number_lowest_value)) {
            throw new \InvalidArgumentException('non-nullable number_lowest_value cannot be null');
        }
        $this->container['number_lowest_value'] = $number_lowest_value;

        return $this;
    }

    /**
     * Gets number_highest_value
     *
     * @return float|null
     */
    public function getNumberHighestValue()
    {
        return $this->container['number_highest_value'];
    }

    /**
     * Sets number_highest_value
     *
     * @param float|null $number_highest_value (numbers_only_text) The highest allowed value for a number option if `number_limited` is true.
     *
     * @return self
     */
    public function setNumberHighestValue($number_highest_value)
    {
        if (is_null($number_highest_value)) {
            throw new \InvalidArgumentException('non-nullable number_highest_value cannot be null');
        }
        $this->container['number_highest_value'] = $number_highest_value;

        return $this;
    }

    /**
     * Gets number_integers_only
     *
     * @return bool|null
     */
    public function getNumberIntegersOnly()
    {
        return $this->container['number_integers_only'];
    }

    /**
     * Sets number_integers_only
     *
     * @param bool|null $number_integers_only (numbers_only_text) Flag to limit the input on a number option to whole numbers only.
     *
     * @return self
     */
    public function setNumberIntegersOnly($number_integers_only)
    {
        if (is_null($number_integers_only)) {
            throw new \InvalidArgumentException('non-nullable number_integers_only cannot be null');
        }
        $this->container['number_integers_only'] = $number_integers_only;

        return $this;
    }

    /**
     * Gets product_list_adjusts_inventory
     *
     * @return bool|null
     */
    public function getProductListAdjustsInventory()
    {
        return $this->container['product_list_adjusts_inventory'];
    }

    /**
     * Sets product_list_adjusts_inventory
     *
     * @param bool|null $product_list_adjusts_inventory (product_list, product_list_with_images) Flag for automatically adjusting inventory on a product included in the list.
     *
     * @return self
     */
    public function setProductListAdjustsInventory($product_list_adjusts_inventory)
    {
        if (is_null($product_list_adjusts_inventory)) {
            throw new \InvalidArgumentException('non-nullable product_list_adjusts_inventory cannot be null');
        }
        $this->container['product_list_adjusts_inventory'] = $product_list_adjusts_inventory;

        return $this;
    }

    /**
     * Gets product_list_adjusts_pricing
     *
     * @return bool|null
     */
    public function getProductListAdjustsPricing()
    {
        return $this->container['product_list_adjusts_pricing'];
    }

    /**
     * Sets product_list_adjusts_pricing
     *
     * @param bool|null $product_list_adjusts_pricing (product_list, product_list_with_images) Flag to add the optional product's price to the main product's price.
     *
     * @return self
     */
    public function setProductListAdjustsPricing($product_list_adjusts_pricing)
    {
        if (is_null($product_list_adjusts_pricing)) {
            throw new \InvalidArgumentException('non-nullable product_list_adjusts_pricing cannot be null');
        }
        $this->container['product_list_adjusts_pricing'] = $product_list_adjusts_pricing;

        return $this;
    }

    /**
     * Gets product_list_shipping_calc
     *
     * @return string|null
     */
    public function getProductListShippingCalc()
    {
        return $this->container['product_list_shipping_calc'];
    }

    /**
     * Sets product_list_shipping_calc
     *
     * @param string|null $product_list_shipping_calc (product_list, product_list_with_images) How to factor the optional product's weight and package dimensions into the shipping quote. Values: `none` - don't adjust; `weight` - use shipping weight only; `package` - use weight and dimensions.
     *
     * @return self
     */
    public function setProductListShippingCalc($product_list_shipping_calc)
    {
        if (is_null($product_list_shipping_calc)) {
            throw new \InvalidArgumentException('non-nullable product_list_shipping_calc cannot be null');
        }
        $allowedValues = $this->getProductListShippingCalcAllowableValues();
        if (!in_array($product_list_shipping_calc, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'product_list_shipping_calc', must be one of '%s'",
                    $product_list_shipping_calc,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['product_list_shipping_calc'] = $product_list_shipping_calc;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


