<?php
/**
 * ProductImage
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Model;

use \ArrayAccess;
use \Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * ProductImage Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProductImage implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Product_Image';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'product_id' => 'int',
        'image_file' => 'string',
        'url_zoom' => 'string',
        'url_standard' => 'string',
        'url_thumbnail' => 'string',
        'url_tiny' => 'string',
        'date_modified' => '\DateTime',
        'is_thumbnail' => 'bool',
        'sort_order' => 'int',
        'description' => 'string',
        'image_url' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'product_id' => null,
        'image_file' => null,
        'url_zoom' => null,
        'url_standard' => null,
        'url_thumbnail' => null,
        'url_tiny' => null,
        'date_modified' => 'date-time',
        'is_thumbnail' => null,
        'sort_order' => null,
        'description' => null,
        'image_url' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'product_id' => false,
        'image_file' => false,
        'url_zoom' => false,
        'url_standard' => false,
        'url_thumbnail' => false,
        'url_tiny' => false,
        'date_modified' => false,
        'is_thumbnail' => false,
        'sort_order' => false,
        'description' => false,
        'image_url' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'product_id' => 'product_id',
        'image_file' => 'image_file',
        'url_zoom' => 'url_zoom',
        'url_standard' => 'url_standard',
        'url_thumbnail' => 'url_thumbnail',
        'url_tiny' => 'url_tiny',
        'date_modified' => 'date_modified',
        'is_thumbnail' => 'is_thumbnail',
        'sort_order' => 'sort_order',
        'description' => 'description',
        'image_url' => 'image_url'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'product_id' => 'setProductId',
        'image_file' => 'setImageFile',
        'url_zoom' => 'setUrlZoom',
        'url_standard' => 'setUrlStandard',
        'url_thumbnail' => 'setUrlThumbnail',
        'url_tiny' => 'setUrlTiny',
        'date_modified' => 'setDateModified',
        'is_thumbnail' => 'setIsThumbnail',
        'sort_order' => 'setSortOrder',
        'description' => 'setDescription',
        'image_url' => 'setImageUrl'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'product_id' => 'getProductId',
        'image_file' => 'getImageFile',
        'url_zoom' => 'getUrlZoom',
        'url_standard' => 'getUrlStandard',
        'url_thumbnail' => 'getUrlThumbnail',
        'url_tiny' => 'getUrlTiny',
        'date_modified' => 'getDateModified',
        'is_thumbnail' => 'getIsThumbnail',
        'sort_order' => 'getSortOrder',
        'description' => 'getDescription',
        'image_url' => 'getImageUrl'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('product_id', $data ?? [], null);
        $this->setIfExists('image_file', $data ?? [], null);
        $this->setIfExists('url_zoom', $data ?? [], null);
        $this->setIfExists('url_standard', $data ?? [], null);
        $this->setIfExists('url_thumbnail', $data ?? [], null);
        $this->setIfExists('url_tiny', $data ?? [], null);
        $this->setIfExists('date_modified', $data ?? [], null);
        $this->setIfExists('is_thumbnail', $data ?? [], null);
        $this->setIfExists('sort_order', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('image_url', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['sort_order']) && ($this->container['sort_order'] > 2147483647)) {
            $invalidProperties[] = "invalid value for 'sort_order', must be smaller than or equal to 2147483647.";
        }

        if (!is_null($this->container['sort_order']) && ($this->container['sort_order'] < -2147483648)) {
            $invalidProperties[] = "invalid value for 'sort_order', must be bigger than or equal to -2147483648.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The unique numeric ID of the image; increments sequentially.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int|null $product_id The unique numeric identifier for the product with which the image is associated.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        if (is_null($product_id)) {
            throw new \InvalidArgumentException('non-nullable product_id cannot be null');
        }
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets image_file
     *
     * @return string|null
     */
    public function getImageFile()
    {
        return $this->container['image_file'];
    }

    /**
     * Sets image_file
     *
     * @param string|null $image_file The local path to the original image file uploaded to BigCommerce. Use image_url when creating a product. A `multipart/form-data` media type.
     *
     * @return self
     */
    public function setImageFile($image_file)
    {
        if (is_null($image_file)) {
            throw new \InvalidArgumentException('non-nullable image_file cannot be null');
        }
        $this->container['image_file'] = $image_file;

        return $this;
    }

    /**
     * Gets url_zoom
     *
     * @return string|null
     */
    public function getUrlZoom()
    {
        return $this->container['url_zoom'];
    }

    /**
     * Sets url_zoom
     *
     * @param string|null $url_zoom The zoom URL for this image. By default, this is used as the zoom image on product pages when zoom images are enabled.
     *
     * @return self
     */
    public function setUrlZoom($url_zoom)
    {
        if (is_null($url_zoom)) {
            throw new \InvalidArgumentException('non-nullable url_zoom cannot be null');
        }
        $this->container['url_zoom'] = $url_zoom;

        return $this;
    }

    /**
     * Gets url_standard
     *
     * @return string|null
     */
    public function getUrlStandard()
    {
        return $this->container['url_standard'];
    }

    /**
     * Sets url_standard
     *
     * @param string|null $url_standard The standard URL for this image. By default, this is used for product-page images.
     *
     * @return self
     */
    public function setUrlStandard($url_standard)
    {
        if (is_null($url_standard)) {
            throw new \InvalidArgumentException('non-nullable url_standard cannot be null');
        }
        $this->container['url_standard'] = $url_standard;

        return $this;
    }

    /**
     * Gets url_thumbnail
     *
     * @return string|null
     */
    public function getUrlThumbnail()
    {
        return $this->container['url_thumbnail'];
    }

    /**
     * Sets url_thumbnail
     *
     * @param string|null $url_thumbnail The thumbnail URL for this image. By default, this is the image size used on the category page and in side panels.
     *
     * @return self
     */
    public function setUrlThumbnail($url_thumbnail)
    {
        if (is_null($url_thumbnail)) {
            throw new \InvalidArgumentException('non-nullable url_thumbnail cannot be null');
        }
        $this->container['url_thumbnail'] = $url_thumbnail;

        return $this;
    }

    /**
     * Gets url_tiny
     *
     * @return string|null
     */
    public function getUrlTiny()
    {
        return $this->container['url_tiny'];
    }

    /**
     * Sets url_tiny
     *
     * @param string|null $url_tiny The tiny URL for this image. By default, this is the image size used for thumbnails beneath the product image on a product page.
     *
     * @return self
     */
    public function setUrlTiny($url_tiny)
    {
        if (is_null($url_tiny)) {
            throw new \InvalidArgumentException('non-nullable url_tiny cannot be null');
        }
        $this->container['url_tiny'] = $url_tiny;

        return $this;
    }

    /**
     * Gets date_modified
     *
     * @return \DateTime|null
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     *
     * @param \DateTime|null $date_modified The date on which the product image was modified.
     *
     * @return self
     */
    public function setDateModified($date_modified)
    {
        if (is_null($date_modified)) {
            throw new \InvalidArgumentException('non-nullable date_modified cannot be null');
        }
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets is_thumbnail
     *
     * @return bool|null
     */
    public function getIsThumbnail()
    {
        return $this->container['is_thumbnail'];
    }

    /**
     * Sets is_thumbnail
     *
     * @param bool|null $is_thumbnail Flag for identifying whether the image is used as the product's thumbnail.
     *
     * @return self
     */
    public function setIsThumbnail($is_thumbnail)
    {
        if (is_null($is_thumbnail)) {
            throw new \InvalidArgumentException('non-nullable is_thumbnail cannot be null');
        }
        $this->container['is_thumbnail'] = $is_thumbnail;

        return $this;
    }

    /**
     * Gets sort_order
     *
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     *
     * @param int|null $sort_order The order in which the image will be displayed on the product page. Higher integers give the image a lower priority. When updating, if the image is given a lower priority, all images with a `sort_order` the same as or greater than the image's new `sort_order` value will have their `sort_order`s reordered.
     *
     * @return self
     */
    public function setSortOrder($sort_order)
    {
        if (is_null($sort_order)) {
            throw new \InvalidArgumentException('non-nullable sort_order cannot be null');
        }

        if (($sort_order > 2147483647)) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling ProductImage., must be smaller than or equal to 2147483647.');
        }
        if (($sort_order < -2147483648)) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling ProductImage., must be bigger than or equal to -2147483648.');
        }

        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The description for the image.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url Publically available URL. Use the image_url when creating a product.
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        if (is_null($image_url)) {
            throw new \InvalidArgumentException('non-nullable image_url cannot be null');
        }
        $this->container['image_url'] = $image_url;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


