<?php
/**
 * ComplexRuleBase
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Model;

use \ArrayAccess;
use \Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * ComplexRuleBase Class Doc Comment
 *
 * @category Class
 * @description Common ComplexRule properties.
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ComplexRuleBase implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'complexRule_Base';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'product_id' => 'int',
        'sort_order' => 'int',
        'enabled' => 'bool',
        'stop' => 'bool',
        'purchasing_disabled' => 'bool',
        'purchasing_disabled_message' => 'string',
        'purchasing_hidden' => 'bool',
        'image_url' => 'string',
        'price_adjuster' => '\Bigcommerce\CatalogV3\Model\AdjusterFull',
        'weight_adjuster' => '\Bigcommerce\CatalogV3\Model\AdjusterFull',
        'conditions' => '\Bigcommerce\CatalogV3\Model\ComplexRuleConditionBase[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'product_id' => null,
        'sort_order' => null,
        'enabled' => null,
        'stop' => null,
        'purchasing_disabled' => null,
        'purchasing_disabled_message' => null,
        'purchasing_hidden' => null,
        'image_url' => null,
        'price_adjuster' => null,
        'weight_adjuster' => null,
        'conditions' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'product_id' => true,
        'sort_order' => false,
        'enabled' => false,
        'stop' => false,
        'purchasing_disabled' => false,
        'purchasing_disabled_message' => false,
        'purchasing_hidden' => false,
        'image_url' => false,
        'price_adjuster' => false,
        'weight_adjuster' => false,
        'conditions' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'product_id' => 'product_id',
        'sort_order' => 'sort_order',
        'enabled' => 'enabled',
        'stop' => 'stop',
        'purchasing_disabled' => 'purchasing_disabled',
        'purchasing_disabled_message' => 'purchasing_disabled_message',
        'purchasing_hidden' => 'purchasing_hidden',
        'image_url' => 'image_url',
        'price_adjuster' => 'price_adjuster',
        'weight_adjuster' => 'weight_adjuster',
        'conditions' => 'conditions'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'product_id' => 'setProductId',
        'sort_order' => 'setSortOrder',
        'enabled' => 'setEnabled',
        'stop' => 'setStop',
        'purchasing_disabled' => 'setPurchasingDisabled',
        'purchasing_disabled_message' => 'setPurchasingDisabledMessage',
        'purchasing_hidden' => 'setPurchasingHidden',
        'image_url' => 'setImageUrl',
        'price_adjuster' => 'setPriceAdjuster',
        'weight_adjuster' => 'setWeightAdjuster',
        'conditions' => 'setConditions'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'product_id' => 'getProductId',
        'sort_order' => 'getSortOrder',
        'enabled' => 'getEnabled',
        'stop' => 'getStop',
        'purchasing_disabled' => 'getPurchasingDisabled',
        'purchasing_disabled_message' => 'getPurchasingDisabledMessage',
        'purchasing_hidden' => 'getPurchasingHidden',
        'image_url' => 'getImageUrl',
        'price_adjuster' => 'getPriceAdjuster',
        'weight_adjuster' => 'getWeightAdjuster',
        'conditions' => 'getConditions'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('product_id', $data ?? [], null);
        $this->setIfExists('sort_order', $data ?? [], null);
        $this->setIfExists('enabled', $data ?? [], null);
        $this->setIfExists('stop', $data ?? [], null);
        $this->setIfExists('purchasing_disabled', $data ?? [], null);
        $this->setIfExists('purchasing_disabled_message', $data ?? [], null);
        $this->setIfExists('purchasing_hidden', $data ?? [], null);
        $this->setIfExists('image_url', $data ?? [], null);
        $this->setIfExists('price_adjuster', $data ?? [], null);
        $this->setIfExists('weight_adjuster', $data ?? [], null);
        $this->setIfExists('conditions', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['sort_order']) && ($this->container['sort_order'] > 2147483647)) {
            $invalidProperties[] = "invalid value for 'sort_order', must be smaller than or equal to 2147483647.";
        }

        if (!is_null($this->container['sort_order']) && ($this->container['sort_order'] < -2147483648)) {
            $invalidProperties[] = "invalid value for 'sort_order', must be bigger than or equal to -2147483648.";
        }

        if (!is_null($this->container['purchasing_disabled_message']) && (mb_strlen($this->container['purchasing_disabled_message']) > 255)) {
            $invalidProperties[] = "invalid value for 'purchasing_disabled_message', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['purchasing_disabled_message']) && (mb_strlen($this->container['purchasing_disabled_message']) < 0)) {
            $invalidProperties[] = "invalid value for 'purchasing_disabled_message', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The unique numeric ID of the rule; increments sequentially. Read-Only
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int|null $product_id The unique numeric ID of the product with which the rule is associated; increments sequentially.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        if (is_null($product_id)) {
            array_push($this->openAPINullablesSetToNull, 'product_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('product_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets sort_order
     *
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     *
     * @param int|null $sort_order The priority to give this rule when making adjustments to the product properties.
     *
     * @return self
     */
    public function setSortOrder($sort_order)
    {
        if (is_null($sort_order)) {
            throw new \InvalidArgumentException('non-nullable sort_order cannot be null');
        }

        if (($sort_order > 2147483647)) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling ComplexRuleBase., must be smaller than or equal to 2147483647.');
        }
        if (($sort_order < -2147483648)) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling ComplexRuleBase., must be bigger than or equal to -2147483648.');
        }

        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets enabled
     *
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     *
     * @param bool|null $enabled Flag for determining whether the rule is to be used when adjusting a product's price, weight, image, or availabilty.
     *
     * @return self
     */
    public function setEnabled($enabled)
    {
        if (is_null($enabled)) {
            throw new \InvalidArgumentException('non-nullable enabled cannot be null');
        }
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets stop
     *
     * @return bool|null
     */
    public function getStop()
    {
        return $this->container['stop'];
    }

    /**
     * Sets stop
     *
     * @param bool|null $stop Flag for determining whether other rules should not be applied after this rule has been applied.
     *
     * @return self
     */
    public function setStop($stop)
    {
        if (is_null($stop)) {
            throw new \InvalidArgumentException('non-nullable stop cannot be null');
        }
        $this->container['stop'] = $stop;

        return $this;
    }

    /**
     * Gets purchasing_disabled
     *
     * @return bool|null
     */
    public function getPurchasingDisabled()
    {
        return $this->container['purchasing_disabled'];
    }

    /**
     * Sets purchasing_disabled
     *
     * @param bool|null $purchasing_disabled Flag for determining whether the rule should disable purchasing of a product when the conditions are applied.
     *
     * @return self
     */
    public function setPurchasingDisabled($purchasing_disabled)
    {
        if (is_null($purchasing_disabled)) {
            throw new \InvalidArgumentException('non-nullable purchasing_disabled cannot be null');
        }
        $this->container['purchasing_disabled'] = $purchasing_disabled;

        return $this;
    }

    /**
     * Gets purchasing_disabled_message
     *
     * @return string|null
     */
    public function getPurchasingDisabledMessage()
    {
        return $this->container['purchasing_disabled_message'];
    }

    /**
     * Sets purchasing_disabled_message
     *
     * @param string|null $purchasing_disabled_message Message displayed on the storefront when a rule disables the purchasing of a product.
     *
     * @return self
     */
    public function setPurchasingDisabledMessage($purchasing_disabled_message)
    {
        if (is_null($purchasing_disabled_message)) {
            throw new \InvalidArgumentException('non-nullable purchasing_disabled_message cannot be null');
        }
        if ((mb_strlen($purchasing_disabled_message) > 255)) {
            throw new \InvalidArgumentException('invalid length for $purchasing_disabled_message when calling ComplexRuleBase., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($purchasing_disabled_message) < 0)) {
            throw new \InvalidArgumentException('invalid length for $purchasing_disabled_message when calling ComplexRuleBase., must be bigger than or equal to 0.');
        }

        $this->container['purchasing_disabled_message'] = $purchasing_disabled_message;

        return $this;
    }

    /**
     * Gets purchasing_hidden
     *
     * @return bool|null
     */
    public function getPurchasingHidden()
    {
        return $this->container['purchasing_hidden'];
    }

    /**
     * Sets purchasing_hidden
     *
     * @param bool|null $purchasing_hidden Flag for determining whether the rule should hide purchasing of a product when the conditions are applied.
     *
     * @return self
     */
    public function setPurchasingHidden($purchasing_hidden)
    {
        if (is_null($purchasing_hidden)) {
            throw new \InvalidArgumentException('non-nullable purchasing_hidden cannot be null');
        }
        $this->container['purchasing_hidden'] = $purchasing_hidden;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url The URL for an image displayed on the storefront when the conditions are applied. Limit of 8MB per file.
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        if (is_null($image_url)) {
            throw new \InvalidArgumentException('non-nullable image_url cannot be null');
        }
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets price_adjuster
     *
     * @return \Bigcommerce\CatalogV3\Model\AdjusterFull|null
     */
    public function getPriceAdjuster()
    {
        return $this->container['price_adjuster'];
    }

    /**
     * Sets price_adjuster
     *
     * @param \Bigcommerce\CatalogV3\Model\AdjusterFull|null $price_adjuster price_adjuster
     *
     * @return self
     */
    public function setPriceAdjuster($price_adjuster)
    {
        if (is_null($price_adjuster)) {
            throw new \InvalidArgumentException('non-nullable price_adjuster cannot be null');
        }
        $this->container['price_adjuster'] = $price_adjuster;

        return $this;
    }

    /**
     * Gets weight_adjuster
     *
     * @return \Bigcommerce\CatalogV3\Model\AdjusterFull|null
     */
    public function getWeightAdjuster()
    {
        return $this->container['weight_adjuster'];
    }

    /**
     * Sets weight_adjuster
     *
     * @param \Bigcommerce\CatalogV3\Model\AdjusterFull|null $weight_adjuster weight_adjuster
     *
     * @return self
     */
    public function setWeightAdjuster($weight_adjuster)
    {
        if (is_null($weight_adjuster)) {
            throw new \InvalidArgumentException('non-nullable weight_adjuster cannot be null');
        }
        $this->container['weight_adjuster'] = $weight_adjuster;

        return $this;
    }

    /**
     * Gets conditions
     *
     * @return \Bigcommerce\CatalogV3\Model\ComplexRuleConditionBase[]|null
     */
    public function getConditions()
    {
        return $this->container['conditions'];
    }

    /**
     * Sets conditions
     *
     * @param \Bigcommerce\CatalogV3\Model\ComplexRuleConditionBase[]|null $conditions conditions
     *
     * @return self
     */
    public function setConditions($conditions)
    {
        if (is_null($conditions)) {
            throw new \InvalidArgumentException('non-nullable conditions cannot be null');
        }
        $this->container['conditions'] = $conditions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


