<?php
/**
 * Category
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Model;

use \ArrayAccess;
use \Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * Category Class Doc Comment
 *
 * @category Class
 * @description Common Category object properties.
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Category implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Category';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'parent_id' => 'int',
        'name' => 'string',
        'description' => 'string',
        'views' => 'int',
        'sort_order' => 'int',
        'page_title' => 'string',
        'search_keywords' => 'string',
        'meta_keywords' => 'string[]',
        'meta_description' => 'string',
        'layout_file' => 'string',
        'is_visible' => 'bool',
        'default_product_sort' => 'string',
        'image_url' => 'string',
        'custom_url' => '\Bigcommerce\CatalogV3\Model\CustomUrlCategory'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'parent_id' => null,
        'name' => null,
        'description' => null,
        'views' => null,
        'sort_order' => null,
        'page_title' => null,
        'search_keywords' => null,
        'meta_keywords' => null,
        'meta_description' => null,
        'layout_file' => null,
        'is_visible' => null,
        'default_product_sort' => null,
        'image_url' => null,
        'custom_url' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'parent_id' => false,
        'name' => false,
        'description' => false,
        'views' => false,
        'sort_order' => false,
        'page_title' => false,
        'search_keywords' => false,
        'meta_keywords' => false,
        'meta_description' => false,
        'layout_file' => false,
        'is_visible' => false,
        'default_product_sort' => false,
        'image_url' => false,
        'custom_url' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'parent_id' => 'parent_id',
        'name' => 'name',
        'description' => 'description',
        'views' => 'views',
        'sort_order' => 'sort_order',
        'page_title' => 'page_title',
        'search_keywords' => 'search_keywords',
        'meta_keywords' => 'meta_keywords',
        'meta_description' => 'meta_description',
        'layout_file' => 'layout_file',
        'is_visible' => 'is_visible',
        'default_product_sort' => 'default_product_sort',
        'image_url' => 'image_url',
        'custom_url' => 'custom_url'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'parent_id' => 'setParentId',
        'name' => 'setName',
        'description' => 'setDescription',
        'views' => 'setViews',
        'sort_order' => 'setSortOrder',
        'page_title' => 'setPageTitle',
        'search_keywords' => 'setSearchKeywords',
        'meta_keywords' => 'setMetaKeywords',
        'meta_description' => 'setMetaDescription',
        'layout_file' => 'setLayoutFile',
        'is_visible' => 'setIsVisible',
        'default_product_sort' => 'setDefaultProductSort',
        'image_url' => 'setImageUrl',
        'custom_url' => 'setCustomUrl'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'parent_id' => 'getParentId',
        'name' => 'getName',
        'description' => 'getDescription',
        'views' => 'getViews',
        'sort_order' => 'getSortOrder',
        'page_title' => 'getPageTitle',
        'search_keywords' => 'getSearchKeywords',
        'meta_keywords' => 'getMetaKeywords',
        'meta_description' => 'getMetaDescription',
        'layout_file' => 'getLayoutFile',
        'is_visible' => 'getIsVisible',
        'default_product_sort' => 'getDefaultProductSort',
        'image_url' => 'getImageUrl',
        'custom_url' => 'getCustomUrl'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DEFAULT_PRODUCT_SORT_USE_STORE_SETTINGS = 'use_store_settings';
    public const DEFAULT_PRODUCT_SORT_FEATURED = 'featured';
    public const DEFAULT_PRODUCT_SORT_NEWEST = 'newest';
    public const DEFAULT_PRODUCT_SORT_BEST_SELLING = 'best_selling';
    public const DEFAULT_PRODUCT_SORT_ALPHA_ASC = 'alpha_asc';
    public const DEFAULT_PRODUCT_SORT_ALPHA_DESC = 'alpha_desc';
    public const DEFAULT_PRODUCT_SORT_AVG_CUSTOMER_REVIEW = 'avg_customer_review';
    public const DEFAULT_PRODUCT_SORT_PRICE_ASC = 'price_asc';
    public const DEFAULT_PRODUCT_SORT_PRICE_DESC = 'price_desc';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDefaultProductSortAllowableValues()
    {
        return [
            self::DEFAULT_PRODUCT_SORT_USE_STORE_SETTINGS,
            self::DEFAULT_PRODUCT_SORT_FEATURED,
            self::DEFAULT_PRODUCT_SORT_NEWEST,
            self::DEFAULT_PRODUCT_SORT_BEST_SELLING,
            self::DEFAULT_PRODUCT_SORT_ALPHA_ASC,
            self::DEFAULT_PRODUCT_SORT_ALPHA_DESC,
            self::DEFAULT_PRODUCT_SORT_AVG_CUSTOMER_REVIEW,
            self::DEFAULT_PRODUCT_SORT_PRICE_ASC,
            self::DEFAULT_PRODUCT_SORT_PRICE_DESC,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('parent_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('views', $data ?? [], null);
        $this->setIfExists('sort_order', $data ?? [], null);
        $this->setIfExists('page_title', $data ?? [], null);
        $this->setIfExists('search_keywords', $data ?? [], null);
        $this->setIfExists('meta_keywords', $data ?? [], null);
        $this->setIfExists('meta_description', $data ?? [], null);
        $this->setIfExists('layout_file', $data ?? [], null);
        $this->setIfExists('is_visible', $data ?? [], null);
        $this->setIfExists('default_product_sort', $data ?? [], null);
        $this->setIfExists('image_url', $data ?? [], null);
        $this->setIfExists('custom_url', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['parent_id'] === null) {
            $invalidProperties[] = "'parent_id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ((mb_strlen($this->container['name']) > 50)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['name']) < 1)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['sort_order']) && ($this->container['sort_order'] > 2147483647)) {
            $invalidProperties[] = "invalid value for 'sort_order', must be smaller than or equal to 2147483647.";
        }

        if (!is_null($this->container['sort_order']) && ($this->container['sort_order'] < -2147483648)) {
            $invalidProperties[] = "invalid value for 'sort_order', must be bigger than or equal to -2147483648.";
        }

        if (!is_null($this->container['page_title']) && (mb_strlen($this->container['page_title']) > 255)) {
            $invalidProperties[] = "invalid value for 'page_title', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['page_title']) && (mb_strlen($this->container['page_title']) < 0)) {
            $invalidProperties[] = "invalid value for 'page_title', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['search_keywords']) && (mb_strlen($this->container['search_keywords']) > 255)) {
            $invalidProperties[] = "invalid value for 'search_keywords', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['search_keywords']) && (mb_strlen($this->container['search_keywords']) < 0)) {
            $invalidProperties[] = "invalid value for 'search_keywords', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['meta_description']) && (mb_strlen($this->container['meta_description']) > 65535)) {
            $invalidProperties[] = "invalid value for 'meta_description', the character length must be smaller than or equal to 65535.";
        }

        if (!is_null($this->container['meta_description']) && (mb_strlen($this->container['meta_description']) < 0)) {
            $invalidProperties[] = "invalid value for 'meta_description', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['layout_file']) && (mb_strlen($this->container['layout_file']) > 500)) {
            $invalidProperties[] = "invalid value for 'layout_file', the character length must be smaller than or equal to 500.";
        }

        if (!is_null($this->container['layout_file']) && (mb_strlen($this->container['layout_file']) < 0)) {
            $invalidProperties[] = "invalid value for 'layout_file', the character length must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getDefaultProductSortAllowableValues();
        if (!is_null($this->container['default_product_sort']) && !in_array($this->container['default_product_sort'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'default_product_sort', must be one of '%s'",
                $this->container['default_product_sort'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Unique ID of the *Category*. Increments sequentially. Read-Only.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return int
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param int $parent_id The unique numeric ID of the category's parent. This field controls where the category sits in the tree of categories that organize the catalog. Required in a POST if creating a child category.
     *
     * @return self
     */
    public function setParentId($parent_id)
    {
        if (is_null($parent_id)) {
            throw new \InvalidArgumentException('non-nullable parent_id cannot be null');
        }
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name displayed for the category. Name is unique with respect to the category's siblings. Required in a POST.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        if ((mb_strlen($name) > 50)) {
            throw new \InvalidArgumentException('invalid length for $name when calling Category., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($name) < 1)) {
            throw new \InvalidArgumentException('invalid length for $name when calling Category., must be bigger than or equal to 1.');
        }

        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The product description, which can include HTML formatting.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets views
     *
     * @return int|null
     */
    public function getViews()
    {
        return $this->container['views'];
    }

    /**
     * Sets views
     *
     * @param int|null $views Number of views the category has on the storefront.
     *
     * @return self
     */
    public function setViews($views)
    {
        if (is_null($views)) {
            throw new \InvalidArgumentException('non-nullable views cannot be null');
        }
        $this->container['views'] = $views;

        return $this;
    }

    /**
     * Gets sort_order
     *
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     *
     * @param int|null $sort_order Priority this category will be given when included in the menu and category pages. The lower the number, the closer to the top of the results the category will be.
     *
     * @return self
     */
    public function setSortOrder($sort_order)
    {
        if (is_null($sort_order)) {
            throw new \InvalidArgumentException('non-nullable sort_order cannot be null');
        }

        if (($sort_order > 2147483647)) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling Category., must be smaller than or equal to 2147483647.');
        }
        if (($sort_order < -2147483648)) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling Category., must be bigger than or equal to -2147483648.');
        }

        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets page_title
     *
     * @return string|null
     */
    public function getPageTitle()
    {
        return $this->container['page_title'];
    }

    /**
     * Sets page_title
     *
     * @param string|null $page_title Custom title for the category page. If not defined, the category name will be used as the meta title.
     *
     * @return self
     */
    public function setPageTitle($page_title)
    {
        if (is_null($page_title)) {
            throw new \InvalidArgumentException('non-nullable page_title cannot be null');
        }
        if ((mb_strlen($page_title) > 255)) {
            throw new \InvalidArgumentException('invalid length for $page_title when calling Category., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($page_title) < 0)) {
            throw new \InvalidArgumentException('invalid length for $page_title when calling Category., must be bigger than or equal to 0.');
        }

        $this->container['page_title'] = $page_title;

        return $this;
    }

    /**
     * Gets search_keywords
     *
     * @return string|null
     */
    public function getSearchKeywords()
    {
        return $this->container['search_keywords'];
    }

    /**
     * Sets search_keywords
     *
     * @param string|null $search_keywords A comma-separated list of keywords that can be used to locate the category when searching the store.
     *
     * @return self
     */
    public function setSearchKeywords($search_keywords)
    {
        if (is_null($search_keywords)) {
            throw new \InvalidArgumentException('non-nullable search_keywords cannot be null');
        }
        if ((mb_strlen($search_keywords) > 255)) {
            throw new \InvalidArgumentException('invalid length for $search_keywords when calling Category., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($search_keywords) < 0)) {
            throw new \InvalidArgumentException('invalid length for $search_keywords when calling Category., must be bigger than or equal to 0.');
        }

        $this->container['search_keywords'] = $search_keywords;

        return $this;
    }

    /**
     * Gets meta_keywords
     *
     * @return string[]|null
     */
    public function getMetaKeywords()
    {
        return $this->container['meta_keywords'];
    }

    /**
     * Sets meta_keywords
     *
     * @param string[]|null $meta_keywords Custom meta keywords for the category page. If not defined, the store's default keywords will be used. Must post as an array like: [\"awesome\",\"sauce\"].
     *
     * @return self
     */
    public function setMetaKeywords($meta_keywords)
    {
        if (is_null($meta_keywords)) {
            throw new \InvalidArgumentException('non-nullable meta_keywords cannot be null');
        }
        $this->container['meta_keywords'] = $meta_keywords;

        return $this;
    }

    /**
     * Gets meta_description
     *
     * @return string|null
     */
    public function getMetaDescription()
    {
        return $this->container['meta_description'];
    }

    /**
     * Sets meta_description
     *
     * @param string|null $meta_description Custom meta description for the category page. If not defined, the store's default meta description will be used.
     *
     * @return self
     */
    public function setMetaDescription($meta_description)
    {
        if (is_null($meta_description)) {
            throw new \InvalidArgumentException('non-nullable meta_description cannot be null');
        }
        if ((mb_strlen($meta_description) > 65535)) {
            throw new \InvalidArgumentException('invalid length for $meta_description when calling Category., must be smaller than or equal to 65535.');
        }
        if ((mb_strlen($meta_description) < 0)) {
            throw new \InvalidArgumentException('invalid length for $meta_description when calling Category., must be bigger than or equal to 0.');
        }

        $this->container['meta_description'] = $meta_description;

        return $this;
    }

    /**
     * Gets layout_file
     *
     * @return string|null
     */
    public function getLayoutFile()
    {
        return $this->container['layout_file'];
    }

    /**
     * Sets layout_file
     *
     * @param string|null $layout_file A valid layout file. (Please refer to [this article](https://support.bigcommerce.com/articles/Public/Creating-Custom-Template-Files/) on creating category files.) This field is writable only for stores with a Blueprint theme applied.
     *
     * @return self
     */
    public function setLayoutFile($layout_file)
    {
        if (is_null($layout_file)) {
            throw new \InvalidArgumentException('non-nullable layout_file cannot be null');
        }
        if ((mb_strlen($layout_file) > 500)) {
            throw new \InvalidArgumentException('invalid length for $layout_file when calling Category., must be smaller than or equal to 500.');
        }
        if ((mb_strlen($layout_file) < 0)) {
            throw new \InvalidArgumentException('invalid length for $layout_file when calling Category., must be bigger than or equal to 0.');
        }

        $this->container['layout_file'] = $layout_file;

        return $this;
    }

    /**
     * Gets is_visible
     *
     * @return bool|null
     */
    public function getIsVisible()
    {
        return $this->container['is_visible'];
    }

    /**
     * Sets is_visible
     *
     * @param bool|null $is_visible Flag to determine whether the product should be displayed to customers browsing the store. If `true`, the category will be displayed. If `false`, the category will be hidden from view.
     *
     * @return self
     */
    public function setIsVisible($is_visible)
    {
        if (is_null($is_visible)) {
            throw new \InvalidArgumentException('non-nullable is_visible cannot be null');
        }
        $this->container['is_visible'] = $is_visible;

        return $this;
    }

    /**
     * Gets default_product_sort
     *
     * @return string|null
     */
    public function getDefaultProductSort()
    {
        return $this->container['default_product_sort'];
    }

    /**
     * Sets default_product_sort
     *
     * @param string|null $default_product_sort Determines how the products are sorted on category page load.
     *
     * @return self
     */
    public function setDefaultProductSort($default_product_sort)
    {
        if (is_null($default_product_sort)) {
            throw new \InvalidArgumentException('non-nullable default_product_sort cannot be null');
        }
        $allowedValues = $this->getDefaultProductSortAllowableValues();
        if (!in_array($default_product_sort, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'default_product_sort', must be one of '%s'",
                    $default_product_sort,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['default_product_sort'] = $default_product_sort;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url Image URL used for this category on the storefront. Images can be uploaded via form file post to `/categories/{categoryId}/image`, or by providing a publicly accessible URL in this field.
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        if (is_null($image_url)) {
            throw new \InvalidArgumentException('non-nullable image_url cannot be null');
        }
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets custom_url
     *
     * @return \Bigcommerce\CatalogV3\Model\CustomUrlCategory|null
     */
    public function getCustomUrl()
    {
        return $this->container['custom_url'];
    }

    /**
     * Sets custom_url
     *
     * @param \Bigcommerce\CatalogV3\Model\CustomUrlCategory|null $custom_url custom_url
     *
     * @return self
     */
    public function setCustomUrl($custom_url)
    {
        if (is_null($custom_url)) {
            throw new \InvalidArgumentException('non-nullable custom_url cannot be null');
        }
        $this->container['custom_url'] = $custom_url;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


