<?php
/**
 * CatalogSummary
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Model;

use \ArrayAccess;
use \Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * CatalogSummary Class Doc Comment
 *
 * @category Class
 * @description Catalog Summary object describes a lightweight summary of the catalog.
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CatalogSummary implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Catalog_Summary';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'inventory_count' => 'int',
        'inventory_value' => 'float',
        'primary_category_id' => 'int',
        'primary_category_name' => 'string',
        'variant_count' => 'int',
        'highest_variant_price' => 'float',
        'average_variant_price' => 'float',
        'lowest_variant_price' => 'string',
        'oldest_variant_date' => 'string',
        'newest_variant_date' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'inventory_count' => null,
        'inventory_value' => 'double',
        'primary_category_id' => null,
        'primary_category_name' => null,
        'variant_count' => null,
        'highest_variant_price' => 'double',
        'average_variant_price' => 'double',
        'lowest_variant_price' => null,
        'oldest_variant_date' => null,
        'newest_variant_date' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'inventory_count' => false,
        'inventory_value' => false,
        'primary_category_id' => false,
        'primary_category_name' => false,
        'variant_count' => false,
        'highest_variant_price' => false,
        'average_variant_price' => false,
        'lowest_variant_price' => false,
        'oldest_variant_date' => false,
        'newest_variant_date' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'inventory_count' => 'inventory_count',
        'inventory_value' => 'inventory_value',
        'primary_category_id' => 'primary_category_id',
        'primary_category_name' => 'primary_category_name',
        'variant_count' => 'variant_count',
        'highest_variant_price' => 'highest_variant_price',
        'average_variant_price' => 'average_variant_price',
        'lowest_variant_price' => 'lowest_variant_price',
        'oldest_variant_date' => 'oldest_variant_date',
        'newest_variant_date' => 'newest_variant_date'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'inventory_count' => 'setInventoryCount',
        'inventory_value' => 'setInventoryValue',
        'primary_category_id' => 'setPrimaryCategoryId',
        'primary_category_name' => 'setPrimaryCategoryName',
        'variant_count' => 'setVariantCount',
        'highest_variant_price' => 'setHighestVariantPrice',
        'average_variant_price' => 'setAverageVariantPrice',
        'lowest_variant_price' => 'setLowestVariantPrice',
        'oldest_variant_date' => 'setOldestVariantDate',
        'newest_variant_date' => 'setNewestVariantDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'inventory_count' => 'getInventoryCount',
        'inventory_value' => 'getInventoryValue',
        'primary_category_id' => 'getPrimaryCategoryId',
        'primary_category_name' => 'getPrimaryCategoryName',
        'variant_count' => 'getVariantCount',
        'highest_variant_price' => 'getHighestVariantPrice',
        'average_variant_price' => 'getAverageVariantPrice',
        'lowest_variant_price' => 'getLowestVariantPrice',
        'oldest_variant_date' => 'getOldestVariantDate',
        'newest_variant_date' => 'getNewestVariantDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('inventory_count', $data ?? [], null);
        $this->setIfExists('inventory_value', $data ?? [], null);
        $this->setIfExists('primary_category_id', $data ?? [], null);
        $this->setIfExists('primary_category_name', $data ?? [], null);
        $this->setIfExists('variant_count', $data ?? [], null);
        $this->setIfExists('highest_variant_price', $data ?? [], null);
        $this->setIfExists('average_variant_price', $data ?? [], null);
        $this->setIfExists('lowest_variant_price', $data ?? [], null);
        $this->setIfExists('oldest_variant_date', $data ?? [], null);
        $this->setIfExists('newest_variant_date', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets inventory_count
     *
     * @return int|null
     */
    public function getInventoryCount()
    {
        return $this->container['inventory_count'];
    }

    /**
     * Sets inventory_count
     *
     * @param int|null $inventory_count A count of all inventory items in the catalog.
     *
     * @return self
     */
    public function setInventoryCount($inventory_count)
    {
        if (is_null($inventory_count)) {
            throw new \InvalidArgumentException('non-nullable inventory_count cannot be null');
        }
        $this->container['inventory_count'] = $inventory_count;

        return $this;
    }

    /**
     * Gets inventory_value
     *
     * @return float|null
     */
    public function getInventoryValue()
    {
        return $this->container['inventory_value'];
    }

    /**
     * Sets inventory_value
     *
     * @param float|null $inventory_value Total value of store's inventory.
     *
     * @return self
     */
    public function setInventoryValue($inventory_value)
    {
        if (is_null($inventory_value)) {
            throw new \InvalidArgumentException('non-nullable inventory_value cannot be null');
        }
        $this->container['inventory_value'] = $inventory_value;

        return $this;
    }

    /**
     * Gets primary_category_id
     *
     * @return int|null
     */
    public function getPrimaryCategoryId()
    {
        return $this->container['primary_category_id'];
    }

    /**
     * Sets primary_category_id
     *
     * @param int|null $primary_category_id ID of the category containing the most products.
     *
     * @return self
     */
    public function setPrimaryCategoryId($primary_category_id)
    {
        if (is_null($primary_category_id)) {
            throw new \InvalidArgumentException('non-nullable primary_category_id cannot be null');
        }
        $this->container['primary_category_id'] = $primary_category_id;

        return $this;
    }

    /**
     * Gets primary_category_name
     *
     * @return string|null
     */
    public function getPrimaryCategoryName()
    {
        return $this->container['primary_category_name'];
    }

    /**
     * Sets primary_category_name
     *
     * @param string|null $primary_category_name Name of the category containing the most products.
     *
     * @return self
     */
    public function setPrimaryCategoryName($primary_category_name)
    {
        if (is_null($primary_category_name)) {
            throw new \InvalidArgumentException('non-nullable primary_category_name cannot be null');
        }
        $this->container['primary_category_name'] = $primary_category_name;

        return $this;
    }

    /**
     * Gets variant_count
     *
     * @return int|null
     */
    public function getVariantCount()
    {
        return $this->container['variant_count'];
    }

    /**
     * Sets variant_count
     *
     * @param int|null $variant_count Total number of variants
     *
     * @return self
     */
    public function setVariantCount($variant_count)
    {
        if (is_null($variant_count)) {
            throw new \InvalidArgumentException('non-nullable variant_count cannot be null');
        }
        $this->container['variant_count'] = $variant_count;

        return $this;
    }

    /**
     * Gets highest_variant_price
     *
     * @return float|null
     */
    public function getHighestVariantPrice()
    {
        return $this->container['highest_variant_price'];
    }

    /**
     * Sets highest_variant_price
     *
     * @param float|null $highest_variant_price Highest priced variant
     *
     * @return self
     */
    public function setHighestVariantPrice($highest_variant_price)
    {
        if (is_null($highest_variant_price)) {
            throw new \InvalidArgumentException('non-nullable highest_variant_price cannot be null');
        }
        $this->container['highest_variant_price'] = $highest_variant_price;

        return $this;
    }

    /**
     * Gets average_variant_price
     *
     * @return float|null
     */
    public function getAverageVariantPrice()
    {
        return $this->container['average_variant_price'];
    }

    /**
     * Sets average_variant_price
     *
     * @param float|null $average_variant_price Average price of all variants
     *
     * @return self
     */
    public function setAverageVariantPrice($average_variant_price)
    {
        if (is_null($average_variant_price)) {
            throw new \InvalidArgumentException('non-nullable average_variant_price cannot be null');
        }
        $this->container['average_variant_price'] = $average_variant_price;

        return $this;
    }

    /**
     * Gets lowest_variant_price
     *
     * @return string|null
     */
    public function getLowestVariantPrice()
    {
        return $this->container['lowest_variant_price'];
    }

    /**
     * Sets lowest_variant_price
     *
     * @param string|null $lowest_variant_price Lowest priced variant in the store
     *
     * @return self
     */
    public function setLowestVariantPrice($lowest_variant_price)
    {
        if (is_null($lowest_variant_price)) {
            throw new \InvalidArgumentException('non-nullable lowest_variant_price cannot be null');
        }
        $this->container['lowest_variant_price'] = $lowest_variant_price;

        return $this;
    }

    /**
     * Gets oldest_variant_date
     *
     * @return string|null
     */
    public function getOldestVariantDate()
    {
        return $this->container['oldest_variant_date'];
    }

    /**
     * Sets oldest_variant_date
     *
     * @param string|null $oldest_variant_date oldest_variant_date
     *
     * @return self
     */
    public function setOldestVariantDate($oldest_variant_date)
    {
        if (is_null($oldest_variant_date)) {
            throw new \InvalidArgumentException('non-nullable oldest_variant_date cannot be null');
        }
        $this->container['oldest_variant_date'] = $oldest_variant_date;

        return $this;
    }

    /**
     * Gets newest_variant_date
     *
     * @return string|null
     */
    public function getNewestVariantDate()
    {
        return $this->container['newest_variant_date'];
    }

    /**
     * Sets newest_variant_date
     *
     * @param string|null $newest_variant_date newest_variant_date
     *
     * @return self
     */
    public function setNewestVariantDate($newest_variant_date)
    {
        if (is_null($newest_variant_date)) {
            throw new \InvalidArgumentException('non-nullable newest_variant_date cannot be null');
        }
        $this->container['newest_variant_date'] = $newest_variant_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


