<?php
/**
 * ProductsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CatalogV3\ApiException;
use Bigcommerce\CatalogV3\Configuration;
use Bigcommerce\CatalogV3\FormDataProcessor;
use Bigcommerce\CatalogV3\HeaderSelector;
use Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * ProductsApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createProduct' => [
            'application/json',
        ],
        'deleteProductById' => [
            'application/json',
        ],
        'deleteProducts' => [
            'application/json',
        ],
        'getProductById' => [
            'application/json',
        ],
        'getProducts' => [
            'application/json',
        ],
        'updateProduct' => [
            'application/json',
        ],
        'updateProducts' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createProduct
     *
     * Create a Product
     *
     * @param  \Bigcommerce\CatalogV3\Model\ProductPost $product product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\ProductResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse
     */
    public function createProduct($product, $include_fields = null, string $contentType = self::contentTypes['createProduct'][0])
    {
        list($response) = $this->createProductWithHttpInfo($product, $include_fields, $contentType);
        return $response;
    }

    /**
     * Operation createProductWithHttpInfo
     *
     * Create a Product
     *
     * @param  \Bigcommerce\CatalogV3\Model\ProductPost $product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\ProductResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProductWithHttpInfo($product, $include_fields = null, string $contentType = self::contentTypes['createProduct'][0])
    {
        $request = $this->createProductRequest($product, $include_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ProductResponse',
                        $request,
                        $response,
                    );
                case 409:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\ProductResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ProductResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createProductAsync
     *
     * Create a Product
     *
     * @param  \Bigcommerce\CatalogV3\Model\ProductPost $product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createProductAsync($product, $include_fields = null, string $contentType = self::contentTypes['createProduct'][0])
    {
        return $this->createProductAsyncWithHttpInfo($product, $include_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createProductAsyncWithHttpInfo
     *
     * Create a Product
     *
     * @param  \Bigcommerce\CatalogV3\Model\ProductPost $product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createProductAsyncWithHttpInfo($product, $include_fields = null, string $contentType = self::contentTypes['createProduct'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\ProductResponse';
        $request = $this->createProductRequest($product, $include_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createProduct'
     *
     * @param  \Bigcommerce\CatalogV3\Model\ProductPost $product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createProductRequest($product, $include_fields = null, string $contentType = self::contentTypes['createProduct'][0])
    {

        // verify the required parameter 'product' is set
        if ($product === null || (is_array($product) && count($product) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product when calling createProduct'
            );
        }



        $resourcePath = '/catalog/products';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product));
            } else {
                $httpBody = $product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteProductById
     *
     * Delete a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteProductById($product_id, string $contentType = self::contentTypes['deleteProductById'][0])
    {
        $this->deleteProductByIdWithHttpInfo($product_id, $contentType);
    }

    /**
     * Operation deleteProductByIdWithHttpInfo
     *
     * Delete a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductByIdWithHttpInfo($product_id, string $contentType = self::contentTypes['deleteProductById'][0])
    {
        $request = $this->deleteProductByIdRequest($product_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteProductByIdAsync
     *
     * Delete a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductByIdAsync($product_id, string $contentType = self::contentTypes['deleteProductById'][0])
    {
        return $this->deleteProductByIdAsyncWithHttpInfo($product_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteProductByIdAsyncWithHttpInfo
     *
     * Delete a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductByIdAsyncWithHttpInfo($product_id, string $contentType = self::contentTypes['deleteProductById'][0])
    {
        $returnType = '';
        $request = $this->deleteProductByIdRequest($product_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteProductById'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteProductByIdRequest($product_id, string $contentType = self::contentTypes['deleteProductById'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling deleteProductById'
            );
        }


        $resourcePath = '/catalog/products/{product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteProducts
     *
     * Delete Products
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. For example &#x60;v3/catalog/products?date_modified:min&#x3D;2018-06-15&#x60; (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. For example &#x60;v3/catalog/products?date_last_imported:min&#x3D;2018-06-15&#x60; (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type: &#x60;physical&#x60; or &#x60;digital&#x60;. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteProducts($name = null, $sku = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_last_imported = null, $is_visible = null, $is_featured = null, $inventory_level = null, $total_sold = null, $type = null, $categories = null, $keyword = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {
        $this->deleteProductsWithHttpInfo($name, $sku, $price, $weight, $condition, $brand_id, $date_modified, $date_last_imported, $is_visible, $is_featured, $inventory_level, $total_sold, $type, $categories, $keyword, $contentType);
    }

    /**
     * Operation deleteProductsWithHttpInfo
     *
     * Delete Products
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. For example &#x60;v3/catalog/products?date_modified:min&#x3D;2018-06-15&#x60; (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. For example &#x60;v3/catalog/products?date_last_imported:min&#x3D;2018-06-15&#x60; (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type: &#x60;physical&#x60; or &#x60;digital&#x60;. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductsWithHttpInfo($name = null, $sku = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_last_imported = null, $is_visible = null, $is_featured = null, $inventory_level = null, $total_sold = null, $type = null, $categories = null, $keyword = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {
        $request = $this->deleteProductsRequest($name, $sku, $price, $weight, $condition, $brand_id, $date_modified, $date_last_imported, $is_visible, $is_featured, $inventory_level, $total_sold, $type, $categories, $keyword, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteProductsAsync
     *
     * Delete Products
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. For example &#x60;v3/catalog/products?date_modified:min&#x3D;2018-06-15&#x60; (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. For example &#x60;v3/catalog/products?date_last_imported:min&#x3D;2018-06-15&#x60; (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type: &#x60;physical&#x60; or &#x60;digital&#x60;. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductsAsync($name = null, $sku = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_last_imported = null, $is_visible = null, $is_featured = null, $inventory_level = null, $total_sold = null, $type = null, $categories = null, $keyword = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {
        return $this->deleteProductsAsyncWithHttpInfo($name, $sku, $price, $weight, $condition, $brand_id, $date_modified, $date_last_imported, $is_visible, $is_featured, $inventory_level, $total_sold, $type, $categories, $keyword, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteProductsAsyncWithHttpInfo
     *
     * Delete Products
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. For example &#x60;v3/catalog/products?date_modified:min&#x3D;2018-06-15&#x60; (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. For example &#x60;v3/catalog/products?date_last_imported:min&#x3D;2018-06-15&#x60; (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type: &#x60;physical&#x60; or &#x60;digital&#x60;. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductsAsyncWithHttpInfo($name = null, $sku = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_last_imported = null, $is_visible = null, $is_featured = null, $inventory_level = null, $total_sold = null, $type = null, $categories = null, $keyword = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {
        $returnType = '';
        $request = $this->deleteProductsRequest($name, $sku, $price, $weight, $condition, $brand_id, $date_modified, $date_last_imported, $is_visible, $is_featured, $inventory_level, $total_sold, $type, $categories, $keyword, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteProducts'
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. For example &#x60;v3/catalog/products?date_modified:min&#x3D;2018-06-15&#x60; (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. For example &#x60;v3/catalog/products?date_last_imported:min&#x3D;2018-06-15&#x60; (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type: &#x60;physical&#x60; or &#x60;digital&#x60;. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteProductsRequest($name = null, $sku = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_last_imported = null, $is_visible = null, $is_featured = null, $inventory_level = null, $total_sold = null, $type = null, $categories = null, $keyword = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {

















        $resourcePath = '/catalog/products';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'sku', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $price,
            'price', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $weight,
            'weight', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $condition,
            'condition', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $brand_id,
            'brand_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified,
            'date_modified', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_last_imported,
            'date_last_imported', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_visible,
            'is_visible', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_featured,
            'is_featured', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_level,
            'inventory_level', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $total_sold,
            'total_sold', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $type,
            'type', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $categories,
            'categories', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $keyword,
            'keyword', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProductById
     *
     * Get a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $price_list_id Filter by price_list_id. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\ProductResponse|\Bigcommerce\CatalogV3\Model\NotFound
     */
    public function getProductById($product_id, $include = null, $include_fields = null, $exclude_fields = null, $price_list_id = null, string $contentType = self::contentTypes['getProductById'][0])
    {
        list($response) = $this->getProductByIdWithHttpInfo($product_id, $include, $include_fields, $exclude_fields, $price_list_id, $contentType);
        return $response;
    }

    /**
     * Operation getProductByIdWithHttpInfo
     *
     * Get a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $price_list_id Filter by price_list_id. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\ProductResponse|\Bigcommerce\CatalogV3\Model\NotFound, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductByIdWithHttpInfo($product_id, $include = null, $include_fields = null, $exclude_fields = null, $price_list_id = null, string $contentType = self::contentTypes['getProductById'][0])
    {
        $request = $this->getProductByIdRequest($product_id, $include, $include_fields, $exclude_fields, $price_list_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ProductResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\ProductResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ProductResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getProductByIdAsync
     *
     * Get a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $price_list_id Filter by price_list_id. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductByIdAsync($product_id, $include = null, $include_fields = null, $exclude_fields = null, $price_list_id = null, string $contentType = self::contentTypes['getProductById'][0])
    {
        return $this->getProductByIdAsyncWithHttpInfo($product_id, $include, $include_fields, $exclude_fields, $price_list_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProductByIdAsyncWithHttpInfo
     *
     * Get a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $price_list_id Filter by price_list_id. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductByIdAsyncWithHttpInfo($product_id, $include = null, $include_fields = null, $exclude_fields = null, $price_list_id = null, string $contentType = self::contentTypes['getProductById'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\ProductResponse';
        $request = $this->getProductByIdRequest($product_id, $include, $include_fields, $exclude_fields, $price_list_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProductById'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $price_list_id Filter by price_list_id. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProductByIdRequest($product_id, $include = null, $include_fields = null, $exclude_fields = null, $price_list_id = null, string $contentType = self::contentTypes['getProductById'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling getProductById'
            );
        }






        $resourcePath = '/catalog/products/{product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include,
            'include', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $price_list_id,
            'price_list_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProducts
     *
     * Get All Products
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in id_in (optional)
     * @param  int[]|null $id_not_in id_not_in (optional)
     * @param  int[]|null $id_min id_min (optional)
     * @param  int[]|null $id_max id_max (optional)
     * @param  int[]|null $id_greater id_greater (optional)
     * @param  int[]|null $id_less id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  string|null $upc Filter items by upc. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  string|null $date_modified_max Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_modified_min Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. (optional)
     * @param  string|null $date_last_imported_max Filter items by date_last_imported. For example, &#x60;date_last_imported:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_last_imported_min Filter items by date_last_imported. For example, &#x60;date_last_imported:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  bool|null $is_visible Filter items based on whether the product is currently visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. &#x60;0&#x60; for true, &#x60;1&#x60; for false. (optional)
     * @param  int|null $is_free_shipping Filter items by is_free_shipping. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $inventory_level_in inventory_level_in (optional)
     * @param  int|null $inventory_level_not_in inventory_level_not_in (optional)
     * @param  int|null $inventory_level_min inventory_level_min (optional)
     * @param  int|null $inventory_level_max inventory_level_max (optional)
     * @param  int|null $inventory_level_greater inventory_level_greater (optional)
     * @param  int|null $inventory_level_less inventory_level_less (optional)
     * @param  int|null $inventory_low Filter items by inventory_low. Values: 1, 0. (optional)
     * @param  int|null $out_of_stock Filter items by out_of_stock. To enable the filter, pass &#x60;out_of_stock&#x60;&#x3D;&#x60;1&#x60;. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string|null $keyword_context Set context used by the search algorithm to return results targeted towards the specified group. Use &#x60;merchant&#x60; to help merchants search their own catalog. Use &#x60;shopper&#x60; to return shopper-facing search results. (optional)
     * @param  int|null $status Filter items by status. (optional)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string|null $availability Filter items by availability. Values are: available, disabled, preorder. (optional)
     * @param  int|null $price_list_id This filter returns the product pricing with the *Price List* pricing instead. To use:&#x60;?price_list_id&#x3D;1&#x60;.If there are variants use:&#x60;?price_list_id&#x3D;1&amp;include&#x3D;variants&#x60;. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $direction Sort direction. Acceptable values are: &#x60;asc&#x60;, &#x60;desc&#x60;. (optional)
     * @param  string|null $sort Field name to sort by. Note: Since &#x60;id&#x60; increments when new products are added, you can use that field to sort by product create date. (optional)
     * @param  int|null $categories_in Filter items by categories. Use for products in multiple categories. For example, &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProducts'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\GetProducts200Response
     */
    public function getProducts($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $sku = null, $upc = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, $date_last_imported = null, $date_last_imported_max = null, $date_last_imported_min = null, $is_visible = null, $is_featured = null, $is_free_shipping = null, $inventory_level = null, $inventory_level_in = null, $inventory_level_not_in = null, $inventory_level_min = null, $inventory_level_max = null, $inventory_level_greater = null, $inventory_level_less = null, $inventory_low = null, $out_of_stock = null, $total_sold = null, $type = null, $categories = null, $keyword = null, $keyword_context = null, $status = null, $include = null, $include_fields = null, $exclude_fields = null, $availability = null, $price_list_id = null, $page = null, $limit = null, $direction = null, $sort = null, $categories_in = null, string $contentType = self::contentTypes['getProducts'][0])
    {
        list($response) = $this->getProductsWithHttpInfo($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $sku, $upc, $price, $weight, $condition, $brand_id, $date_modified, $date_modified_max, $date_modified_min, $date_last_imported, $date_last_imported_max, $date_last_imported_min, $is_visible, $is_featured, $is_free_shipping, $inventory_level, $inventory_level_in, $inventory_level_not_in, $inventory_level_min, $inventory_level_max, $inventory_level_greater, $inventory_level_less, $inventory_low, $out_of_stock, $total_sold, $type, $categories, $keyword, $keyword_context, $status, $include, $include_fields, $exclude_fields, $availability, $price_list_id, $page, $limit, $direction, $sort, $categories_in, $contentType);
        return $response;
    }

    /**
     * Operation getProductsWithHttpInfo
     *
     * Get All Products
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in (optional)
     * @param  int[]|null $id_not_in (optional)
     * @param  int[]|null $id_min (optional)
     * @param  int[]|null $id_max (optional)
     * @param  int[]|null $id_greater (optional)
     * @param  int[]|null $id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  string|null $upc Filter items by upc. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  string|null $date_modified_max Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_modified_min Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. (optional)
     * @param  string|null $date_last_imported_max Filter items by date_last_imported. For example, &#x60;date_last_imported:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_last_imported_min Filter items by date_last_imported. For example, &#x60;date_last_imported:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  bool|null $is_visible Filter items based on whether the product is currently visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. &#x60;0&#x60; for true, &#x60;1&#x60; for false. (optional)
     * @param  int|null $is_free_shipping Filter items by is_free_shipping. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $inventory_level_in (optional)
     * @param  int|null $inventory_level_not_in (optional)
     * @param  int|null $inventory_level_min (optional)
     * @param  int|null $inventory_level_max (optional)
     * @param  int|null $inventory_level_greater (optional)
     * @param  int|null $inventory_level_less (optional)
     * @param  int|null $inventory_low Filter items by inventory_low. Values: 1, 0. (optional)
     * @param  int|null $out_of_stock Filter items by out_of_stock. To enable the filter, pass &#x60;out_of_stock&#x60;&#x3D;&#x60;1&#x60;. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string|null $keyword_context Set context used by the search algorithm to return results targeted towards the specified group. Use &#x60;merchant&#x60; to help merchants search their own catalog. Use &#x60;shopper&#x60; to return shopper-facing search results. (optional)
     * @param  int|null $status Filter items by status. (optional)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string|null $availability Filter items by availability. Values are: available, disabled, preorder. (optional)
     * @param  int|null $price_list_id This filter returns the product pricing with the *Price List* pricing instead. To use:&#x60;?price_list_id&#x3D;1&#x60;.If there are variants use:&#x60;?price_list_id&#x3D;1&amp;include&#x3D;variants&#x60;. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $direction Sort direction. Acceptable values are: &#x60;asc&#x60;, &#x60;desc&#x60;. (optional)
     * @param  string|null $sort Field name to sort by. Note: Since &#x60;id&#x60; increments when new products are added, you can use that field to sort by product create date. (optional)
     * @param  int|null $categories_in Filter items by categories. Use for products in multiple categories. For example, &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProducts'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\GetProducts200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductsWithHttpInfo($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $sku = null, $upc = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, $date_last_imported = null, $date_last_imported_max = null, $date_last_imported_min = null, $is_visible = null, $is_featured = null, $is_free_shipping = null, $inventory_level = null, $inventory_level_in = null, $inventory_level_not_in = null, $inventory_level_min = null, $inventory_level_max = null, $inventory_level_greater = null, $inventory_level_less = null, $inventory_low = null, $out_of_stock = null, $total_sold = null, $type = null, $categories = null, $keyword = null, $keyword_context = null, $status = null, $include = null, $include_fields = null, $exclude_fields = null, $availability = null, $price_list_id = null, $page = null, $limit = null, $direction = null, $sort = null, $categories_in = null, string $contentType = self::contentTypes['getProducts'][0])
    {
        $request = $this->getProductsRequest($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $sku, $upc, $price, $weight, $condition, $brand_id, $date_modified, $date_modified_max, $date_modified_min, $date_last_imported, $date_last_imported_max, $date_last_imported_min, $is_visible, $is_featured, $is_free_shipping, $inventory_level, $inventory_level_in, $inventory_level_not_in, $inventory_level_min, $inventory_level_max, $inventory_level_greater, $inventory_level_less, $inventory_low, $out_of_stock, $total_sold, $type, $categories, $keyword, $keyword_context, $status, $include, $include_fields, $exclude_fields, $availability, $price_list_id, $page, $limit, $direction, $sort, $categories_in, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\GetProducts200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\GetProducts200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\GetProducts200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getProductsAsync
     *
     * Get All Products
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in (optional)
     * @param  int[]|null $id_not_in (optional)
     * @param  int[]|null $id_min (optional)
     * @param  int[]|null $id_max (optional)
     * @param  int[]|null $id_greater (optional)
     * @param  int[]|null $id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  string|null $upc Filter items by upc. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  string|null $date_modified_max Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_modified_min Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. (optional)
     * @param  string|null $date_last_imported_max Filter items by date_last_imported. For example, &#x60;date_last_imported:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_last_imported_min Filter items by date_last_imported. For example, &#x60;date_last_imported:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  bool|null $is_visible Filter items based on whether the product is currently visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. &#x60;0&#x60; for true, &#x60;1&#x60; for false. (optional)
     * @param  int|null $is_free_shipping Filter items by is_free_shipping. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $inventory_level_in (optional)
     * @param  int|null $inventory_level_not_in (optional)
     * @param  int|null $inventory_level_min (optional)
     * @param  int|null $inventory_level_max (optional)
     * @param  int|null $inventory_level_greater (optional)
     * @param  int|null $inventory_level_less (optional)
     * @param  int|null $inventory_low Filter items by inventory_low. Values: 1, 0. (optional)
     * @param  int|null $out_of_stock Filter items by out_of_stock. To enable the filter, pass &#x60;out_of_stock&#x60;&#x3D;&#x60;1&#x60;. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string|null $keyword_context Set context used by the search algorithm to return results targeted towards the specified group. Use &#x60;merchant&#x60; to help merchants search their own catalog. Use &#x60;shopper&#x60; to return shopper-facing search results. (optional)
     * @param  int|null $status Filter items by status. (optional)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string|null $availability Filter items by availability. Values are: available, disabled, preorder. (optional)
     * @param  int|null $price_list_id This filter returns the product pricing with the *Price List* pricing instead. To use:&#x60;?price_list_id&#x3D;1&#x60;.If there are variants use:&#x60;?price_list_id&#x3D;1&amp;include&#x3D;variants&#x60;. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $direction Sort direction. Acceptable values are: &#x60;asc&#x60;, &#x60;desc&#x60;. (optional)
     * @param  string|null $sort Field name to sort by. Note: Since &#x60;id&#x60; increments when new products are added, you can use that field to sort by product create date. (optional)
     * @param  int|null $categories_in Filter items by categories. Use for products in multiple categories. For example, &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductsAsync($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $sku = null, $upc = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, $date_last_imported = null, $date_last_imported_max = null, $date_last_imported_min = null, $is_visible = null, $is_featured = null, $is_free_shipping = null, $inventory_level = null, $inventory_level_in = null, $inventory_level_not_in = null, $inventory_level_min = null, $inventory_level_max = null, $inventory_level_greater = null, $inventory_level_less = null, $inventory_low = null, $out_of_stock = null, $total_sold = null, $type = null, $categories = null, $keyword = null, $keyword_context = null, $status = null, $include = null, $include_fields = null, $exclude_fields = null, $availability = null, $price_list_id = null, $page = null, $limit = null, $direction = null, $sort = null, $categories_in = null, string $contentType = self::contentTypes['getProducts'][0])
    {
        return $this->getProductsAsyncWithHttpInfo($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $sku, $upc, $price, $weight, $condition, $brand_id, $date_modified, $date_modified_max, $date_modified_min, $date_last_imported, $date_last_imported_max, $date_last_imported_min, $is_visible, $is_featured, $is_free_shipping, $inventory_level, $inventory_level_in, $inventory_level_not_in, $inventory_level_min, $inventory_level_max, $inventory_level_greater, $inventory_level_less, $inventory_low, $out_of_stock, $total_sold, $type, $categories, $keyword, $keyword_context, $status, $include, $include_fields, $exclude_fields, $availability, $price_list_id, $page, $limit, $direction, $sort, $categories_in, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProductsAsyncWithHttpInfo
     *
     * Get All Products
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in (optional)
     * @param  int[]|null $id_not_in (optional)
     * @param  int[]|null $id_min (optional)
     * @param  int[]|null $id_max (optional)
     * @param  int[]|null $id_greater (optional)
     * @param  int[]|null $id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  string|null $upc Filter items by upc. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  string|null $date_modified_max Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_modified_min Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. (optional)
     * @param  string|null $date_last_imported_max Filter items by date_last_imported. For example, &#x60;date_last_imported:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_last_imported_min Filter items by date_last_imported. For example, &#x60;date_last_imported:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  bool|null $is_visible Filter items based on whether the product is currently visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. &#x60;0&#x60; for true, &#x60;1&#x60; for false. (optional)
     * @param  int|null $is_free_shipping Filter items by is_free_shipping. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $inventory_level_in (optional)
     * @param  int|null $inventory_level_not_in (optional)
     * @param  int|null $inventory_level_min (optional)
     * @param  int|null $inventory_level_max (optional)
     * @param  int|null $inventory_level_greater (optional)
     * @param  int|null $inventory_level_less (optional)
     * @param  int|null $inventory_low Filter items by inventory_low. Values: 1, 0. (optional)
     * @param  int|null $out_of_stock Filter items by out_of_stock. To enable the filter, pass &#x60;out_of_stock&#x60;&#x3D;&#x60;1&#x60;. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string|null $keyword_context Set context used by the search algorithm to return results targeted towards the specified group. Use &#x60;merchant&#x60; to help merchants search their own catalog. Use &#x60;shopper&#x60; to return shopper-facing search results. (optional)
     * @param  int|null $status Filter items by status. (optional)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string|null $availability Filter items by availability. Values are: available, disabled, preorder. (optional)
     * @param  int|null $price_list_id This filter returns the product pricing with the *Price List* pricing instead. To use:&#x60;?price_list_id&#x3D;1&#x60;.If there are variants use:&#x60;?price_list_id&#x3D;1&amp;include&#x3D;variants&#x60;. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $direction Sort direction. Acceptable values are: &#x60;asc&#x60;, &#x60;desc&#x60;. (optional)
     * @param  string|null $sort Field name to sort by. Note: Since &#x60;id&#x60; increments when new products are added, you can use that field to sort by product create date. (optional)
     * @param  int|null $categories_in Filter items by categories. Use for products in multiple categories. For example, &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductsAsyncWithHttpInfo($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $sku = null, $upc = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, $date_last_imported = null, $date_last_imported_max = null, $date_last_imported_min = null, $is_visible = null, $is_featured = null, $is_free_shipping = null, $inventory_level = null, $inventory_level_in = null, $inventory_level_not_in = null, $inventory_level_min = null, $inventory_level_max = null, $inventory_level_greater = null, $inventory_level_less = null, $inventory_low = null, $out_of_stock = null, $total_sold = null, $type = null, $categories = null, $keyword = null, $keyword_context = null, $status = null, $include = null, $include_fields = null, $exclude_fields = null, $availability = null, $price_list_id = null, $page = null, $limit = null, $direction = null, $sort = null, $categories_in = null, string $contentType = self::contentTypes['getProducts'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\GetProducts200Response';
        $request = $this->getProductsRequest($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $sku, $upc, $price, $weight, $condition, $brand_id, $date_modified, $date_modified_max, $date_modified_min, $date_last_imported, $date_last_imported_max, $date_last_imported_min, $is_visible, $is_featured, $is_free_shipping, $inventory_level, $inventory_level_in, $inventory_level_not_in, $inventory_level_min, $inventory_level_max, $inventory_level_greater, $inventory_level_less, $inventory_low, $out_of_stock, $total_sold, $type, $categories, $keyword, $keyword_context, $status, $include, $include_fields, $exclude_fields, $availability, $price_list_id, $page, $limit, $direction, $sort, $categories_in, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProducts'
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in (optional)
     * @param  int[]|null $id_not_in (optional)
     * @param  int[]|null $id_min (optional)
     * @param  int[]|null $id_max (optional)
     * @param  int[]|null $id_greater (optional)
     * @param  int[]|null $id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  string|null $sku Filter items by sku. (optional)
     * @param  string|null $upc Filter items by upc. (optional)
     * @param  float|null $price Filter items by price. (optional)
     * @param  float|null $weight Filter items by weight. (optional)
     * @param  string|null $condition Filter items by condition. (optional)
     * @param  int|null $brand_id Filter items by brand_id. (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  string|null $date_modified_max Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_modified_min Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  \DateTime|null $date_last_imported Filter items by date_last_imported. (optional)
     * @param  string|null $date_last_imported_max Filter items by date_last_imported. For example, &#x60;date_last_imported:max&#x3D;2020-06-15&#x60;. (optional)
     * @param  string|null $date_last_imported_min Filter items by date_last_imported. For example, &#x60;date_last_imported:min&#x3D;2018-06-15&#x60;. (optional)
     * @param  bool|null $is_visible Filter items based on whether the product is currently visible on the storefront. (optional)
     * @param  int|null $is_featured Filter items by is_featured. &#x60;0&#x60; for true, &#x60;1&#x60; for false. (optional)
     * @param  int|null $is_free_shipping Filter items by is_free_shipping. (optional)
     * @param  int|null $inventory_level Filter items by inventory_level. (optional)
     * @param  int|null $inventory_level_in (optional)
     * @param  int|null $inventory_level_not_in (optional)
     * @param  int|null $inventory_level_min (optional)
     * @param  int|null $inventory_level_max (optional)
     * @param  int|null $inventory_level_greater (optional)
     * @param  int|null $inventory_level_less (optional)
     * @param  int|null $inventory_low Filter items by inventory_low. Values: 1, 0. (optional)
     * @param  int|null $out_of_stock Filter items by out_of_stock. To enable the filter, pass &#x60;out_of_stock&#x60;&#x3D;&#x60;1&#x60;. (optional)
     * @param  int|null $total_sold Filter items by total_sold. (optional)
     * @param  string|null $type Filter items by type. (optional)
     * @param  int|null $categories Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string|null $keyword Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @param  string|null $keyword_context Set context used by the search algorithm to return results targeted towards the specified group. Use &#x60;merchant&#x60; to help merchants search their own catalog. Use &#x60;shopper&#x60; to return shopper-facing search results. (optional)
     * @param  int|null $status Filter items by status. (optional)
     * @param  string|null $include Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string|null $availability Filter items by availability. Values are: available, disabled, preorder. (optional)
     * @param  int|null $price_list_id This filter returns the product pricing with the *Price List* pricing instead. To use:&#x60;?price_list_id&#x3D;1&#x60;.If there are variants use:&#x60;?price_list_id&#x3D;1&amp;include&#x3D;variants&#x60;. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $direction Sort direction. Acceptable values are: &#x60;asc&#x60;, &#x60;desc&#x60;. (optional)
     * @param  string|null $sort Field name to sort by. Note: Since &#x60;id&#x60; increments when new products are added, you can use that field to sort by product create date. (optional)
     * @param  int|null $categories_in Filter items by categories. Use for products in multiple categories. For example, &#x60;categories:in&#x3D;12&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProductsRequest($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $sku = null, $upc = null, $price = null, $weight = null, $condition = null, $brand_id = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, $date_last_imported = null, $date_last_imported_max = null, $date_last_imported_min = null, $is_visible = null, $is_featured = null, $is_free_shipping = null, $inventory_level = null, $inventory_level_in = null, $inventory_level_not_in = null, $inventory_level_min = null, $inventory_level_max = null, $inventory_level_greater = null, $inventory_level_less = null, $inventory_low = null, $out_of_stock = null, $total_sold = null, $type = null, $categories = null, $keyword = null, $keyword_context = null, $status = null, $include = null, $include_fields = null, $exclude_fields = null, $availability = null, $price_list_id = null, $page = null, $limit = null, $direction = null, $sort = null, $categories_in = null, string $contentType = self::contentTypes['getProducts'][0])
    {


















































        $resourcePath = '/catalog/products';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_not_in,
            'id:not_in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_min,
            'id:min', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_max,
            'id:max', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_greater,
            'id:greater', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_less,
            'id:less', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'sku', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $upc,
            'upc', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $price,
            'price', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $weight,
            'weight', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $condition,
            'condition', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $brand_id,
            'brand_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified,
            'date_modified', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified_max,
            'date_modified:max', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified_min,
            'date_modified:min', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_last_imported,
            'date_last_imported', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_last_imported_max,
            'date_last_imported:max', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_last_imported_min,
            'date_last_imported:min', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_visible,
            'is_visible', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_featured,
            'is_featured', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_free_shipping,
            'is_free_shipping', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_level,
            'inventory_level', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_level_in,
            'inventory_level:in', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_level_not_in,
            'inventory_level:not_in', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_level_min,
            'inventory_level:min', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_level_max,
            'inventory_level:max', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_level_greater,
            'inventory_level:greater', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_level_less,
            'inventory_level:less', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_low,
            'inventory_low', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $out_of_stock,
            'out_of_stock', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $total_sold,
            'total_sold', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $type,
            'type', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $categories,
            'categories', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $keyword,
            'keyword', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $keyword_context,
            'keyword_context', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'status', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include,
            'include', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $availability,
            'availability', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $price_list_id,
            'price_list_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $direction,
            'direction', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $categories_in,
            'categories:in', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateProduct
     *
     * Update a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut $product product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProduct'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\ProductResponse|object|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse
     */
    public function updateProduct($product_id, $product, $include_fields = null, string $contentType = self::contentTypes['updateProduct'][0])
    {
        list($response) = $this->updateProductWithHttpInfo($product_id, $product, $include_fields, $contentType);
        return $response;
    }

    /**
     * Operation updateProductWithHttpInfo
     *
     * Update a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut $product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProduct'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\ProductResponse|object|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductWithHttpInfo($product_id, $product, $include_fields = null, string $contentType = self::contentTypes['updateProduct'][0])
    {
        $request = $this->updateProductRequest($product_id, $product, $include_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ProductResponse',
                        $request,
                        $response,
                    );
                case 201:
                    return $this->handleResponseWithDataType(
                        'object',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
                case 409:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\ProductResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ProductResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateProductAsync
     *
     * Update a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut $product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateProductAsync($product_id, $product, $include_fields = null, string $contentType = self::contentTypes['updateProduct'][0])
    {
        return $this->updateProductAsyncWithHttpInfo($product_id, $product, $include_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateProductAsyncWithHttpInfo
     *
     * Update a Product
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut $product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateProductAsyncWithHttpInfo($product_id, $product, $include_fields = null, string $contentType = self::contentTypes['updateProduct'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\ProductResponse';
        $request = $this->updateProductRequest($product_id, $product, $include_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateProduct'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut $product (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateProductRequest($product_id, $product, $include_fields = null, string $contentType = self::contentTypes['updateProduct'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling updateProduct'
            );
        }

        // verify the required parameter 'product' is set
        if ($product === null || (is_array($product) && count($product) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product when calling updateProduct'
            );
        }



        $resourcePath = '/catalog/products/{product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product));
            } else {
                $httpBody = $product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateProducts
     *
     * Update Products (Batch)
     *
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut[]|null $products products (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProducts'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\GetProducts200Response|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse409|\Bigcommerce\CatalogV3\Model\ErrorBase|\Bigcommerce\CatalogV3\Model\ErrorResponse422
     */
    public function updateProducts($include_fields = null, $products = null, string $contentType = self::contentTypes['updateProducts'][0])
    {
        list($response) = $this->updateProductsWithHttpInfo($include_fields, $products, $contentType);
        return $response;
    }

    /**
     * Operation updateProductsWithHttpInfo
     *
     * Update Products (Batch)
     *
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut[]|null $products (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProducts'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\GetProducts200Response|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse409|\Bigcommerce\CatalogV3\Model\ErrorBase|\Bigcommerce\CatalogV3\Model\ErrorResponse422, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductsWithHttpInfo($include_fields = null, $products = null, string $contentType = self::contentTypes['updateProducts'][0])
    {
        $request = $this->updateProductsRequest($include_fields, $products, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\GetProducts200Response',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
                case 409:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse409',
                        $request,
                        $response,
                    );
                case 413:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorBase',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse422',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\GetProducts200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\GetProducts200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorBase',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse422',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateProductsAsync
     *
     * Update Products (Batch)
     *
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut[]|null $products (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateProductsAsync($include_fields = null, $products = null, string $contentType = self::contentTypes['updateProducts'][0])
    {
        return $this->updateProductsAsyncWithHttpInfo($include_fields, $products, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateProductsAsyncWithHttpInfo
     *
     * Update Products (Batch)
     *
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut[]|null $products (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateProductsAsyncWithHttpInfo($include_fields = null, $products = null, string $contentType = self::contentTypes['updateProducts'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\GetProducts200Response';
        $request = $this->updateProductsRequest($include_fields, $products, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateProducts'
     *
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  \Bigcommerce\CatalogV3\Model\ProductPut[]|null $products (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateProductsRequest($include_fields = null, $products = null, string $contentType = self::contentTypes['updateProducts'][0])
    {




        $resourcePath = '/catalog/products';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($products)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($products));
            } else {
                $httpBody = $products;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
