<?php
/**
 * ProductVariantOptionValuesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CatalogV3\ApiException;
use Bigcommerce\CatalogV3\Configuration;
use Bigcommerce\CatalogV3\FormDataProcessor;
use Bigcommerce\CatalogV3\HeaderSelector;
use Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * ProductVariantOptionValuesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductVariantOptionValuesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createOptionValue' => [
            'application/json',
        ],
        'deleteOptionValueById' => [
            'application/json',
        ],
        'getOptionValueById' => [
            'application/json',
        ],
        'getOptionValues' => [
            'application/json',
        ],
        'updateOptionValue' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createOptionValue
     *
     * Create a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePost $option_value option_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOptionValue'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\OptionValueResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse
     */
    public function createOptionValue($product_id, $option_id, $option_value, string $contentType = self::contentTypes['createOptionValue'][0])
    {
        list($response) = $this->createOptionValueWithHttpInfo($product_id, $option_id, $option_value, $contentType);
        return $response;
    }

    /**
     * Operation createOptionValueWithHttpInfo
     *
     * Create a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePost $option_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOptionValue'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\OptionValueResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOptionValueWithHttpInfo($product_id, $option_id, $option_value, string $contentType = self::contentTypes['createOptionValue'][0])
    {
        $request = $this->createOptionValueRequest($product_id, $option_id, $option_value, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createOptionValueAsync
     *
     * Create a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePost $option_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOptionValue'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOptionValueAsync($product_id, $option_id, $option_value, string $contentType = self::contentTypes['createOptionValue'][0])
    {
        return $this->createOptionValueAsyncWithHttpInfo($product_id, $option_id, $option_value, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOptionValueAsyncWithHttpInfo
     *
     * Create a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePost $option_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOptionValue'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOptionValueAsyncWithHttpInfo($product_id, $option_id, $option_value, string $contentType = self::contentTypes['createOptionValue'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\OptionValueResponse';
        $request = $this->createOptionValueRequest($product_id, $option_id, $option_value, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOptionValue'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePost $option_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOptionValue'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOptionValueRequest($product_id, $option_id, $option_value, string $contentType = self::contentTypes['createOptionValue'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling createOptionValue'
            );
        }

        // verify the required parameter 'option_id' is set
        if ($option_id === null || (is_array($option_id) && count($option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_id when calling createOptionValue'
            );
        }

        // verify the required parameter 'option_value' is set
        if ($option_value === null || (is_array($option_value) && count($option_value) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_value when calling createOptionValue'
            );
        }


        $resourcePath = '/catalog/products/{product_id}/options/{option_id}/values';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'option_id' . '}',
                ObjectSerializer::toPathValue($option_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($option_value)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($option_value));
            } else {
                $httpBody = $option_value;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOptionValueById
     *
     * Delete a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOptionValueById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOptionValueById($product_id, $option_id, $value_id, string $contentType = self::contentTypes['deleteOptionValueById'][0])
    {
        $this->deleteOptionValueByIdWithHttpInfo($product_id, $option_id, $value_id, $contentType);
    }

    /**
     * Operation deleteOptionValueByIdWithHttpInfo
     *
     * Delete a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOptionValueById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOptionValueByIdWithHttpInfo($product_id, $option_id, $value_id, string $contentType = self::contentTypes['deleteOptionValueById'][0])
    {
        $request = $this->deleteOptionValueByIdRequest($product_id, $option_id, $value_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteOptionValueByIdAsync
     *
     * Delete a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOptionValueById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOptionValueByIdAsync($product_id, $option_id, $value_id, string $contentType = self::contentTypes['deleteOptionValueById'][0])
    {
        return $this->deleteOptionValueByIdAsyncWithHttpInfo($product_id, $option_id, $value_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOptionValueByIdAsyncWithHttpInfo
     *
     * Delete a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOptionValueById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOptionValueByIdAsyncWithHttpInfo($product_id, $option_id, $value_id, string $contentType = self::contentTypes['deleteOptionValueById'][0])
    {
        $returnType = '';
        $request = $this->deleteOptionValueByIdRequest($product_id, $option_id, $value_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOptionValueById'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOptionValueById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOptionValueByIdRequest($product_id, $option_id, $value_id, string $contentType = self::contentTypes['deleteOptionValueById'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling deleteOptionValueById'
            );
        }

        // verify the required parameter 'option_id' is set
        if ($option_id === null || (is_array($option_id) && count($option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_id when calling deleteOptionValueById'
            );
        }

        // verify the required parameter 'value_id' is set
        if ($value_id === null || (is_array($value_id) && count($value_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $value_id when calling deleteOptionValueById'
            );
        }


        $resourcePath = '/catalog/products/{product_id}/options/{option_id}/values/{value_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'option_id' . '}',
                ObjectSerializer::toPathValue($option_id),
                $resourcePath
            );
        }
        // path params
        if ($value_id !== null) {
            $resourcePath = str_replace(
                '{' . 'value_id' . '}',
                ObjectSerializer::toPathValue($value_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOptionValueById
     *
     * Get a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValueById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\OptionValueResponse|\Bigcommerce\CatalogV3\Model\NotFound
     */
    public function getOptionValueById($product_id, $option_id, $value_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getOptionValueById'][0])
    {
        list($response) = $this->getOptionValueByIdWithHttpInfo($product_id, $option_id, $value_id, $include_fields, $exclude_fields, $contentType);
        return $response;
    }

    /**
     * Operation getOptionValueByIdWithHttpInfo
     *
     * Get a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValueById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\OptionValueResponse|\Bigcommerce\CatalogV3\Model\NotFound, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOptionValueByIdWithHttpInfo($product_id, $option_id, $value_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getOptionValueById'][0])
    {
        $request = $this->getOptionValueByIdRequest($product_id, $option_id, $value_id, $include_fields, $exclude_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOptionValueByIdAsync
     *
     * Get a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValueById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOptionValueByIdAsync($product_id, $option_id, $value_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getOptionValueById'][0])
    {
        return $this->getOptionValueByIdAsyncWithHttpInfo($product_id, $option_id, $value_id, $include_fields, $exclude_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOptionValueByIdAsyncWithHttpInfo
     *
     * Get a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValueById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOptionValueByIdAsyncWithHttpInfo($product_id, $option_id, $value_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getOptionValueById'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\OptionValueResponse';
        $request = $this->getOptionValueByIdRequest($product_id, $option_id, $value_id, $include_fields, $exclude_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOptionValueById'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValueById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOptionValueByIdRequest($product_id, $option_id, $value_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getOptionValueById'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling getOptionValueById'
            );
        }

        // verify the required parameter 'option_id' is set
        if ($option_id === null || (is_array($option_id) && count($option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_id when calling getOptionValueById'
            );
        }

        // verify the required parameter 'value_id' is set
        if ($value_id === null || (is_array($value_id) && count($value_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $value_id when calling getOptionValueById'
            );
        }




        $resourcePath = '/catalog/products/{product_id}/options/{option_id}/values/{value_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'option_id' . '}',
                ObjectSerializer::toPathValue($option_id),
                $resourcePath
            );
        }
        // path params
        if ($value_id !== null) {
            $resourcePath = str_replace(
                '{' . 'value_id' . '}',
                ObjectSerializer::toPathValue($value_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOptionValues
     *
     * Get All Product Variant Option Values
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValues'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\OptionValueCollectionResponse
     */
    public function getOptionValues($product_id, $option_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOptionValues'][0])
    {
        list($response) = $this->getOptionValuesWithHttpInfo($product_id, $option_id, $include_fields, $exclude_fields, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation getOptionValuesWithHttpInfo
     *
     * Get All Product Variant Option Values
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValues'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\OptionValueCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOptionValuesWithHttpInfo($product_id, $option_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOptionValues'][0])
    {
        $request = $this->getOptionValuesRequest($product_id, $option_id, $include_fields, $exclude_fields, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\OptionValueCollectionResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\OptionValueCollectionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\OptionValueCollectionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOptionValuesAsync
     *
     * Get All Product Variant Option Values
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValues'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOptionValuesAsync($product_id, $option_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOptionValues'][0])
    {
        return $this->getOptionValuesAsyncWithHttpInfo($product_id, $option_id, $include_fields, $exclude_fields, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOptionValuesAsyncWithHttpInfo
     *
     * Get All Product Variant Option Values
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValues'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOptionValuesAsyncWithHttpInfo($product_id, $option_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOptionValues'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\OptionValueCollectionResponse';
        $request = $this->getOptionValuesRequest($product_id, $option_id, $include_fields, $exclude_fields, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOptionValues'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOptionValues'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOptionValuesRequest($product_id, $option_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOptionValues'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling getOptionValues'
            );
        }

        // verify the required parameter 'option_id' is set
        if ($option_id === null || (is_array($option_id) && count($option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_id when calling getOptionValues'
            );
        }






        $resourcePath = '/catalog/products/{product_id}/options/{option_id}/values';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'option_id' . '}',
                ObjectSerializer::toPathValue($option_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateOptionValue
     *
     * Update a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePut $option_value A BigCommerce &#x60;OptionValue&#x60; object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateOptionValue'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\OptionValueResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse
     */
    public function updateOptionValue($product_id, $option_id, $value_id, $option_value, string $contentType = self::contentTypes['updateOptionValue'][0])
    {
        list($response) = $this->updateOptionValueWithHttpInfo($product_id, $option_id, $value_id, $option_value, $contentType);
        return $response;
    }

    /**
     * Operation updateOptionValueWithHttpInfo
     *
     * Update a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePut $option_value A BigCommerce &#x60;OptionValue&#x60; object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateOptionValue'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\OptionValueResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateOptionValueWithHttpInfo($product_id, $option_id, $value_id, $option_value, string $contentType = self::contentTypes['updateOptionValue'][0])
    {
        $request = $this->updateOptionValueRequest($product_id, $option_id, $value_id, $option_value, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\OptionValueResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateOptionValueAsync
     *
     * Update a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePut $option_value A BigCommerce &#x60;OptionValue&#x60; object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateOptionValue'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateOptionValueAsync($product_id, $option_id, $value_id, $option_value, string $contentType = self::contentTypes['updateOptionValue'][0])
    {
        return $this->updateOptionValueAsyncWithHttpInfo($product_id, $option_id, $value_id, $option_value, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateOptionValueAsyncWithHttpInfo
     *
     * Update a Product Variant Option Value
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePut $option_value A BigCommerce &#x60;OptionValue&#x60; object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateOptionValue'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateOptionValueAsyncWithHttpInfo($product_id, $option_id, $value_id, $option_value, string $contentType = self::contentTypes['updateOptionValue'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\OptionValueResponse';
        $request = $this->updateOptionValueRequest($product_id, $option_id, $value_id, $option_value, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateOptionValue'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param  int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\OptionValuePut $option_value A BigCommerce &#x60;OptionValue&#x60; object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateOptionValue'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateOptionValueRequest($product_id, $option_id, $value_id, $option_value, string $contentType = self::contentTypes['updateOptionValue'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling updateOptionValue'
            );
        }

        // verify the required parameter 'option_id' is set
        if ($option_id === null || (is_array($option_id) && count($option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_id when calling updateOptionValue'
            );
        }

        // verify the required parameter 'value_id' is set
        if ($value_id === null || (is_array($value_id) && count($value_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $value_id when calling updateOptionValue'
            );
        }

        // verify the required parameter 'option_value' is set
        if ($option_value === null || (is_array($option_value) && count($option_value) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_value when calling updateOptionValue'
            );
        }


        $resourcePath = '/catalog/products/{product_id}/options/{option_id}/values/{value_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'option_id' . '}',
                ObjectSerializer::toPathValue($option_id),
                $resourcePath
            );
        }
        // path params
        if ($value_id !== null) {
            $resourcePath = str_replace(
                '{' . 'value_id' . '}',
                ObjectSerializer::toPathValue($value_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($option_value)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($option_value));
            } else {
                $httpBody = $option_value;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
