<?php
/**
 * ProductImagesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CatalogV3\ApiException;
use Bigcommerce\CatalogV3\Configuration;
use Bigcommerce\CatalogV3\FormDataProcessor;
use Bigcommerce\CatalogV3\HeaderSelector;
use Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * ProductImagesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductImagesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createProductImage' => [
            'multipart/form-data',
            'application/json',
        ],
        'deleteProductImage' => [
            'application/json',
        ],
        'getProductImageById' => [
            'application/json',
        ],
        'getProductImages' => [
            'application/json',
        ],
        'updateProductImage' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createProductImage
     *
     * Create a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $id The unique numeric ID of the image; increments sequentially. (optional)
     * @param  int|null $product_id2 The unique numeric identifier for the product with which the image is associated. (optional)
     * @param  string|null $image_file Must be sent as a multipart/form-data field in the request body. (optional)
     * @param  string|null $url_zoom The zoom URL for this image. By default, this is used as the zoom image on product pages when zoom images are enabled. (optional)
     * @param  string|null $url_standard The standard URL for this image. By default, this is used for product-page images. (optional)
     * @param  string|null $url_thumbnail The thumbnail URL for this image. By default, this is the image size used on the category page and in side panels. (optional)
     * @param  string|null $url_tiny The tiny URL for this image. By default, this is the image size used for thumbnails beneath the product image on a product page. (optional)
     * @param  \DateTime|null $date_modified The date on which the product image was modified. (optional)
     * @param  bool|null $is_thumbnail Flag for identifying whether the image is used as the product&#39;s thumbnail. (optional)
     * @param  int|null $sort_order The order in which the image will be displayed on the product page. Higher integers give the image a lower priority. When updating, if the image is given a lower priority, all images with a &#x60;sort_order&#x60; the same as or greater than the image&#39;s new &#x60;sort_order&#x60; value will have their &#x60;sort_order&#x60;s reordered. (optional)
     * @param  string|null $description The description for the image. (optional)
     * @param  string|null $image_url Must be a fully qualified URL path, including protocol. Limit of 8MB per file. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProductImage'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\ProductImageResponse|\Bigcommerce\CatalogV3\Model\NotFound
     */
    public function createProductImage($product_id, $id = null, $product_id2 = null, $image_file = null, $url_zoom = null, $url_standard = null, $url_thumbnail = null, $url_tiny = null, $date_modified = null, $is_thumbnail = null, $sort_order = null, $description = null, $image_url = null, string $contentType = self::contentTypes['createProductImage'][0])
    {
        list($response) = $this->createProductImageWithHttpInfo($product_id, $id, $product_id2, $image_file, $url_zoom, $url_standard, $url_thumbnail, $url_tiny, $date_modified, $is_thumbnail, $sort_order, $description, $image_url, $contentType);
        return $response;
    }

    /**
     * Operation createProductImageWithHttpInfo
     *
     * Create a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $id The unique numeric ID of the image; increments sequentially. (optional)
     * @param  int|null $product_id2 The unique numeric identifier for the product with which the image is associated. (optional)
     * @param  string|null $image_file Must be sent as a multipart/form-data field in the request body. (optional)
     * @param  string|null $url_zoom The zoom URL for this image. By default, this is used as the zoom image on product pages when zoom images are enabled. (optional)
     * @param  string|null $url_standard The standard URL for this image. By default, this is used for product-page images. (optional)
     * @param  string|null $url_thumbnail The thumbnail URL for this image. By default, this is the image size used on the category page and in side panels. (optional)
     * @param  string|null $url_tiny The tiny URL for this image. By default, this is the image size used for thumbnails beneath the product image on a product page. (optional)
     * @param  \DateTime|null $date_modified The date on which the product image was modified. (optional)
     * @param  bool|null $is_thumbnail Flag for identifying whether the image is used as the product&#39;s thumbnail. (optional)
     * @param  int|null $sort_order The order in which the image will be displayed on the product page. Higher integers give the image a lower priority. When updating, if the image is given a lower priority, all images with a &#x60;sort_order&#x60; the same as or greater than the image&#39;s new &#x60;sort_order&#x60; value will have their &#x60;sort_order&#x60;s reordered. (optional)
     * @param  string|null $description The description for the image. (optional)
     * @param  string|null $image_url Must be a fully qualified URL path, including protocol. Limit of 8MB per file. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProductImage'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\ProductImageResponse|\Bigcommerce\CatalogV3\Model\NotFound, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProductImageWithHttpInfo($product_id, $id = null, $product_id2 = null, $image_file = null, $url_zoom = null, $url_standard = null, $url_thumbnail = null, $url_tiny = null, $date_modified = null, $is_thumbnail = null, $sort_order = null, $description = null, $image_url = null, string $contentType = self::contentTypes['createProductImage'][0])
    {
        $request = $this->createProductImageRequest($product_id, $id, $product_id2, $image_file, $url_zoom, $url_standard, $url_thumbnail, $url_tiny, $date_modified, $is_thumbnail, $sort_order, $description, $image_url, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ProductImageResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\ProductImageResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ProductImageResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createProductImageAsync
     *
     * Create a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $id The unique numeric ID of the image; increments sequentially. (optional)
     * @param  int|null $product_id2 The unique numeric identifier for the product with which the image is associated. (optional)
     * @param  string|null $image_file Must be sent as a multipart/form-data field in the request body. (optional)
     * @param  string|null $url_zoom The zoom URL for this image. By default, this is used as the zoom image on product pages when zoom images are enabled. (optional)
     * @param  string|null $url_standard The standard URL for this image. By default, this is used for product-page images. (optional)
     * @param  string|null $url_thumbnail The thumbnail URL for this image. By default, this is the image size used on the category page and in side panels. (optional)
     * @param  string|null $url_tiny The tiny URL for this image. By default, this is the image size used for thumbnails beneath the product image on a product page. (optional)
     * @param  \DateTime|null $date_modified The date on which the product image was modified. (optional)
     * @param  bool|null $is_thumbnail Flag for identifying whether the image is used as the product&#39;s thumbnail. (optional)
     * @param  int|null $sort_order The order in which the image will be displayed on the product page. Higher integers give the image a lower priority. When updating, if the image is given a lower priority, all images with a &#x60;sort_order&#x60; the same as or greater than the image&#39;s new &#x60;sort_order&#x60; value will have their &#x60;sort_order&#x60;s reordered. (optional)
     * @param  string|null $description The description for the image. (optional)
     * @param  string|null $image_url Must be a fully qualified URL path, including protocol. Limit of 8MB per file. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createProductImageAsync($product_id, $id = null, $product_id2 = null, $image_file = null, $url_zoom = null, $url_standard = null, $url_thumbnail = null, $url_tiny = null, $date_modified = null, $is_thumbnail = null, $sort_order = null, $description = null, $image_url = null, string $contentType = self::contentTypes['createProductImage'][0])
    {
        return $this->createProductImageAsyncWithHttpInfo($product_id, $id, $product_id2, $image_file, $url_zoom, $url_standard, $url_thumbnail, $url_tiny, $date_modified, $is_thumbnail, $sort_order, $description, $image_url, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createProductImageAsyncWithHttpInfo
     *
     * Create a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $id The unique numeric ID of the image; increments sequentially. (optional)
     * @param  int|null $product_id2 The unique numeric identifier for the product with which the image is associated. (optional)
     * @param  string|null $image_file Must be sent as a multipart/form-data field in the request body. (optional)
     * @param  string|null $url_zoom The zoom URL for this image. By default, this is used as the zoom image on product pages when zoom images are enabled. (optional)
     * @param  string|null $url_standard The standard URL for this image. By default, this is used for product-page images. (optional)
     * @param  string|null $url_thumbnail The thumbnail URL for this image. By default, this is the image size used on the category page and in side panels. (optional)
     * @param  string|null $url_tiny The tiny URL for this image. By default, this is the image size used for thumbnails beneath the product image on a product page. (optional)
     * @param  \DateTime|null $date_modified The date on which the product image was modified. (optional)
     * @param  bool|null $is_thumbnail Flag for identifying whether the image is used as the product&#39;s thumbnail. (optional)
     * @param  int|null $sort_order The order in which the image will be displayed on the product page. Higher integers give the image a lower priority. When updating, if the image is given a lower priority, all images with a &#x60;sort_order&#x60; the same as or greater than the image&#39;s new &#x60;sort_order&#x60; value will have their &#x60;sort_order&#x60;s reordered. (optional)
     * @param  string|null $description The description for the image. (optional)
     * @param  string|null $image_url Must be a fully qualified URL path, including protocol. Limit of 8MB per file. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createProductImageAsyncWithHttpInfo($product_id, $id = null, $product_id2 = null, $image_file = null, $url_zoom = null, $url_standard = null, $url_thumbnail = null, $url_tiny = null, $date_modified = null, $is_thumbnail = null, $sort_order = null, $description = null, $image_url = null, string $contentType = self::contentTypes['createProductImage'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\ProductImageResponse';
        $request = $this->createProductImageRequest($product_id, $id, $product_id2, $image_file, $url_zoom, $url_standard, $url_thumbnail, $url_tiny, $date_modified, $is_thumbnail, $sort_order, $description, $image_url, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createProductImage'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $id The unique numeric ID of the image; increments sequentially. (optional)
     * @param  int|null $product_id2 The unique numeric identifier for the product with which the image is associated. (optional)
     * @param  string|null $image_file Must be sent as a multipart/form-data field in the request body. (optional)
     * @param  string|null $url_zoom The zoom URL for this image. By default, this is used as the zoom image on product pages when zoom images are enabled. (optional)
     * @param  string|null $url_standard The standard URL for this image. By default, this is used for product-page images. (optional)
     * @param  string|null $url_thumbnail The thumbnail URL for this image. By default, this is the image size used on the category page and in side panels. (optional)
     * @param  string|null $url_tiny The tiny URL for this image. By default, this is the image size used for thumbnails beneath the product image on a product page. (optional)
     * @param  \DateTime|null $date_modified The date on which the product image was modified. (optional)
     * @param  bool|null $is_thumbnail Flag for identifying whether the image is used as the product&#39;s thumbnail. (optional)
     * @param  int|null $sort_order The order in which the image will be displayed on the product page. Higher integers give the image a lower priority. When updating, if the image is given a lower priority, all images with a &#x60;sort_order&#x60; the same as or greater than the image&#39;s new &#x60;sort_order&#x60; value will have their &#x60;sort_order&#x60;s reordered. (optional)
     * @param  string|null $description The description for the image. (optional)
     * @param  string|null $image_url Must be a fully qualified URL path, including protocol. Limit of 8MB per file. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createProductImageRequest($product_id, $id = null, $product_id2 = null, $image_file = null, $url_zoom = null, $url_standard = null, $url_thumbnail = null, $url_tiny = null, $date_modified = null, $is_thumbnail = null, $sort_order = null, $description = null, $image_url = null, string $contentType = self::contentTypes['createProductImage'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling createProductImage'
            );
        }










        if ($sort_order !== null && $sort_order > 2147483647) {
            throw new \InvalidArgumentException('invalid value for "$sort_order" when calling ProductImagesApi.createProductImage, must be smaller than or equal to 2147483647.');
        }
        if ($sort_order !== null && $sort_order < -2147483648) {
            throw new \InvalidArgumentException('invalid value for "$sort_order" when calling ProductImagesApi.createProductImage, must be bigger than or equal to -2147483648.');
        }
        



        $resourcePath = '/catalog/products/{product_id}/images';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'id' => $id,
            'product_id2' => $product_id2,
            'image_file' => $image_file,
            'url_zoom' => $url_zoom,
            'url_standard' => $url_standard,
            'url_thumbnail' => $url_thumbnail,
            'url_tiny' => $url_tiny,
            'date_modified' => $date_modified,
            'is_thumbnail' => $is_thumbnail,
            'sort_order' => $sort_order,
            'description' => $description,
            'image_url' => $image_url,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteProductImage
     *
     * Delete a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductImage'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteProductImage($product_id, $image_id, string $contentType = self::contentTypes['deleteProductImage'][0])
    {
        $this->deleteProductImageWithHttpInfo($product_id, $image_id, $contentType);
    }

    /**
     * Operation deleteProductImageWithHttpInfo
     *
     * Delete a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductImage'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductImageWithHttpInfo($product_id, $image_id, string $contentType = self::contentTypes['deleteProductImage'][0])
    {
        $request = $this->deleteProductImageRequest($product_id, $image_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteProductImageAsync
     *
     * Delete a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductImageAsync($product_id, $image_id, string $contentType = self::contentTypes['deleteProductImage'][0])
    {
        return $this->deleteProductImageAsyncWithHttpInfo($product_id, $image_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteProductImageAsyncWithHttpInfo
     *
     * Delete a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductImageAsyncWithHttpInfo($product_id, $image_id, string $contentType = self::contentTypes['deleteProductImage'][0])
    {
        $returnType = '';
        $request = $this->deleteProductImageRequest($product_id, $image_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteProductImage'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteProductImageRequest($product_id, $image_id, string $contentType = self::contentTypes['deleteProductImage'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling deleteProductImage'
            );
        }

        // verify the required parameter 'image_id' is set
        if ($image_id === null || (is_array($image_id) && count($image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $image_id when calling deleteProductImage'
            );
        }


        $resourcePath = '/catalog/products/{product_id}/images/{image_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'image_id' . '}',
                ObjectSerializer::toPathValue($image_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProductImageById
     *
     * Get a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImageById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\ProductImageResponse1|\Bigcommerce\CatalogV3\Model\NotFound
     */
    public function getProductImageById($product_id, $image_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImageById'][0])
    {
        list($response) = $this->getProductImageByIdWithHttpInfo($product_id, $image_id, $include_fields, $exclude_fields, $contentType);
        return $response;
    }

    /**
     * Operation getProductImageByIdWithHttpInfo
     *
     * Get a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImageById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\ProductImageResponse1|\Bigcommerce\CatalogV3\Model\NotFound, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductImageByIdWithHttpInfo($product_id, $image_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImageById'][0])
    {
        $request = $this->getProductImageByIdRequest($product_id, $image_id, $include_fields, $exclude_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ProductImageResponse1',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\ProductImageResponse1',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ProductImageResponse1',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getProductImageByIdAsync
     *
     * Get a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImageById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductImageByIdAsync($product_id, $image_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImageById'][0])
    {
        return $this->getProductImageByIdAsyncWithHttpInfo($product_id, $image_id, $include_fields, $exclude_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProductImageByIdAsyncWithHttpInfo
     *
     * Get a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImageById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductImageByIdAsyncWithHttpInfo($product_id, $image_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImageById'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\ProductImageResponse1';
        $request = $this->getProductImageByIdRequest($product_id, $image_id, $include_fields, $exclude_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProductImageById'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImageById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProductImageByIdRequest($product_id, $image_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImageById'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling getProductImageById'
            );
        }

        // verify the required parameter 'image_id' is set
        if ($image_id === null || (is_array($image_id) && count($image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $image_id when calling getProductImageById'
            );
        }




        $resourcePath = '/catalog/products/{product_id}/images/{image_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'image_id' . '}',
                ObjectSerializer::toPathValue($image_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProductImages
     *
     * Get All Product Images
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImages'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\ProductImageCollectionResponse|\Bigcommerce\CatalogV3\Model\NotFound
     */
    public function getProductImages($product_id, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImages'][0])
    {
        list($response) = $this->getProductImagesWithHttpInfo($product_id, $page, $limit, $include_fields, $exclude_fields, $contentType);
        return $response;
    }

    /**
     * Operation getProductImagesWithHttpInfo
     *
     * Get All Product Images
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImages'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\ProductImageCollectionResponse|\Bigcommerce\CatalogV3\Model\NotFound, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductImagesWithHttpInfo($product_id, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImages'][0])
    {
        $request = $this->getProductImagesRequest($product_id, $page, $limit, $include_fields, $exclude_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ProductImageCollectionResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\ProductImageCollectionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ProductImageCollectionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getProductImagesAsync
     *
     * Get All Product Images
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductImagesAsync($product_id, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImages'][0])
    {
        return $this->getProductImagesAsyncWithHttpInfo($product_id, $page, $limit, $include_fields, $exclude_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProductImagesAsyncWithHttpInfo
     *
     * Get All Product Images
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductImagesAsyncWithHttpInfo($product_id, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImages'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\ProductImageCollectionResponse';
        $request = $this->getProductImagesRequest($product_id, $page, $limit, $include_fields, $exclude_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProductImages'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProductImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProductImagesRequest($product_id, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getProductImages'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling getProductImages'
            );
        }






        $resourcePath = '/catalog/products/{product_id}/images';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateProductImage
     *
     * Update a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductImagePut $product_image product_image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProductImage'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\ProductImageResponse2|\Bigcommerce\CatalogV3\Model\NotFound
     */
    public function updateProductImage($product_id, $image_id, $product_image, string $contentType = self::contentTypes['updateProductImage'][0])
    {
        list($response) = $this->updateProductImageWithHttpInfo($product_id, $image_id, $product_image, $contentType);
        return $response;
    }

    /**
     * Operation updateProductImageWithHttpInfo
     *
     * Update a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductImagePut $product_image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProductImage'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\ProductImageResponse2|\Bigcommerce\CatalogV3\Model\NotFound, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductImageWithHttpInfo($product_id, $image_id, $product_image, string $contentType = self::contentTypes['updateProductImage'][0])
    {
        $request = $this->updateProductImageRequest($product_id, $image_id, $product_image, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ProductImageResponse2',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\ProductImageResponse2',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ProductImageResponse2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateProductImageAsync
     *
     * Update a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductImagePut $product_image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateProductImageAsync($product_id, $image_id, $product_image, string $contentType = self::contentTypes['updateProductImage'][0])
    {
        return $this->updateProductImageAsyncWithHttpInfo($product_id, $image_id, $product_image, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateProductImageAsyncWithHttpInfo
     *
     * Update a Product Image
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductImagePut $product_image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateProductImageAsyncWithHttpInfo($product_id, $image_id, $product_image, string $contentType = self::contentTypes['updateProductImage'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\ProductImageResponse2';
        $request = $this->updateProductImageRequest($product_id, $image_id, $product_image, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateProductImage'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param  \Bigcommerce\CatalogV3\Model\ProductImagePut $product_image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateProductImageRequest($product_id, $image_id, $product_image, string $contentType = self::contentTypes['updateProductImage'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling updateProductImage'
            );
        }

        // verify the required parameter 'image_id' is set
        if ($image_id === null || (is_array($image_id) && count($image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $image_id when calling updateProductImage'
            );
        }

        // verify the required parameter 'product_image' is set
        if ($product_image === null || (is_array($product_image) && count($product_image) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_image when calling updateProductImage'
            );
        }


        $resourcePath = '/catalog/products/{product_id}/images/{image_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'image_id' . '}',
                ObjectSerializer::toPathValue($image_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product_image)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product_image));
            } else {
                $httpBody = $product_image;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
