<?php
/**
 * ProductCustomFieldsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CatalogV3\ApiException;
use Bigcommerce\CatalogV3\Configuration;
use Bigcommerce\CatalogV3\FormDataProcessor;
use Bigcommerce\CatalogV3\HeaderSelector;
use Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * ProductCustomFieldsApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductCustomFieldsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createCustomField' => [
            'application/json',
        ],
        'deleteCustomFieldById' => [
            'application/json',
        ],
        'getCustomFieldById' => [
            'application/json',
        ],
        'getCustomFields' => [
            'application/json',
        ],
        'updateCustomField' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createCustomField
     *
     * Create a Custom Fields
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomField'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\CreateCustomField200Response|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse
     */
    public function createCustomField($product_id, $custom_field, string $contentType = self::contentTypes['createCustomField'][0])
    {
        list($response) = $this->createCustomFieldWithHttpInfo($product_id, $custom_field, $contentType);
        return $response;
    }

    /**
     * Operation createCustomFieldWithHttpInfo
     *
     * Create a Custom Fields
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomField'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\CreateCustomField200Response|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomFieldWithHttpInfo($product_id, $custom_field, string $contentType = self::contentTypes['createCustomField'][0])
    {
        $request = $this->createCustomFieldRequest($product_id, $custom_field, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\CreateCustomField200Response',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\CreateCustomField200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\CreateCustomField200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createCustomFieldAsync
     *
     * Create a Custom Fields
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomField'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomFieldAsync($product_id, $custom_field, string $contentType = self::contentTypes['createCustomField'][0])
    {
        return $this->createCustomFieldAsyncWithHttpInfo($product_id, $custom_field, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCustomFieldAsyncWithHttpInfo
     *
     * Create a Custom Fields
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomField'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomFieldAsyncWithHttpInfo($product_id, $custom_field, string $contentType = self::contentTypes['createCustomField'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\CreateCustomField200Response';
        $request = $this->createCustomFieldRequest($product_id, $custom_field, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCustomField'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomField'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCustomFieldRequest($product_id, $custom_field, string $contentType = self::contentTypes['createCustomField'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling createCustomField'
            );
        }

        // verify the required parameter 'custom_field' is set
        if ($custom_field === null || (is_array($custom_field) && count($custom_field) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field when calling createCustomField'
            );
        }


        $resourcePath = '/catalog/products/{product_id}/custom-fields';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($custom_field)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($custom_field));
            } else {
                $httpBody = $custom_field;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCustomFieldById
     *
     * Delete a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomFieldById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteCustomFieldById($product_id, $custom_field_id, string $contentType = self::contentTypes['deleteCustomFieldById'][0])
    {
        $this->deleteCustomFieldByIdWithHttpInfo($product_id, $custom_field_id, $contentType);
    }

    /**
     * Operation deleteCustomFieldByIdWithHttpInfo
     *
     * Delete a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomFieldById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomFieldByIdWithHttpInfo($product_id, $custom_field_id, string $contentType = self::contentTypes['deleteCustomFieldById'][0])
    {
        $request = $this->deleteCustomFieldByIdRequest($product_id, $custom_field_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteCustomFieldByIdAsync
     *
     * Delete a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomFieldById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCustomFieldByIdAsync($product_id, $custom_field_id, string $contentType = self::contentTypes['deleteCustomFieldById'][0])
    {
        return $this->deleteCustomFieldByIdAsyncWithHttpInfo($product_id, $custom_field_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCustomFieldByIdAsyncWithHttpInfo
     *
     * Delete a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomFieldById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCustomFieldByIdAsyncWithHttpInfo($product_id, $custom_field_id, string $contentType = self::contentTypes['deleteCustomFieldById'][0])
    {
        $returnType = '';
        $request = $this->deleteCustomFieldByIdRequest($product_id, $custom_field_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCustomFieldById'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomFieldById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCustomFieldByIdRequest($product_id, $custom_field_id, string $contentType = self::contentTypes['deleteCustomFieldById'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling deleteCustomFieldById'
            );
        }

        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null || (is_array($custom_field_id) && count($custom_field_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_id when calling deleteCustomFieldById'
            );
        }


        $resourcePath = '/catalog/products/{product_id}/custom-fields/{custom_field_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                '{' . 'custom_field_id' . '}',
                ObjectSerializer::toPathValue($custom_field_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomFieldById
     *
     * Get a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFieldById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\GetCustomFieldById200Response|\Bigcommerce\CatalogV3\Model\NotFound
     */
    public function getCustomFieldById($product_id, $custom_field_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCustomFieldById'][0])
    {
        list($response) = $this->getCustomFieldByIdWithHttpInfo($product_id, $custom_field_id, $include_fields, $exclude_fields, $contentType);
        return $response;
    }

    /**
     * Operation getCustomFieldByIdWithHttpInfo
     *
     * Get a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFieldById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\GetCustomFieldById200Response|\Bigcommerce\CatalogV3\Model\NotFound, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomFieldByIdWithHttpInfo($product_id, $custom_field_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCustomFieldById'][0])
    {
        $request = $this->getCustomFieldByIdRequest($product_id, $custom_field_id, $include_fields, $exclude_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\GetCustomFieldById200Response',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\GetCustomFieldById200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\GetCustomFieldById200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCustomFieldByIdAsync
     *
     * Get a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFieldById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomFieldByIdAsync($product_id, $custom_field_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCustomFieldById'][0])
    {
        return $this->getCustomFieldByIdAsyncWithHttpInfo($product_id, $custom_field_id, $include_fields, $exclude_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomFieldByIdAsyncWithHttpInfo
     *
     * Get a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFieldById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomFieldByIdAsyncWithHttpInfo($product_id, $custom_field_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCustomFieldById'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\GetCustomFieldById200Response';
        $request = $this->getCustomFieldByIdRequest($product_id, $custom_field_id, $include_fields, $exclude_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomFieldById'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFieldById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomFieldByIdRequest($product_id, $custom_field_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCustomFieldById'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling getCustomFieldById'
            );
        }

        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null || (is_array($custom_field_id) && count($custom_field_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_id when calling getCustomFieldById'
            );
        }




        $resourcePath = '/catalog/products/{product_id}/custom-fields/{custom_field_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                '{' . 'custom_field_id' . '}',
                ObjectSerializer::toPathValue($custom_field_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomFields
     *
     * Get Custom Fields
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFields'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\GetCustomFields200Response
     */
    public function getCustomFields($product_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getCustomFields'][0])
    {
        list($response) = $this->getCustomFieldsWithHttpInfo($product_id, $include_fields, $exclude_fields, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation getCustomFieldsWithHttpInfo
     *
     * Get Custom Fields
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFields'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\GetCustomFields200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomFieldsWithHttpInfo($product_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getCustomFields'][0])
    {
        $request = $this->getCustomFieldsRequest($product_id, $include_fields, $exclude_fields, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\GetCustomFields200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\GetCustomFields200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\GetCustomFields200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCustomFieldsAsync
     *
     * Get Custom Fields
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomFieldsAsync($product_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getCustomFields'][0])
    {
        return $this->getCustomFieldsAsyncWithHttpInfo($product_id, $include_fields, $exclude_fields, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomFieldsAsyncWithHttpInfo
     *
     * Get Custom Fields
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomFieldsAsyncWithHttpInfo($product_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getCustomFields'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\GetCustomFields200Response';
        $request = $this->getCustomFieldsRequest($product_id, $include_fields, $exclude_fields, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomFields'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomFields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomFieldsRequest($product_id, $include_fields = null, $exclude_fields = null, $page = null, $limit = null, string $contentType = self::contentTypes['getCustomFields'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling getCustomFields'
            );
        }






        $resourcePath = '/catalog/products/{product_id}/custom-fields';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateCustomField
     *
     * Update a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomField'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\CreateCustomField200Response|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse
     */
    public function updateCustomField($product_id, $custom_field_id, $custom_field, string $contentType = self::contentTypes['updateCustomField'][0])
    {
        list($response) = $this->updateCustomFieldWithHttpInfo($product_id, $custom_field_id, $custom_field, $contentType);
        return $response;
    }

    /**
     * Operation updateCustomFieldWithHttpInfo
     *
     * Update a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomField'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\CreateCustomField200Response|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomFieldWithHttpInfo($product_id, $custom_field_id, $custom_field, string $contentType = self::contentTypes['updateCustomField'][0])
    {
        $request = $this->updateCustomFieldRequest($product_id, $custom_field_id, $custom_field, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\CreateCustomField200Response',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\CreateCustomField200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\CreateCustomField200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateCustomFieldAsync
     *
     * Update a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomField'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomFieldAsync($product_id, $custom_field_id, $custom_field, string $contentType = self::contentTypes['updateCustomField'][0])
    {
        return $this->updateCustomFieldAsyncWithHttpInfo($product_id, $custom_field_id, $custom_field, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateCustomFieldAsyncWithHttpInfo
     *
     * Update a Custom Field
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomField'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomFieldAsyncWithHttpInfo($product_id, $custom_field_id, $custom_field, string $contentType = self::contentTypes['updateCustomField'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\CreateCustomField200Response';
        $request = $this->updateCustomFieldRequest($product_id, $custom_field_id, $custom_field, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateCustomField'
     *
     * @param  int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param  int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param  \Bigcommerce\CatalogV3\Model\CustomField $custom_field (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomField'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateCustomFieldRequest($product_id, $custom_field_id, $custom_field, string $contentType = self::contentTypes['updateCustomField'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling updateCustomField'
            );
        }

        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null || (is_array($custom_field_id) && count($custom_field_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field_id when calling updateCustomField'
            );
        }

        // verify the required parameter 'custom_field' is set
        if ($custom_field === null || (is_array($custom_field) && count($custom_field) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $custom_field when calling updateCustomField'
            );
        }


        $resourcePath = '/catalog/products/{product_id}/custom-fields/{custom_field_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }
        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                '{' . 'custom_field_id' . '}',
                ObjectSerializer::toPathValue($custom_field_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($custom_field)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($custom_field));
            } else {
                $httpBody = $custom_field;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
