<?php
/**
 * CategoryApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Catalog
 *
 * Manage products, brands and categories. To learn more about catalog resources see [Catalog Overview](https://developer.bigcommerce.com/api-docs/catalog/products-overview).  - [Authentication](#authentication) - [Differentiating Variants & Modifiers](#variants-and-modifiers) - [Available Endpoints](#available-endpoints) - [Resources](#resources)  ## Authentication Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes | UI Name  | Permission | Parameter                     | |----------|------------|-------------------------------| | Products | modify     | `store_v2_products`           | | Products | read-only  | `store_v2_products_read_only` |  For more information on OAuth Scopes, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Differentiating Variants and Modifiers [Variants](https://support.bigcommerce.com/s/article/Product-Options-v3#variations) represent a physical product made up of [Product Option](https://support.bigcommerce.com/s/article/Product-Options-v3) choices, i.e. a large blue t-shirt. Each variant can have a unique SKU.  Modifiers represent a choice a customer makes about a product that doesn't represent a physical item, i.e. text to be printed on a t-shirt. Assigning a SKU to a modifier will turn it into a variant.  See [Variant Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#variant-options) and [Modifier Options](https://developer.bigcommerce.com/api-docs/catalog/products-overview#modifier-options) for more information.  ## Available Endpoints | Resource / Endpoint                     | Description                                                             | |-----------------------------------------|-------------------------------------------------------------------------| | Brand Images                            | Create and manage brand images                                          | | Brand Metafields                        | Create and manage brand metafields                                      | | Brands                                  | Create and manage brands                                                | | Catalog                                 | Create and manage store categories, products, and brands                | | Categories                              | Create and manage categorties                                           | | Category Images                         | Create and manage category images                                       | | Category Metafields                     | Create and manage category metafields                                   | | Product Bulk Pricing Rules              | Create and manage product bulk pricing rules                            | | Product Complex Rules                   | Create and manage product complex rules                                 | | Product Custom Fields                   | Create and manage product custom fields                                 | | Product Images                          | Create and manage product images                                        | | Product Metafields                      | Create and manage product meta fields                                   | | Product Modifier Images                 | Create and manage product modifer images                                | | Product Modifier Values                 | Create and manage product modifier values                               | | Product Modifiers                       | Create and manage product midifiers                                     | | Product Reviews                         | Create and manage product reviews                                       | | Product Variant Option Values           | Create and manage product variant option values                         | | Product Variant Options                 | Create and manage product variant options                               | | Product Variants                        | Create and manage product variants                                      | | Product Videos                          | Create and manage product videos                                        | | Products                                | Create and manage products                                              | | ProductVariant Metafields               | Create and manage product meta flields                                  | | Variants                                | Get and update all variants                                             |  ## Resources  ### Webhooks * [Products](/api-docs/getting-started/webhooks/webhook-events#webhook-events_products) * [Categories](/api-docs/getting-started/webhooks/webhook-events#webhook-events_category) * [SKU](/api-docs/getting-started/webhooks/webhook-events#webhook-events_sku)  ### Related Endpoints * [Catalog API](/api-reference/catalog/catalog-api)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CatalogV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CatalogV3\ApiException;
use Bigcommerce\CatalogV3\Configuration;
use Bigcommerce\CatalogV3\FormDataProcessor;
use Bigcommerce\CatalogV3\HeaderSelector;
use Bigcommerce\CatalogV3\ObjectSerializer;

/**
 * CategoryApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CatalogV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CategoryApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createCategory' => [
            'application/json',
        ],
        'deleteCategories' => [
            'application/json',
        ],
        'deleteCategoryById' => [
            'application/json',
        ],
        'getCategories' => [
            'application/json',
        ],
        'getCategoryById' => [
            'application/json',
        ],
        'getCategoryTree' => [
            'application/json',
        ],
        'updateCategory' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createCategory
     *
     * Create a Category
     *
     * @param  \Bigcommerce\CatalogV3\Model\Category $category category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\CategoryResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse
     */
    public function createCategory($category, string $contentType = self::contentTypes['createCategory'][0])
    {
        list($response) = $this->createCategoryWithHttpInfo($category, $contentType);
        return $response;
    }

    /**
     * Operation createCategoryWithHttpInfo
     *
     * Create a Category
     *
     * @param  \Bigcommerce\CatalogV3\Model\Category $category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\CategoryResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCategoryWithHttpInfo($category, string $contentType = self::contentTypes['createCategory'][0])
    {
        $request = $this->createCategoryRequest($category, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\CategoryResponse',
                        $request,
                        $response,
                    );
                case 409:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\CategoryResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\CategoryResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createCategoryAsync
     *
     * Create a Category
     *
     * @param  \Bigcommerce\CatalogV3\Model\Category $category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCategoryAsync($category, string $contentType = self::contentTypes['createCategory'][0])
    {
        return $this->createCategoryAsyncWithHttpInfo($category, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCategoryAsyncWithHttpInfo
     *
     * Create a Category
     *
     * @param  \Bigcommerce\CatalogV3\Model\Category $category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCategoryAsyncWithHttpInfo($category, string $contentType = self::contentTypes['createCategory'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\CategoryResponse';
        $request = $this->createCategoryRequest($category, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCategory'
     *
     * @param  \Bigcommerce\CatalogV3\Model\Category $category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCategoryRequest($category, string $contentType = self::contentTypes['createCategory'][0])
    {

        // verify the required parameter 'category' is set
        if ($category === null || (is_array($category) && count($category) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category when calling createCategory'
            );
        }


        $resourcePath = '/catalog/categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($category)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($category));
            } else {
                $httpBody = $category;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCategories
     *
     * Delete Categories
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategories'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteCategories($name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, string $contentType = self::contentTypes['deleteCategories'][0])
    {
        $this->deleteCategoriesWithHttpInfo($name, $parent_id, $page_title, $keyword, $is_visible, $contentType);
    }

    /**
     * Operation deleteCategoriesWithHttpInfo
     *
     * Delete Categories
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategories'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCategoriesWithHttpInfo($name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, string $contentType = self::contentTypes['deleteCategories'][0])
    {
        $request = $this->deleteCategoriesRequest($name, $parent_id, $page_title, $keyword, $is_visible, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteCategoriesAsync
     *
     * Delete Categories
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCategoriesAsync($name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, string $contentType = self::contentTypes['deleteCategories'][0])
    {
        return $this->deleteCategoriesAsyncWithHttpInfo($name, $parent_id, $page_title, $keyword, $is_visible, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCategoriesAsyncWithHttpInfo
     *
     * Delete Categories
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCategoriesAsyncWithHttpInfo($name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, string $contentType = self::contentTypes['deleteCategories'][0])
    {
        $returnType = '';
        $request = $this->deleteCategoriesRequest($name, $parent_id, $page_title, $keyword, $is_visible, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCategories'
     *
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCategoriesRequest($name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, string $contentType = self::contentTypes['deleteCategories'][0])
    {







        $resourcePath = '/catalog/categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $parent_id,
            'parent_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_title,
            'page_title', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $keyword,
            'keyword', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_visible,
            'is_visible', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCategoryById
     *
     * Delete a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteCategoryById($category_id, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {
        $this->deleteCategoryByIdWithHttpInfo($category_id, $contentType);
    }

    /**
     * Operation deleteCategoryByIdWithHttpInfo
     *
     * Delete a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCategoryByIdWithHttpInfo($category_id, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {
        $request = $this->deleteCategoryByIdRequest($category_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteCategoryByIdAsync
     *
     * Delete a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCategoryByIdAsync($category_id, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {
        return $this->deleteCategoryByIdAsyncWithHttpInfo($category_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCategoryByIdAsyncWithHttpInfo
     *
     * Delete a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCategoryByIdAsyncWithHttpInfo($category_id, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {
        $returnType = '';
        $request = $this->deleteCategoryByIdRequest($category_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCategoryById'
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCategoryByIdRequest($category_id, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {

        // verify the required parameter 'category_id' is set
        if ($category_id === null || (is_array($category_id) && count($category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category_id when calling deleteCategoryById'
            );
        }


        $resourcePath = '/catalog/categories/{category_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'category_id' . '}',
                ObjectSerializer::toPathValue($category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCategories
     *
     * Get All Categories
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in id_in (optional)
     * @param  int[]|null $id_not_in id_not_in (optional)
     * @param  int[]|null $id_min id_min (optional)
     * @param  int[]|null $id_max id_max (optional)
     * @param  int[]|null $id_greater id_greater (optional)
     * @param  int[]|null $id_less id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\CategoryBase
     */
    public function getCategories($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategories'][0])
    {
        list($response) = $this->getCategoriesWithHttpInfo($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $parent_id, $page_title, $keyword, $is_visible, $page, $limit, $include_fields, $exclude_fields, $contentType);
        return $response;
    }

    /**
     * Operation getCategoriesWithHttpInfo
     *
     * Get All Categories
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in (optional)
     * @param  int[]|null $id_not_in (optional)
     * @param  int[]|null $id_min (optional)
     * @param  int[]|null $id_max (optional)
     * @param  int[]|null $id_greater (optional)
     * @param  int[]|null $id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\CategoryBase, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoriesWithHttpInfo($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategories'][0])
    {
        $request = $this->getCategoriesRequest($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $parent_id, $page_title, $keyword, $is_visible, $page, $limit, $include_fields, $exclude_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\CategoryBase',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\CategoryBase',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\CategoryBase',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCategoriesAsync
     *
     * Get All Categories
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in (optional)
     * @param  int[]|null $id_not_in (optional)
     * @param  int[]|null $id_min (optional)
     * @param  int[]|null $id_max (optional)
     * @param  int[]|null $id_greater (optional)
     * @param  int[]|null $id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoriesAsync($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategories'][0])
    {
        return $this->getCategoriesAsyncWithHttpInfo($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $parent_id, $page_title, $keyword, $is_visible, $page, $limit, $include_fields, $exclude_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCategoriesAsyncWithHttpInfo
     *
     * Get All Categories
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in (optional)
     * @param  int[]|null $id_not_in (optional)
     * @param  int[]|null $id_min (optional)
     * @param  int[]|null $id_max (optional)
     * @param  int[]|null $id_greater (optional)
     * @param  int[]|null $id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoriesAsyncWithHttpInfo($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategories'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\CategoryBase';
        $request = $this->getCategoriesRequest($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $parent_id, $page_title, $keyword, $is_visible, $page, $limit, $include_fields, $exclude_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCategories'
     *
     * @param  int|null $id Filter items by id. (optional)
     * @param  int[]|null $id_in (optional)
     * @param  int[]|null $id_not_in (optional)
     * @param  int[]|null $id_min (optional)
     * @param  int[]|null $id_max (optional)
     * @param  int[]|null $id_greater (optional)
     * @param  int[]|null $id_less (optional)
     * @param  string|null $name Filter items by name. (optional)
     * @param  int|null $parent_id Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. (optional)
     * @param  string|null $page_title Filter items by page_title. (optional)
     * @param  string|null $keyword Filter items by keywords. eg. new, towel, bath (optional)
     * @param  bool|null $is_visible Filter items by if visible on the storefront. (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of products. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCategoriesRequest($id = null, $id_in = null, $id_not_in = null, $id_min = null, $id_max = null, $id_greater = null, $id_less = null, $name = null, $parent_id = null, $page_title = null, $keyword = null, $is_visible = null, $page = null, $limit = null, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategories'][0])
    {


















        $resourcePath = '/catalog/categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_not_in,
            'id:not_in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_min,
            'id:min', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_max,
            'id:max', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_greater,
            'id:greater', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_less,
            'id:less', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $parent_id,
            'parent_id', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_title,
            'page_title', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $keyword,
            'keyword', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_visible,
            'is_visible', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCategoryById
     *
     * Get a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\CategoryResponse|\Bigcommerce\CatalogV3\Model\NotFound
     */
    public function getCategoryById($category_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategoryById'][0])
    {
        list($response) = $this->getCategoryByIdWithHttpInfo($category_id, $include_fields, $exclude_fields, $contentType);
        return $response;
    }

    /**
     * Operation getCategoryByIdWithHttpInfo
     *
     * Get a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\CategoryResponse|\Bigcommerce\CatalogV3\Model\NotFound, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoryByIdWithHttpInfo($category_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategoryById'][0])
    {
        $request = $this->getCategoryByIdRequest($category_id, $include_fields, $exclude_fields, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\CategoryResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\CategoryResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\CategoryResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCategoryByIdAsync
     *
     * Get a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoryByIdAsync($category_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategoryById'][0])
    {
        return $this->getCategoryByIdAsyncWithHttpInfo($category_id, $include_fields, $exclude_fields, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCategoryByIdAsyncWithHttpInfo
     *
     * Get a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoryByIdAsyncWithHttpInfo($category_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategoryById'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\CategoryResponse';
        $request = $this->getCategoryByIdRequest($category_id, $include_fields, $exclude_fields, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCategoryById'
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  string|null $include_fields Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     * @param  string|null $exclude_fields Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCategoryByIdRequest($category_id, $include_fields = null, $exclude_fields = null, string $contentType = self::contentTypes['getCategoryById'][0])
    {

        // verify the required parameter 'category_id' is set
        if ($category_id === null || (is_array($category_id) && count($category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category_id when calling getCategoryById'
            );
        }




        $resourcePath = '/catalog/categories/{category_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_fields,
            'include_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_fields,
            'exclude_fields', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'category_id' . '}',
                ObjectSerializer::toPathValue($category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCategoryTree
     *
     * Get Category Tree
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryTree'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\CategoriesTreeResp
     */
    public function getCategoryTree(string $contentType = self::contentTypes['getCategoryTree'][0])
    {
        list($response) = $this->getCategoryTreeWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getCategoryTreeWithHttpInfo
     *
     * Get Category Tree
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryTree'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\CategoriesTreeResp, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoryTreeWithHttpInfo(string $contentType = self::contentTypes['getCategoryTree'][0])
    {
        $request = $this->getCategoryTreeRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\CategoriesTreeResp',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\CategoriesTreeResp',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\CategoriesTreeResp',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCategoryTreeAsync
     *
     * Get Category Tree
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryTree'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoryTreeAsync(string $contentType = self::contentTypes['getCategoryTree'][0])
    {
        return $this->getCategoryTreeAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCategoryTreeAsyncWithHttpInfo
     *
     * Get Category Tree
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryTree'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoryTreeAsyncWithHttpInfo(string $contentType = self::contentTypes['getCategoryTree'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\CategoriesTreeResp';
        $request = $this->getCategoryTreeRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCategoryTree'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryTree'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCategoryTreeRequest(string $contentType = self::contentTypes['getCategoryTree'][0])
    {


        $resourcePath = '/catalog/categories/tree';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateCategory
     *
     * Update a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\Category $category category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCategory'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CatalogV3\Model\CategoryResponse1|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse
     */
    public function updateCategory($category_id, $category, string $contentType = self::contentTypes['updateCategory'][0])
    {
        list($response) = $this->updateCategoryWithHttpInfo($category_id, $category, $contentType);
        return $response;
    }

    /**
     * Operation updateCategoryWithHttpInfo
     *
     * Update a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\Category $category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCategory'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CatalogV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CatalogV3\Model\CategoryResponse1|\Bigcommerce\CatalogV3\Model\NotFound|\Bigcommerce\CatalogV3\Model\ErrorResponse|\Bigcommerce\CatalogV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCategoryWithHttpInfo($category_id, $category, string $contentType = self::contentTypes['updateCategory'][0])
    {
        $request = $this->updateCategoryRequest($category_id, $category, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\CategoryResponse1',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $request,
                        $response,
                    );
                case 409:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CatalogV3\Model\CategoryResponse1',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\CategoryResponse1',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\NotFound',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CatalogV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateCategoryAsync
     *
     * Update a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\Category $category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCategoryAsync($category_id, $category, string $contentType = self::contentTypes['updateCategory'][0])
    {
        return $this->updateCategoryAsyncWithHttpInfo($category_id, $category, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateCategoryAsyncWithHttpInfo
     *
     * Update a Category
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\Category $category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCategoryAsyncWithHttpInfo($category_id, $category, string $contentType = self::contentTypes['updateCategory'][0])
    {
        $returnType = '\Bigcommerce\CatalogV3\Model\CategoryResponse1';
        $request = $this->updateCategoryRequest($category_id, $category, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateCategory'
     *
     * @param  int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param  \Bigcommerce\CatalogV3\Model\Category $category (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateCategoryRequest($category_id, $category, string $contentType = self::contentTypes['updateCategory'][0])
    {

        // verify the required parameter 'category_id' is set
        if ($category_id === null || (is_array($category_id) && count($category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category_id when calling updateCategory'
            );
        }

        // verify the required parameter 'category' is set
        if ($category === null || (is_array($category) && count($category) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category when calling updateCategory'
            );
        }


        $resourcePath = '/catalog/categories/{category_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'category_id' . '}',
                ObjectSerializer::toPathValue($category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($category)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($category));
            } else {
                $httpBody = $category;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
