# # ProductBase

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **string** | The product name. |
**type** | **string** | The product type. One of: &#x60;physical&#x60; - a physical stock unit, &#x60;digital&#x60; - a digital download. |
**sku** | **string** | User defined product code/stock keeping unit (SKU). | [optional]
**description** | **string** | The product description, which can include HTML formatting. | [optional]
**weight** | **float** | Weight of the product, which can be used when calculating shipping costs. This is based on the unit set on the store |
**width** | **float** | Width of the product, which can be used when calculating shipping costs. | [optional]
**depth** | **float** | Depth of the product, which can be used when calculating shipping costs. | [optional]
**height** | **float** | Height of the product, which can be used when calculating shipping costs. | [optional]
**price** | **float** | The price of the product. The price should include or exclude tax, based on the store settings. |
**cost_price** | **float** | The cost price of the product. Stored for reference only; it is not used or displayed anywhere on the store. | [optional]
**retail_price** | **float** | The retail cost of the product. If entered, the retail cost price will be shown on the product page. | [optional]
**sale_price** | **float** | If entered, the sale price will be used instead of value in the price field when calculating the product&#39;s cost. | [optional]
**tax_class_id** | **int** | The ID of the tax class applied to the product. (NOTE: Value ignored if automatic tax is enabled.) | [optional]
**product_tax_code** | **string** | Accepts AvaTax System Tax Codes, which identify products and services that fall into special sales-tax categories. By using these codes, merchants who subscribe to BigCommerce&#39;s Avalara Premium integration can calculate sales taxes more accurately. Stores without Avalara Premium will ignore the code when calculating sales tax. Do not pass more than one code. The codes are case-sensitive. For details, please see Avalara&#39;s documentation. | [optional]
**categories** | **int[]** | An array of IDs for the categories to which this product belongs. When updating a product, if an array of categories is supplied, all product categories will be overwritten. Does not accept more than 1,000 ID values. | [optional]
**brand_id** | **int** | A product can be added to an existing brand during a product /PUT or /POST. | [optional]
**inventory_level** | **int** | Current inventory level of the product. Simple inventory tracking must be enabled (See the &#x60;inventory_tracking&#x60; field) for this to take any effect. | [optional]
**inventory_warning_level** | **int** | Inventory warning level for the product. When the product&#39;s inventory level drops below the warning level, the store owner will be informed. Simple inventory tracking must be enabled (see the &#x60;inventory_tracking&#x60; field) for this to take any effect. | [optional]
**inventory_tracking** | **string** | The type of inventory tracking for the product. Values are: &#x60;none&#x60; - inventory levels will not be tracked; &#x60;product&#x60; - inventory levels will be tracked using the &#x60;inventory_level&#x60; and &#x60;inventory_warning_level&#x60; fields; &#x60;variant&#x60; - inventory levels will be tracked based on variants, which maintain their own warning levels and inventory levels. | [optional]
**fixed_cost_shipping_price** | **float** | A fixed shipping cost for the product. If defined, this value will be used during checkout instead of normal shipping-cost calculation. | [optional]
**is_free_shipping** | **bool** | Flag used to indicate whether the product has free shipping. If &#x60;true&#x60;, the shipping cost for the product will be zero. | [optional]
**is_visible** | **bool** | Flag to determine whether the product should be displayed to customers browsing the store. If &#x60;true&#x60;, the product will be displayed. If &#x60;false&#x60;, the product will be hidden from view. | [optional]
**is_featured** | **bool** | Flag to determine whether the product should be included in the &#x60;featured products&#x60; panel when viewing the store. | [optional]
**related_products** | **int[]** | An array of IDs for the related products. | [optional]
**warranty** | **string** | Warranty information displayed on the product page. Can include HTML formatting. | [optional]
**bin_picking_number** | **string** | The BIN picking number for the product. | [optional]
**layout_file** | **string** | The layout template file used to render this product category. This field is writable only for stores with a Blueprint theme applied. | [optional]
**upc** | **string** | The product UPC code, which is used in feeds for shopping comparison sites and external channel integrations. | [optional]
**search_keywords** | **string** | A comma-separated list of keywords that can be used to locate the product when searching the store. | [optional]
**availability** | **string** | Availability of the product. Availability options are: &#x60;available&#x60; - the product can be purchased on the storefront; &#x60;disabled&#x60; - the product is listed in the storefront, but cannot be purchased; &#x60;preorder&#x60; - the product is listed for pre-orders. | [optional]
**availability_description** | **string** | Availability text displayed on the checkout page, under the product title. Tells the customer how long it will normally take to ship this product, such as: &#39;Usually ships in 24 hours.&#39; | [optional]
**gift_wrapping_options_type** | **string** | Type of gift-wrapping options. Values: &#x60;any&#x60; - allow any gift-wrapping options in the store; &#x60;none&#x60; - disallow gift-wrapping on the product; &#x60;list&#x60; – provide a list of IDs in the &#x60;gift_wrapping_options_list&#x60; field. | [optional]
**gift_wrapping_options_list** | **int[]** | A list of gift-wrapping option IDs. | [optional]
**sort_order** | **int** | Priority to give this product when included in product lists on category pages and in search results. Lower integers will place the product closer to the top of the results. | [optional]
**condition** | **string** | The product condition. Will be shown on the product page if the &#x60;is_condition_shown&#x60; field&#39;s value is &#x60;true&#x60;. Possible values: &#x60;New&#x60;, &#x60;Used&#x60;, &#x60;Refurbished&#x60;. | [optional]
**is_condition_shown** | **bool** | Flag used to determine whether the product condition is shown to the customer on the product page. | [optional]
**order_quantity_minimum** | **int** | The minimum quantity an order must contain, to be eligible to purchase this product. | [optional]
**order_quantity_maximum** | **int** | The maximum quantity an order can contain when purchasing the product. | [optional]
**page_title** | **string** | Custom title for the product page. If not defined, the product name will be used as the meta title. | [optional]
**meta_keywords** | **string[]** | Custom meta keywords for the product page. If not defined, the store&#39;s default keywords will be used. | [optional]
**meta_description** | **string** | Custom meta description for the product page. If not defined, the store&#39;s default meta description will be used. | [optional]
**view_count** | **int** | The number of times the product has been viewed. | [optional]
**preorder_release_date** | **\DateTime** | Pre-order release date. See the &#x60;availability&#x60; field for details on setting a product&#39;s availability to accept pre-orders. | [optional]
**preorder_message** | **string** | Custom expected-date message to display on the product page. If undefined, the message defaults to the storewide setting. Can contain the &#x60;%%DATE%%&#x60; placeholder, which will be substituted for the release date. | [optional]
**is_preorder_only** | **bool** | If set to true then on the preorder release date the preorder status will automatically be removed. If set to false, then on the release date the preorder status **will not** be removed. It will need to be changed manually either in the control panel or using the API. Using the API set &#x60;availability&#x60; to &#x60;available&#x60;. | [optional]
**is_price_hidden** | **bool** | False by default, indicating that this product&#39;s price should be shown on the product page. If set to &#x60;true&#x60;, the price is hidden. (NOTE: To successfully set &#x60;is_price_hidden&#x60; to &#x60;true&#x60;, the &#x60;availability&#x60; value must be &#x60;disabled&#x60;.) | [optional]
**price_hidden_label** | **string** | By default, an empty string. If &#x60;is_price_hidden&#x60; is &#x60;true&#x60;, the value of &#x60;price_hidden_label&#x60; is displayed instead of the price. (NOTE: To successfully set a non-empty string value with &#x60;is_price_hidden&#x60; set to &#x60;true&#x60;, the &#x60;availability&#x60; value must be &#x60;disabled&#x60;.) | [optional]
**custom_url** | [**\Bigcommerce\CatalogV3\Model\CustomUrlFull**](CustomUrlFull.md) |  | [optional]
**open_graph_type** | **string** | Type of product, defaults to &#x60;product&#x60;. | [optional]
**open_graph_title** | **string** | Title of the product, if not specified the product name will be used instead. | [optional]
**open_graph_description** | **string** | Description to use for the product, if not specified then the meta_description will be used instead. | [optional]
**open_graph_use_meta_description** | **bool** | Flag to determine if product description or open graph description is used. | [optional]
**open_graph_use_product_name** | **bool** | Flag to determine if product name or open graph name is used. | [optional]
**open_graph_use_image** | **bool** | Flag to determine if product image or open graph image is used. | [optional]
**brand_name** | **string** | The brand can be created during a product PUT or POST request. If the brand already exists then the product will be added. If not the brand will be created and the product added. If using &#x60;brand_name&#x60; it performs a fuzzy match and adds the brand. eg. \&quot;Common Good\&quot; and \&quot;Common good\&quot; are the same. Brand name does not return as part of a product response. Only the &#x60;brand_id&#x60;. | [optional]
**gtin** | **string** | Global Trade Item Number | [optional]
**mpn** | **string** | Manufacturer Part Number | [optional]
**reviews_rating_sum** | **int** | The total rating for the product. | [optional]
**reviews_count** | **int** | The number of times the product has been rated. | [optional]
**total_sold** | **int** | The total quantity of this product sold. | [optional]
**custom_fields** | [**\Bigcommerce\CatalogV3\Model\ProductCustomFieldPut[]**](ProductCustomFieldPut.md) |  | [optional]
**bulk_pricing_rules** | [**\Bigcommerce\CatalogV3\Model\BulkPricingRuleFull[]**](BulkPricingRuleFull.md) |  | [optional]
**images** | [**\Bigcommerce\CatalogV3\Model\ProductImageFull[]**](ProductImageFull.md) |  | [optional]
**videos** | [**\Bigcommerce\CatalogV3\Model\ProductVideoFull[]**](ProductVideoFull.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
