# Bigcommerce\CatalogV3\VariantsApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getVariants()**](VariantsApi.md#getVariants) | **GET** /catalog/variants | Get All Variants |
| [**updateVariantsBatch()**](VariantsApi.md#updateVariantsBatch) | **PUT** /catalog/variants | Update Variants (Batch) |


## `getVariants()`

```php
getVariants($id, $sku, $page, $limit, $include_fields, $exclude_fields, $product_id): \Bigcommerce\CatalogV3\Model\VariantCollectionResponse1
```

Get All Variants

Returns a list of all variants in your catalog. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\VariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Filter items by id.
$sku = 'sku_example'; // string | Filter items by sku.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.
$product_id = 'product_id_example'; // string | A comma-separated list of ids of Products whose prices were requested. For example: `?product_id=:id` `?product_id:in=77,80,81`

try {
    $result = $apiInstance->getVariants($id, $sku, $page, $limit, $include_fields, $exclude_fields, $product_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VariantsApi->getVariants: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Filter items by id. | [optional] |
| **sku** | **string**| Filter items by sku. | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |
| **product_id** | **string**| A comma-separated list of ids of Products whose prices were requested. For example: &#x60;?product_id&#x3D;:id&#x60; &#x60;?product_id:in&#x3D;77,80,81&#x60; | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\VariantCollectionResponse1**](../Model/VariantCollectionResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateVariantsBatch()`

```php
updateVariantsBatch($body): \Bigcommerce\CatalogV3\Model\VariantCollectionResponse2
```

Update Variants (Batch)

Creates or updates a batch of `Variant` objects. At the time of writing, the current limit is `50` variants. This limit is subject to change.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\VariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = array(new \Bigcommerce\CatalogV3\Model\VariantPut()); // \Bigcommerce\CatalogV3\Model\VariantPut[]

try {
    $result = $apiInstance->updateVariantsBatch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VariantsApi->updateVariantsBatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Bigcommerce\CatalogV3\Model\VariantPut[]**](../Model/VariantPut.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\VariantCollectionResponse2**](../Model/VariantCollectionResponse2.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
