# Bigcommerce\CatalogV3\SummaryApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getCatalogSummary()**](SummaryApi.md#getCatalogSummary) | **GET** /catalog/summary | Get a Catalog Summary |


## `getCatalogSummary()`

```php
getCatalogSummary(): \Bigcommerce\CatalogV3\Model\CatalogSummaryResponse
```

Get a Catalog Summary

Returns a lightweight inventory summary from the BigCommerce Catalog.  The inventory summary includes: * \"inventory_count\" * \"variant_count\" * \"inventory_value\" * \"highest_variant_price\" * \"average_variant_price\" * \"lowest_variant_price\" * \"oldest_variant_date\" * \"newest_variant_date\" * \"primary_category_id\" * \"primary_category_name\"

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\SummaryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getCatalogSummary();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SummaryApi->getCatalogSummary: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\CatalogV3\Model\CatalogSummaryResponse**](../Model/CatalogSummaryResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
