# Bigcommerce\CatalogV3\ProductsApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createProduct()**](ProductsApi.md#createProduct) | **POST** /catalog/products | Create a Product |
| [**deleteProductById()**](ProductsApi.md#deleteProductById) | **DELETE** /catalog/products/{product_id} | Delete a Product |
| [**deleteProducts()**](ProductsApi.md#deleteProducts) | **DELETE** /catalog/products | Delete Products |
| [**getProductById()**](ProductsApi.md#getProductById) | **GET** /catalog/products/{product_id} | Get a Product |
| [**getProducts()**](ProductsApi.md#getProducts) | **GET** /catalog/products | Get All Products |
| [**updateProduct()**](ProductsApi.md#updateProduct) | **PUT** /catalog/products/{product_id} | Update a Product |
| [**updateProducts()**](ProductsApi.md#updateProducts) | **PUT** /catalog/products | Update Products (Batch) |


## `createProduct()`

```php
createProduct($product, $include_fields): \Bigcommerce\CatalogV3\Model\ProductResponse
```

Create a Product

Creates a *Product*. Only one product can be created at a time.  **Required Fields:** - `name` - `type` - `weight` - `price`  **Read-Only Fields** - `id` - `date_created` - `date_modified` - `calculated_price` - `base_variant_id`  **Usage Notes** * `POST` requests to `/products` accepts a single `video` object; to send an array of video objects, see: `/products/{product_id}/videos`.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product = new \Bigcommerce\CatalogV3\Model\ProductPost(); // \Bigcommerce\CatalogV3\Model\ProductPost
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.

try {
    $result = $apiInstance->createProduct($product, $include_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->createProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product** | [**\Bigcommerce\CatalogV3\Model\ProductPost**](../Model/ProductPost.md)|  | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductResponse**](../Model/ProductResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductById()`

```php
deleteProductById($product_id)
```

Delete a Product

Deletes a *Product*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.

try {
    $apiInstance->deleteProductById($product_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->deleteProductById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProducts()`

```php
deleteProducts($name, $sku, $price, $weight, $condition, $brand_id, $date_modified, $date_last_imported, $is_visible, $is_featured, $inventory_level, $total_sold, $type, $categories, $keyword)
```

Delete Products

To delete *Product* objects, you must include a filter. This prevents inadvertently deleting all *Product* objects in a store.  **Example**: To delete products with the id's of 1,2 and 3, use `DELETE /v3/catalog/products?id:in=1,2,3`.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$name = 'name_example'; // string | Filter items by name.
$sku = 'sku_example'; // string | Filter items by sku.
$price = 3.4; // float | Filter items by price.
$weight = 3.4; // float | Filter items by weight.
$condition = 'condition_example'; // string | Filter items by condition.
$brand_id = 56; // int | Filter items by brand_id.
$date_modified = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by date_modified. For example `v3/catalog/products?date_modified:min=2018-06-15`
$date_last_imported = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by date_last_imported. For example `v3/catalog/products?date_last_imported:min=2018-06-15`
$is_visible = True; // bool | Filter items by if visible on the storefront.
$is_featured = 56; // int | Filter items by is_featured.
$inventory_level = 56; // int | Filter items by inventory_level.
$total_sold = 56; // int | Filter items by total_sold.
$type = 'type_example'; // string | Filter items by type: `physical` or `digital`.
$categories = 56; // int | Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use `categories:in=12`.
$keyword = 'keyword_example'; // string | Filter items by keywords found in the `name`, `description`, or `sku` fields, or in the brand name.

try {
    $apiInstance->deleteProducts($name, $sku, $price, $weight, $condition, $brand_id, $date_modified, $date_last_imported, $is_visible, $is_featured, $inventory_level, $total_sold, $type, $categories, $keyword);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->deleteProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **name** | **string**| Filter items by name. | [optional] |
| **sku** | **string**| Filter items by sku. | [optional] |
| **price** | **float**| Filter items by price. | [optional] |
| **weight** | **float**| Filter items by weight. | [optional] |
| **condition** | **string**| Filter items by condition. | [optional] |
| **brand_id** | **int**| Filter items by brand_id. | [optional] |
| **date_modified** | **\DateTime**| Filter items by date_modified. For example &#x60;v3/catalog/products?date_modified:min&#x3D;2018-06-15&#x60; | [optional] |
| **date_last_imported** | **\DateTime**| Filter items by date_last_imported. For example &#x60;v3/catalog/products?date_last_imported:min&#x3D;2018-06-15&#x60; | [optional] |
| **is_visible** | **bool**| Filter items by if visible on the storefront. | [optional] |
| **is_featured** | **int**| Filter items by is_featured. | [optional] |
| **inventory_level** | **int**| Filter items by inventory_level. | [optional] |
| **total_sold** | **int**| Filter items by total_sold. | [optional] |
| **type** | **string**| Filter items by type: &#x60;physical&#x60; or &#x60;digital&#x60;. | [optional] |
| **categories** | **int**| Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. | [optional] |
| **keyword** | **string**| Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. | [optional] |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductById()`

```php
getProductById($product_id, $include, $include_fields, $exclude_fields, $price_list_id): \Bigcommerce\CatalogV3\Model\ProductResponse
```

Get a Product

Returns a single *Product*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$include = 'include_example'; // string | Sub-resources to include on a product, in a comma-separated list. If `options` or `modifiers` is used, results are limited to 10 per page.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.
$price_list_id = 56; // int | Filter by price_list_id.

try {
    $result = $apiInstance->getProductById($product_id, $include, $include_fields, $exclude_fields, $price_list_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProductById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **include** | **string**| Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. | [optional] |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |
| **price_list_id** | **int**| Filter by price_list_id. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductResponse**](../Model/ProductResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProducts()`

```php
getProducts($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $sku, $upc, $price, $weight, $condition, $brand_id, $date_modified, $date_modified_max, $date_modified_min, $date_last_imported, $date_last_imported_max, $date_last_imported_min, $is_visible, $is_featured, $is_free_shipping, $inventory_level, $inventory_level_in, $inventory_level_not_in, $inventory_level_min, $inventory_level_max, $inventory_level_greater, $inventory_level_less, $inventory_low, $out_of_stock, $total_sold, $type, $categories, $keyword, $keyword_context, $status, $include, $include_fields, $exclude_fields, $availability, $price_list_id, $page, $limit, $direction, $sort, $categories_in): \Bigcommerce\CatalogV3\Model\GetProducts200Response
```

Get All Products

Returns a list of **Products**. Optional filter parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Filter items by id.
$id_in = array(56); // int[]
$id_not_in = array(56); // int[]
$id_min = array(56); // int[]
$id_max = array(56); // int[]
$id_greater = array(56); // int[]
$id_less = array(56); // int[]
$name = 'name_example'; // string | Filter items by name.
$sku = 'sku_example'; // string | Filter items by sku.
$upc = 'upc_example'; // string | Filter items by upc.
$price = 3.4; // float | Filter items by price.
$weight = 3.4; // float | Filter items by weight.
$condition = 'condition_example'; // string | Filter items by condition.
$brand_id = 56; // int | Filter items by brand_id.
$date_modified = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by `date_modified`.
$date_modified_max = 'date_modified_max_example'; // string | Filter items by `date_modified`. For example, `date_modified:max=2020-06-15`.
$date_modified_min = 'date_modified_min_example'; // string | Filter items by `date_modified`. For example, `date_modified:min=2018-06-15`.
$date_last_imported = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter items by date_last_imported.
$date_last_imported_max = 'date_last_imported_max_example'; // string | Filter items by date_last_imported. For example, `date_last_imported:max=2020-06-15`.
$date_last_imported_min = 'date_last_imported_min_example'; // string | Filter items by date_last_imported. For example, `date_last_imported:min=2018-06-15`.
$is_visible = True; // bool | Filter items based on whether the product is currently visible on the storefront.
$is_featured = 56; // int | Filter items by is_featured. `0` for true, `1` for false.
$is_free_shipping = 56; // int | Filter items by is_free_shipping.
$inventory_level = 56; // int | Filter items by inventory_level.
$inventory_level_in = 56; // int
$inventory_level_not_in = 56; // int
$inventory_level_min = 56; // int
$inventory_level_max = 56; // int
$inventory_level_greater = 56; // int
$inventory_level_less = 56; // int
$inventory_low = 56; // int | Filter items by inventory_low. Values: 1, 0.
$out_of_stock = 56; // int | Filter items by out_of_stock. To enable the filter, pass `out_of_stock`=`1`.
$total_sold = 56; // int | Filter items by total_sold.
$type = 'type_example'; // string | Filter items by type.
$categories = 56; // int | Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use `categories:in=12`.
$keyword = 'keyword_example'; // string | Filter items by keywords found in the `name`, `description`, or `sku` fields, or in the brand name.
$keyword_context = 'keyword_context_example'; // string | Set context used by the search algorithm to return results targeted towards the specified group. Use `merchant` to help merchants search their own catalog. Use `shopper` to return shopper-facing search results.
$status = 56; // int | Filter items by status.
$include = 'include_example'; // string | Sub-resources to include on a product, in a comma-separated list. If `options` or `modifiers` is used, results are limited to 10 per page.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.
$availability = 'availability_example'; // string | Filter items by availability. Values are: available, disabled, preorder.
$price_list_id = 56; // int | This filter returns the product pricing with the *Price List* pricing instead. To use:`?price_list_id=1`.If there are variants use:`?price_list_id=1&include=variants`.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.
$direction = 'direction_example'; // string | Sort direction. Acceptable values are: `asc`, `desc`.
$sort = 'sort_example'; // string | Field name to sort by. Note: Since `id` increments when new products are added, you can use that field to sort by product create date.
$categories_in = 56; // int | Filter items by categories. Use for products in multiple categories. For example, `categories:in=12`.

try {
    $result = $apiInstance->getProducts($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $sku, $upc, $price, $weight, $condition, $brand_id, $date_modified, $date_modified_max, $date_modified_min, $date_last_imported, $date_last_imported_max, $date_last_imported_min, $is_visible, $is_featured, $is_free_shipping, $inventory_level, $inventory_level_in, $inventory_level_not_in, $inventory_level_min, $inventory_level_max, $inventory_level_greater, $inventory_level_less, $inventory_low, $out_of_stock, $total_sold, $type, $categories, $keyword, $keyword_context, $status, $include, $include_fields, $exclude_fields, $availability, $price_list_id, $page, $limit, $direction, $sort, $categories_in);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Filter items by id. | [optional] |
| **id_in** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_not_in** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_min** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_max** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_greater** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_less** | [**int[]**](../Model/int.md)|  | [optional] |
| **name** | **string**| Filter items by name. | [optional] |
| **sku** | **string**| Filter items by sku. | [optional] |
| **upc** | **string**| Filter items by upc. | [optional] |
| **price** | **float**| Filter items by price. | [optional] |
| **weight** | **float**| Filter items by weight. | [optional] |
| **condition** | **string**| Filter items by condition. | [optional] |
| **brand_id** | **int**| Filter items by brand_id. | [optional] |
| **date_modified** | **\DateTime**| Filter items by &#x60;date_modified&#x60;. | [optional] |
| **date_modified_max** | **string**| Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:max&#x3D;2020-06-15&#x60;. | [optional] |
| **date_modified_min** | **string**| Filter items by &#x60;date_modified&#x60;. For example, &#x60;date_modified:min&#x3D;2018-06-15&#x60;. | [optional] |
| **date_last_imported** | **\DateTime**| Filter items by date_last_imported. | [optional] |
| **date_last_imported_max** | **string**| Filter items by date_last_imported. For example, &#x60;date_last_imported:max&#x3D;2020-06-15&#x60;. | [optional] |
| **date_last_imported_min** | **string**| Filter items by date_last_imported. For example, &#x60;date_last_imported:min&#x3D;2018-06-15&#x60;. | [optional] |
| **is_visible** | **bool**| Filter items based on whether the product is currently visible on the storefront. | [optional] |
| **is_featured** | **int**| Filter items by is_featured. &#x60;0&#x60; for true, &#x60;1&#x60; for false. | [optional] |
| **is_free_shipping** | **int**| Filter items by is_free_shipping. | [optional] |
| **inventory_level** | **int**| Filter items by inventory_level. | [optional] |
| **inventory_level_in** | **int**|  | [optional] |
| **inventory_level_not_in** | **int**|  | [optional] |
| **inventory_level_min** | **int**|  | [optional] |
| **inventory_level_max** | **int**|  | [optional] |
| **inventory_level_greater** | **int**|  | [optional] |
| **inventory_level_less** | **int**|  | [optional] |
| **inventory_low** | **int**| Filter items by inventory_low. Values: 1, 0. | [optional] |
| **out_of_stock** | **int**| Filter items by out_of_stock. To enable the filter, pass &#x60;out_of_stock&#x60;&#x3D;&#x60;1&#x60;. | [optional] |
| **total_sold** | **int**| Filter items by total_sold. | [optional] |
| **type** | **string**| Filter items by type. | [optional] |
| **categories** | **int**| Filter items by categories.  If a product is in more than one category, using this query will not return the product. Instead use &#x60;categories:in&#x3D;12&#x60;. | [optional] |
| **keyword** | **string**| Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. | [optional] |
| **keyword_context** | **string**| Set context used by the search algorithm to return results targeted towards the specified group. Use &#x60;merchant&#x60; to help merchants search their own catalog. Use &#x60;shopper&#x60; to return shopper-facing search results. | [optional] |
| **status** | **int**| Filter items by status. | [optional] |
| **include** | **string**| Sub-resources to include on a product, in a comma-separated list. If &#x60;options&#x60; or &#x60;modifiers&#x60; is used, results are limited to 10 per page. | [optional] |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |
| **availability** | **string**| Filter items by availability. Values are: available, disabled, preorder. | [optional] |
| **price_list_id** | **int**| This filter returns the product pricing with the *Price List* pricing instead. To use:&#x60;?price_list_id&#x3D;1&#x60;.If there are variants use:&#x60;?price_list_id&#x3D;1&amp;include&#x3D;variants&#x60;. | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |
| **direction** | **string**| Sort direction. Acceptable values are: &#x60;asc&#x60;, &#x60;desc&#x60;. | [optional] |
| **sort** | **string**| Field name to sort by. Note: Since &#x60;id&#x60; increments when new products are added, you can use that field to sort by product create date. | [optional] |
| **categories_in** | **int**| Filter items by categories. Use for products in multiple categories. For example, &#x60;categories:in&#x3D;12&#x60;. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\GetProducts200Response**](../Model/GetProducts200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProduct()`

```php
updateProduct($product_id, $product, $include_fields): \Bigcommerce\CatalogV3\Model\ProductResponse
```

Update a Product

Updates a *Product*.  **Read-Only Fields** - id - date_created - date_modified - calculated_price - base_variant_id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$product = new \Bigcommerce\CatalogV3\Model\ProductPut(); // \Bigcommerce\CatalogV3\Model\ProductPut
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.

try {
    $result = $apiInstance->updateProduct($product_id, $product, $include_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->updateProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **product** | [**\Bigcommerce\CatalogV3\Model\ProductPut**](../Model/ProductPut.md)|  | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductResponse**](../Model/ProductResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProducts()`

```php
updateProducts($include_fields, $products): \Bigcommerce\CatalogV3\Model\GetProducts200Response
```

Update Products (Batch)

Updates products in batches. At the time of writing, batches are limited to 10 products.  **Required Fields** * `id` - product `id` is required for batch updates to products.  **Read-Only Fields** - `id` - `date_created` - `date_modified` - `calculated_price` - `base_variant_id`

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$products = array(new \Bigcommerce\CatalogV3\Model\ProductPut()); // \Bigcommerce\CatalogV3\Model\ProductPut[]

try {
    $result = $apiInstance->updateProducts($include_fields, $products);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->updateProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **products** | [**\Bigcommerce\CatalogV3\Model\ProductPut[]**](../Model/ProductPut.md)|  | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\GetProducts200Response**](../Model/GetProducts200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
