# Bigcommerce\CatalogV3\ProductVideosApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createProductVideo()**](ProductVideosApi.md#createProductVideo) | **POST** /catalog/products/{product_id}/videos | Create a Product Video |
| [**deleteProductVideo()**](ProductVideosApi.md#deleteProductVideo) | **DELETE** /catalog/products/{product_id}/videos/{id} | Delete a Product Video |
| [**getProductVideoById()**](ProductVideosApi.md#getProductVideoById) | **GET** /catalog/products/{product_id}/videos/{id} | Get a Product Video |
| [**getProductVideos()**](ProductVideosApi.md#getProductVideos) | **GET** /catalog/products/{product_id}/videos | Get All Product Videos |
| [**updateProductVideo()**](ProductVideosApi.md#updateProductVideo) | **PUT** /catalog/products/{product_id}/videos/{id} | Update a Product Video |


## `createProductVideo()`

```php
createProductVideo($product_id, $product_video): \Bigcommerce\CatalogV3\Model\ProductVideoResponse
```

Create a Product Video

Creates a *Product Video*.  **Required Fields** * video_id - Example: https://www.youtube.com/watch?v=`R12345677`  **Read-Only Fields** * id  Publicly accessible URLs are valid parameters. Videos must be loaded through YouTube at this time.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVideosApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$product_video = new \Bigcommerce\CatalogV3\Model\ProductVideoPost(); // \Bigcommerce\CatalogV3\Model\ProductVideoPost

try {
    $result = $apiInstance->createProductVideo($product_id, $product_video);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVideosApi->createProductVideo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **product_video** | [**\Bigcommerce\CatalogV3\Model\ProductVideoPost**](../Model/ProductVideoPost.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductVideoResponse**](../Model/ProductVideoResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductVideo()`

```php
deleteProductVideo($product_id, $id)
```

Delete a Product Video

Deletes a *Product Video*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVideosApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$id = 56; // int | The BigCommerce ID of the `Video`

try {
    $apiInstance->deleteProductVideo($product_id, $id);
} catch (Exception $e) {
    echo 'Exception when calling ProductVideosApi->deleteProductVideo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **id** | **int**| The BigCommerce ID of the &#x60;Video&#x60; | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductVideoById()`

```php
getProductVideoById($product_id, $id, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\ProductVideoResponse1
```

Get a Product Video

Returns a single *Product Video*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVideosApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$id = 56; // int | The BigCommerce ID of the `Video`
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getProductVideoById($product_id, $id, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVideosApi->getProductVideoById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **id** | **int**| The BigCommerce ID of the &#x60;Video&#x60; | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductVideoResponse1**](../Model/ProductVideoResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductVideos()`

```php
getProductVideos($product_id, $include_fields, $exclude_fields, $page, $limit): \Bigcommerce\CatalogV3\Model\ProductVideoCollectionResponse
```

Get All Product Videos

Returns a list of *Product Videos*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVideosApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.

try {
    $result = $apiInstance->getProductVideos($product_id, $include_fields, $exclude_fields, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVideosApi->getProductVideos: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductVideoCollectionResponse**](../Model/ProductVideoCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductVideo()`

```php
updateProductVideo($product_id, $id, $product_video): \Bigcommerce\CatalogV3\Model\ProductVideoResponse
```

Update a Product Video

Updates a *Product Video.  **Required Fields** * none  **Read-Only Fields** * id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVideosApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$id = 56; // int | The BigCommerce ID of the `Video`
$product_video = new \Bigcommerce\CatalogV3\Model\ProductVideoPut(); // \Bigcommerce\CatalogV3\Model\ProductVideoPut

try {
    $result = $apiInstance->updateProductVideo($product_id, $id, $product_video);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVideosApi->updateProductVideo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **id** | **int**| The BigCommerce ID of the &#x60;Video&#x60; | |
| **product_video** | [**\Bigcommerce\CatalogV3\Model\ProductVideoPut**](../Model/ProductVideoPut.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductVideoResponse**](../Model/ProductVideoResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
