# Bigcommerce\CatalogV3\ProductVariantsMetafieldsApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createVariantMetafield()**](ProductVariantsMetafieldsApi.md#createVariantMetafield) | **POST** /catalog/products/{product_id}/variants/{variant_id}/metafields | Create a Product Variant Metafield |
| [**deleteVariantMetafieldById()**](ProductVariantsMetafieldsApi.md#deleteVariantMetafieldById) | **DELETE** /catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id} | Delete a Variant Metafield |
| [**getVariantMetafieldByProductIdAndVariantId()**](ProductVariantsMetafieldsApi.md#getVariantMetafieldByProductIdAndVariantId) | **GET** /catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id} | Get Product Variant Metafields |
| [**getVariantMetafieldsByProductIdAndVariantId()**](ProductVariantsMetafieldsApi.md#getVariantMetafieldsByProductIdAndVariantId) | **GET** /catalog/products/{product_id}/variants/{variant_id}/metafields | Get Product Variant Metafields |
| [**updateVariantMetafield()**](ProductVariantsMetafieldsApi.md#updateVariantMetafield) | **PUT** /catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id} | Update Product Variant Metafields |


## `createVariantMetafield()`

```php
createVariantMetafield($product_id, $variant_id, $metafield): \Bigcommerce\CatalogV3\Model\MetafieldResponse
```

Create a Product Variant Metafield

Creates a product variant *Metafield*.  **Required Fields:** * permission_set * namespace * key * value  **Read-Only Fields** * id  **Note:** The max number of metafields allowed on each product, category, variant, or brand is fifty. For more information, see [Platform Limits](https://support.bigcommerce.com/s/article/Platform-Limits) in the Help Center.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantsMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$variant_id = 56; // int | ID of the variant on a product, or on an associated Price List Record.
$metafield = new \Bigcommerce\CatalogV3\Model\MetafieldPost(); // \Bigcommerce\CatalogV3\Model\MetafieldPost

try {
    $result = $apiInstance->createVariantMetafield($product_id, $variant_id, $metafield);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsMetafieldsApi->createVariantMetafield: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **variant_id** | **int**| ID of the variant on a product, or on an associated Price List Record. | |
| **metafield** | [**\Bigcommerce\CatalogV3\Model\MetafieldPost**](../Model/MetafieldPost.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\MetafieldResponse**](../Model/MetafieldResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteVariantMetafieldById()`

```php
deleteVariantMetafieldById($metafield_id, $product_id, $variant_id)
```

Delete a Variant Metafield

Deletes a product variant *Metafield*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantsMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$metafield_id = 56; // int | The ID of the `Metafield`.
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$variant_id = 56; // int | ID of the variant on a product, or on an associated Price List Record.

try {
    $apiInstance->deleteVariantMetafieldById($metafield_id, $product_id, $variant_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsMetafieldsApi->deleteVariantMetafieldById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **variant_id** | **int**| ID of the variant on a product, or on an associated Price List Record. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVariantMetafieldByProductIdAndVariantId()`

```php
getVariantMetafieldByProductIdAndVariantId($metafield_id, $product_id, $variant_id, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\MetafieldResponse1
```

Get Product Variant Metafields

Returns a single product variant *Metafield*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantsMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$metafield_id = 56; // int | The ID of the `Metafield`.
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$variant_id = 56; // int | ID of the variant on a product, or on an associated Price List Record.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getVariantMetafieldByProductIdAndVariantId($metafield_id, $product_id, $variant_id, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsMetafieldsApi->getVariantMetafieldByProductIdAndVariantId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **variant_id** | **int**| ID of the variant on a product, or on an associated Price List Record. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\MetafieldResponse1**](../Model/MetafieldResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVariantMetafieldsByProductIdAndVariantId()`

```php
getVariantMetafieldsByProductIdAndVariantId($product_id, $variant_id, $page, $limit, $key, $namespace, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\MetaFieldCollectionResponse
```

Get Product Variant Metafields

Returns a list of product variant *Metafields*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantsMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$variant_id = 56; // int | ID of the variant on a product, or on an associated Price List Record.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.
$key = 'key_example'; // string | Filter based on a metafield's key.
$namespace = 'namespace_example'; // string | Filter based on a metafield's namespace.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getVariantMetafieldsByProductIdAndVariantId($product_id, $variant_id, $page, $limit, $key, $namespace, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsMetafieldsApi->getVariantMetafieldsByProductIdAndVariantId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **variant_id** | **int**| ID of the variant on a product, or on an associated Price List Record. | |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |
| **key** | **string**| Filter based on a metafield&#39;s key. | [optional] |
| **namespace** | **string**| Filter based on a metafield&#39;s namespace. | [optional] |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\MetaFieldCollectionResponse**](../Model/MetaFieldCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateVariantMetafield()`

```php
updateVariantMetafield($metafield_id, $product_id, $variant_id, $metafield): \Bigcommerce\CatalogV3\Model\MetafieldResponse1
```

Update Product Variant Metafields

Updates a product variant *Metafield*.  **Required Fields:** * none  **Read-Only Fields** * id * These fields can only be modified by the app (API credentials) that created the metafield:  * namespace  * key  * permission_set  **Usage Notes** * Attempting to modify `namespace`, `key`, and `permission_set` fields using a client ID different from the one used to create those metafields will result in a 403 error message.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantsMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$metafield_id = 56; // int | The ID of the `Metafield`.
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$variant_id = 56; // int | ID of the variant on a product, or on an associated Price List Record.
$metafield = new \Bigcommerce\CatalogV3\Model\MetafieldPut(); // \Bigcommerce\CatalogV3\Model\MetafieldPut

try {
    $result = $apiInstance->updateVariantMetafield($metafield_id, $product_id, $variant_id, $metafield);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsMetafieldsApi->updateVariantMetafield: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **variant_id** | **int**| ID of the variant on a product, or on an associated Price List Record. | |
| **metafield** | [**\Bigcommerce\CatalogV3\Model\MetafieldPut**](../Model/MetafieldPut.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\MetafieldResponse1**](../Model/MetafieldResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
