# Bigcommerce\CatalogV3\ProductVariantOptionValuesApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createOptionValue()**](ProductVariantOptionValuesApi.md#createOptionValue) | **POST** /catalog/products/{product_id}/options/{option_id}/values | Create a Product Variant Option Value |
| [**deleteOptionValueById()**](ProductVariantOptionValuesApi.md#deleteOptionValueById) | **DELETE** /catalog/products/{product_id}/options/{option_id}/values/{value_id} | Delete a Product Variant Option Value |
| [**getOptionValueById()**](ProductVariantOptionValuesApi.md#getOptionValueById) | **GET** /catalog/products/{product_id}/options/{option_id}/values/{value_id} | Get a Product Variant Option Value |
| [**getOptionValues()**](ProductVariantOptionValuesApi.md#getOptionValues) | **GET** /catalog/products/{product_id}/options/{option_id}/values | Get All Product Variant Option Values |
| [**updateOptionValue()**](ProductVariantOptionValuesApi.md#updateOptionValue) | **PUT** /catalog/products/{product_id}/options/{option_id}/values/{value_id} | Update a Product Variant Option Value |


## `createOptionValue()`

```php
createOptionValue($product_id, $option_id, $option_value): \Bigcommerce\CatalogV3\Model\OptionValueResponse
```

Create a Product Variant Option Value

Creates a *Variant Option Value*.  **Required Fields** * label * sort_order  **Read-Only Fields** * id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantOptionValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$option_id = 56; // int | The ID of the `Option`.
$option_value = new \Bigcommerce\CatalogV3\Model\OptionValuePost(); // \Bigcommerce\CatalogV3\Model\OptionValuePost

try {
    $result = $apiInstance->createOptionValue($product_id, $option_id, $option_value);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantOptionValuesApi->createOptionValue: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **option_id** | **int**| The ID of the &#x60;Option&#x60;. | |
| **option_value** | [**\Bigcommerce\CatalogV3\Model\OptionValuePost**](../Model/OptionValuePost.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\OptionValueResponse**](../Model/OptionValueResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteOptionValueById()`

```php
deleteOptionValueById($product_id, $option_id, $value_id)
```

Delete a Product Variant Option Value

Deletes a *Variant Option Value*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantOptionValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$option_id = 56; // int | The ID of the `Option`.
$value_id = 56; // int | The ID of the `Modifier/Option Value`.

try {
    $apiInstance->deleteOptionValueById($product_id, $option_id, $value_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantOptionValuesApi->deleteOptionValueById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **option_id** | **int**| The ID of the &#x60;Option&#x60;. | |
| **value_id** | **int**| The ID of the &#x60;Modifier/Option Value&#x60;. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOptionValueById()`

```php
getOptionValueById($product_id, $option_id, $value_id, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\OptionValueResponse
```

Get a Product Variant Option Value

Returns a single *Variant Option Value*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantOptionValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$option_id = 56; // int | The ID of the `Option`.
$value_id = 56; // int | The ID of the `Modifier/Option Value`.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getOptionValueById($product_id, $option_id, $value_id, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantOptionValuesApi->getOptionValueById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **option_id** | **int**| The ID of the &#x60;Option&#x60;. | |
| **value_id** | **int**| The ID of the &#x60;Modifier/Option Value&#x60;. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\OptionValueResponse**](../Model/OptionValueResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOptionValues()`

```php
getOptionValues($product_id, $option_id, $include_fields, $exclude_fields, $page, $limit): \Bigcommerce\CatalogV3\Model\OptionValueCollectionResponse
```

Get All Product Variant Option Values

Returns a list of all *Variant Option Values*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantOptionValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$option_id = 56; // int | The ID of the `Option`.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.

try {
    $result = $apiInstance->getOptionValues($product_id, $option_id, $include_fields, $exclude_fields, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantOptionValuesApi->getOptionValues: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **option_id** | **int**| The ID of the &#x60;Option&#x60;. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\OptionValueCollectionResponse**](../Model/OptionValueCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateOptionValue()`

```php
updateOptionValue($product_id, $option_id, $value_id, $option_value): \Bigcommerce\CatalogV3\Model\OptionValueResponse
```

Update a Product Variant Option Value

Updates a *Variant Option Value*.  **Read-Only Fields** * id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductVariantOptionValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$option_id = 56; // int | The ID of the `Option`.
$value_id = 56; // int | The ID of the `Modifier/Option Value`.
$option_value = new \Bigcommerce\CatalogV3\Model\OptionValuePut(); // \Bigcommerce\CatalogV3\Model\OptionValuePut | A BigCommerce `OptionValue` object.

try {
    $result = $apiInstance->updateOptionValue($product_id, $option_id, $value_id, $option_value);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantOptionValuesApi->updateOptionValue: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **option_id** | **int**| The ID of the &#x60;Option&#x60;. | |
| **value_id** | **int**| The ID of the &#x60;Modifier/Option Value&#x60;. | |
| **option_value** | [**\Bigcommerce\CatalogV3\Model\OptionValuePut**](../Model/OptionValuePut.md)| A BigCommerce &#x60;OptionValue&#x60; object. | |

### Return type

[**\Bigcommerce\CatalogV3\Model\OptionValueResponse**](../Model/OptionValueResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
