# Bigcommerce\CatalogV3\ProductModifierValuesApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createModifierValue()**](ProductModifierValuesApi.md#createModifierValue) | **POST** /catalog/products/{product_id}/modifiers/{modifier_id}/values | Create Modifier Value |
| [**deleteModifierValueById()**](ProductModifierValuesApi.md#deleteModifierValueById) | **DELETE** /catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id} | Delete Modifier Value |
| [**getModifierValueById()**](ProductModifierValuesApi.md#getModifierValueById) | **GET** /catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id} | Get a Modifier Value |
| [**getModifierValues()**](ProductModifierValuesApi.md#getModifierValues) | **GET** /catalog/products/{product_id}/modifiers/{modifier_id}/values | Get All Modifier Values |
| [**updateModifierValue()**](ProductModifierValuesApi.md#updateModifierValue) | **PUT** /catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id} | Update a Modifier Value |


## `createModifierValue()`

```php
createModifierValue($product_id, $modifier_id, $modifier_value): \Bigcommerce\CatalogV3\Model\ModifierValueResponse
```

Create Modifier Value

Creates a *Modifier Value*.  **Required Fields** * label * sort_order  **Read-Only Fields** * id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductModifierValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$modifier_id = 56; // int | The ID of the `Modifier`.
$modifier_value = new \Bigcommerce\CatalogV3\Model\ModifierValuePost(); // \Bigcommerce\CatalogV3\Model\ModifierValuePost

try {
    $result = $apiInstance->createModifierValue($product_id, $modifier_id, $modifier_value);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductModifierValuesApi->createModifierValue: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **modifier_id** | **int**| The ID of the &#x60;Modifier&#x60;. | |
| **modifier_value** | [**\Bigcommerce\CatalogV3\Model\ModifierValuePost**](../Model/ModifierValuePost.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\ModifierValueResponse**](../Model/ModifierValueResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteModifierValueById()`

```php
deleteModifierValueById($product_id, $modifier_id, $value_id)
```

Delete Modifier Value

Deletes a *Modifier Value*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductModifierValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$modifier_id = 56; // int | The ID of the `Modifier`.
$value_id = 56; // int | The ID of the `Modifier/Option Value`.

try {
    $apiInstance->deleteModifierValueById($product_id, $modifier_id, $value_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductModifierValuesApi->deleteModifierValueById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **modifier_id** | **int**| The ID of the &#x60;Modifier&#x60;. | |
| **value_id** | **int**| The ID of the &#x60;Modifier/Option Value&#x60;. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getModifierValueById()`

```php
getModifierValueById($product_id, $modifier_id, $value_id, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\ModifierValueResponse1
```

Get a Modifier Value

Returns a single *Modifier Value*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductModifierValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$modifier_id = 56; // int | The ID of the `Modifier`.
$value_id = 56; // int | The ID of the `Modifier/Option Value`.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getModifierValueById($product_id, $modifier_id, $value_id, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductModifierValuesApi->getModifierValueById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **modifier_id** | **int**| The ID of the &#x60;Modifier&#x60;. | |
| **value_id** | **int**| The ID of the &#x60;Modifier/Option Value&#x60;. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ModifierValueResponse1**](../Model/ModifierValueResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getModifierValues()`

```php
getModifierValues($product_id, $modifier_id, $include_fields, $exclude_fields, $page, $limit): \Bigcommerce\CatalogV3\Model\ModifierValueCollectionResponse
```

Get All Modifier Values

Returns a list of all product *Modifier Values*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductModifierValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$modifier_id = 56; // int | The ID of the `Modifier`.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.

try {
    $result = $apiInstance->getModifierValues($product_id, $modifier_id, $include_fields, $exclude_fields, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductModifierValuesApi->getModifierValues: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **modifier_id** | **int**| The ID of the &#x60;Modifier&#x60;. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ModifierValueCollectionResponse**](../Model/ModifierValueCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateModifierValue()`

```php
updateModifierValue($product_id, $modifier_id, $value_id, $modifier_value): \Bigcommerce\CatalogV3\Model\ModifierValueResponse
```

Update a Modifier Value

Updates a *Modifier Value*.  **Required Fields** * none  **Read-Only Fields** * id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductModifierValuesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$modifier_id = 56; // int | The ID of the `Modifier`.
$value_id = 56; // int | The ID of the `Modifier/Option Value`.
$modifier_value = new \Bigcommerce\CatalogV3\Model\ModifierValuePut(); // \Bigcommerce\CatalogV3\Model\ModifierValuePut

try {
    $result = $apiInstance->updateModifierValue($product_id, $modifier_id, $value_id, $modifier_value);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductModifierValuesApi->updateModifierValue: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **modifier_id** | **int**| The ID of the &#x60;Modifier&#x60;. | |
| **value_id** | **int**| The ID of the &#x60;Modifier/Option Value&#x60;. | |
| **modifier_value** | [**\Bigcommerce\CatalogV3\Model\ModifierValuePut**](../Model/ModifierValuePut.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\ModifierValueResponse**](../Model/ModifierValueResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
