# Bigcommerce\CatalogV3\ProductImagesApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createProductImage()**](ProductImagesApi.md#createProductImage) | **POST** /catalog/products/{product_id}/images | Create a Product Image |
| [**deleteProductImage()**](ProductImagesApi.md#deleteProductImage) | **DELETE** /catalog/products/{product_id}/images/{image_id} | Delete a Product Image |
| [**getProductImageById()**](ProductImagesApi.md#getProductImageById) | **GET** /catalog/products/{product_id}/images/{image_id} | Get a Product Image |
| [**getProductImages()**](ProductImagesApi.md#getProductImages) | **GET** /catalog/products/{product_id}/images | Get All Product Images |
| [**updateProductImage()**](ProductImagesApi.md#updateProductImage) | **PUT** /catalog/products/{product_id}/images/{image_id} | Update a Product Image |


## `createProductImage()`

```php
createProductImage($product_id, $id, $product_id2, $image_file, $url_zoom, $url_standard, $url_thumbnail, $url_tiny, $date_modified, $is_thumbnail, $sort_order, $description, $image_url): \Bigcommerce\CatalogV3\Model\ProductImageResponse
```

Create a Product Image

Creates a *Product Image*.   **Required Fields** - `image_file`, or - `image_url`  **Usage Notes** - `image_url` - `255` character limit - For file uploads, use the `multipart/form-data` media type - Only one image at a time can be created - Supported image file types are BMP, GIF, JPEG, PNG, WBMP, XBM, and WEBP.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductImagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$id = 56; // int | The unique numeric ID of the image; increments sequentially.
$product_id2 = 56; // int | The unique numeric identifier for the product with which the image is associated.
$image_file = 'image_file_example'; // string | Must be sent as a multipart/form-data field in the request body.
$url_zoom = 'url_zoom_example'; // string | The zoom URL for this image. By default, this is used as the zoom image on product pages when zoom images are enabled.
$url_standard = 'url_standard_example'; // string | The standard URL for this image. By default, this is used for product-page images.
$url_thumbnail = 'url_thumbnail_example'; // string | The thumbnail URL for this image. By default, this is the image size used on the category page and in side panels.
$url_tiny = 'url_tiny_example'; // string | The tiny URL for this image. By default, this is the image size used for thumbnails beneath the product image on a product page.
$date_modified = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The date on which the product image was modified.
$is_thumbnail = True; // bool | Flag for identifying whether the image is used as the product's thumbnail.
$sort_order = 56; // int | The order in which the image will be displayed on the product page. Higher integers give the image a lower priority. When updating, if the image is given a lower priority, all images with a `sort_order` the same as or greater than the image's new `sort_order` value will have their `sort_order`s reordered.
$description = 'description_example'; // string | The description for the image.
$image_url = 'image_url_example'; // string | Must be a fully qualified URL path, including protocol. Limit of 8MB per file.

try {
    $result = $apiInstance->createProductImage($product_id, $id, $product_id2, $image_file, $url_zoom, $url_standard, $url_thumbnail, $url_tiny, $date_modified, $is_thumbnail, $sort_order, $description, $image_url);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductImagesApi->createProductImage: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **id** | **int**| The unique numeric ID of the image; increments sequentially. | [optional] |
| **product_id2** | **int**| The unique numeric identifier for the product with which the image is associated. | [optional] |
| **image_file** | **string**| Must be sent as a multipart/form-data field in the request body. | [optional] |
| **url_zoom** | **string**| The zoom URL for this image. By default, this is used as the zoom image on product pages when zoom images are enabled. | [optional] |
| **url_standard** | **string**| The standard URL for this image. By default, this is used for product-page images. | [optional] |
| **url_thumbnail** | **string**| The thumbnail URL for this image. By default, this is the image size used on the category page and in side panels. | [optional] |
| **url_tiny** | **string**| The tiny URL for this image. By default, this is the image size used for thumbnails beneath the product image on a product page. | [optional] |
| **date_modified** | **\DateTime**| The date on which the product image was modified. | [optional] |
| **is_thumbnail** | **bool**| Flag for identifying whether the image is used as the product&#39;s thumbnail. | [optional] |
| **sort_order** | **int**| The order in which the image will be displayed on the product page. Higher integers give the image a lower priority. When updating, if the image is given a lower priority, all images with a &#x60;sort_order&#x60; the same as or greater than the image&#39;s new &#x60;sort_order&#x60; value will have their &#x60;sort_order&#x60;s reordered. | [optional] |
| **description** | **string**| The description for the image. | [optional] |
| **image_url** | **string**| Must be a fully qualified URL path, including protocol. Limit of 8MB per file. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductImageResponse**](../Model/ProductImageResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `multipart/form-data`, `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductImage()`

```php
deleteProductImage($product_id, $image_id)
```

Delete a Product Image

Deletes a *Product Image*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductImagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$image_id = 56; // int | The ID of the `Image` that is being operated on.

try {
    $apiInstance->deleteProductImage($product_id, $image_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductImagesApi->deleteProductImage: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **image_id** | **int**| The ID of the &#x60;Image&#x60; that is being operated on. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductImageById()`

```php
getProductImageById($product_id, $image_id, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\ProductImageResponse1
```

Get a Product Image

Returns a single *Product Image*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductImagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$image_id = 56; // int | The ID of the `Image` that is being operated on.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getProductImageById($product_id, $image_id, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductImagesApi->getProductImageById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **image_id** | **int**| The ID of the &#x60;Image&#x60; that is being operated on. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductImageResponse1**](../Model/ProductImageResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductImages()`

```php
getProductImages($product_id, $page, $limit, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\ProductImageCollectionResponse
```

Get All Product Images

Returns a list of *Product Images*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductImagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getProductImages($product_id, $page, $limit, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductImagesApi->getProductImages: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductImageCollectionResponse**](../Model/ProductImageCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductImage()`

```php
updateProductImage($product_id, $image_id, $product_image): \Bigcommerce\CatalogV3\Model\ProductImageResponse2
```

Update a Product Image

Updates a *Product Image*.  **Usage Notes** - `image_url` - `255` character limit - For file uploads, send a POST request using the `multipart/form-data` media type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductImagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$image_id = 56; // int | The ID of the `Image` that is being operated on.
$product_image = new \Bigcommerce\CatalogV3\Model\ProductImagePut(); // \Bigcommerce\CatalogV3\Model\ProductImagePut

try {
    $result = $apiInstance->updateProductImage($product_id, $image_id, $product_image);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductImagesApi->updateProductImage: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **image_id** | **int**| The ID of the &#x60;Image&#x60; that is being operated on. | |
| **product_image** | [**\Bigcommerce\CatalogV3\Model\ProductImagePut**](../Model/ProductImagePut.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\ProductImageResponse2**](../Model/ProductImageResponse2.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
