# Bigcommerce\CatalogV3\ProductBulkPricingRulesApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createBulkPricingRule()**](ProductBulkPricingRulesApi.md#createBulkPricingRule) | **POST** /catalog/products/{product_id}/bulk-pricing-rules | Creates a Bulk Pricing Rule |
| [**deleteBulkPricingRuleById()**](ProductBulkPricingRulesApi.md#deleteBulkPricingRuleById) | **DELETE** /catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id} | Delete a Bulk Pricing Rule |
| [**getBulkPricingRuleById()**](ProductBulkPricingRulesApi.md#getBulkPricingRuleById) | **GET** /catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id} | Get a Bulk Pricing Rule |
| [**getBulkPricingRules()**](ProductBulkPricingRulesApi.md#getBulkPricingRules) | **GET** /catalog/products/{product_id}/bulk-pricing-rules | Get All Bulk Pricing Rules |
| [**updateBulkPricingRule()**](ProductBulkPricingRulesApi.md#updateBulkPricingRule) | **PUT** /catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id} | Update a Bulk Pricing Rule |


## `createBulkPricingRule()`

```php
createBulkPricingRule($product_id, $bulk_pricing_rule, $page, $limit): \Bigcommerce\CatalogV3\Model\CreateBulkPricingRule200Response
```

Creates a Bulk Pricing Rule

Creates a *Bulk Pricing Rule*.  **Required Fields** - quantity_min - quantity_max - type - amount  **Read-Only Fields** - id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductBulkPricingRulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$bulk_pricing_rule = new \Bigcommerce\CatalogV3\Model\BulkPricingRuleFull(); // \Bigcommerce\CatalogV3\Model\BulkPricingRuleFull
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.

try {
    $result = $apiInstance->createBulkPricingRule($product_id, $bulk_pricing_rule, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductBulkPricingRulesApi->createBulkPricingRule: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **bulk_pricing_rule** | [**\Bigcommerce\CatalogV3\Model\BulkPricingRuleFull**](../Model/BulkPricingRuleFull.md)|  | |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\CreateBulkPricingRule200Response**](../Model/CreateBulkPricingRule200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteBulkPricingRuleById()`

```php
deleteBulkPricingRuleById($product_id, $bulk_pricing_rule_id)
```

Delete a Bulk Pricing Rule

Deletes a *Bulk Pricing Rule*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductBulkPricingRulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$bulk_pricing_rule_id = 56; // int | The ID of the `BulkPricingRule`.

try {
    $apiInstance->deleteBulkPricingRuleById($product_id, $bulk_pricing_rule_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductBulkPricingRulesApi->deleteBulkPricingRuleById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **bulk_pricing_rule_id** | **int**| The ID of the &#x60;BulkPricingRule&#x60;. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBulkPricingRuleById()`

```php
getBulkPricingRuleById($product_id, $bulk_pricing_rule_id, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\CreateBulkPricingRule200Response
```

Get a Bulk Pricing Rule

Returns a single *Bulk Pricing Rule*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductBulkPricingRulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$bulk_pricing_rule_id = 56; // int | The ID of the `BulkPricingRule`.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getBulkPricingRuleById($product_id, $bulk_pricing_rule_id, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductBulkPricingRulesApi->getBulkPricingRuleById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **bulk_pricing_rule_id** | **int**| The ID of the &#x60;BulkPricingRule&#x60;. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\CreateBulkPricingRule200Response**](../Model/CreateBulkPricingRule200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBulkPricingRules()`

```php
getBulkPricingRules($product_id, $include_fields, $exclude_fields, $page, $limit): \Bigcommerce\CatalogV3\Model\GetBulkPricingRules200Response
```

Get All Bulk Pricing Rules

Returns a list of *Bulk Pricing Rules*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductBulkPricingRulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.

try {
    $result = $apiInstance->getBulkPricingRules($product_id, $include_fields, $exclude_fields, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductBulkPricingRulesApi->getBulkPricingRules: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\GetBulkPricingRules200Response**](../Model/GetBulkPricingRules200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateBulkPricingRule()`

```php
updateBulkPricingRule($product_id, $bulk_pricing_rule_id, $bulk_pricing_rule): \Bigcommerce\CatalogV3\Model\UpdateBulkPricingRule200Response
```

Update a Bulk Pricing Rule

Updates a *Bulk Pricing Rule*.  **Required Fields** * none  **Read-Only Fields** - id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\ProductBulkPricingRulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 56; // int | The ID of the `Product` to which the resource belongs.
$bulk_pricing_rule_id = 56; // int | The ID of the `BulkPricingRule`.
$bulk_pricing_rule = new \Bigcommerce\CatalogV3\Model\BulkPricingRuleFull(); // \Bigcommerce\CatalogV3\Model\BulkPricingRuleFull

try {
    $result = $apiInstance->updateBulkPricingRule($product_id, $bulk_pricing_rule_id, $bulk_pricing_rule);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductBulkPricingRulesApi->updateBulkPricingRule: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**| The ID of the &#x60;Product&#x60; to which the resource belongs. | |
| **bulk_pricing_rule_id** | **int**| The ID of the &#x60;BulkPricingRule&#x60;. | |
| **bulk_pricing_rule** | [**\Bigcommerce\CatalogV3\Model\BulkPricingRuleFull**](../Model/BulkPricingRuleFull.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\UpdateBulkPricingRule200Response**](../Model/UpdateBulkPricingRule200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
