# Bigcommerce\CatalogV3\CategoryMetafieldsApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createCategoryMetafield()**](CategoryMetafieldsApi.md#createCategoryMetafield) | **POST** /catalog/categories/{category_id}/metafields | Create a Category Metafield |
| [**deleteCategoryMetafieldById()**](CategoryMetafieldsApi.md#deleteCategoryMetafieldById) | **DELETE** /catalog/categories/{category_id}/metafields/{metafield_id} | Delete a Category Metafield |
| [**getCategoryMetafieldByCategoryId()**](CategoryMetafieldsApi.md#getCategoryMetafieldByCategoryId) | **GET** /catalog/categories/{category_id}/metafields/{metafield_id} | Get a Category Metafield |
| [**getCategoryMetafieldsByCategoryId()**](CategoryMetafieldsApi.md#getCategoryMetafieldsByCategoryId) | **GET** /catalog/categories/{category_id}/metafields | Get All Category Metafields |
| [**updateCategoryMetafield()**](CategoryMetafieldsApi.md#updateCategoryMetafield) | **PUT** /catalog/categories/{category_id}/metafields/{metafield_id} | Update a Category Metafield |


## `createCategoryMetafield()`

```php
createCategoryMetafield($category_id, $metafield): \Bigcommerce\CatalogV3\Model\MetafieldResponse
```

Create a Category Metafield

Creates a *Category Metafield*.  **Required Fields:** - permission_set - namespace - key - value  **Read-Only Fields** - id  **Note:** The max number of metafields allowed on each product, category, variant, or brand is fifty. For more information, see [Platform Limits](https://support.bigcommerce.com/s/article/Platform-Limits) in the Help Center.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category_id = 56; // int | The ID of the `Category` to which the resource belongs.
$metafield = new \Bigcommerce\CatalogV3\Model\MetafieldBase(); // \Bigcommerce\CatalogV3\Model\MetafieldBase

try {
    $result = $apiInstance->createCategoryMetafield($category_id, $metafield);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryMetafieldsApi->createCategoryMetafield: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**| The ID of the &#x60;Category&#x60; to which the resource belongs. | |
| **metafield** | **\Bigcommerce\CatalogV3\Model\MetafieldBase**|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\MetafieldResponse**](../Model/MetafieldResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCategoryMetafieldById()`

```php
deleteCategoryMetafieldById($metafield_id, $category_id)
```

Delete a Category Metafield

Deletes a *Category Metafield*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$metafield_id = 56; // int | The ID of the `Metafield`.
$category_id = 56; // int | The ID of the `Category` to which the resource belongs.

try {
    $apiInstance->deleteCategoryMetafieldById($metafield_id, $category_id);
} catch (Exception $e) {
    echo 'Exception when calling CategoryMetafieldsApi->deleteCategoryMetafieldById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |
| **category_id** | **int**| The ID of the &#x60;Category&#x60; to which the resource belongs. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCategoryMetafieldByCategoryId()`

```php
getCategoryMetafieldByCategoryId($metafield_id, $category_id, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\MetafieldResponse2
```

Get a Category Metafield

Returns a single *Category Metafield*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$metafield_id = 56; // int | The ID of the `Metafield`.
$category_id = 56; // int | The ID of the `Category` to which the resource belongs.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getCategoryMetafieldByCategoryId($metafield_id, $category_id, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryMetafieldsApi->getCategoryMetafieldByCategoryId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |
| **category_id** | **int**| The ID of the &#x60;Category&#x60; to which the resource belongs. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\MetafieldResponse2**](../Model/MetafieldResponse2.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCategoryMetafieldsByCategoryId()`

```php
getCategoryMetafieldsByCategoryId($category_id, $id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $page, $limit, $key, $namespace, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\MetaFieldCollectionResponse1
```

Get All Category Metafields

Returns a list of *Metafields* on a *Category*. Optional filter parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category_id = 56; // int | The ID of the `Category` to which the resource belongs.
$id = 56; // int | Filter items by id.
$id_in = array(56); // int[]
$id_not_in = array(56); // int[]
$id_min = array(56); // int[]
$id_max = array(56); // int[]
$id_greater = array(56); // int[]
$id_less = array(56); // int[]
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.
$key = 'key_example'; // string | Filter based on a metafield's key.
$namespace = 'namespace_example'; // string | Filter based on a metafield's namespace.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getCategoryMetafieldsByCategoryId($category_id, $id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $page, $limit, $key, $namespace, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryMetafieldsApi->getCategoryMetafieldsByCategoryId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**| The ID of the &#x60;Category&#x60; to which the resource belongs. | |
| **id** | **int**| Filter items by id. | [optional] |
| **id_in** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_not_in** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_min** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_max** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_greater** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_less** | [**int[]**](../Model/int.md)|  | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |
| **key** | **string**| Filter based on a metafield&#39;s key. | [optional] |
| **namespace** | **string**| Filter based on a metafield&#39;s namespace. | [optional] |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\MetaFieldCollectionResponse1**](../Model/MetaFieldCollectionResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCategoryMetafield()`

```php
updateCategoryMetafield($metafield_id, $category_id, $metafield): \Bigcommerce\CatalogV3\Model\MetafieldResponse1
```

Update a Category Metafield

Updates a *Category Metafield*.  **Required Fields** * none  **Read-Only Fields** * id * These fields can only be modified by the app (API credentials) that created the metafield:  * namespace  * key  * permission_set  **Usage Notes** * Attempting to modify `namespace`, `key`, and `permission_set` fields using a client ID different from the one used to create those metafields will result in a 403 error message.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryMetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$metafield_id = 56; // int | The ID of the `Metafield`.
$category_id = 56; // int | The ID of the `Category` to which the resource belongs.
$metafield = new \Bigcommerce\CatalogV3\Model\MetafieldPut(); // \Bigcommerce\CatalogV3\Model\MetafieldPut

try {
    $result = $apiInstance->updateCategoryMetafield($metafield_id, $category_id, $metafield);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryMetafieldsApi->updateCategoryMetafield: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |
| **category_id** | **int**| The ID of the &#x60;Category&#x60; to which the resource belongs. | |
| **metafield** | [**\Bigcommerce\CatalogV3\Model\MetafieldPut**](../Model/MetafieldPut.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\MetafieldResponse1**](../Model/MetafieldResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
