# Bigcommerce\CatalogV3\CategoryApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createCategory()**](CategoryApi.md#createCategory) | **POST** /catalog/categories | Create a Category |
| [**deleteCategories()**](CategoryApi.md#deleteCategories) | **DELETE** /catalog/categories | Delete Categories |
| [**deleteCategoryById()**](CategoryApi.md#deleteCategoryById) | **DELETE** /catalog/categories/{category_id} | Delete a Category |
| [**getCategories()**](CategoryApi.md#getCategories) | **GET** /catalog/categories | Get All Categories |
| [**getCategoryById()**](CategoryApi.md#getCategoryById) | **GET** /catalog/categories/{category_id} | Get a Category |
| [**getCategoryTree()**](CategoryApi.md#getCategoryTree) | **GET** /catalog/categories/tree | Get Category Tree |
| [**updateCategory()**](CategoryApi.md#updateCategory) | **PUT** /catalog/categories/{category_id} | Update a Category |


## `createCategory()`

```php
createCategory($category): \Bigcommerce\CatalogV3\Model\CategoryResponse
```

Create a Category

Creates a *Category*.  **Required Fields**: - parent_id:   - To create a child category, set the parent_id to the parent category.  - To create a top level category, set the parent_id to 0. - name  **Read-Only Fields**: - id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category = new \Bigcommerce\CatalogV3\Model\Category(); // \Bigcommerce\CatalogV3\Model\Category

try {
    $result = $apiInstance->createCategory($category);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->createCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category** | [**\Bigcommerce\CatalogV3\Model\Category**](../Model/Category.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\CategoryResponse**](../Model/CategoryResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCategories()`

```php
deleteCategories($name, $parent_id, $page_title, $keyword, $is_visible)
```

Delete Categories

By default, it deletes all *Category* objects. A filter should be added to avoid deleting all *Category* objects in a store.  Sending a `DELETE` to this endpoint will result in a `422` error. Move products to a new category by sending a `PUT` to the `/catalog/products/{product_id}` endpoint before deleting a category.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$name = 'name_example'; // string | Filter items by name.
$parent_id = 56; // int | Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id.
$page_title = 'page_title_example'; // string | Filter items by page_title.
$keyword = 'keyword_example'; // string | Filter items by keywords. eg. new, towel, bath
$is_visible = True; // bool | Filter items by if visible on the storefront.

try {
    $apiInstance->deleteCategories($name, $parent_id, $page_title, $keyword, $is_visible);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->deleteCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **name** | **string**| Filter items by name. | [optional] |
| **parent_id** | **int**| Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. | [optional] |
| **page_title** | **string**| Filter items by page_title. | [optional] |
| **keyword** | **string**| Filter items by keywords. eg. new, towel, bath | [optional] |
| **is_visible** | **bool**| Filter items by if visible on the storefront. | [optional] |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCategoryById()`

```php
deleteCategoryById($category_id)
```

Delete a Category

Deletes a *Category*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category_id = 56; // int | The ID of the `Category` to which the resource belongs.

try {
    $apiInstance->deleteCategoryById($category_id);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->deleteCategoryById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**| The ID of the &#x60;Category&#x60; to which the resource belongs. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCategories()`

```php
getCategories($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $parent_id, $page_title, $keyword, $is_visible, $page, $limit, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\CategoryBase
```

Get All Categories

Returns a list of *Categories*. Optional filter parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Filter items by id.
$id_in = array(56); // int[]
$id_not_in = array(56); // int[]
$id_min = array(56); // int[]
$id_max = array(56); // int[]
$id_greater = array(56); // int[]
$id_less = array(56); // int[]
$name = 'name_example'; // string | Filter items by name.
$parent_id = 56; // int | Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id.
$page_title = 'page_title_example'; // string | Filter items by page_title.
$keyword = 'keyword_example'; // string | Filter items by keywords. eg. new, towel, bath
$is_visible = True; // bool | Filter items by if visible on the storefront.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getCategories($id, $id_in, $id_not_in, $id_min, $id_max, $id_greater, $id_less, $name, $parent_id, $page_title, $keyword, $is_visible, $page, $limit, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->getCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Filter items by id. | [optional] |
| **id_in** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_not_in** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_min** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_max** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_greater** | [**int[]**](../Model/int.md)|  | [optional] |
| **id_less** | [**int[]**](../Model/int.md)|  | [optional] |
| **name** | **string**| Filter items by name. | [optional] |
| **parent_id** | **int**| Filter items by parent_id. If the category is a child or sub category it can be filtered with the parent_id. | [optional] |
| **page_title** | **string**| Filter items by page_title. | [optional] |
| **keyword** | **string**| Filter items by keywords. eg. new, towel, bath | [optional] |
| **is_visible** | **bool**| Filter items by if visible on the storefront. | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\CategoryBase**](../Model/CategoryBase.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCategoryById()`

```php
getCategoryById($category_id, $include_fields, $exclude_fields): \Bigcommerce\CatalogV3\Model\CategoryResponse
```

Get a Category

Returns a single *Category*. Optional parameters can be passed in.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category_id = 56; // int | The ID of the `Category` to which the resource belongs.
$include_fields = 'include_fields_example'; // string | Fields to include, in a comma-separated list. The ID and the specified fields will be returned.
$exclude_fields = 'exclude_fields_example'; // string | Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded.

try {
    $result = $apiInstance->getCategoryById($category_id, $include_fields, $exclude_fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->getCategoryById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**| The ID of the &#x60;Category&#x60; to which the resource belongs. | |
| **include_fields** | **string**| Fields to include, in a comma-separated list. The ID and the specified fields will be returned. | [optional] |
| **exclude_fields** | **string**| Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. | [optional] |

### Return type

[**\Bigcommerce\CatalogV3\Model\CategoryResponse**](../Model/CategoryResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCategoryTree()`

```php
getCategoryTree(): \Bigcommerce\CatalogV3\Model\CategoriesTreeResp
```

Get Category Tree

Returns the categories tree, a nested lineage of the categories with parent->child relationship. The Category objects returned are simplified versions of the category objects returned in the rest of this API.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getCategoryTree();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->getCategoryTree: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\CatalogV3\Model\CategoriesTreeResp**](../Model/CategoriesTreeResp.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCategory()`

```php
updateCategory($category_id, $category): \Bigcommerce\CatalogV3\Model\CategoryResponse1
```

Update a Category

Updates a *Category*.  **Required Fields** * none  **Read-Only Fields** - id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\CatalogV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\CatalogV3\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category_id = 56; // int | The ID of the `Category` to which the resource belongs.
$category = new \Bigcommerce\CatalogV3\Model\Category(); // \Bigcommerce\CatalogV3\Model\Category

try {
    $result = $apiInstance->updateCategory($category_id, $category);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->updateCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**| The ID of the &#x60;Category&#x60; to which the resource belongs. | |
| **category** | [**\Bigcommerce\CatalogV3\Model\Category**](../Model/Category.md)|  | |

### Return type

[**\Bigcommerce\CatalogV3\Model\CategoryResponse1**](../Model/CategoryResponse1.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
