<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace AmazonMWS;

use ConnectorSupport\Guzzle\Handler\Console;
use Psr\Log\LoggerInterface;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Client;
use ConnectorSupport\Guzzle\Handler\Logger;
use MCS\MWSClient;

class ClientBuilder
{
    /**
     * @param string $marketplace_id
     * @param string $seller_id
     * @param string $access_key_id
     * @param string $secret_access_key
     * @param string $auth_token
     * @param null|LoggerInterface $logger
     * @return MWSClient
     * @throws
     */
    public static function getClient($marketplace_id, $seller_id, $access_key_id, $secret_access_key, $auth_token, LoggerInterface $logger = null)
    {
        $stack = HandlerStack::create();

        $log = Logger::create($logger);
        $stack->push($log);

        $loggingClient = new Client([

            'handler' => $stack

        ]);

        $client = new MWSClient([
            'Marketplace_Id' => $marketplace_id,
            'Seller_Id' => $seller_id,
            'Access_Key_ID' => $access_key_id,
            'Secret_Access_Key' => $secret_access_key,
            'MWSAuthToken' => $auth_token
        ]);

        $client->setClient($loggingClient);

        return $client;
    }
}