<?php
/**
 * MarketplaceLevelAttributes
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Amazon\Sellers
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Selling Partner API for Sellers
 *
 * The [Selling Partner API for Sellers](https://developer-docs.amazon.com/sp-api/docs/sellers-api-v1-reference) (Sellers API) provides essential information about seller accounts, such as:  - The marketplaces a seller can list in - The default language and currency of a marketplace - Whether the seller has suspended listings  Refer to the [Sellers API reference](https://developer-docs.amazon.com/sp-api/docs/sellers-api-v1-reference) for details about this API's operations, data types, and schemas.
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Amazon\Sellers\Model;

use \ArrayAccess;
use \Amazon\Sellers\ObjectSerializer;

/**
 * MarketplaceLevelAttributes Class Doc Comment
 *
 * @category Class
 * @description Attributes that define the seller&#39;s presence and status within a specific marketplace. These attributes include the marketplace details, store name, listing status, and the selling plan the seller is subscribed to.
 * @package  Amazon\Sellers
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MarketplaceLevelAttributes implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MarketplaceLevelAttributes';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace' => '\Amazon\Sellers\Model\Marketplace',
        'store_name' => 'string',
        'listing_status' => 'string',
        'selling_plan' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace' => null,
        'store_name' => null,
        'listing_status' => null,
        'selling_plan' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'marketplace' => false,
        'store_name' => false,
        'listing_status' => false,
        'selling_plan' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace' => 'marketplace',
        'store_name' => 'storeName',
        'listing_status' => 'listingStatus',
        'selling_plan' => 'sellingPlan'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace' => 'setMarketplace',
        'store_name' => 'setStoreName',
        'listing_status' => 'setListingStatus',
        'selling_plan' => 'setSellingPlan'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace' => 'getMarketplace',
        'store_name' => 'getStoreName',
        'listing_status' => 'getListingStatus',
        'selling_plan' => 'getSellingPlan'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const LISTING_STATUS_ACTIVE = 'ACTIVE';
    public const LISTING_STATUS_INACTIVE = 'INACTIVE';
    public const SELLING_PLAN_PROFESSIONAL = 'PROFESSIONAL';
    public const SELLING_PLAN_INDIVIDUAL = 'INDIVIDUAL';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getListingStatusAllowableValues()
    {
        return [
            self::LISTING_STATUS_ACTIVE,
            self::LISTING_STATUS_INACTIVE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSellingPlanAllowableValues()
    {
        return [
            self::SELLING_PLAN_PROFESSIONAL,
            self::SELLING_PLAN_INDIVIDUAL,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('marketplace', $data ?? [], null);
        $this->setIfExists('store_name', $data ?? [], null);
        $this->setIfExists('listing_status', $data ?? [], null);
        $this->setIfExists('selling_plan', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['marketplace'] === null) {
            $invalidProperties[] = "'marketplace' can't be null";
        }
        if ($this->container['store_name'] === null) {
            $invalidProperties[] = "'store_name' can't be null";
        }
        if ($this->container['listing_status'] === null) {
            $invalidProperties[] = "'listing_status' can't be null";
        }
        $allowedValues = $this->getListingStatusAllowableValues();
        if (!is_null($this->container['listing_status']) && !in_array($this->container['listing_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'listing_status', must be one of '%s'",
                $this->container['listing_status'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['selling_plan'] === null) {
            $invalidProperties[] = "'selling_plan' can't be null";
        }
        $allowedValues = $this->getSellingPlanAllowableValues();
        if (!is_null($this->container['selling_plan']) && !in_array($this->container['selling_plan'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'selling_plan', must be one of '%s'",
                $this->container['selling_plan'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets marketplace
     *
     * @return \Amazon\Sellers\Model\Marketplace
     */
    public function getMarketplace()
    {
        return $this->container['marketplace'];
    }

    /**
     * Sets marketplace
     *
     * @param \Amazon\Sellers\Model\Marketplace $marketplace marketplace
     *
     * @return self
     */
    public function setMarketplace($marketplace)
    {
        if (is_null($marketplace)) {
            throw new \InvalidArgumentException('non-nullable marketplace cannot be null');
        }
        $this->container['marketplace'] = $marketplace;

        return $this;
    }

    /**
     * Gets store_name
     *
     * @return string
     */
    public function getStoreName()
    {
        return $this->container['store_name'];
    }

    /**
     * Sets store_name
     *
     * @param string $store_name The name of the seller's store as displayed in the marketplace.
     *
     * @return self
     */
    public function setStoreName($store_name)
    {
        if (is_null($store_name)) {
            throw new \InvalidArgumentException('non-nullable store_name cannot be null');
        }
        $this->container['store_name'] = $store_name;

        return $this;
    }

    /**
     * Gets listing_status
     *
     * @return string
     */
    public function getListingStatus()
    {
        return $this->container['listing_status'];
    }

    /**
     * Sets listing_status
     *
     * @param string $listing_status The current status of the seller's listings.
     *
     * @return self
     */
    public function setListingStatus($listing_status)
    {
        if (is_null($listing_status)) {
            throw new \InvalidArgumentException('non-nullable listing_status cannot be null');
        }
        $allowedValues = $this->getListingStatusAllowableValues();
        if (!in_array($listing_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'listing_status', must be one of '%s'",
                    $listing_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['listing_status'] = $listing_status;

        return $this;
    }

    /**
     * Gets selling_plan
     *
     * @return string
     */
    public function getSellingPlan()
    {
        return $this->container['selling_plan'];
    }

    /**
     * Sets selling_plan
     *
     * @param string $selling_plan The selling plan details.
     *
     * @return self
     */
    public function setSellingPlan($selling_plan)
    {
        if (is_null($selling_plan)) {
            throw new \InvalidArgumentException('non-nullable selling_plan cannot be null');
        }
        $allowedValues = $this->getSellingPlanAllowableValues();
        if (!in_array($selling_plan, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'selling_plan', must be one of '%s'",
                    $selling_plan,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['selling_plan'] = $selling_plan;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


