<?php
/**
 * Account
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Amazon\Sellers
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Selling Partner API for Sellers
 *
 * The [Selling Partner API for Sellers](https://developer-docs.amazon.com/sp-api/docs/sellers-api-v1-reference) (Sellers API) provides essential information about seller accounts, such as:  - The marketplaces a seller can list in - The default language and currency of a marketplace - Whether the seller has suspended listings  Refer to the [Sellers API reference](https://developer-docs.amazon.com/sp-api/docs/sellers-api-v1-reference) for details about this API's operations, data types, and schemas.
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Amazon\Sellers\Model;

use \ArrayAccess;
use \Amazon\Sellers\ObjectSerializer;

/**
 * Account Class Doc Comment
 *
 * @category Class
 * @description The response schema for the &#x60;getAccount&#x60; operation.
 * @package  Amazon\Sellers
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Account implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Account';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace_level_attributes' => '\Amazon\Sellers\Model\MarketplaceLevelAttributes[]',
        'business_type' => 'string',
        'business' => '\Amazon\Sellers\Model\Business',
        'primary_contact' => '\Amazon\Sellers\Model\PrimaryContact'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace_level_attributes' => null,
        'business_type' => null,
        'business' => null,
        'primary_contact' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'marketplace_level_attributes' => false,
        'business_type' => false,
        'business' => false,
        'primary_contact' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace_level_attributes' => 'marketplaceLevelAttributes',
        'business_type' => 'businessType',
        'business' => 'business',
        'primary_contact' => 'primaryContact'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace_level_attributes' => 'setMarketplaceLevelAttributes',
        'business_type' => 'setBusinessType',
        'business' => 'setBusiness',
        'primary_contact' => 'setPrimaryContact'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace_level_attributes' => 'getMarketplaceLevelAttributes',
        'business_type' => 'getBusinessType',
        'business' => 'getBusiness',
        'primary_contact' => 'getPrimaryContact'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const BUSINESS_TYPE_CHARITY = 'CHARITY';
    public const BUSINESS_TYPE_CRAFTSMAN = 'CRAFTSMAN';
    public const BUSINESS_TYPE_NATURAL_PERSON_COMPANY = 'NATURAL_PERSON_COMPANY';
    public const BUSINESS_TYPE_PUBLIC_LISTED = 'PUBLIC_LISTED';
    public const BUSINESS_TYPE_PRIVATE_LIMITED = 'PRIVATE_LIMITED';
    public const BUSINESS_TYPE_SOLE_PROPRIETORSHIP = 'SOLE_PROPRIETORSHIP';
    public const BUSINESS_TYPE_STATE_OWNED = 'STATE_OWNED';
    public const BUSINESS_TYPE_INDIVIDUAL = 'INDIVIDUAL';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getBusinessTypeAllowableValues()
    {
        return [
            self::BUSINESS_TYPE_CHARITY,
            self::BUSINESS_TYPE_CRAFTSMAN,
            self::BUSINESS_TYPE_NATURAL_PERSON_COMPANY,
            self::BUSINESS_TYPE_PUBLIC_LISTED,
            self::BUSINESS_TYPE_PRIVATE_LIMITED,
            self::BUSINESS_TYPE_SOLE_PROPRIETORSHIP,
            self::BUSINESS_TYPE_STATE_OWNED,
            self::BUSINESS_TYPE_INDIVIDUAL,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('marketplace_level_attributes', $data ?? [], null);
        $this->setIfExists('business_type', $data ?? [], null);
        $this->setIfExists('business', $data ?? [], null);
        $this->setIfExists('primary_contact', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['marketplace_level_attributes'] === null) {
            $invalidProperties[] = "'marketplace_level_attributes' can't be null";
        }
        if ($this->container['business_type'] === null) {
            $invalidProperties[] = "'business_type' can't be null";
        }
        $allowedValues = $this->getBusinessTypeAllowableValues();
        if (!is_null($this->container['business_type']) && !in_array($this->container['business_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'business_type', must be one of '%s'",
                $this->container['business_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets marketplace_level_attributes
     *
     * @return \Amazon\Sellers\Model\MarketplaceLevelAttributes[]
     */
    public function getMarketplaceLevelAttributes()
    {
        return $this->container['marketplace_level_attributes'];
    }

    /**
     * Sets marketplace_level_attributes
     *
     * @param \Amazon\Sellers\Model\MarketplaceLevelAttributes[] $marketplace_level_attributes A list of details of the marketplaces where the seller account is active.
     *
     * @return self
     */
    public function setMarketplaceLevelAttributes($marketplace_level_attributes)
    {
        if (is_null($marketplace_level_attributes)) {
            throw new \InvalidArgumentException('non-nullable marketplace_level_attributes cannot be null');
        }
        $this->container['marketplace_level_attributes'] = $marketplace_level_attributes;

        return $this;
    }

    /**
     * Gets business_type
     *
     * @return string
     */
    public function getBusinessType()
    {
        return $this->container['business_type'];
    }

    /**
     * Sets business_type
     *
     * @param string $business_type The type of business registered for the seller account.
     *
     * @return self
     */
    public function setBusinessType($business_type)
    {
        if (is_null($business_type)) {
            throw new \InvalidArgumentException('non-nullable business_type cannot be null');
        }
        $allowedValues = $this->getBusinessTypeAllowableValues();
        if (!in_array($business_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'business_type', must be one of '%s'",
                    $business_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['business_type'] = $business_type;

        return $this;
    }

    /**
     * Gets business
     *
     * @return \Amazon\Sellers\Model\Business|null
     */
    public function getBusiness()
    {
        return $this->container['business'];
    }

    /**
     * Sets business
     *
     * @param \Amazon\Sellers\Model\Business|null $business business
     *
     * @return self
     */
    public function setBusiness($business)
    {
        if (is_null($business)) {
            throw new \InvalidArgumentException('non-nullable business cannot be null');
        }
        $this->container['business'] = $business;

        return $this;
    }

    /**
     * Gets primary_contact
     *
     * @return \Amazon\Sellers\Model\PrimaryContact|null
     */
    public function getPrimaryContact()
    {
        return $this->container['primary_contact'];
    }

    /**
     * Sets primary_contact
     *
     * @param \Amazon\Sellers\Model\PrimaryContact|null $primary_contact primary_contact
     *
     * @return self
     */
    public function setPrimaryContact($primary_contact)
    {
        if (is_null($primary_contact)) {
            throw new \InvalidArgumentException('non-nullable primary_contact cannot be null');
        }
        $this->container['primary_contact'] = $primary_contact;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


