# OpenAPIClient-php

The [Selling Partner API for Sellers](https://developer-docs.amazon.com/sp-api/docs/sellers-api-v1-reference) (Sellers API) provides essential information about seller accounts, such as:

- The marketplaces a seller can list in
- The default language and currency of a marketplace
- Whether the seller has suspended listings

Refer to the [Sellers API reference](https://developer-docs.amazon.com/sp-api/docs/sellers-api-v1-reference) for details about this API's operations, data types, and schemas.

For more information, please visit [https://sellercentral.amazon.com/gp/mws/contactus.html](https://sellercentral.amazon.com/gp/mws/contactus.html).

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/amazon-spapi.git"
    }
  ],
  "require": {
    "talisman/amazon-spapi": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Amazon\Sellers\Api\SellersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getAccount();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SellersApi->getAccount: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://sellingpartnerapi-na.amazon.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SellersApi* | [**getAccount**](docs/Api/SellersApi.md#getaccount) | **GET** /sellers/v1/account | 
*SellersApi* | [**getMarketplaceParticipations**](docs/Api/SellersApi.md#getmarketplaceparticipations) | **GET** /sellers/v1/marketplaceParticipations | 

## Models

- [Account](docs/Model/Account.md)
- [Address](docs/Model/Address.md)
- [Business](docs/Model/Business.md)
- [Error](docs/Model/Error.md)
- [GetAccountResponse](docs/Model/GetAccountResponse.md)
- [GetMarketplaceParticipationsResponse](docs/Model/GetMarketplaceParticipationsResponse.md)
- [Marketplace](docs/Model/Marketplace.md)
- [MarketplaceLevelAttributes](docs/Model/MarketplaceLevelAttributes.md)
- [MarketplaceParticipation](docs/Model/MarketplaceParticipation.md)
- [Participation](docs/Model/Participation.md)
- [PrimaryContact](docs/Model/PrimaryContact.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `v1`
    - Package version: `1`
    - Generator version: `7.8.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
