<?php
/**
 * PrescriptionDetail
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Amazon\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Selling Partner API for Orders
 *
 * Use the Orders Selling Partner API to programmatically retrieve order information. With this API, you can develop fast, flexible, and custom applications to manage order synchronization, perform order research, and create demand-based decision support tools.   _Note:_ For the JP, AU, and SG marketplaces, the Orders API supports orders from 2016 onward. For all other marketplaces, the Orders API supports orders for the last two years (orders older than this don't show up in the response).
 *
 * The version of the OpenAPI document: v0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Amazon\Orders\Model;

use \ArrayAccess;
use \Amazon\Orders\ObjectSerializer;

/**
 * PrescriptionDetail Class Doc Comment
 *
 * @category Class
 * @description Information about the prescription that is used to verify a regulated product. This must be provided once per order and reflect the seller’s own records. Only approved orders can have prescriptions.
 * @package  Amazon\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PrescriptionDetail implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PrescriptionDetail';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'prescription_id' => 'string',
        'expiration_date' => '\DateTime',
        'written_quantity' => 'int',
        'total_refills_authorized' => 'int',
        'refills_remaining' => 'int',
        'clinic_id' => 'string',
        'usage_instructions' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'prescription_id' => null,
        'expiration_date' => 'date-time',
        'written_quantity' => null,
        'total_refills_authorized' => null,
        'refills_remaining' => null,
        'clinic_id' => null,
        'usage_instructions' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'prescription_id' => false,
        'expiration_date' => false,
        'written_quantity' => false,
        'total_refills_authorized' => false,
        'refills_remaining' => false,
        'clinic_id' => false,
        'usage_instructions' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'prescription_id' => 'prescriptionId',
        'expiration_date' => 'expirationDate',
        'written_quantity' => 'writtenQuantity',
        'total_refills_authorized' => 'totalRefillsAuthorized',
        'refills_remaining' => 'refillsRemaining',
        'clinic_id' => 'clinicId',
        'usage_instructions' => 'usageInstructions'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'prescription_id' => 'setPrescriptionId',
        'expiration_date' => 'setExpirationDate',
        'written_quantity' => 'setWrittenQuantity',
        'total_refills_authorized' => 'setTotalRefillsAuthorized',
        'refills_remaining' => 'setRefillsRemaining',
        'clinic_id' => 'setClinicId',
        'usage_instructions' => 'setUsageInstructions'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'prescription_id' => 'getPrescriptionId',
        'expiration_date' => 'getExpirationDate',
        'written_quantity' => 'getWrittenQuantity',
        'total_refills_authorized' => 'getTotalRefillsAuthorized',
        'refills_remaining' => 'getRefillsRemaining',
        'clinic_id' => 'getClinicId',
        'usage_instructions' => 'getUsageInstructions'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('prescription_id', $data ?? [], null);
        $this->setIfExists('expiration_date', $data ?? [], null);
        $this->setIfExists('written_quantity', $data ?? [], null);
        $this->setIfExists('total_refills_authorized', $data ?? [], null);
        $this->setIfExists('refills_remaining', $data ?? [], null);
        $this->setIfExists('clinic_id', $data ?? [], null);
        $this->setIfExists('usage_instructions', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['prescription_id'] === null) {
            $invalidProperties[] = "'prescription_id' can't be null";
        }
        if ($this->container['expiration_date'] === null) {
            $invalidProperties[] = "'expiration_date' can't be null";
        }
        if ($this->container['written_quantity'] === null) {
            $invalidProperties[] = "'written_quantity' can't be null";
        }
        if (($this->container['written_quantity'] < 1)) {
            $invalidProperties[] = "invalid value for 'written_quantity', must be bigger than or equal to 1.";
        }

        if ($this->container['total_refills_authorized'] === null) {
            $invalidProperties[] = "'total_refills_authorized' can't be null";
        }
        if (($this->container['total_refills_authorized'] < 0)) {
            $invalidProperties[] = "invalid value for 'total_refills_authorized', must be bigger than or equal to 0.";
        }

        if ($this->container['refills_remaining'] === null) {
            $invalidProperties[] = "'refills_remaining' can't be null";
        }
        if (($this->container['refills_remaining'] < 0)) {
            $invalidProperties[] = "invalid value for 'refills_remaining', must be bigger than or equal to 0.";
        }

        if ($this->container['clinic_id'] === null) {
            $invalidProperties[] = "'clinic_id' can't be null";
        }
        if ($this->container['usage_instructions'] === null) {
            $invalidProperties[] = "'usage_instructions' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets prescription_id
     *
     * @return string
     */
    public function getPrescriptionId()
    {
        return $this->container['prescription_id'];
    }

    /**
     * Sets prescription_id
     *
     * @param string $prescription_id The identifier for the prescription used to verify the regulated product.
     *
     * @return self
     */
    public function setPrescriptionId($prescription_id)
    {
        if (is_null($prescription_id)) {
            throw new \InvalidArgumentException('non-nullable prescription_id cannot be null');
        }
        $this->container['prescription_id'] = $prescription_id;

        return $this;
    }

    /**
     * Gets expiration_date
     *
     * @return \DateTime
     */
    public function getExpirationDate()
    {
        return $this->container['expiration_date'];
    }

    /**
     * Sets expiration_date
     *
     * @param \DateTime $expiration_date The expiration date of the prescription used to verify the regulated product, in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format.
     *
     * @return self
     */
    public function setExpirationDate($expiration_date)
    {
        if (is_null($expiration_date)) {
            throw new \InvalidArgumentException('non-nullable expiration_date cannot be null');
        }
        $this->container['expiration_date'] = $expiration_date;

        return $this;
    }

    /**
     * Gets written_quantity
     *
     * @return int
     */
    public function getWrittenQuantity()
    {
        return $this->container['written_quantity'];
    }

    /**
     * Sets written_quantity
     *
     * @param int $written_quantity The number of units in each fill as provided in the prescription.
     *
     * @return self
     */
    public function setWrittenQuantity($written_quantity)
    {
        if (is_null($written_quantity)) {
            throw new \InvalidArgumentException('non-nullable written_quantity cannot be null');
        }

        if (($written_quantity < 1)) {
            throw new \InvalidArgumentException('invalid value for $written_quantity when calling PrescriptionDetail., must be bigger than or equal to 1.');
        }

        $this->container['written_quantity'] = $written_quantity;

        return $this;
    }

    /**
     * Gets total_refills_authorized
     *
     * @return int
     */
    public function getTotalRefillsAuthorized()
    {
        return $this->container['total_refills_authorized'];
    }

    /**
     * Sets total_refills_authorized
     *
     * @param int $total_refills_authorized The total number of refills written in the original prescription used to verify the regulated product. If a prescription originally had no refills, this value must be 0.
     *
     * @return self
     */
    public function setTotalRefillsAuthorized($total_refills_authorized)
    {
        if (is_null($total_refills_authorized)) {
            throw new \InvalidArgumentException('non-nullable total_refills_authorized cannot be null');
        }

        if (($total_refills_authorized < 0)) {
            throw new \InvalidArgumentException('invalid value for $total_refills_authorized when calling PrescriptionDetail., must be bigger than or equal to 0.');
        }

        $this->container['total_refills_authorized'] = $total_refills_authorized;

        return $this;
    }

    /**
     * Gets refills_remaining
     *
     * @return int
     */
    public function getRefillsRemaining()
    {
        return $this->container['refills_remaining'];
    }

    /**
     * Sets refills_remaining
     *
     * @param int $refills_remaining The number of refills remaining for the prescription used to verify the regulated product. If a prescription originally had 10 total refills, this value must be `10` for the first order, `9` for the second order, and `0` for the eleventh order. If a prescription originally had no refills, this value must be 0.
     *
     * @return self
     */
    public function setRefillsRemaining($refills_remaining)
    {
        if (is_null($refills_remaining)) {
            throw new \InvalidArgumentException('non-nullable refills_remaining cannot be null');
        }

        if (($refills_remaining < 0)) {
            throw new \InvalidArgumentException('invalid value for $refills_remaining when calling PrescriptionDetail., must be bigger than or equal to 0.');
        }

        $this->container['refills_remaining'] = $refills_remaining;

        return $this;
    }

    /**
     * Gets clinic_id
     *
     * @return string
     */
    public function getClinicId()
    {
        return $this->container['clinic_id'];
    }

    /**
     * Sets clinic_id
     *
     * @param string $clinic_id The identifier for the clinic which provided the prescription used to verify the regulated product.
     *
     * @return self
     */
    public function setClinicId($clinic_id)
    {
        if (is_null($clinic_id)) {
            throw new \InvalidArgumentException('non-nullable clinic_id cannot be null');
        }
        $this->container['clinic_id'] = $clinic_id;

        return $this;
    }

    /**
     * Gets usage_instructions
     *
     * @return string
     */
    public function getUsageInstructions()
    {
        return $this->container['usage_instructions'];
    }

    /**
     * Sets usage_instructions
     *
     * @param string $usage_instructions The instructions for the prescription as provided by the approver of the regulated product.
     *
     * @return self
     */
    public function setUsageInstructions($usage_instructions)
    {
        if (is_null($usage_instructions)) {
            throw new \InvalidArgumentException('non-nullable usage_instructions cannot be null');
        }
        $this->container['usage_instructions'] = $usage_instructions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


