<?php
/**
 * Order
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Amazon\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Selling Partner API for Orders
 *
 * Use the Orders Selling Partner API to programmatically retrieve order information. With this API, you can develop fast, flexible, and custom applications to manage order synchronization, perform order research, and create demand-based decision support tools.   _Note:_ For the JP, AU, and SG marketplaces, the Orders API supports orders from 2016 onward. For all other marketplaces, the Orders API supports orders for the last two years (orders older than this don't show up in the response).
 *
 * The version of the OpenAPI document: v0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Amazon\Orders\Model;

use \ArrayAccess;
use \Amazon\Orders\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @description Order information.
 * @package  Amazon\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Order implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'amazon_order_id' => 'string',
        'seller_order_id' => 'string',
        'purchase_date' => 'string',
        'last_update_date' => 'string',
        'order_status' => 'string',
        'fulfillment_channel' => 'string',
        'sales_channel' => 'string',
        'order_channel' => 'string',
        'ship_service_level' => 'string',
        'order_total' => '\Amazon\Orders\Model\Money',
        'number_of_items_shipped' => 'int',
        'number_of_items_unshipped' => 'int',
        'payment_execution_detail' => '\Amazon\Orders\Model\PaymentExecutionDetailItem[]',
        'payment_method' => 'string',
        'payment_method_details' => 'string[]',
        'marketplace_id' => 'string',
        'shipment_service_level_category' => 'string',
        'easy_ship_shipment_status' => '\Amazon\Orders\Model\EasyShipShipmentStatus',
        'cba_displayable_shipping_label' => 'string',
        'order_type' => 'string',
        'earliest_ship_date' => 'string',
        'latest_ship_date' => 'string',
        'earliest_delivery_date' => 'string',
        'latest_delivery_date' => 'string',
        'is_business_order' => 'bool',
        'is_prime' => 'bool',
        'is_premium_order' => 'bool',
        'is_global_express_enabled' => 'bool',
        'replaced_order_id' => 'string',
        'is_replacement_order' => 'bool',
        'promise_response_due_date' => 'string',
        'is_estimated_ship_date_set' => 'bool',
        'is_sold_by_ab' => 'bool',
        'is_iba' => 'bool',
        'default_ship_from_location_address' => '\Amazon\Orders\Model\Address',
        'buyer_invoice_preference' => 'string',
        'buyer_tax_information' => '\Amazon\Orders\Model\BuyerTaxInformation',
        'fulfillment_instruction' => '\Amazon\Orders\Model\FulfillmentInstruction',
        'is_ispu' => 'bool',
        'is_access_point_order' => 'bool',
        'marketplace_tax_info' => '\Amazon\Orders\Model\MarketplaceTaxInfo',
        'seller_display_name' => 'string',
        'shipping_address' => '\Amazon\Orders\Model\Address',
        'buyer_info' => '\Amazon\Orders\Model\BuyerInfo',
        'automated_shipping_settings' => '\Amazon\Orders\Model\AutomatedShippingSettings',
        'has_regulated_items' => 'bool',
        'electronic_invoice_status' => '\Amazon\Orders\Model\ElectronicInvoiceStatus'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'amazon_order_id' => null,
        'seller_order_id' => null,
        'purchase_date' => null,
        'last_update_date' => null,
        'order_status' => null,
        'fulfillment_channel' => null,
        'sales_channel' => null,
        'order_channel' => null,
        'ship_service_level' => null,
        'order_total' => null,
        'number_of_items_shipped' => null,
        'number_of_items_unshipped' => null,
        'payment_execution_detail' => null,
        'payment_method' => null,
        'payment_method_details' => null,
        'marketplace_id' => null,
        'shipment_service_level_category' => null,
        'easy_ship_shipment_status' => null,
        'cba_displayable_shipping_label' => null,
        'order_type' => null,
        'earliest_ship_date' => null,
        'latest_ship_date' => null,
        'earliest_delivery_date' => null,
        'latest_delivery_date' => null,
        'is_business_order' => null,
        'is_prime' => null,
        'is_premium_order' => null,
        'is_global_express_enabled' => null,
        'replaced_order_id' => null,
        'is_replacement_order' => null,
        'promise_response_due_date' => null,
        'is_estimated_ship_date_set' => null,
        'is_sold_by_ab' => null,
        'is_iba' => null,
        'default_ship_from_location_address' => null,
        'buyer_invoice_preference' => null,
        'buyer_tax_information' => null,
        'fulfillment_instruction' => null,
        'is_ispu' => null,
        'is_access_point_order' => null,
        'marketplace_tax_info' => null,
        'seller_display_name' => null,
        'shipping_address' => null,
        'buyer_info' => null,
        'automated_shipping_settings' => null,
        'has_regulated_items' => null,
        'electronic_invoice_status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'amazon_order_id' => false,
        'seller_order_id' => false,
        'purchase_date' => false,
        'last_update_date' => false,
        'order_status' => false,
        'fulfillment_channel' => false,
        'sales_channel' => false,
        'order_channel' => false,
        'ship_service_level' => false,
        'order_total' => false,
        'number_of_items_shipped' => false,
        'number_of_items_unshipped' => false,
        'payment_execution_detail' => false,
        'payment_method' => false,
        'payment_method_details' => false,
        'marketplace_id' => false,
        'shipment_service_level_category' => false,
        'easy_ship_shipment_status' => false,
        'cba_displayable_shipping_label' => false,
        'order_type' => false,
        'earliest_ship_date' => false,
        'latest_ship_date' => false,
        'earliest_delivery_date' => false,
        'latest_delivery_date' => false,
        'is_business_order' => false,
        'is_prime' => false,
        'is_premium_order' => false,
        'is_global_express_enabled' => false,
        'replaced_order_id' => false,
        'is_replacement_order' => false,
        'promise_response_due_date' => false,
        'is_estimated_ship_date_set' => false,
        'is_sold_by_ab' => false,
        'is_iba' => false,
        'default_ship_from_location_address' => false,
        'buyer_invoice_preference' => false,
        'buyer_tax_information' => false,
        'fulfillment_instruction' => false,
        'is_ispu' => false,
        'is_access_point_order' => false,
        'marketplace_tax_info' => false,
        'seller_display_name' => false,
        'shipping_address' => false,
        'buyer_info' => false,
        'automated_shipping_settings' => false,
        'has_regulated_items' => false,
        'electronic_invoice_status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'amazon_order_id' => 'AmazonOrderId',
        'seller_order_id' => 'SellerOrderId',
        'purchase_date' => 'PurchaseDate',
        'last_update_date' => 'LastUpdateDate',
        'order_status' => 'OrderStatus',
        'fulfillment_channel' => 'FulfillmentChannel',
        'sales_channel' => 'SalesChannel',
        'order_channel' => 'OrderChannel',
        'ship_service_level' => 'ShipServiceLevel',
        'order_total' => 'OrderTotal',
        'number_of_items_shipped' => 'NumberOfItemsShipped',
        'number_of_items_unshipped' => 'NumberOfItemsUnshipped',
        'payment_execution_detail' => 'PaymentExecutionDetail',
        'payment_method' => 'PaymentMethod',
        'payment_method_details' => 'PaymentMethodDetails',
        'marketplace_id' => 'MarketplaceId',
        'shipment_service_level_category' => 'ShipmentServiceLevelCategory',
        'easy_ship_shipment_status' => 'EasyShipShipmentStatus',
        'cba_displayable_shipping_label' => 'CbaDisplayableShippingLabel',
        'order_type' => 'OrderType',
        'earliest_ship_date' => 'EarliestShipDate',
        'latest_ship_date' => 'LatestShipDate',
        'earliest_delivery_date' => 'EarliestDeliveryDate',
        'latest_delivery_date' => 'LatestDeliveryDate',
        'is_business_order' => 'IsBusinessOrder',
        'is_prime' => 'IsPrime',
        'is_premium_order' => 'IsPremiumOrder',
        'is_global_express_enabled' => 'IsGlobalExpressEnabled',
        'replaced_order_id' => 'ReplacedOrderId',
        'is_replacement_order' => 'IsReplacementOrder',
        'promise_response_due_date' => 'PromiseResponseDueDate',
        'is_estimated_ship_date_set' => 'IsEstimatedShipDateSet',
        'is_sold_by_ab' => 'IsSoldByAB',
        'is_iba' => 'IsIBA',
        'default_ship_from_location_address' => 'DefaultShipFromLocationAddress',
        'buyer_invoice_preference' => 'BuyerInvoicePreference',
        'buyer_tax_information' => 'BuyerTaxInformation',
        'fulfillment_instruction' => 'FulfillmentInstruction',
        'is_ispu' => 'IsISPU',
        'is_access_point_order' => 'IsAccessPointOrder',
        'marketplace_tax_info' => 'MarketplaceTaxInfo',
        'seller_display_name' => 'SellerDisplayName',
        'shipping_address' => 'ShippingAddress',
        'buyer_info' => 'BuyerInfo',
        'automated_shipping_settings' => 'AutomatedShippingSettings',
        'has_regulated_items' => 'HasRegulatedItems',
        'electronic_invoice_status' => 'ElectronicInvoiceStatus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'amazon_order_id' => 'setAmazonOrderId',
        'seller_order_id' => 'setSellerOrderId',
        'purchase_date' => 'setPurchaseDate',
        'last_update_date' => 'setLastUpdateDate',
        'order_status' => 'setOrderStatus',
        'fulfillment_channel' => 'setFulfillmentChannel',
        'sales_channel' => 'setSalesChannel',
        'order_channel' => 'setOrderChannel',
        'ship_service_level' => 'setShipServiceLevel',
        'order_total' => 'setOrderTotal',
        'number_of_items_shipped' => 'setNumberOfItemsShipped',
        'number_of_items_unshipped' => 'setNumberOfItemsUnshipped',
        'payment_execution_detail' => 'setPaymentExecutionDetail',
        'payment_method' => 'setPaymentMethod',
        'payment_method_details' => 'setPaymentMethodDetails',
        'marketplace_id' => 'setMarketplaceId',
        'shipment_service_level_category' => 'setShipmentServiceLevelCategory',
        'easy_ship_shipment_status' => 'setEasyShipShipmentStatus',
        'cba_displayable_shipping_label' => 'setCbaDisplayableShippingLabel',
        'order_type' => 'setOrderType',
        'earliest_ship_date' => 'setEarliestShipDate',
        'latest_ship_date' => 'setLatestShipDate',
        'earliest_delivery_date' => 'setEarliestDeliveryDate',
        'latest_delivery_date' => 'setLatestDeliveryDate',
        'is_business_order' => 'setIsBusinessOrder',
        'is_prime' => 'setIsPrime',
        'is_premium_order' => 'setIsPremiumOrder',
        'is_global_express_enabled' => 'setIsGlobalExpressEnabled',
        'replaced_order_id' => 'setReplacedOrderId',
        'is_replacement_order' => 'setIsReplacementOrder',
        'promise_response_due_date' => 'setPromiseResponseDueDate',
        'is_estimated_ship_date_set' => 'setIsEstimatedShipDateSet',
        'is_sold_by_ab' => 'setIsSoldByAb',
        'is_iba' => 'setIsIba',
        'default_ship_from_location_address' => 'setDefaultShipFromLocationAddress',
        'buyer_invoice_preference' => 'setBuyerInvoicePreference',
        'buyer_tax_information' => 'setBuyerTaxInformation',
        'fulfillment_instruction' => 'setFulfillmentInstruction',
        'is_ispu' => 'setIsIspu',
        'is_access_point_order' => 'setIsAccessPointOrder',
        'marketplace_tax_info' => 'setMarketplaceTaxInfo',
        'seller_display_name' => 'setSellerDisplayName',
        'shipping_address' => 'setShippingAddress',
        'buyer_info' => 'setBuyerInfo',
        'automated_shipping_settings' => 'setAutomatedShippingSettings',
        'has_regulated_items' => 'setHasRegulatedItems',
        'electronic_invoice_status' => 'setElectronicInvoiceStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'amazon_order_id' => 'getAmazonOrderId',
        'seller_order_id' => 'getSellerOrderId',
        'purchase_date' => 'getPurchaseDate',
        'last_update_date' => 'getLastUpdateDate',
        'order_status' => 'getOrderStatus',
        'fulfillment_channel' => 'getFulfillmentChannel',
        'sales_channel' => 'getSalesChannel',
        'order_channel' => 'getOrderChannel',
        'ship_service_level' => 'getShipServiceLevel',
        'order_total' => 'getOrderTotal',
        'number_of_items_shipped' => 'getNumberOfItemsShipped',
        'number_of_items_unshipped' => 'getNumberOfItemsUnshipped',
        'payment_execution_detail' => 'getPaymentExecutionDetail',
        'payment_method' => 'getPaymentMethod',
        'payment_method_details' => 'getPaymentMethodDetails',
        'marketplace_id' => 'getMarketplaceId',
        'shipment_service_level_category' => 'getShipmentServiceLevelCategory',
        'easy_ship_shipment_status' => 'getEasyShipShipmentStatus',
        'cba_displayable_shipping_label' => 'getCbaDisplayableShippingLabel',
        'order_type' => 'getOrderType',
        'earliest_ship_date' => 'getEarliestShipDate',
        'latest_ship_date' => 'getLatestShipDate',
        'earliest_delivery_date' => 'getEarliestDeliveryDate',
        'latest_delivery_date' => 'getLatestDeliveryDate',
        'is_business_order' => 'getIsBusinessOrder',
        'is_prime' => 'getIsPrime',
        'is_premium_order' => 'getIsPremiumOrder',
        'is_global_express_enabled' => 'getIsGlobalExpressEnabled',
        'replaced_order_id' => 'getReplacedOrderId',
        'is_replacement_order' => 'getIsReplacementOrder',
        'promise_response_due_date' => 'getPromiseResponseDueDate',
        'is_estimated_ship_date_set' => 'getIsEstimatedShipDateSet',
        'is_sold_by_ab' => 'getIsSoldByAb',
        'is_iba' => 'getIsIba',
        'default_ship_from_location_address' => 'getDefaultShipFromLocationAddress',
        'buyer_invoice_preference' => 'getBuyerInvoicePreference',
        'buyer_tax_information' => 'getBuyerTaxInformation',
        'fulfillment_instruction' => 'getFulfillmentInstruction',
        'is_ispu' => 'getIsIspu',
        'is_access_point_order' => 'getIsAccessPointOrder',
        'marketplace_tax_info' => 'getMarketplaceTaxInfo',
        'seller_display_name' => 'getSellerDisplayName',
        'shipping_address' => 'getShippingAddress',
        'buyer_info' => 'getBuyerInfo',
        'automated_shipping_settings' => 'getAutomatedShippingSettings',
        'has_regulated_items' => 'getHasRegulatedItems',
        'electronic_invoice_status' => 'getElectronicInvoiceStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ORDER_STATUS_PENDING = 'Pending';
    public const ORDER_STATUS_UNSHIPPED = 'Unshipped';
    public const ORDER_STATUS_PARTIALLY_SHIPPED = 'PartiallyShipped';
    public const ORDER_STATUS_SHIPPED = 'Shipped';
    public const ORDER_STATUS_CANCELED = 'Canceled';
    public const ORDER_STATUS_UNFULFILLABLE = 'Unfulfillable';
    public const ORDER_STATUS_INVOICE_UNCONFIRMED = 'InvoiceUnconfirmed';
    public const ORDER_STATUS_PENDING_AVAILABILITY = 'PendingAvailability';
    public const FULFILLMENT_CHANNEL_MFN = 'MFN';
    public const FULFILLMENT_CHANNEL_AFN = 'AFN';
    public const PAYMENT_METHOD_COD = 'COD';
    public const PAYMENT_METHOD_CVS = 'CVS';
    public const PAYMENT_METHOD_OTHER = 'Other';
    public const ORDER_TYPE_STANDARD_ORDER = 'StandardOrder';
    public const ORDER_TYPE_LONG_LEAD_TIME_ORDER = 'LongLeadTimeOrder';
    public const ORDER_TYPE_PREORDER = 'Preorder';
    public const ORDER_TYPE_BACK_ORDER = 'BackOrder';
    public const ORDER_TYPE_SOURCING_ON_DEMAND_ORDER = 'SourcingOnDemandOrder';
    public const BUYER_INVOICE_PREFERENCE_INDIVIDUAL = 'INDIVIDUAL';
    public const BUYER_INVOICE_PREFERENCE_BUSINESS = 'BUSINESS';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getOrderStatusAllowableValues()
    {
        return [
            self::ORDER_STATUS_PENDING,
            self::ORDER_STATUS_UNSHIPPED,
            self::ORDER_STATUS_PARTIALLY_SHIPPED,
            self::ORDER_STATUS_SHIPPED,
            self::ORDER_STATUS_CANCELED,
            self::ORDER_STATUS_UNFULFILLABLE,
            self::ORDER_STATUS_INVOICE_UNCONFIRMED,
            self::ORDER_STATUS_PENDING_AVAILABILITY,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFulfillmentChannelAllowableValues()
    {
        return [
            self::FULFILLMENT_CHANNEL_MFN,
            self::FULFILLMENT_CHANNEL_AFN,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPaymentMethodAllowableValues()
    {
        return [
            self::PAYMENT_METHOD_COD,
            self::PAYMENT_METHOD_CVS,
            self::PAYMENT_METHOD_OTHER,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getOrderTypeAllowableValues()
    {
        return [
            self::ORDER_TYPE_STANDARD_ORDER,
            self::ORDER_TYPE_LONG_LEAD_TIME_ORDER,
            self::ORDER_TYPE_PREORDER,
            self::ORDER_TYPE_BACK_ORDER,
            self::ORDER_TYPE_SOURCING_ON_DEMAND_ORDER,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getBuyerInvoicePreferenceAllowableValues()
    {
        return [
            self::BUYER_INVOICE_PREFERENCE_INDIVIDUAL,
            self::BUYER_INVOICE_PREFERENCE_BUSINESS,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('amazon_order_id', $data ?? [], null);
        $this->setIfExists('seller_order_id', $data ?? [], null);
        $this->setIfExists('purchase_date', $data ?? [], null);
        $this->setIfExists('last_update_date', $data ?? [], null);
        $this->setIfExists('order_status', $data ?? [], null);
        $this->setIfExists('fulfillment_channel', $data ?? [], null);
        $this->setIfExists('sales_channel', $data ?? [], null);
        $this->setIfExists('order_channel', $data ?? [], null);
        $this->setIfExists('ship_service_level', $data ?? [], null);
        $this->setIfExists('order_total', $data ?? [], null);
        $this->setIfExists('number_of_items_shipped', $data ?? [], null);
        $this->setIfExists('number_of_items_unshipped', $data ?? [], null);
        $this->setIfExists('payment_execution_detail', $data ?? [], null);
        $this->setIfExists('payment_method', $data ?? [], null);
        $this->setIfExists('payment_method_details', $data ?? [], null);
        $this->setIfExists('marketplace_id', $data ?? [], null);
        $this->setIfExists('shipment_service_level_category', $data ?? [], null);
        $this->setIfExists('easy_ship_shipment_status', $data ?? [], null);
        $this->setIfExists('cba_displayable_shipping_label', $data ?? [], null);
        $this->setIfExists('order_type', $data ?? [], null);
        $this->setIfExists('earliest_ship_date', $data ?? [], null);
        $this->setIfExists('latest_ship_date', $data ?? [], null);
        $this->setIfExists('earliest_delivery_date', $data ?? [], null);
        $this->setIfExists('latest_delivery_date', $data ?? [], null);
        $this->setIfExists('is_business_order', $data ?? [], null);
        $this->setIfExists('is_prime', $data ?? [], null);
        $this->setIfExists('is_premium_order', $data ?? [], null);
        $this->setIfExists('is_global_express_enabled', $data ?? [], null);
        $this->setIfExists('replaced_order_id', $data ?? [], null);
        $this->setIfExists('is_replacement_order', $data ?? [], null);
        $this->setIfExists('promise_response_due_date', $data ?? [], null);
        $this->setIfExists('is_estimated_ship_date_set', $data ?? [], null);
        $this->setIfExists('is_sold_by_ab', $data ?? [], null);
        $this->setIfExists('is_iba', $data ?? [], null);
        $this->setIfExists('default_ship_from_location_address', $data ?? [], null);
        $this->setIfExists('buyer_invoice_preference', $data ?? [], null);
        $this->setIfExists('buyer_tax_information', $data ?? [], null);
        $this->setIfExists('fulfillment_instruction', $data ?? [], null);
        $this->setIfExists('is_ispu', $data ?? [], null);
        $this->setIfExists('is_access_point_order', $data ?? [], null);
        $this->setIfExists('marketplace_tax_info', $data ?? [], null);
        $this->setIfExists('seller_display_name', $data ?? [], null);
        $this->setIfExists('shipping_address', $data ?? [], null);
        $this->setIfExists('buyer_info', $data ?? [], null);
        $this->setIfExists('automated_shipping_settings', $data ?? [], null);
        $this->setIfExists('has_regulated_items', $data ?? [], null);
        $this->setIfExists('electronic_invoice_status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['amazon_order_id'] === null) {
            $invalidProperties[] = "'amazon_order_id' can't be null";
        }
        if ($this->container['purchase_date'] === null) {
            $invalidProperties[] = "'purchase_date' can't be null";
        }
        if ($this->container['last_update_date'] === null) {
            $invalidProperties[] = "'last_update_date' can't be null";
        }
        if ($this->container['order_status'] === null) {
            $invalidProperties[] = "'order_status' can't be null";
        }
        $allowedValues = $this->getOrderStatusAllowableValues();
        if (!is_null($this->container['order_status']) && !in_array($this->container['order_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'order_status', must be one of '%s'",
                $this->container['order_status'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getFulfillmentChannelAllowableValues();
        if (!is_null($this->container['fulfillment_channel']) && !in_array($this->container['fulfillment_channel'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'fulfillment_channel', must be one of '%s'",
                $this->container['fulfillment_channel'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getPaymentMethodAllowableValues();
        if (!is_null($this->container['payment_method']) && !in_array($this->container['payment_method'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'payment_method', must be one of '%s'",
                $this->container['payment_method'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getOrderTypeAllowableValues();
        if (!is_null($this->container['order_type']) && !in_array($this->container['order_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'order_type', must be one of '%s'",
                $this->container['order_type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getBuyerInvoicePreferenceAllowableValues();
        if (!is_null($this->container['buyer_invoice_preference']) && !in_array($this->container['buyer_invoice_preference'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'buyer_invoice_preference', must be one of '%s'",
                $this->container['buyer_invoice_preference'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets amazon_order_id
     *
     * @return string
     */
    public function getAmazonOrderId()
    {
        return $this->container['amazon_order_id'];
    }

    /**
     * Sets amazon_order_id
     *
     * @param string $amazon_order_id An Amazon-defined order identifier, in 3-7-7 format.
     *
     * @return self
     */
    public function setAmazonOrderId($amazon_order_id)
    {
        if (is_null($amazon_order_id)) {
            throw new \InvalidArgumentException('non-nullable amazon_order_id cannot be null');
        }
        $this->container['amazon_order_id'] = $amazon_order_id;

        return $this;
    }

    /**
     * Gets seller_order_id
     *
     * @return string|null
     */
    public function getSellerOrderId()
    {
        return $this->container['seller_order_id'];
    }

    /**
     * Sets seller_order_id
     *
     * @param string|null $seller_order_id A seller-defined order identifier.
     *
     * @return self
     */
    public function setSellerOrderId($seller_order_id)
    {
        if (is_null($seller_order_id)) {
            throw new \InvalidArgumentException('non-nullable seller_order_id cannot be null');
        }
        $this->container['seller_order_id'] = $seller_order_id;

        return $this;
    }

    /**
     * Gets purchase_date
     *
     * @return string
     */
    public function getPurchaseDate()
    {
        return $this->container['purchase_date'];
    }

    /**
     * Sets purchase_date
     *
     * @param string $purchase_date The date when the order was created.
     *
     * @return self
     */
    public function setPurchaseDate($purchase_date)
    {
        if (is_null($purchase_date)) {
            throw new \InvalidArgumentException('non-nullable purchase_date cannot be null');
        }
        $this->container['purchase_date'] = $purchase_date;

        return $this;
    }

    /**
     * Gets last_update_date
     *
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->container['last_update_date'];
    }

    /**
     * Sets last_update_date
     *
     * @param string $last_update_date The date when the order was last updated.  __Note__: `LastUpdateDate` is returned with an incorrect date for orders that were last updated before 2009-04-01.
     *
     * @return self
     */
    public function setLastUpdateDate($last_update_date)
    {
        if (is_null($last_update_date)) {
            throw new \InvalidArgumentException('non-nullable last_update_date cannot be null');
        }
        $this->container['last_update_date'] = $last_update_date;

        return $this;
    }

    /**
     * Gets order_status
     *
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->container['order_status'];
    }

    /**
     * Sets order_status
     *
     * @param string $order_status The current order status.
     *
     * @return self
     */
    public function setOrderStatus($order_status)
    {
        if (is_null($order_status)) {
            throw new \InvalidArgumentException('non-nullable order_status cannot be null');
        }
        $allowedValues = $this->getOrderStatusAllowableValues();
        if (!in_array($order_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'order_status', must be one of '%s'",
                    $order_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['order_status'] = $order_status;

        return $this;
    }

    /**
     * Gets fulfillment_channel
     *
     * @return string|null
     */
    public function getFulfillmentChannel()
    {
        return $this->container['fulfillment_channel'];
    }

    /**
     * Sets fulfillment_channel
     *
     * @param string|null $fulfillment_channel Whether the order was fulfilled by Amazon (`AFN`) or by the seller (`MFN`).
     *
     * @return self
     */
    public function setFulfillmentChannel($fulfillment_channel)
    {
        if (is_null($fulfillment_channel)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_channel cannot be null');
        }
        $allowedValues = $this->getFulfillmentChannelAllowableValues();
        if (!in_array($fulfillment_channel, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'fulfillment_channel', must be one of '%s'",
                    $fulfillment_channel,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['fulfillment_channel'] = $fulfillment_channel;

        return $this;
    }

    /**
     * Gets sales_channel
     *
     * @return string|null
     */
    public function getSalesChannel()
    {
        return $this->container['sales_channel'];
    }

    /**
     * Sets sales_channel
     *
     * @param string|null $sales_channel The sales channel for the first item in the order.
     *
     * @return self
     */
    public function setSalesChannel($sales_channel)
    {
        if (is_null($sales_channel)) {
            throw new \InvalidArgumentException('non-nullable sales_channel cannot be null');
        }
        $this->container['sales_channel'] = $sales_channel;

        return $this;
    }

    /**
     * Gets order_channel
     *
     * @return string|null
     */
    public function getOrderChannel()
    {
        return $this->container['order_channel'];
    }

    /**
     * Sets order_channel
     *
     * @param string|null $order_channel The order channel for the first item in the order.
     *
     * @return self
     */
    public function setOrderChannel($order_channel)
    {
        if (is_null($order_channel)) {
            throw new \InvalidArgumentException('non-nullable order_channel cannot be null');
        }
        $this->container['order_channel'] = $order_channel;

        return $this;
    }

    /**
     * Gets ship_service_level
     *
     * @return string|null
     */
    public function getShipServiceLevel()
    {
        return $this->container['ship_service_level'];
    }

    /**
     * Sets ship_service_level
     *
     * @param string|null $ship_service_level The order's shipment service level.
     *
     * @return self
     */
    public function setShipServiceLevel($ship_service_level)
    {
        if (is_null($ship_service_level)) {
            throw new \InvalidArgumentException('non-nullable ship_service_level cannot be null');
        }
        $this->container['ship_service_level'] = $ship_service_level;

        return $this;
    }

    /**
     * Gets order_total
     *
     * @return \Amazon\Orders\Model\Money|null
     */
    public function getOrderTotal()
    {
        return $this->container['order_total'];
    }

    /**
     * Sets order_total
     *
     * @param \Amazon\Orders\Model\Money|null $order_total order_total
     *
     * @return self
     */
    public function setOrderTotal($order_total)
    {
        if (is_null($order_total)) {
            throw new \InvalidArgumentException('non-nullable order_total cannot be null');
        }
        $this->container['order_total'] = $order_total;

        return $this;
    }

    /**
     * Gets number_of_items_shipped
     *
     * @return int|null
     */
    public function getNumberOfItemsShipped()
    {
        return $this->container['number_of_items_shipped'];
    }

    /**
     * Sets number_of_items_shipped
     *
     * @param int|null $number_of_items_shipped The number of items shipped.
     *
     * @return self
     */
    public function setNumberOfItemsShipped($number_of_items_shipped)
    {
        if (is_null($number_of_items_shipped)) {
            throw new \InvalidArgumentException('non-nullable number_of_items_shipped cannot be null');
        }
        $this->container['number_of_items_shipped'] = $number_of_items_shipped;

        return $this;
    }

    /**
     * Gets number_of_items_unshipped
     *
     * @return int|null
     */
    public function getNumberOfItemsUnshipped()
    {
        return $this->container['number_of_items_unshipped'];
    }

    /**
     * Sets number_of_items_unshipped
     *
     * @param int|null $number_of_items_unshipped The number of items unshipped.
     *
     * @return self
     */
    public function setNumberOfItemsUnshipped($number_of_items_unshipped)
    {
        if (is_null($number_of_items_unshipped)) {
            throw new \InvalidArgumentException('non-nullable number_of_items_unshipped cannot be null');
        }
        $this->container['number_of_items_unshipped'] = $number_of_items_unshipped;

        return $this;
    }

    /**
     * Gets payment_execution_detail
     *
     * @return \Amazon\Orders\Model\PaymentExecutionDetailItem[]|null
     */
    public function getPaymentExecutionDetail()
    {
        return $this->container['payment_execution_detail'];
    }

    /**
     * Sets payment_execution_detail
     *
     * @param \Amazon\Orders\Model\PaymentExecutionDetailItem[]|null $payment_execution_detail A list of payment execution detail items.
     *
     * @return self
     */
    public function setPaymentExecutionDetail($payment_execution_detail)
    {
        if (is_null($payment_execution_detail)) {
            throw new \InvalidArgumentException('non-nullable payment_execution_detail cannot be null');
        }
        $this->container['payment_execution_detail'] = $payment_execution_detail;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param string|null $payment_method The payment method for the order. This property is limited to COD and CVS payment methods. Unless you need the specific COD payment information provided by the `PaymentExecutionDetailItem` object, we recommend using the `PaymentMethodDetails` property to get payment method information.
     *
     * @return self
     */
    public function setPaymentMethod($payment_method)
    {
        if (is_null($payment_method)) {
            throw new \InvalidArgumentException('non-nullable payment_method cannot be null');
        }
        $allowedValues = $this->getPaymentMethodAllowableValues();
        if (!in_array($payment_method, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'payment_method', must be one of '%s'",
                    $payment_method,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets payment_method_details
     *
     * @return string[]|null
     */
    public function getPaymentMethodDetails()
    {
        return $this->container['payment_method_details'];
    }

    /**
     * Sets payment_method_details
     *
     * @param string[]|null $payment_method_details A list of payment method detail items.
     *
     * @return self
     */
    public function setPaymentMethodDetails($payment_method_details)
    {
        if (is_null($payment_method_details)) {
            throw new \InvalidArgumentException('non-nullable payment_method_details cannot be null');
        }
        $this->container['payment_method_details'] = $payment_method_details;

        return $this;
    }

    /**
     * Gets marketplace_id
     *
     * @return string|null
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string|null $marketplace_id The identifier for the marketplace where the order was placed.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        if (is_null($marketplace_id)) {
            throw new \InvalidArgumentException('non-nullable marketplace_id cannot be null');
        }
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }

    /**
     * Gets shipment_service_level_category
     *
     * @return string|null
     */
    public function getShipmentServiceLevelCategory()
    {
        return $this->container['shipment_service_level_category'];
    }

    /**
     * Sets shipment_service_level_category
     *
     * @param string|null $shipment_service_level_category The shipment service level category for the order.  **Possible values**: `Expedited`, `FreeEconomy`, `NextDay`, `Priority`, `SameDay`, `SecondDay`, `Scheduled`, and `Standard`.
     *
     * @return self
     */
    public function setShipmentServiceLevelCategory($shipment_service_level_category)
    {
        if (is_null($shipment_service_level_category)) {
            throw new \InvalidArgumentException('non-nullable shipment_service_level_category cannot be null');
        }
        $this->container['shipment_service_level_category'] = $shipment_service_level_category;

        return $this;
    }

    /**
     * Gets easy_ship_shipment_status
     *
     * @return \Amazon\Orders\Model\EasyShipShipmentStatus|null
     */
    public function getEasyShipShipmentStatus()
    {
        return $this->container['easy_ship_shipment_status'];
    }

    /**
     * Sets easy_ship_shipment_status
     *
     * @param \Amazon\Orders\Model\EasyShipShipmentStatus|null $easy_ship_shipment_status easy_ship_shipment_status
     *
     * @return self
     */
    public function setEasyShipShipmentStatus($easy_ship_shipment_status)
    {
        if (is_null($easy_ship_shipment_status)) {
            throw new \InvalidArgumentException('non-nullable easy_ship_shipment_status cannot be null');
        }
        $this->container['easy_ship_shipment_status'] = $easy_ship_shipment_status;

        return $this;
    }

    /**
     * Gets cba_displayable_shipping_label
     *
     * @return string|null
     */
    public function getCbaDisplayableShippingLabel()
    {
        return $this->container['cba_displayable_shipping_label'];
    }

    /**
     * Sets cba_displayable_shipping_label
     *
     * @param string|null $cba_displayable_shipping_label Custom ship label for Checkout by Amazon (CBA).
     *
     * @return self
     */
    public function setCbaDisplayableShippingLabel($cba_displayable_shipping_label)
    {
        if (is_null($cba_displayable_shipping_label)) {
            throw new \InvalidArgumentException('non-nullable cba_displayable_shipping_label cannot be null');
        }
        $this->container['cba_displayable_shipping_label'] = $cba_displayable_shipping_label;

        return $this;
    }

    /**
     * Gets order_type
     *
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->container['order_type'];
    }

    /**
     * Sets order_type
     *
     * @param string|null $order_type The order's type.
     *
     * @return self
     */
    public function setOrderType($order_type)
    {
        if (is_null($order_type)) {
            throw new \InvalidArgumentException('non-nullable order_type cannot be null');
        }
        $allowedValues = $this->getOrderTypeAllowableValues();
        if (!in_array($order_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'order_type', must be one of '%s'",
                    $order_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['order_type'] = $order_type;

        return $this;
    }

    /**
     * Gets earliest_ship_date
     *
     * @return string|null
     */
    public function getEarliestShipDate()
    {
        return $this->container['earliest_ship_date'];
    }

    /**
     * Sets earliest_ship_date
     *
     * @param string|null $earliest_ship_date The start of the time period within which you have committed to ship the order. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format. Only returned for seller-fulfilled orders.  __Note__: `EarliestShipDate` might not be returned for orders placed before February 1, 2013.
     *
     * @return self
     */
    public function setEarliestShipDate($earliest_ship_date)
    {
        if (is_null($earliest_ship_date)) {
            throw new \InvalidArgumentException('non-nullable earliest_ship_date cannot be null');
        }
        $this->container['earliest_ship_date'] = $earliest_ship_date;

        return $this;
    }

    /**
     * Gets latest_ship_date
     *
     * @return string|null
     */
    public function getLatestShipDate()
    {
        return $this->container['latest_ship_date'];
    }

    /**
     * Sets latest_ship_date
     *
     * @param string|null $latest_ship_date The end of the time period within which you have committed to ship the order. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format. Only returned for seller-fulfilled orders.  __Note__: `LatestShipDate` might not be returned for orders placed before February 1, 2013.
     *
     * @return self
     */
    public function setLatestShipDate($latest_ship_date)
    {
        if (is_null($latest_ship_date)) {
            throw new \InvalidArgumentException('non-nullable latest_ship_date cannot be null');
        }
        $this->container['latest_ship_date'] = $latest_ship_date;

        return $this;
    }

    /**
     * Gets earliest_delivery_date
     *
     * @return string|null
     */
    public function getEarliestDeliveryDate()
    {
        return $this->container['earliest_delivery_date'];
    }

    /**
     * Sets earliest_delivery_date
     *
     * @param string|null $earliest_delivery_date The start of the time period within which you have committed to fulfill the order. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format. Only returned for seller-fulfilled orders.
     *
     * @return self
     */
    public function setEarliestDeliveryDate($earliest_delivery_date)
    {
        if (is_null($earliest_delivery_date)) {
            throw new \InvalidArgumentException('non-nullable earliest_delivery_date cannot be null');
        }
        $this->container['earliest_delivery_date'] = $earliest_delivery_date;

        return $this;
    }

    /**
     * Gets latest_delivery_date
     *
     * @return string|null
     */
    public function getLatestDeliveryDate()
    {
        return $this->container['latest_delivery_date'];
    }

    /**
     * Sets latest_delivery_date
     *
     * @param string|null $latest_delivery_date The end of the time period within which you have committed to fulfill the order. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format. Only returned for seller-fulfilled orders that do not have a `PendingAvailability`, `Pending`, or `Canceled` status.
     *
     * @return self
     */
    public function setLatestDeliveryDate($latest_delivery_date)
    {
        if (is_null($latest_delivery_date)) {
            throw new \InvalidArgumentException('non-nullable latest_delivery_date cannot be null');
        }
        $this->container['latest_delivery_date'] = $latest_delivery_date;

        return $this;
    }

    /**
     * Gets is_business_order
     *
     * @return bool|null
     */
    public function getIsBusinessOrder()
    {
        return $this->container['is_business_order'];
    }

    /**
     * Sets is_business_order
     *
     * @param bool|null $is_business_order When true, the order is an Amazon Business order. An Amazon Business order is an order where the buyer is a Verified Business Buyer.
     *
     * @return self
     */
    public function setIsBusinessOrder($is_business_order)
    {
        if (is_null($is_business_order)) {
            throw new \InvalidArgumentException('non-nullable is_business_order cannot be null');
        }
        $this->container['is_business_order'] = $is_business_order;

        return $this;
    }

    /**
     * Gets is_prime
     *
     * @return bool|null
     */
    public function getIsPrime()
    {
        return $this->container['is_prime'];
    }

    /**
     * Sets is_prime
     *
     * @param bool|null $is_prime When true, the order is a seller-fulfilled Amazon Prime order.
     *
     * @return self
     */
    public function setIsPrime($is_prime)
    {
        if (is_null($is_prime)) {
            throw new \InvalidArgumentException('non-nullable is_prime cannot be null');
        }
        $this->container['is_prime'] = $is_prime;

        return $this;
    }

    /**
     * Gets is_premium_order
     *
     * @return bool|null
     */
    public function getIsPremiumOrder()
    {
        return $this->container['is_premium_order'];
    }

    /**
     * Sets is_premium_order
     *
     * @param bool|null $is_premium_order When true, the order has a Premium Shipping Service Level Agreement. For more information about Premium Shipping orders, refer to \"Premium Shipping Options\" in the Seller Central Help for your marketplace.
     *
     * @return self
     */
    public function setIsPremiumOrder($is_premium_order)
    {
        if (is_null($is_premium_order)) {
            throw new \InvalidArgumentException('non-nullable is_premium_order cannot be null');
        }
        $this->container['is_premium_order'] = $is_premium_order;

        return $this;
    }

    /**
     * Gets is_global_express_enabled
     *
     * @return bool|null
     */
    public function getIsGlobalExpressEnabled()
    {
        return $this->container['is_global_express_enabled'];
    }

    /**
     * Sets is_global_express_enabled
     *
     * @param bool|null $is_global_express_enabled When true, the order is a `GlobalExpress` order.
     *
     * @return self
     */
    public function setIsGlobalExpressEnabled($is_global_express_enabled)
    {
        if (is_null($is_global_express_enabled)) {
            throw new \InvalidArgumentException('non-nullable is_global_express_enabled cannot be null');
        }
        $this->container['is_global_express_enabled'] = $is_global_express_enabled;

        return $this;
    }

    /**
     * Gets replaced_order_id
     *
     * @return string|null
     */
    public function getReplacedOrderId()
    {
        return $this->container['replaced_order_id'];
    }

    /**
     * Sets replaced_order_id
     *
     * @param string|null $replaced_order_id The order ID value for the order that is being replaced. Returned only if IsReplacementOrder = true.
     *
     * @return self
     */
    public function setReplacedOrderId($replaced_order_id)
    {
        if (is_null($replaced_order_id)) {
            throw new \InvalidArgumentException('non-nullable replaced_order_id cannot be null');
        }
        $this->container['replaced_order_id'] = $replaced_order_id;

        return $this;
    }

    /**
     * Gets is_replacement_order
     *
     * @return bool|null
     */
    public function getIsReplacementOrder()
    {
        return $this->container['is_replacement_order'];
    }

    /**
     * Sets is_replacement_order
     *
     * @param bool|null $is_replacement_order When true, this is a replacement order.
     *
     * @return self
     */
    public function setIsReplacementOrder($is_replacement_order)
    {
        if (is_null($is_replacement_order)) {
            throw new \InvalidArgumentException('non-nullable is_replacement_order cannot be null');
        }
        $this->container['is_replacement_order'] = $is_replacement_order;

        return $this;
    }

    /**
     * Gets promise_response_due_date
     *
     * @return string|null
     */
    public function getPromiseResponseDueDate()
    {
        return $this->container['promise_response_due_date'];
    }

    /**
     * Sets promise_response_due_date
     *
     * @param string|null $promise_response_due_date Indicates the date by which the seller must respond to the buyer with an estimated ship date. Only returned for Sourcing on Demand orders.
     *
     * @return self
     */
    public function setPromiseResponseDueDate($promise_response_due_date)
    {
        if (is_null($promise_response_due_date)) {
            throw new \InvalidArgumentException('non-nullable promise_response_due_date cannot be null');
        }
        $this->container['promise_response_due_date'] = $promise_response_due_date;

        return $this;
    }

    /**
     * Gets is_estimated_ship_date_set
     *
     * @return bool|null
     */
    public function getIsEstimatedShipDateSet()
    {
        return $this->container['is_estimated_ship_date_set'];
    }

    /**
     * Sets is_estimated_ship_date_set
     *
     * @param bool|null $is_estimated_ship_date_set When true, the estimated ship date is set for the order. Only returned for Sourcing on Demand orders.
     *
     * @return self
     */
    public function setIsEstimatedShipDateSet($is_estimated_ship_date_set)
    {
        if (is_null($is_estimated_ship_date_set)) {
            throw new \InvalidArgumentException('non-nullable is_estimated_ship_date_set cannot be null');
        }
        $this->container['is_estimated_ship_date_set'] = $is_estimated_ship_date_set;

        return $this;
    }

    /**
     * Gets is_sold_by_ab
     *
     * @return bool|null
     */
    public function getIsSoldByAb()
    {
        return $this->container['is_sold_by_ab'];
    }

    /**
     * Sets is_sold_by_ab
     *
     * @param bool|null $is_sold_by_ab When true, the item within this order was bought and re-sold by Amazon Business EU SARL (ABEU). By buying and instantly re-selling your items, ABEU becomes the seller of record, making your inventory available for sale to customers who would not otherwise purchase from a third-party seller.
     *
     * @return self
     */
    public function setIsSoldByAb($is_sold_by_ab)
    {
        if (is_null($is_sold_by_ab)) {
            throw new \InvalidArgumentException('non-nullable is_sold_by_ab cannot be null');
        }
        $this->container['is_sold_by_ab'] = $is_sold_by_ab;

        return $this;
    }

    /**
     * Gets is_iba
     *
     * @return bool|null
     */
    public function getIsIba()
    {
        return $this->container['is_iba'];
    }

    /**
     * Sets is_iba
     *
     * @param bool|null $is_iba When true, the item within this order was bought and re-sold by Amazon Business EU SARL (ABEU). By buying and instantly re-selling your items, ABEU becomes the seller of record, making your inventory available for sale to customers who would not otherwise purchase from a third-party seller.
     *
     * @return self
     */
    public function setIsIba($is_iba)
    {
        if (is_null($is_iba)) {
            throw new \InvalidArgumentException('non-nullable is_iba cannot be null');
        }
        $this->container['is_iba'] = $is_iba;

        return $this;
    }

    /**
     * Gets default_ship_from_location_address
     *
     * @return \Amazon\Orders\Model\Address|null
     */
    public function getDefaultShipFromLocationAddress()
    {
        return $this->container['default_ship_from_location_address'];
    }

    /**
     * Sets default_ship_from_location_address
     *
     * @param \Amazon\Orders\Model\Address|null $default_ship_from_location_address default_ship_from_location_address
     *
     * @return self
     */
    public function setDefaultShipFromLocationAddress($default_ship_from_location_address)
    {
        if (is_null($default_ship_from_location_address)) {
            throw new \InvalidArgumentException('non-nullable default_ship_from_location_address cannot be null');
        }
        $this->container['default_ship_from_location_address'] = $default_ship_from_location_address;

        return $this;
    }

    /**
     * Gets buyer_invoice_preference
     *
     * @return string|null
     */
    public function getBuyerInvoicePreference()
    {
        return $this->container['buyer_invoice_preference'];
    }

    /**
     * Sets buyer_invoice_preference
     *
     * @param string|null $buyer_invoice_preference The buyer's invoicing preference. Sellers can use this data to issue electronic invoices for orders in Turkey.  **Note**: This attribute is only available in the Turkey marketplace.
     *
     * @return self
     */
    public function setBuyerInvoicePreference($buyer_invoice_preference)
    {
        if (is_null($buyer_invoice_preference)) {
            throw new \InvalidArgumentException('non-nullable buyer_invoice_preference cannot be null');
        }
        $allowedValues = $this->getBuyerInvoicePreferenceAllowableValues();
        if (!in_array($buyer_invoice_preference, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'buyer_invoice_preference', must be one of '%s'",
                    $buyer_invoice_preference,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['buyer_invoice_preference'] = $buyer_invoice_preference;

        return $this;
    }

    /**
     * Gets buyer_tax_information
     *
     * @return \Amazon\Orders\Model\BuyerTaxInformation|null
     */
    public function getBuyerTaxInformation()
    {
        return $this->container['buyer_tax_information'];
    }

    /**
     * Sets buyer_tax_information
     *
     * @param \Amazon\Orders\Model\BuyerTaxInformation|null $buyer_tax_information buyer_tax_information
     *
     * @return self
     */
    public function setBuyerTaxInformation($buyer_tax_information)
    {
        if (is_null($buyer_tax_information)) {
            throw new \InvalidArgumentException('non-nullable buyer_tax_information cannot be null');
        }
        $this->container['buyer_tax_information'] = $buyer_tax_information;

        return $this;
    }

    /**
     * Gets fulfillment_instruction
     *
     * @return \Amazon\Orders\Model\FulfillmentInstruction|null
     */
    public function getFulfillmentInstruction()
    {
        return $this->container['fulfillment_instruction'];
    }

    /**
     * Sets fulfillment_instruction
     *
     * @param \Amazon\Orders\Model\FulfillmentInstruction|null $fulfillment_instruction fulfillment_instruction
     *
     * @return self
     */
    public function setFulfillmentInstruction($fulfillment_instruction)
    {
        if (is_null($fulfillment_instruction)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_instruction cannot be null');
        }
        $this->container['fulfillment_instruction'] = $fulfillment_instruction;

        return $this;
    }

    /**
     * Gets is_ispu
     *
     * @return bool|null
     */
    public function getIsIspu()
    {
        return $this->container['is_ispu'];
    }

    /**
     * Sets is_ispu
     *
     * @param bool|null $is_ispu When true, this order is marked to be picked up from a store rather than delivered.
     *
     * @return self
     */
    public function setIsIspu($is_ispu)
    {
        if (is_null($is_ispu)) {
            throw new \InvalidArgumentException('non-nullable is_ispu cannot be null');
        }
        $this->container['is_ispu'] = $is_ispu;

        return $this;
    }

    /**
     * Gets is_access_point_order
     *
     * @return bool|null
     */
    public function getIsAccessPointOrder()
    {
        return $this->container['is_access_point_order'];
    }

    /**
     * Sets is_access_point_order
     *
     * @param bool|null $is_access_point_order When true, this order is marked to be delivered to an Access Point. The access location is chosen by the customer. Access Points include Amazon Hub Lockers, Amazon Hub Counters, and pickup points operated by carriers.
     *
     * @return self
     */
    public function setIsAccessPointOrder($is_access_point_order)
    {
        if (is_null($is_access_point_order)) {
            throw new \InvalidArgumentException('non-nullable is_access_point_order cannot be null');
        }
        $this->container['is_access_point_order'] = $is_access_point_order;

        return $this;
    }

    /**
     * Gets marketplace_tax_info
     *
     * @return \Amazon\Orders\Model\MarketplaceTaxInfo|null
     */
    public function getMarketplaceTaxInfo()
    {
        return $this->container['marketplace_tax_info'];
    }

    /**
     * Sets marketplace_tax_info
     *
     * @param \Amazon\Orders\Model\MarketplaceTaxInfo|null $marketplace_tax_info marketplace_tax_info
     *
     * @return self
     */
    public function setMarketplaceTaxInfo($marketplace_tax_info)
    {
        if (is_null($marketplace_tax_info)) {
            throw new \InvalidArgumentException('non-nullable marketplace_tax_info cannot be null');
        }
        $this->container['marketplace_tax_info'] = $marketplace_tax_info;

        return $this;
    }

    /**
     * Gets seller_display_name
     *
     * @return string|null
     */
    public function getSellerDisplayName()
    {
        return $this->container['seller_display_name'];
    }

    /**
     * Sets seller_display_name
     *
     * @param string|null $seller_display_name The seller’s friendly name registered in the marketplace where the sale took place. Sellers can use this data to issue electronic invoices for orders in Brazil.  **Note**: This attribute is only available in the Brazil marketplace for the orders with `Pending` or `Unshipped` status.
     *
     * @return self
     */
    public function setSellerDisplayName($seller_display_name)
    {
        if (is_null($seller_display_name)) {
            throw new \InvalidArgumentException('non-nullable seller_display_name cannot be null');
        }
        $this->container['seller_display_name'] = $seller_display_name;

        return $this;
    }

    /**
     * Gets shipping_address
     *
     * @return \Amazon\Orders\Model\Address|null
     */
    public function getShippingAddress()
    {
        return $this->container['shipping_address'];
    }

    /**
     * Sets shipping_address
     *
     * @param \Amazon\Orders\Model\Address|null $shipping_address shipping_address
     *
     * @return self
     */
    public function setShippingAddress($shipping_address)
    {
        if (is_null($shipping_address)) {
            throw new \InvalidArgumentException('non-nullable shipping_address cannot be null');
        }
        $this->container['shipping_address'] = $shipping_address;

        return $this;
    }

    /**
     * Gets buyer_info
     *
     * @return \Amazon\Orders\Model\BuyerInfo|null
     */
    public function getBuyerInfo()
    {
        return $this->container['buyer_info'];
    }

    /**
     * Sets buyer_info
     *
     * @param \Amazon\Orders\Model\BuyerInfo|null $buyer_info buyer_info
     *
     * @return self
     */
    public function setBuyerInfo($buyer_info)
    {
        if (is_null($buyer_info)) {
            throw new \InvalidArgumentException('non-nullable buyer_info cannot be null');
        }
        $this->container['buyer_info'] = $buyer_info;

        return $this;
    }

    /**
     * Gets automated_shipping_settings
     *
     * @return \Amazon\Orders\Model\AutomatedShippingSettings|null
     */
    public function getAutomatedShippingSettings()
    {
        return $this->container['automated_shipping_settings'];
    }

    /**
     * Sets automated_shipping_settings
     *
     * @param \Amazon\Orders\Model\AutomatedShippingSettings|null $automated_shipping_settings automated_shipping_settings
     *
     * @return self
     */
    public function setAutomatedShippingSettings($automated_shipping_settings)
    {
        if (is_null($automated_shipping_settings)) {
            throw new \InvalidArgumentException('non-nullable automated_shipping_settings cannot be null');
        }
        $this->container['automated_shipping_settings'] = $automated_shipping_settings;

        return $this;
    }

    /**
     * Gets has_regulated_items
     *
     * @return bool|null
     */
    public function getHasRegulatedItems()
    {
        return $this->container['has_regulated_items'];
    }

    /**
     * Sets has_regulated_items
     *
     * @param bool|null $has_regulated_items Whether the order contains regulated items which may require additional approval steps before being fulfilled.
     *
     * @return self
     */
    public function setHasRegulatedItems($has_regulated_items)
    {
        if (is_null($has_regulated_items)) {
            throw new \InvalidArgumentException('non-nullable has_regulated_items cannot be null');
        }
        $this->container['has_regulated_items'] = $has_regulated_items;

        return $this;
    }

    /**
     * Gets electronic_invoice_status
     *
     * @return \Amazon\Orders\Model\ElectronicInvoiceStatus|null
     */
    public function getElectronicInvoiceStatus()
    {
        return $this->container['electronic_invoice_status'];
    }

    /**
     * Sets electronic_invoice_status
     *
     * @param \Amazon\Orders\Model\ElectronicInvoiceStatus|null $electronic_invoice_status electronic_invoice_status
     *
     * @return self
     */
    public function setElectronicInvoiceStatus($electronic_invoice_status)
    {
        if (is_null($electronic_invoice_status)) {
            throw new \InvalidArgumentException('non-nullable electronic_invoice_status cannot be null');
        }
        $this->container['electronic_invoice_status'] = $electronic_invoice_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


