<?php
/**
 * FulfillmentPlan
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Amazon\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Selling Partner API for Orders
 *
 * Use the Orders Selling Partner API to programmatically retrieve order information. With this API, you can develop fast, flexible, and custom applications to manage order synchronization, perform order research, and create demand-based decision support tools.   _Note:_ For the JP, AU, and SG marketplaces, the Orders API supports orders from 2016 onward. For all other marketplaces, the Orders API supports orders for the last two years (orders older than this don't show up in the response).
 *
 * The version of the OpenAPI document: v0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Amazon\Orders\Model;

use \ArrayAccess;
use \Amazon\Orders\ObjectSerializer;

/**
 * FulfillmentPlan Class Doc Comment
 *
 * @category Class
 * @description A collection of order items that are to be fulfilled from the same location with the same shipping, pickup, and service instructions.
 * @package  Amazon\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FulfillmentPlan implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FulfillmentPlan';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'fulfillment_plan_id' => 'string',
        'creation_date' => 'string',
        'fulfillment_type' => 'string',
        'fulfillment_plan_status' => 'string',
        'last_status_update_date' => 'string',
        'fulfillment_location' => '\Amazon\Orders\Model\FulfillmentLocation',
        'shipping_instructions' => '\Amazon\Orders\Model\ShippingInstructions',
        'fulfillment_plan_items' => '\Amazon\Orders\Model\FulfillmentPlanItem[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'fulfillment_plan_id' => null,
        'creation_date' => null,
        'fulfillment_type' => null,
        'fulfillment_plan_status' => null,
        'last_status_update_date' => null,
        'fulfillment_location' => null,
        'shipping_instructions' => null,
        'fulfillment_plan_items' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'fulfillment_plan_id' => false,
        'creation_date' => false,
        'fulfillment_type' => false,
        'fulfillment_plan_status' => false,
        'last_status_update_date' => false,
        'fulfillment_location' => false,
        'shipping_instructions' => false,
        'fulfillment_plan_items' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'fulfillment_plan_id' => 'FulfillmentPlanId',
        'creation_date' => 'CreationDate',
        'fulfillment_type' => 'FulfillmentType',
        'fulfillment_plan_status' => 'FulfillmentPlanStatus',
        'last_status_update_date' => 'LastStatusUpdateDate',
        'fulfillment_location' => 'FulfillmentLocation',
        'shipping_instructions' => 'ShippingInstructions',
        'fulfillment_plan_items' => 'FulfillmentPlanItems'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'fulfillment_plan_id' => 'setFulfillmentPlanId',
        'creation_date' => 'setCreationDate',
        'fulfillment_type' => 'setFulfillmentType',
        'fulfillment_plan_status' => 'setFulfillmentPlanStatus',
        'last_status_update_date' => 'setLastStatusUpdateDate',
        'fulfillment_location' => 'setFulfillmentLocation',
        'shipping_instructions' => 'setShippingInstructions',
        'fulfillment_plan_items' => 'setFulfillmentPlanItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'fulfillment_plan_id' => 'getFulfillmentPlanId',
        'creation_date' => 'getCreationDate',
        'fulfillment_type' => 'getFulfillmentType',
        'fulfillment_plan_status' => 'getFulfillmentPlanStatus',
        'last_status_update_date' => 'getLastStatusUpdateDate',
        'fulfillment_location' => 'getFulfillmentLocation',
        'shipping_instructions' => 'getShippingInstructions',
        'fulfillment_plan_items' => 'getFulfillmentPlanItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const FULFILLMENT_TYPE_INSTORE_PICKUP = 'INSTORE_PICKUP';
    public const FULFILLMENT_TYPE_SERVICE = 'SERVICE';
    public const FULFILLMENT_TYPE_SHIP = 'SHIP';
    public const FULFILLMENT_PLAN_STATUS_ACTIVE = 'ACTIVE';
    public const FULFILLMENT_PLAN_STATUS_ABORTED = 'ABORTED';
    public const FULFILLMENT_PLAN_STATUS_COMPLETED = 'COMPLETED';
    public const FULFILLMENT_PLAN_STATUS_PARTIALLY_FULFILLED = 'PARTIALLY_FULFILLED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFulfillmentTypeAllowableValues()
    {
        return [
            self::FULFILLMENT_TYPE_INSTORE_PICKUP,
            self::FULFILLMENT_TYPE_SERVICE,
            self::FULFILLMENT_TYPE_SHIP,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFulfillmentPlanStatusAllowableValues()
    {
        return [
            self::FULFILLMENT_PLAN_STATUS_ACTIVE,
            self::FULFILLMENT_PLAN_STATUS_ABORTED,
            self::FULFILLMENT_PLAN_STATUS_COMPLETED,
            self::FULFILLMENT_PLAN_STATUS_PARTIALLY_FULFILLED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('fulfillment_plan_id', $data ?? [], null);
        $this->setIfExists('creation_date', $data ?? [], null);
        $this->setIfExists('fulfillment_type', $data ?? [], null);
        $this->setIfExists('fulfillment_plan_status', $data ?? [], null);
        $this->setIfExists('last_status_update_date', $data ?? [], null);
        $this->setIfExists('fulfillment_location', $data ?? [], null);
        $this->setIfExists('shipping_instructions', $data ?? [], null);
        $this->setIfExists('fulfillment_plan_items', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['fulfillment_plan_id'] === null) {
            $invalidProperties[] = "'fulfillment_plan_id' can't be null";
        }
        if ($this->container['creation_date'] === null) {
            $invalidProperties[] = "'creation_date' can't be null";
        }
        if ($this->container['fulfillment_type'] === null) {
            $invalidProperties[] = "'fulfillment_type' can't be null";
        }
        $allowedValues = $this->getFulfillmentTypeAllowableValues();
        if (!is_null($this->container['fulfillment_type']) && !in_array($this->container['fulfillment_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'fulfillment_type', must be one of '%s'",
                $this->container['fulfillment_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['fulfillment_plan_status'] === null) {
            $invalidProperties[] = "'fulfillment_plan_status' can't be null";
        }
        $allowedValues = $this->getFulfillmentPlanStatusAllowableValues();
        if (!is_null($this->container['fulfillment_plan_status']) && !in_array($this->container['fulfillment_plan_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'fulfillment_plan_status', must be one of '%s'",
                $this->container['fulfillment_plan_status'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['last_status_update_date'] === null) {
            $invalidProperties[] = "'last_status_update_date' can't be null";
        }
        if ($this->container['fulfillment_plan_items'] === null) {
            $invalidProperties[] = "'fulfillment_plan_items' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets fulfillment_plan_id
     *
     * @return string
     */
    public function getFulfillmentPlanId()
    {
        return $this->container['fulfillment_plan_id'];
    }

    /**
     * Sets fulfillment_plan_id
     *
     * @param string $fulfillment_plan_id Unique identifier for a fulfillment plan.
     *
     * @return self
     */
    public function setFulfillmentPlanId($fulfillment_plan_id)
    {
        if (is_null($fulfillment_plan_id)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_plan_id cannot be null');
        }
        $this->container['fulfillment_plan_id'] = $fulfillment_plan_id;

        return $this;
    }

    /**
     * Gets creation_date
     *
     * @return string
     */
    public function getCreationDate()
    {
        return $this->container['creation_date'];
    }

    /**
     * Sets creation_date
     *
     * @param string $creation_date Time when the fulfillment plan was created in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) format.
     *
     * @return self
     */
    public function setCreationDate($creation_date)
    {
        if (is_null($creation_date)) {
            throw new \InvalidArgumentException('non-nullable creation_date cannot be null');
        }
        $this->container['creation_date'] = $creation_date;

        return $this;
    }

    /**
     * Gets fulfillment_type
     *
     * @return string
     */
    public function getFulfillmentType()
    {
        return $this->container['fulfillment_type'];
    }

    /**
     * Sets fulfillment_type
     *
     * @param string $fulfillment_type Type of fulfillment
     *
     * @return self
     */
    public function setFulfillmentType($fulfillment_type)
    {
        if (is_null($fulfillment_type)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_type cannot be null');
        }
        $allowedValues = $this->getFulfillmentTypeAllowableValues();
        if (!in_array($fulfillment_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'fulfillment_type', must be one of '%s'",
                    $fulfillment_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['fulfillment_type'] = $fulfillment_type;

        return $this;
    }

    /**
     * Gets fulfillment_plan_status
     *
     * @return string
     */
    public function getFulfillmentPlanStatus()
    {
        return $this->container['fulfillment_plan_status'];
    }

    /**
     * Sets fulfillment_plan_status
     *
     * @param string $fulfillment_plan_status The fulfillment plan status.
     *
     * @return self
     */
    public function setFulfillmentPlanStatus($fulfillment_plan_status)
    {
        if (is_null($fulfillment_plan_status)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_plan_status cannot be null');
        }
        $allowedValues = $this->getFulfillmentPlanStatusAllowableValues();
        if (!in_array($fulfillment_plan_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'fulfillment_plan_status', must be one of '%s'",
                    $fulfillment_plan_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['fulfillment_plan_status'] = $fulfillment_plan_status;

        return $this;
    }

    /**
     * Gets last_status_update_date
     *
     * @return string
     */
    public function getLastStatusUpdateDate()
    {
        return $this->container['last_status_update_date'];
    }

    /**
     * Sets last_status_update_date
     *
     * @param string $last_status_update_date The time when the fulfillment plan's status was last updated in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) format.
     *
     * @return self
     */
    public function setLastStatusUpdateDate($last_status_update_date)
    {
        if (is_null($last_status_update_date)) {
            throw new \InvalidArgumentException('non-nullable last_status_update_date cannot be null');
        }
        $this->container['last_status_update_date'] = $last_status_update_date;

        return $this;
    }

    /**
     * Gets fulfillment_location
     *
     * @return \Amazon\Orders\Model\FulfillmentLocation|null
     */
    public function getFulfillmentLocation()
    {
        return $this->container['fulfillment_location'];
    }

    /**
     * Sets fulfillment_location
     *
     * @param \Amazon\Orders\Model\FulfillmentLocation|null $fulfillment_location fulfillment_location
     *
     * @return self
     */
    public function setFulfillmentLocation($fulfillment_location)
    {
        if (is_null($fulfillment_location)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_location cannot be null');
        }
        $this->container['fulfillment_location'] = $fulfillment_location;

        return $this;
    }

    /**
     * Gets shipping_instructions
     *
     * @return \Amazon\Orders\Model\ShippingInstructions|null
     */
    public function getShippingInstructions()
    {
        return $this->container['shipping_instructions'];
    }

    /**
     * Sets shipping_instructions
     *
     * @param \Amazon\Orders\Model\ShippingInstructions|null $shipping_instructions shipping_instructions
     *
     * @return self
     */
    public function setShippingInstructions($shipping_instructions)
    {
        if (is_null($shipping_instructions)) {
            throw new \InvalidArgumentException('non-nullable shipping_instructions cannot be null');
        }
        $this->container['shipping_instructions'] = $shipping_instructions;

        return $this;
    }

    /**
     * Gets fulfillment_plan_items
     *
     * @return \Amazon\Orders\Model\FulfillmentPlanItem[]
     */
    public function getFulfillmentPlanItems()
    {
        return $this->container['fulfillment_plan_items'];
    }

    /**
     * Sets fulfillment_plan_items
     *
     * @param \Amazon\Orders\Model\FulfillmentPlanItem[] $fulfillment_plan_items The details of the order items that are included in the fulfillment plan.
     *
     * @return self
     */
    public function setFulfillmentPlanItems($fulfillment_plan_items)
    {
        if (is_null($fulfillment_plan_items)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_plan_items cannot be null');
        }
        $this->container['fulfillment_plan_items'] = $fulfillment_plan_items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


