# OpenAPIClient-php

The Selling Partner API for Feeds lets you upload data to Amazon on behalf of a selling partner.

For more information, please visit [https://sellercentral.amazon.com/gp/mws/contactus.html](https://sellercentral.amazon.com/gp/mws/contactus.html).

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/amazon-spapi.git"
    }
  ],
  "require": {
    "talisman/amazon-spapi": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Amazon\Feeds\Api\FeedsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$feed_id = 'feed_id_example'; // string | The identifier for the feed. This identifier is unique only in combination with a seller ID.

try {
    $apiInstance->cancelFeed($feed_id);
} catch (Exception $e) {
    echo 'Exception when calling FeedsApi->cancelFeed: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://sellingpartnerapi-na.amazon.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FeedsApi* | [**cancelFeed**](docs/Api/FeedsApi.md#cancelfeed) | **DELETE** /feeds/2021-06-30/feeds/{feedId} | 
*FeedsApi* | [**createFeed**](docs/Api/FeedsApi.md#createfeed) | **POST** /feeds/2021-06-30/feeds | 
*FeedsApi* | [**createFeedDocument**](docs/Api/FeedsApi.md#createfeeddocument) | **POST** /feeds/2021-06-30/documents | 
*FeedsApi* | [**getFeed**](docs/Api/FeedsApi.md#getfeed) | **GET** /feeds/2021-06-30/feeds/{feedId} | 
*FeedsApi* | [**getFeedDocument**](docs/Api/FeedsApi.md#getfeeddocument) | **GET** /feeds/2021-06-30/documents/{feedDocumentId} | 
*FeedsApi* | [**getFeeds**](docs/Api/FeedsApi.md#getfeeds) | **GET** /feeds/2021-06-30/feeds | 

## Models

- [CreateFeedDocumentResponse](docs/Model/CreateFeedDocumentResponse.md)
- [CreateFeedDocumentSpecification](docs/Model/CreateFeedDocumentSpecification.md)
- [CreateFeedResponse](docs/Model/CreateFeedResponse.md)
- [CreateFeedSpecification](docs/Model/CreateFeedSpecification.md)
- [Error](docs/Model/Error.md)
- [ErrorList](docs/Model/ErrorList.md)
- [Feed](docs/Model/Feed.md)
- [FeedDocument](docs/Model/FeedDocument.md)
- [GetFeedsResponse](docs/Model/GetFeedsResponse.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `2021-06-30`
    - Package version: `1`
    - Generator version: `7.8.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
